import static org.junit.Assert.*;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;

public class JosephusEliminationTest {
  JosephusElimination test;

  @Before
  public void setUp() {
    test = new JosephusElimination(5, 3);
  }

  @Test
  public void testConstructor() {
    int[] expectedResult = new int[] {1, 2, 3, 4, 5};

    List<Integer> actualResult = test.getPeople();

    // test size
    assertEquals(expectedResult.length, actualResult.size());

    // test each person
    for (int i = 0; i < actualResult.size(); i ++) {
      assertEquals(expectedResult[i], actualResult.get(i), 0);
    }
  }

  @Test
  public void testEliminate1() {
    int[] expectedResult = new int[] {1, 2, 4, 5};

    int eliminatedPerson = test.eliminateNext();

    // test the person who get killed
    assertEquals(3, eliminatedPerson);

    // test the size after killed
    assertEquals(4, test.getNumberOfPeopleLeft());

    // test each person
    for (int i = 0; i < test.getNumberOfPeopleLeft(); i ++) {
      assertEquals(expectedResult[i], test.getPeople().get(i), 0);
    }
  }

  @Test
  public void testEliminate2() {
    int[] expectedResult = new int[] {2, 4, 5};

    test.eliminateNext();
    int eliminatedPerson = test.eliminateNext();

    // test the person who get killed
    assertEquals(1, eliminatedPerson);

    // test the size after killed
    assertEquals(3, test.getNumberOfPeopleLeft());

    // test each person
    for (int i = 0; i < test.getNumberOfPeopleLeft(); i ++) {
      assertEquals(expectedResult[i], test.getPeople().get(i), 0);
    }
  }

  @Test
  public void testEliminate3() {
    int[] expectedResult = new int[] {4};

    test.eliminateNext();
    test.eliminateNext();
    test.eliminateNext();
    int eliminatedPerson = test.eliminateNext();

    // test the person who get killed
    assertEquals(2, eliminatedPerson);

    // test the size after killed
    assertEquals(1, test.getNumberOfPeopleLeft());

    // test each person
    for (int i = 0; i < test.getNumberOfPeopleLeft(); i ++) {
      assertEquals(expectedResult[i], test.getPeople().get(i), 0);
    }
  }
}