import static org.junit.Assert.*;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class GraderTest {
  Grader test;

  @Before
  public void setup() {
    char[][] studentAnswers = new char[ ][ ] {
      {'A', 'B', 'A', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
      {'D', 'B', 'A', 'B', 'C', 'A', 'E', 'E', 'A', 'D'},
      {'E', 'D', 'D', 'A', 'C', 'B', 'E', 'E', 'A', 'D'},
      {'C', 'B', 'A', 'E', 'D', 'C', 'E', 'E', 'A', 'D'},
      {'A', 'B', 'D', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
      {'B', 'B', 'E', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
      {'B', 'B', 'A', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
      {'E', 'B', 'E', 'C', 'C', 'D', 'E', 'E', 'A', 'D'}
    };
    char[] key = new char[ ]
      {'D', 'B', 'D', 'C', 'C', 'D', 'A', 'E', 'A', 'D'};

    test = new Grader(studentAnswers, key);
  }

  @Test
  public void testConstrutor() {
    char[][] studentAnswers = new char[ ][ ] {
      {'A', 'B', 'A', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
      {'D', 'B', 'A', 'B', 'C', 'A', 'E', 'E', 'A', 'D'},
      {'E', 'D', 'D', 'A', 'C', 'B', 'E', 'E', 'A', 'D'},
      {'C', 'B', 'A', 'E', 'D', 'C', 'E', 'E', 'A', 'D'},
      {'A', 'B', 'D', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
      {'B', 'B', 'E', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
      {'B', 'B', 'A', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
      {'E', 'B', 'E', 'C', 'C', 'D', 'E', 'E', 'A', 'D'}
    };
    char[] key = new char[ ]
      {'D', 'B', 'D', 'C', 'C', 'D', 'A', 'E', 'A', 'D'};

    for (int i = 0; i < studentAnswers.length; i ++) {
      for (int j = 0; j < studentAnswers[i].length; j ++) {
        assertEquals(studentAnswers[i][j], test.getStudentAnswers()[i][j]);
      }
    }

    for (int i = 0; i < key.length; i ++) {
      assertEquals(key[i], test.getKey()[i]);
    }
  }

  @Test
  public void testComputeScore() {
    int[] expectedScores = new int[]
      {7, 6, 5, 4, 8, 7, 7, 7};

    int[] actualScores = test.computeScores();

    for (int i = 0; i < expectedScores.length; i ++) {
      assertEquals(expectedScores[i], actualScores[i]);
    }
  }

  @Test
  public void testGetAverageScore() {
    double expectedAverage = 6.375;

    test.computeScores();
    double actualAverage = test.getAverageScore();

    assertEquals(expectedAverage, actualAverage, 0);
  }

  @Test
  public void testGetHardestProblems() {
    int[] expectedProblems = new int[] { 6 };

    test.computeScores();

    assertEquals(expectedProblems.length, test.getHardestProblems().length);

    int[] actualProblems = test.getHardestProblems();

    for (int i = 0; i < expectedProblems.length; i ++) {
      assertEquals(expectedProblems[i], actualProblems[i]);
    }
  }
}