import java.util.List;
import java.util.ArrayList;

public class Grader {

    private char[ ][ ] studentAnswers;
    private char[ ] key;
    private int[ ] studentScores;
    private int numStudents;

    public Grader(char[][] studentAnswers, char[ ] key) {

        // TODO: initialize the sample data
        this.studentAnswers = studentAnswers;
        this.key = key;
        this.numStudents = studentAnswers.length;
        this.studentScores = new int[numStudents];

    }

    public char[][] getStudentAnswers() {
        return studentAnswers;
    }

    public char[] getKey() {
        return key;
    }

    public int[] computeScores() {

        // TODO: Compute each score one student by one student
        //       and return studentScores
        // hint: be aware of the **instance variable** above
        for (int student = 0; student < studentAnswers.length; student ++) {
            for (int question = 0; question < studentAnswers[student].length;
                question ++) {
                if (studentAnswers[student][question] == key[question]) {
                    studentScores[student] ++;
                }
            }
        }

        return studentScores;
    }

    public double getAverageScore() {

        // TODO: Return what is the average score of the students
        double total = 0;
        for (int score: studentScores) {
            total += score;
        }

        return total/numStudents;
    }

    public int[] getHardestProblems() {

        // TODO: Return the hardest problem(s) in array
        int[] wrongCounts = new int[key.length];

        for (int student = 0; student < studentAnswers.length; student ++) {
            for (int question = 0; question < studentAnswers[student].length;
                question ++) {
                if (studentAnswers[student][question] != key[question]) {
                    wrongCounts[question] ++;
                }
            }
        }

        List<Integer> hardestProblems = new ArrayList<Integer>();

        int max = -1;
        for (int wrongCount: wrongCounts) {
            if (wrongCount > max) {
                max = wrongCount;
            }
        }

        for (int i = 0; i < wrongCounts.length; i ++) {
            if (wrongCounts[i] == max) {
                hardestProblems.add(i);
            }
        }

        int[] result = new int[hardestProblems.size()];

        for (int i = 0; i < hardestProblems.size(); i ++) {
            result[i] = hardestProblems.get(i);
        }

        return result;
    }
}
