package edu.calstatela.jplone.arframework.landmark;


import android.util.Log;

import java.util.ArrayList;
import java.util.Scanner;


public class MountainData {
    

    private static final String TAG = "waka-MtnData";


    public static float[] mtWilson = {34.224770353682786f, -118.05668717979921f, 1733.442f};
    public static float[] sanGabrielPeak = {34.24340686131956f, -118.09707311231966f, 1826.785f};
    public static float[] mtLukens = {34.26899177233548f, -118.23898315429688f, 1547.361f};
    public static float[] brownMountain = {34.2366701f, -118.14701609999997f, 1357.138f};
    public static float[] hoytMountain = {34.27196702744981f, -118.17869480013769f, 1152.849f};

    public static ArrayList<float[]> extractCoords(String dataString){
        ArrayList<float[]> list = new ArrayList<>();
        Scanner scanner = new Scanner(dataString);
        while(scanner.hasNext()){
            float[] latLonAlt = new float[3];
            scanner.next(); // rejects the first number of each line
            String temp = scanner.next();
            latLonAlt[0] = Float.parseFloat(temp);
            temp = scanner.next();
            latLonAlt[1] = Float.parseFloat(temp);
            temp = scanner.next();
            latLonAlt[2] = Float.parseFloat(temp);

            list.add(latLonAlt);
        }

        return list;
    }

    public static float[][][] extract(String dataString){
        Log.d(TAG, ".... extract() .....");
//        Log.d(TAG, "dataString:\n" + dataString);
        ArrayList< ArrayList<float[]> > lists = new ArrayList<>();
        ArrayList<float[]> currentList = null;

        Scanner scanner = new Scanner(dataString);
        float[] latLonAlt = new float[3];

        while(scanner.hasNext()){

            String temp = scanner.next();
            if(temp.equals("xx")){
                currentList = new ArrayList<>();
                lists.add(currentList);
                scanner.next();
            }

            temp = scanner.next();
            latLonAlt[0] = Float.parseFloat(temp);
            temp = scanner.next();
            latLonAlt[1] = Float.parseFloat(temp);
            temp = scanner.next();
            latLonAlt[2] = Float.parseFloat(temp);

            currentList.add(latLonAlt);
            latLonAlt = new float[3];
        }

        float[][][] heightMap = new float[lists.size()][lists.get(0).size()][3];
        for(int i = 0; i < lists.size(); i++){
            currentList = lists.get(i);
            for(int j = 0; j < currentList.size(); j++){
                float[] currentCoord = currentList.get(j);
                heightMap[i][j][0] = currentCoord[0];
                heightMap[i][j][1] = currentCoord[1];
                heightMap[i][j][2] = currentCoord[2];
            }
        }

//        for(int i = 0; i < heightMap.length; i++){
//            for(int j = 0; j < heightMap[0].length; j++) {
//                Log.d(TAG, String.format("(%f, %f, %f)\n", heightMap[i][j][0], heightMap[i][j][1], heightMap[i][j][2]));
//            }
//            Log.d(TAG, "  ");
//        }

        return heightMap;
    }

    public static final String mtWilsonHeightDataString =
            "xx " +
            "01     34.204310048739515     -118.1114513361033     840.176\n" +
            "11     34.20047675723339     -118.09737510319314     575.811\n" +
            "21     34.1940875507241     -118.08226890202127     987.643\n" +
            "31     34.18712986415717     -118.06596107121072     798.789\n" +
            "xx " +
            "41     34.21666058002387     -118.10492820377908     1357.516\n" +
            "51     34.21183415107134     -118.0920536005076     1149.926\n" +
            "61     34.2070074456794     -118.07471580143533     971.382\n" +
            "71     34.20104466327002     -118.05806464787088     1170.375\n" +
            "xx " +
            "81     34.23028665176656     -118.09668845768533     1406.989\n" +
            "91     34.22574487276787     -118.0836421930369     1234.835\n" +
            "101     34.22077702154966     -118.06870765324197     1382.947\n" +
            "111     34.21524107079388     -118.05051154728494     1249.715\n" +
            "xx " +
            "121     34.2416400276349     -118.08741874332986     1426.606\n" +
            "131     34.239369474940716     -118.07196921940408     1305.736\n" +
            "141     34.23695694560052     -118.06012458439432     1369.678\n" +
            "151     34.231847831728444     -118.04416007633768     1395.351\n";
            
    
    public static final String waka =
            "xx " +
            "01    34.200974675324595    -118.12286308199651    515.526\n" +
            "11    34.206795496458696    -118.1163399496723    671.854\n" +
            "21    34.21332569535238    -118.10895851046331    1053.977\n" +
            "31    34.21971344376307    -118.10157707125433    1220.334\n" +
            "41    34.225107165266714    -118.09539726168401    1373.900\n" +
            "51    34.231210170438    -118.0895607748676    1304.066\n" +
            "61    34.23674507172083    -118.0833809652973    1590.070\n" +
            "xx " +
            "71    34.199838858482885    -118.11734309584386    542.423\n" +
            "81    34.20438203403492    -118.10996165663488    859.263\n" +
            "91    34.21105437921525    -118.10155024916418    1217.271\n" +
            "101    34.217158402512396    -118.09434047133215    1111.849\n" +
            "111    34.224255547989735    -118.0890189686466    1042.185\n" +
            "121    34.229648978654375    -118.08335414320715    1411.464\n" +
            "131    34.235467819102645    -118.07648768812902    1633.459\n" +
            "xx " +
            "141    34.19643131614632    -118.11184993178136    547.218\n" +
            "151    34.20239442485784    -118.10412516981847    720.377\n" +
            "161    34.208499075386754    -118.09571376234777    984.021\n" +
            "171    34.21474523685007    -118.08850398451574    1021.362\n" +
            "181    34.22184258561321    -118.08009257704504    1034.948\n" +
            "191    34.2287974073008    -118.0751143971134    1454.368\n" +
            "201    34.23419054710824    -118.0699645558048    1569.954\n" +
            "xx " +
            "211    34.193165625515675    -118.10378184706457    418.143\n" +
            "221    34.19912896518621    -118.09622874647863    593.455\n" +
            "231    34.20750532519664    -118.08884730726965    909.970\n" +
            "241    34.21389351482116    -118.08266749769933    864.363\n" +
            "251    34.22099093533058    -118.07322612196691    1326.617\n" +
            "261    34.22780389650514    -118.06773295790441    1718.025\n" +
            "271    34.23404862680169    -118.06223979384191    1562.891\n" +
            "xx " +
            "281    34.18890583897896    -118.09846034437902    486.079\n" +
            "291    34.19572139415908    -118.09090724379308    871.378\n" +
            "301    34.20438203403492    -118.08283915907629    914.389\n" +
            "311    34.211196338267335    -118.07665934950597    990.837\n" +
            "321    34.218010091538886    -118.06670298964269    1464.898\n" +
            "331    34.225391035778955    -118.06035151869543    1694.875\n" +
            "341    34.23206171739359    -118.05331340224035    1556.043\n" +
            "xx " +
            "351    34.1859238603866    -118.09262385756261    407.767\n" +
            "361    34.192171694568664    -118.0861007252384    818.688\n" +
            "371    34.199838858482885    -118.07717433363683    1089.703\n" +
            "381    34.20764729022688    -118.0699645558048    1162.764\n" +
            "391    34.21602280375124    -118.06035151869543    1424.839\n" +
            "401    34.222410347684956    -118.05194011122472    1475.213\n" +
            "411    34.230642467683595    -118.04558864027746    1435.277\n" +
            "xx " +
            "421    34.18322578891676    -118.08558574110754    432.222\n" +
            "431    34.189757813498936    -118.08009257704504    784.388\n" +
            "441    34.1967152832676    -118.07116618544347    935.835\n" +
            "451    34.20480794418991    -118.06241145521886    1407.349\n" +
            "461    34.21289982823984    -118.05520167738683    1255.413\n" +
            "471    34.21971344376307    -118.04558864027746    1333.337\n" +
            "481    34.227520034125114    -118.03923716933019    1162.728\n" +
            "xx " +
            "491    34.181237681036365    -118.08043589979894    445.933\n" +
            "501    34.18691786496432    -118.07477107435949    659.680\n" +
            "511    34.19415954474812    -118.06584468275793    1008.314\n" +
            "521    34.20012281412789    -118.05777659804113    1117.404\n" +
            "531    34.20778925501799    -118.0505668202091    1309.305\n" +
            "541    34.2161647544334    -118.04112544447668    1198.126\n" +
            "551    34.22567490533446    -118.03134074599035    1103.729";

}
