/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview.series;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.series.BaseSeries;
import com.jjoe64.graphview.series.DataPointInterface;
import java.util.Iterator;

public class LineGraphSeries<E extends DataPointInterface>
extends BaseSeries<E> {
    private Styles mStyles;
    private Paint mPaint;
    private Paint mPaintBackground;
    private Path mPathBackground;
    private Path mPath;
    private Paint mCustomPaint;

    public LineGraphSeries() {
        this.init();
    }

    public LineGraphSeries(E[] data) {
        super(data);
        this.init();
    }

    protected void init() {
        this.mStyles = new Styles();
        this.mPaint = new Paint();
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaintBackground = new Paint();
        this.mPathBackground = new Path();
        this.mPath = new Path();
    }

    @Override
    public void draw(GraphView graphView, Canvas canvas, boolean isSecondScale) {
        double minY;
        double maxY;
        this.resetDataPoints();
        double maxX = graphView.getViewport().getMaxX(false);
        double minX = graphView.getViewport().getMinX(false);
        if (isSecondScale) {
            maxY = graphView.getSecondScale().getMaxY();
            minY = graphView.getSecondScale().getMinY();
        } else {
            maxY = graphView.getViewport().getMaxY(false);
            minY = graphView.getViewport().getMinY(false);
        }
        Iterator values = this.getValues(minX, maxX);
        double lastEndY = 0.0;
        double lastEndX = 0.0;
        this.mPaint.setStrokeWidth((float)this.mStyles.thickness);
        this.mPaint.setColor(this.getColor());
        this.mPaintBackground.setColor(this.mStyles.backgroundColor);
        Paint paint = this.mCustomPaint != null ? this.mCustomPaint : this.mPaint;
        if (this.mStyles.drawBackground) {
            this.mPathBackground.reset();
        }
        double diffY = maxY - minY;
        double diffX = maxX - minX;
        float graphHeight = graphView.getGraphContentHeight();
        float graphWidth = graphView.getGraphContentWidth();
        float graphLeft = graphView.getGraphContentLeft();
        float graphTop = graphView.getGraphContentTop();
        lastEndY = 0.0;
        lastEndX = 0.0;
        double lastUsedEndX = 0.0;
        float firstX = 0.0f;
        int i = 0;
        while (values.hasNext()) {
            double x;
            DataPointInterface value = (DataPointInterface)values.next();
            double valY = value.getY() - minY;
            double ratY = valY / diffY;
            double y = (double)graphHeight * ratY;
            double valX = value.getX() - minX;
            double ratX = valX / diffX;
            double orgX = x = (double)graphWidth * ratX;
            double orgY = y;
            if (i > 0) {
                double b;
                if (x > (double)graphWidth) {
                    b = ((double)graphWidth - lastEndX) * (y - lastEndY) / (x - lastEndX);
                    y = lastEndY + b;
                    x = graphWidth;
                }
                if (y < 0.0) {
                    b = (0.0 - lastEndY) * (x - lastEndX) / (y - lastEndY);
                    x = lastEndX + b;
                    y = 0.0;
                }
                if (y > (double)graphHeight) {
                    b = ((double)graphHeight - lastEndY) * (x - lastEndX) / (y - lastEndY);
                    x = lastEndX + b;
                    y = graphHeight;
                }
                if (lastEndY < 0.0) {
                    b = (0.0 - y) * (x - lastEndX) / (lastEndY - y);
                    lastEndX = x - b;
                    lastEndY = 0.0;
                }
                if (lastEndX < 0.0) {
                    b = (0.0 - x) * (y - lastEndY) / (lastEndX - x);
                    lastEndY = y - b;
                    lastEndX = 0.0;
                }
                if (lastEndY > (double)graphHeight) {
                    b = ((double)graphHeight - y) * (x - lastEndX) / (lastEndY - y);
                    lastEndX = x - b;
                    lastEndY = graphHeight;
                }
                float startX = (float)lastEndX + (graphLeft + 1.0f);
                float startY = (float)((double)graphTop - lastEndY) + graphHeight;
                float endX = (float)x + (graphLeft + 1.0f);
                float endY = (float)((double)graphTop - y) + graphHeight;
                if (this.mStyles.drawDataPoints) {
                    canvas.drawCircle(endX, endY, this.mStyles.dataPointsRadius, this.mPaint);
                }
                this.registerDataPoint(endX, endY, value);
                this.mPath.reset();
                this.mPath.moveTo(startX, startY);
                this.mPath.lineTo(endX, endY);
                canvas.drawPath(this.mPath, paint);
                if (this.mStyles.drawBackground) {
                    if (i == 1) {
                        firstX = startX;
                        this.mPathBackground.moveTo(startX, startY);
                    }
                    this.mPathBackground.lineTo(endX, endY);
                }
                lastUsedEndX = endX;
            } else if (this.mStyles.drawDataPoints) {
                float first_X = (float)x + (graphLeft + 1.0f);
                float first_Y = (float)((double)graphTop - y) + graphHeight;
            }
            lastEndY = orgY;
            lastEndX = orgX;
            ++i;
        }
        if (this.mStyles.drawBackground) {
            this.mPathBackground.lineTo((float)lastUsedEndX, graphHeight + graphTop);
            this.mPathBackground.lineTo(firstX, graphHeight + graphTop);
            this.mPathBackground.close();
            canvas.drawPath(this.mPathBackground, this.mPaintBackground);
        }
    }

    public int getThickness() {
        return this.mStyles.thickness;
    }

    public void setThickness(int thickness) {
        this.mStyles.thickness = thickness;
    }

    public boolean isDrawBackground() {
        return this.mStyles.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.mStyles.drawBackground = drawBackground;
    }

    public boolean isDrawDataPoints() {
        return this.mStyles.drawDataPoints;
    }

    public void setDrawDataPoints(boolean drawDataPoints) {
        this.mStyles.drawDataPoints = drawDataPoints;
    }

    public float getDataPointsRadius() {
        return this.mStyles.dataPointsRadius;
    }

    public void setDataPointsRadius(float dataPointsRadius) {
        this.mStyles.dataPointsRadius = dataPointsRadius;
    }

    public int getBackgroundColor() {
        return this.mStyles.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mStyles.backgroundColor = backgroundColor;
    }

    public void setCustomPaint(Paint customPaint) {
        this.mCustomPaint = customPaint;
    }

    private final class Styles {
        private int thickness = 5;
        private boolean drawBackground = false;
        private boolean drawDataPoints = false;
        private float dataPointsRadius = 10.0f;
        private int backgroundColor = Color.argb((int)100, (int)172, (int)218, (int)255);

        private Styles() {
        }
    }
}

