/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview.series;

import android.graphics.PointF;
import android.util.Log;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.series.DataPointInterface;
import com.jjoe64.graphview.series.OnDataPointTapListener;
import com.jjoe64.graphview.series.Series;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class BaseSeries<E extends DataPointInterface>
implements Series<E> {
    private final List<E> mData = new ArrayList();
    private Map<PointF, E> mDataPoints = new HashMap<PointF, E>();
    private String mTitle;
    private int mColor = -16746548;
    protected OnDataPointTapListener mOnDataPointTapListener;
    private List<GraphView> mGraphViews = new ArrayList<GraphView>();

    public BaseSeries() {
    }

    public BaseSeries(E[] data) {
        for (E d : data) {
            this.mData.add(d);
        }
    }

    @Override
    public double getLowestValueX() {
        if (this.mData.isEmpty()) {
            return 0.0;
        }
        return ((DataPointInterface)this.mData.get(0)).getX();
    }

    @Override
    public double getHighestValueX() {
        if (this.mData.isEmpty()) {
            return 0.0;
        }
        return ((DataPointInterface)this.mData.get(this.mData.size() - 1)).getX();
    }

    @Override
    public double getLowestValueY() {
        if (this.mData.isEmpty()) {
            return 0.0;
        }
        double l = ((DataPointInterface)this.mData.get(0)).getY();
        for (int i = 1; i < this.mData.size(); ++i) {
            double c = ((DataPointInterface)this.mData.get(i)).getY();
            if (!(l > c)) continue;
            l = c;
        }
        return l;
    }

    @Override
    public double getHighestValueY() {
        if (this.mData.isEmpty()) {
            return 0.0;
        }
        double h = ((DataPointInterface)this.mData.get(0)).getY();
        for (int i = 1; i < this.mData.size(); ++i) {
            double c = ((DataPointInterface)this.mData.get(i)).getY();
            if (!(h < c)) continue;
            h = c;
        }
        return h;
    }

    @Override
    public Iterator<E> getValues(final double from, final double until) {
        if (from <= this.getLowestValueX() && until >= this.getHighestValueX()) {
            return this.mData.iterator();
        }
        return new Iterator<E>(){
            Iterator<E> org;
            E nextValue;
            E nextNextValue;
            boolean plusOne;
            {
                this.org = BaseSeries.this.mData.iterator();
                this.nextValue = null;
                this.nextNextValue = null;
                this.plusOne = true;
                boolean found = false;
                DataPointInterface prevValue = null;
                if (this.org.hasNext()) {
                    prevValue = (DataPointInterface)this.org.next();
                }
                if (prevValue.getX() >= from) {
                    this.nextValue = prevValue;
                    found = true;
                } else {
                    while (this.org.hasNext()) {
                        this.nextValue = (DataPointInterface)this.org.next();
                        if (this.nextValue.getX() >= from) {
                            found = true;
                            this.nextNextValue = this.nextValue;
                            this.nextValue = prevValue;
                            break;
                        }
                        prevValue = this.nextValue;
                    }
                }
                if (!found) {
                    this.nextValue = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    Object r = this.nextValue;
                    if (r.getX() > until) {
                        this.plusOne = false;
                    }
                    if (this.nextNextValue != null) {
                        this.nextValue = this.nextNextValue;
                        this.nextNextValue = null;
                    } else {
                        this.nextValue = this.org.hasNext() ? (DataPointInterface)this.org.next() : null;
                    }
                    return r;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.nextValue != null && (this.nextValue.getX() <= until || this.plusOne);
            }
        };
    }

    @Override
    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String mTitle) {
        this.mTitle = mTitle;
    }

    @Override
    public int getColor() {
        return this.mColor;
    }

    public void setColor(int mColor) {
        this.mColor = mColor;
    }

    @Override
    public void setOnDataPointTapListener(OnDataPointTapListener l) {
        this.mOnDataPointTapListener = l;
    }

    @Override
    public void onTap(float x, float y) {
        E p;
        if (this.mOnDataPointTapListener != null && (p = this.findDataPoint(x, y)) != null) {
            this.mOnDataPointTapListener.onTap(this, (DataPointInterface)p);
        }
    }

    protected E findDataPoint(float x, float y) {
        float shortestDistance = Float.NaN;
        DataPointInterface shortest = null;
        for (Map.Entry<PointF, E> entry : this.mDataPoints.entrySet()) {
            float x1 = entry.getKey().x;
            float y1 = entry.getKey().y;
            float x2 = x;
            float y2 = y;
            float distance = (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
            if (shortest != null && !(distance < shortestDistance)) continue;
            shortestDistance = distance;
            shortest = (DataPointInterface)entry.getValue();
        }
        if (shortest != null) {
            if (shortestDistance < 120.0f) {
                return (E)shortest;
            }
            Log.d((String)"BaseSeries", (String)("point too far: " + shortestDistance));
        }
        return null;
    }

    protected void registerDataPoint(float x, float y, E dp) {
        this.mDataPoints.put(new PointF(x, y), dp);
    }

    protected void resetDataPoints() {
        this.mDataPoints.clear();
    }

    public void resetData(E[] data) {
        this.mData.clear();
        for (E d : data) {
            this.mData.add(d);
        }
        this.checkValueOrder(null);
        for (GraphView gv : this.mGraphViews) {
            gv.onDataChanged(true, false);
        }
    }

    @Override
    public void onGraphViewAttached(GraphView graphView) {
        this.mGraphViews.add(graphView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendData(E dataPoint, boolean scrollToEnd, int maxDataPoints) {
        this.checkValueOrder((DataPointInterface)dataPoint);
        if (!this.mData.isEmpty() && dataPoint.getX() < ((DataPointInterface)this.mData.get(this.mData.size() - 1)).getX()) {
            throw new IllegalArgumentException("new x-value must be greater then the last value. x-values has to be ordered in ASC.");
        }
        List<E> list = this.mData;
        synchronized (list) {
            int curDataCount = this.mData.size();
            if (curDataCount < maxDataPoints) {
                this.mData.add(dataPoint);
            } else {
                this.mData.remove(0);
                this.mData.add(dataPoint);
            }
        }
        boolean keepLabels = this.mData.size() != 1;
        for (GraphView gv : this.mGraphViews) {
            gv.onDataChanged(keepLabels, scrollToEnd);
            if (!scrollToEnd) continue;
            gv.getViewport().scrollToEnd();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.mData.isEmpty();
    }

    protected void checkValueOrder(DataPointInterface onlyLast) {
        if (this.mData.size() > 1) {
            if (onlyLast != null) {
                if (onlyLast.getX() < ((DataPointInterface)this.mData.get(this.mData.size() - 1)).getX()) {
                    throw new IllegalArgumentException("new x-value must be greater then the last value. x-values has to be ordered in ASC.");
                }
            } else {
                double lx = ((DataPointInterface)this.mData.get(0)).getX();
                for (int i = 1; i < this.mData.size(); ++i) {
                    if (((DataPointInterface)this.mData.get(i)).getX() == Double.NaN) continue;
                    if (lx > ((DataPointInterface)this.mData.get(i)).getX()) {
                        throw new IllegalArgumentException("The order of the values is not correct. X-Values have to be ordered ASC. First the lowest x value and at least the highest x value.");
                    }
                    lx = ((DataPointInterface)this.mData.get(i)).getX();
                }
            }
        }
    }
}

