/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview.helper;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.R;
import com.jjoe64.graphview.series.BarGraphSeries;
import com.jjoe64.graphview.series.BaseSeries;
import com.jjoe64.graphview.series.DataPoint;
import com.jjoe64.graphview.series.DataPointInterface;
import com.jjoe64.graphview.series.LineGraphSeries;
import com.jjoe64.graphview.series.PointsGraphSeries;

public class GraphViewXML
extends GraphView {
    public GraphViewXML(Context context, AttributeSet attrs) {
        super(context, attrs);
        BaseSeries series;
        DataPointInterface[] data;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GraphViewXML);
        String dataStr = a.getString(R.styleable.GraphViewXML_seriesData);
        int color = a.getColor(R.styleable.GraphViewXML_seriesColor, 0);
        String type = a.getString(R.styleable.GraphViewXML_seriesType);
        String seriesTitle = a.getString(R.styleable.GraphViewXML_seriesTitle);
        String title = a.getString(R.styleable.GraphViewXML_android_title);
        a.recycle();
        if (dataStr == null || dataStr.isEmpty()) {
            throw new IllegalArgumentException("Attribute seriesData is required in the format: 0=5.0;1=5;2=4;3=9");
        }
        String[] d = dataStr.split(";");
        try {
            data = new DataPoint[d.length];
            int i = 0;
            for (String dd : d) {
                String[] xy = dd.split("=");
                data[i] = new DataPoint(Double.parseDouble(xy[0]), Double.parseDouble(xy[1]));
                ++i;
            }
        }
        catch (Exception e) {
            Log.e((String)"GraphViewXML", (String)e.toString());
            throw new IllegalArgumentException("Attribute seriesData is broken. Use this format: 0=5.0;1=5;2=4;3=9");
        }
        if (type == null || type.isEmpty()) {
            type = "line";
        }
        if (type.equals("line")) {
            series = new LineGraphSeries(data);
        } else if (type.equals("bar")) {
            series = new BarGraphSeries(data);
        } else if (type.equals("points")) {
            series = new PointsGraphSeries(data);
        } else {
            throw new IllegalArgumentException("unknown graph type: " + type + ". Possible is line|bar|points");
        }
        if (color != 0) {
            series.setColor(color);
        }
        this.addSeries(series);
        if (seriesTitle != null && !seriesTitle.isEmpty()) {
            series.setTitle(seriesTitle);
            this.getLegendRenderer().setVisible(true);
        }
        if (title != null && !title.isEmpty()) {
            this.setTitle(title);
        }
    }
}

