/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.TypedValue;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.series.Series;
import java.util.ArrayList;

public class LegendRenderer {
    private Styles mStyles;
    private final GraphView mGraphView;
    private boolean mIsVisible;
    private Paint mPaint;
    private int cachedLegendWidth;

    public LegendRenderer(GraphView graphView) {
        this.mGraphView = graphView;
        this.mIsVisible = false;
        this.mPaint = new Paint();
        this.mPaint.setTextAlign(Paint.Align.LEFT);
        this.mStyles = new Styles();
        this.cachedLegendWidth = 0;
        this.resetStyles();
    }

    public void resetStyles() {
        int color1;
        this.mStyles.align = LegendAlign.MIDDLE;
        this.mStyles.textSize = this.mGraphView.getGridLabelRenderer().getTextSize();
        this.mStyles.spacing = (int)(this.mStyles.textSize / 5.0f);
        this.mStyles.padding = (int)(this.mStyles.textSize / 2.0f);
        this.mStyles.width = 0;
        this.mStyles.backgroundColor = Color.argb((int)180, (int)100, (int)100, (int)100);
        this.mStyles.margin = (int)(this.mStyles.textSize / 5.0f);
        TypedValue typedValue = new TypedValue();
        this.mGraphView.getContext().getTheme().resolveAttribute(16842818, typedValue, true);
        try {
            TypedArray array = this.mGraphView.getContext().obtainStyledAttributes(typedValue.data, new int[]{16842806});
            color1 = array.getColor(0, -16777216);
            array.recycle();
        }
        catch (Exception e) {
            color1 = -16777216;
        }
        this.mStyles.textColor = color1;
        this.cachedLegendWidth = 0;
    }

    public void draw(Canvas canvas) {
        float lTop;
        float lLeft;
        int legendWidth;
        if (!this.mIsVisible) {
            return;
        }
        this.mPaint.setTextSize(this.mStyles.textSize);
        int shapeSize = (int)((double)this.mStyles.textSize * 0.8);
        ArrayList<Series> allSeries = new ArrayList<Series>();
        allSeries.addAll(this.mGraphView.getSeries());
        if (this.mGraphView.mSecondScale != null) {
            allSeries.addAll(this.mGraphView.getSecondScale().getSeries());
        }
        if ((legendWidth = this.mStyles.width) == 0 && (legendWidth = this.cachedLegendWidth) == 0) {
            Rect textBounds = new Rect();
            for (Series s : allSeries) {
                if (s.getTitle() == null) continue;
                this.mPaint.getTextBounds(s.getTitle(), 0, s.getTitle().length(), textBounds);
                legendWidth = Math.max(legendWidth, textBounds.width());
            }
            if (legendWidth == 0) {
                legendWidth = 1;
            }
            this.cachedLegendWidth = legendWidth += shapeSize + this.mStyles.padding * 2 + this.mStyles.spacing;
        }
        float legendHeight = (this.mStyles.textSize + (float)this.mStyles.spacing) * (float)allSeries.size() - (float)this.mStyles.spacing;
        if (this.mStyles.fixedPosition != null) {
            lLeft = this.mGraphView.getGraphContentLeft() + this.mStyles.margin + this.mStyles.fixedPosition.x;
            lTop = this.mGraphView.getGraphContentTop() + this.mStyles.margin + this.mStyles.fixedPosition.y;
        } else {
            lLeft = this.mGraphView.getGraphContentLeft() + this.mGraphView.getGraphContentWidth() - legendWidth - this.mStyles.margin;
            switch (this.mStyles.align) {
                case TOP: {
                    lTop = this.mGraphView.getGraphContentTop() + this.mStyles.margin;
                    break;
                }
                case MIDDLE: {
                    lTop = (float)(this.mGraphView.getHeight() / 2) - legendHeight / 2.0f;
                    break;
                }
                default: {
                    lTop = (float)(this.mGraphView.getGraphContentTop() + this.mGraphView.getGraphContentHeight() - this.mStyles.margin) - legendHeight - (float)(2 * this.mStyles.padding);
                }
            }
        }
        float lRight = lLeft + (float)legendWidth;
        float lBottom = lTop + legendHeight + (float)(2 * this.mStyles.padding);
        this.mPaint.setColor(this.mStyles.backgroundColor);
        canvas.drawRoundRect(new RectF(lLeft, lTop, lRight, lBottom), 8.0f, 8.0f, this.mPaint);
        int i = 0;
        for (Series series : allSeries) {
            this.mPaint.setColor(series.getColor());
            canvas.drawRect(new RectF(lLeft + (float)this.mStyles.padding, lTop + (float)this.mStyles.padding + (float)i * (this.mStyles.textSize + (float)this.mStyles.spacing), lLeft + (float)this.mStyles.padding + (float)shapeSize, lTop + (float)this.mStyles.padding + (float)i * (this.mStyles.textSize + (float)this.mStyles.spacing) + (float)shapeSize), this.mPaint);
            if (series.getTitle() != null) {
                this.mPaint.setColor(this.mStyles.textColor);
                canvas.drawText(series.getTitle(), lLeft + (float)this.mStyles.padding + (float)shapeSize + (float)this.mStyles.spacing, lTop + (float)this.mStyles.padding + this.mStyles.textSize + (float)i * (this.mStyles.textSize + (float)this.mStyles.spacing), this.mPaint);
            }
            ++i;
        }
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public void setVisible(boolean mIsVisible) {
        this.mIsVisible = mIsVisible;
    }

    public float getTextSize() {
        return this.mStyles.textSize;
    }

    public void setTextSize(float textSize) {
        this.mStyles.textSize = textSize;
        this.cachedLegendWidth = 0;
    }

    public int getSpacing() {
        return this.mStyles.spacing;
    }

    public void setSpacing(int spacing) {
        this.mStyles.spacing = spacing;
    }

    public int getPadding() {
        return this.mStyles.padding;
    }

    public void setPadding(int padding) {
        this.mStyles.padding = padding;
    }

    public int getWidth() {
        return this.mStyles.width;
    }

    public void setWidth(int width) {
        this.mStyles.width = width;
    }

    public int getBackgroundColor() {
        return this.mStyles.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mStyles.backgroundColor = backgroundColor;
    }

    public int getMargin() {
        return this.mStyles.margin;
    }

    public void setMargin(int margin) {
        this.mStyles.margin = margin;
    }

    public LegendAlign getAlign() {
        return this.mStyles.align;
    }

    public void setAlign(LegendAlign align) {
        this.mStyles.align = align;
    }

    public int getTextColor() {
        return this.mStyles.textColor;
    }

    public void setTextColor(int textColor) {
        this.mStyles.textColor = textColor;
    }

    public void setFixedPosition(int x, int y) {
        this.mStyles.fixedPosition = new Point(x, y);
    }

    public static enum LegendAlign {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    private final class Styles {
        float textSize;
        int spacing;
        int padding;
        int width;
        int backgroundColor;
        int textColor;
        int margin;
        LegendAlign align;
        Point fixedPosition;

        private Styles() {
        }
    }
}

