/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.OverScroller;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.RectD;
import com.jjoe64.graphview.series.DataPointInterface;
import com.jjoe64.graphview.series.Series;
import java.util.Iterator;
import java.util.List;

public class Viewport {
    private final ScaleGestureDetector.OnScaleGestureListener mScaleGestureListener = new ScaleGestureDetector.OnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            double overlap;
            double viewportWidth = Viewport.this.mCurrentViewport.width();
            double center = Viewport.this.mCurrentViewport.left + viewportWidth / 2.0;
            Viewport.this.mCurrentViewport.left = center - (viewportWidth /= (double)detector.getScaleFactor()) / 2.0;
            Viewport.this.mCurrentViewport.right = Viewport.this.mCurrentViewport.left + viewportWidth;
            double minX = Viewport.this.getMinX(true);
            if (Viewport.this.mCurrentViewport.left < minX) {
                Viewport.this.mCurrentViewport.left = minX;
                Viewport.this.mCurrentViewport.right = Viewport.this.mCurrentViewport.left + viewportWidth;
            }
            double maxX = Viewport.this.getMaxX(true);
            if (viewportWidth == 0.0) {
                Viewport.this.mCurrentViewport.right = maxX;
            }
            if ((overlap = Viewport.this.mCurrentViewport.left + viewportWidth - maxX) > 0.0) {
                if (Viewport.this.mCurrentViewport.left - overlap > minX) {
                    Viewport.this.mCurrentViewport.left -= overlap;
                    Viewport.this.mCurrentViewport.right = Viewport.this.mCurrentViewport.left + viewportWidth;
                } else {
                    Viewport.this.mCurrentViewport.left = minX;
                    Viewport.this.mCurrentViewport.right = maxX;
                }
            }
            Viewport.this.mGraphView.onDataChanged(true, false);
            ViewCompat.postInvalidateOnAnimation((View)Viewport.this.mGraphView);
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            if (Viewport.this.mIsScalable) {
                Viewport.this.mScalingActive = true;
                return true;
            }
            return false;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            Viewport.this.mScalingActive = false;
            if (Viewport.this.mOnXAxisBoundsChangedListener != null) {
                Viewport.this.mOnXAxisBoundsChangedListener.onXAxisBoundsChanged(Viewport.this.getMinX(false), Viewport.this.getMaxX(false), OnXAxisBoundsChangedListener.Reason.SCALE);
            }
            ViewCompat.postInvalidateOnAnimation((View)Viewport.this.mGraphView);
        }
    };
    private final GestureDetector.SimpleOnGestureListener mGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent e) {
            if (!Viewport.this.mIsScrollable || Viewport.this.mScalingActive) {
                return false;
            }
            Viewport.this.releaseEdgeEffects();
            Viewport.this.mScrollerStartViewport.set(Viewport.this.mCurrentViewport.toRectF());
            Viewport.this.mScroller.forceFinished(true);
            ViewCompat.postInvalidateOnAnimation((View)Viewport.this.mGraphView);
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            boolean canScrollY;
            if (!Viewport.this.mIsScrollable || Viewport.this.mScalingActive) {
                return false;
            }
            double viewportOffsetX = (double)distanceX * Viewport.this.mCurrentViewport.width() / (double)Viewport.this.mGraphView.getGraphContentWidth();
            double viewportOffsetY = (double)(-distanceY) * Viewport.this.mCurrentViewport.height() / (double)Viewport.this.mGraphView.getGraphContentHeight();
            int completeWidth = (int)(Viewport.this.mCompleteRange.width() / Viewport.this.mCurrentViewport.width() * (double)Viewport.this.mGraphView.getGraphContentWidth());
            int completeHeight = (int)(Viewport.this.mCompleteRange.height() / Viewport.this.mCurrentViewport.height() * (double)Viewport.this.mGraphView.getGraphContentHeight());
            int scrolledX = (int)((double)completeWidth * (Viewport.this.mCurrentViewport.left + viewportOffsetX - Viewport.this.mCompleteRange.left) / Viewport.this.mCompleteRange.width());
            int scrolledY = (int)((double)completeHeight * (Viewport.this.mCompleteRange.bottom - Viewport.this.mCurrentViewport.bottom - viewportOffsetY) / Viewport.this.mCompleteRange.height());
            boolean canScrollX = Viewport.this.mCurrentViewport.left > Viewport.this.mCompleteRange.left || Viewport.this.mCurrentViewport.right < Viewport.this.mCompleteRange.right;
            boolean bl = canScrollY = Viewport.this.mCurrentViewport.bottom > Viewport.this.mCompleteRange.bottom || Viewport.this.mCurrentViewport.top < Viewport.this.mCompleteRange.top;
            if (canScrollX) {
                if (viewportOffsetX < 0.0) {
                    double tooMuch = Viewport.this.mCurrentViewport.left + viewportOffsetX - Viewport.this.mCompleteRange.left;
                    if (tooMuch < 0.0) {
                        viewportOffsetX -= tooMuch;
                    }
                } else {
                    double tooMuch = Viewport.this.mCurrentViewport.right + viewportOffsetX - Viewport.this.mCompleteRange.right;
                    if (tooMuch > 0.0) {
                        viewportOffsetX -= tooMuch;
                    }
                }
                Viewport.this.mCurrentViewport.left += viewportOffsetX;
                Viewport.this.mCurrentViewport.right += viewportOffsetX;
                if (Viewport.this.mOnXAxisBoundsChangedListener != null) {
                    Viewport.this.mOnXAxisBoundsChangedListener.onXAxisBoundsChanged(Viewport.this.getMinX(false), Viewport.this.getMaxX(false), OnXAxisBoundsChangedListener.Reason.SCROLL);
                }
            }
            if (canScrollY) {
                // empty if block
            }
            if (canScrollX && scrolledX < 0) {
                Viewport.this.mEdgeEffectLeft.onPull((float)scrolledX / (float)Viewport.this.mGraphView.getGraphContentWidth());
                Viewport.this.mEdgeEffectLeftActive = true;
            }
            if (canScrollY && scrolledY < 0) {
                Viewport.this.mEdgeEffectBottom.onPull((float)scrolledY / (float)Viewport.this.mGraphView.getGraphContentHeight());
                Viewport.this.mEdgeEffectBottomActive = true;
            }
            if (canScrollX && scrolledX > completeWidth - Viewport.this.mGraphView.getGraphContentWidth()) {
                Viewport.this.mEdgeEffectRight.onPull((float)(scrolledX - completeWidth + Viewport.this.mGraphView.getGraphContentWidth()) / (float)Viewport.this.mGraphView.getGraphContentWidth());
                Viewport.this.mEdgeEffectRightActive = true;
            }
            Viewport.this.mGraphView.onDataChanged(true, false);
            ViewCompat.postInvalidateOnAnimation((View)Viewport.this.mGraphView);
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return true;
        }
    };
    private Paint mPaint;
    private final GraphView mGraphView;
    protected RectD mCurrentViewport = new RectD();
    protected RectD mCompleteRange = new RectD();
    protected boolean mScalingActive;
    private boolean mIsScrollable;
    private boolean mIsScalable;
    protected GestureDetector mGestureDetector;
    protected ScaleGestureDetector mScaleGestureDetector;
    protected OverScroller mScroller;
    private EdgeEffectCompat mEdgeEffectTop;
    private EdgeEffectCompat mEdgeEffectBottom;
    private EdgeEffectCompat mEdgeEffectLeft;
    private EdgeEffectCompat mEdgeEffectRight;
    private boolean mEdgeEffectTopActive;
    private boolean mEdgeEffectBottomActive;
    private boolean mEdgeEffectLeftActive;
    private boolean mEdgeEffectRightActive;
    private RectF mScrollerStartViewport = new RectF();
    protected AxisBoundsStatus mXAxisBoundsStatus;
    private AxisBoundsStatus mYAxisBoundsStatus;
    private boolean mXAxisBoundsManual;
    private boolean mYAxisBoundsManual;
    private int mBackgroundColor;
    protected OnXAxisBoundsChangedListener mOnXAxisBoundsChangedListener;
    private boolean mDrawBorder;
    private Integer mBorderColor;
    private Paint mBorderPaint;

    Viewport(GraphView graphView) {
        this.mScroller = new OverScroller(graphView.getContext());
        this.mEdgeEffectTop = new EdgeEffectCompat(graphView.getContext());
        this.mEdgeEffectBottom = new EdgeEffectCompat(graphView.getContext());
        this.mEdgeEffectLeft = new EdgeEffectCompat(graphView.getContext());
        this.mEdgeEffectRight = new EdgeEffectCompat(graphView.getContext());
        this.mGestureDetector = new GestureDetector(graphView.getContext(), (GestureDetector.OnGestureListener)this.mGestureListener);
        this.mScaleGestureDetector = new ScaleGestureDetector(graphView.getContext(), this.mScaleGestureListener);
        this.mGraphView = graphView;
        this.mXAxisBoundsStatus = AxisBoundsStatus.INITIAL;
        this.mYAxisBoundsStatus = AxisBoundsStatus.INITIAL;
        this.mBackgroundColor = 0;
        this.mPaint = new Paint();
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean b = this.mScaleGestureDetector.onTouchEvent(event);
        return b |= this.mGestureDetector.onTouchEvent(event);
    }

    public void setXAxisBoundsStatus(AxisBoundsStatus s) {
        this.mXAxisBoundsStatus = s;
    }

    public void setYAxisBoundsStatus(AxisBoundsStatus s) {
        this.mYAxisBoundsStatus = s;
    }

    public boolean isScrollable() {
        return this.mIsScrollable;
    }

    public void setScrollable(boolean mIsScrollable) {
        this.mIsScrollable = mIsScrollable;
    }

    public AxisBoundsStatus getXAxisBoundsStatus() {
        return this.mXAxisBoundsStatus;
    }

    public AxisBoundsStatus getYAxisBoundsStatus() {
        return this.mYAxisBoundsStatus;
    }

    public void calcCompleteRange() {
        double d;
        List<Series> series = this.mGraphView.getSeries();
        this.mCompleteRange.set(0.0, 0.0, 0.0, 0.0);
        if (!series.isEmpty() && !series.get(0).isEmpty()) {
            d = series.get(0).getLowestValueX();
            for (Series s : series) {
                if (s.isEmpty() || !(d > s.getLowestValueX())) continue;
                d = s.getLowestValueX();
            }
            this.mCompleteRange.left = d;
            d = series.get(0).getHighestValueX();
            for (Series s : series) {
                if (s.isEmpty() || !(d < s.getHighestValueX())) continue;
                d = s.getHighestValueX();
            }
            this.mCompleteRange.right = d;
            if (!this.mYAxisBoundsManual) {
                d = series.get(0).getLowestValueY();
                for (Series s : series) {
                    if (s.isEmpty() || !(d > s.getLowestValueY())) continue;
                    d = s.getLowestValueY();
                }
                this.mCompleteRange.bottom = d;
            }
            d = series.get(0).getHighestValueY();
            for (Series s : series) {
                if (s.isEmpty() || !(d < s.getHighestValueY())) continue;
                d = s.getHighestValueY();
            }
            this.mCompleteRange.top = d;
        }
        if (this.mYAxisBoundsStatus == AxisBoundsStatus.AUTO_ADJUSTED) {
            this.mYAxisBoundsStatus = AxisBoundsStatus.INITIAL;
        }
        if (this.mYAxisBoundsStatus == AxisBoundsStatus.INITIAL) {
            this.mCurrentViewport.top = this.mCompleteRange.top;
            this.mCurrentViewport.bottom = this.mCompleteRange.bottom;
        }
        if (this.mXAxisBoundsStatus == AxisBoundsStatus.AUTO_ADJUSTED) {
            this.mXAxisBoundsStatus = AxisBoundsStatus.INITIAL;
        }
        if (this.mXAxisBoundsStatus == AxisBoundsStatus.INITIAL) {
            this.mCurrentViewport.left = this.mCompleteRange.left;
            this.mCurrentViewport.right = this.mCompleteRange.right;
        } else if (this.mXAxisBoundsManual && !this.mYAxisBoundsManual && this.mCompleteRange.width() != 0.0) {
            double v;
            Iterator values;
            d = Double.MAX_VALUE;
            for (Series s : series) {
                values = s.getValues(this.mCurrentViewport.left, this.mCurrentViewport.right);
                while (values.hasNext()) {
                    v = ((DataPointInterface)values.next()).getY();
                    if (!(d > v)) continue;
                    d = v;
                }
            }
            this.mCurrentViewport.bottom = d;
            d = Double.MIN_VALUE;
            for (Series s : series) {
                values = s.getValues(this.mCurrentViewport.left, this.mCurrentViewport.right);
                while (values.hasNext()) {
                    v = ((DataPointInterface)values.next()).getY();
                    if (!(d < v)) continue;
                    d = v;
                }
            }
            this.mCurrentViewport.top = d;
        }
        if (this.mCurrentViewport.left == this.mCurrentViewport.right) {
            this.mCurrentViewport.right += 1.0;
        }
        if (this.mCurrentViewport.top == this.mCurrentViewport.bottom) {
            this.mCurrentViewport.top += 1.0;
        }
    }

    public double getMinX(boolean completeRange) {
        if (completeRange) {
            return this.mCompleteRange.left;
        }
        return this.mCurrentViewport.left;
    }

    public double getMaxX(boolean completeRange) {
        if (completeRange) {
            return this.mCompleteRange.right;
        }
        return this.mCurrentViewport.right;
    }

    public double getMinY(boolean completeRange) {
        if (completeRange) {
            return this.mCompleteRange.bottom;
        }
        return this.mCurrentViewport.bottom;
    }

    public double getMaxY(boolean completeRange) {
        if (completeRange) {
            return this.mCompleteRange.top;
        }
        return this.mCurrentViewport.top;
    }

    public void setMaxY(double y) {
        this.mCurrentViewport.top = y;
    }

    public void setMinY(double y) {
        this.mCurrentViewport.bottom = y;
    }

    public void setMaxX(double x) {
        this.mCurrentViewport.right = x;
    }

    public void setMinX(double x) {
        this.mCurrentViewport.left = x;
    }

    private void releaseEdgeEffects() {
        this.mEdgeEffectRightActive = false;
        this.mEdgeEffectLeftActive = false;
        this.mEdgeEffectLeft.onRelease();
        this.mEdgeEffectRight.onRelease();
    }

    private void fling(int velocityX, int velocityY) {
        velocityY = 0;
        this.releaseEdgeEffects();
        this.mScrollerStartViewport.set(this.mCurrentViewport.toRectF());
        int maxX = (int)(this.mCurrentViewport.width() / this.mCompleteRange.width() * (double)this.mGraphView.getGraphContentWidth()) - this.mGraphView.getGraphContentWidth();
        int maxY = (int)(this.mCurrentViewport.height() / this.mCompleteRange.height() * (double)this.mGraphView.getGraphContentHeight()) - this.mGraphView.getGraphContentHeight();
        int startX = (int)((this.mCurrentViewport.left - this.mCompleteRange.left) / this.mCompleteRange.width()) * maxX;
        int startY = (int)((this.mCurrentViewport.top - this.mCompleteRange.top) / this.mCompleteRange.height()) * maxY;
        this.mScroller.forceFinished(true);
        this.mScroller.fling(startX, startY, velocityX, velocityY, 0, maxX, 0, maxY, this.mGraphView.getGraphContentWidth() / 2, this.mGraphView.getGraphContentHeight() / 2);
        ViewCompat.postInvalidateOnAnimation((View)this.mGraphView);
    }

    public void computeScroll() {
    }

    private void drawEdgeEffectsUnclipped(Canvas canvas) {
        int restoreCount;
        boolean needsInvalidate = false;
        if (!this.mEdgeEffectTop.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate((float)this.mGraphView.getGraphContentLeft(), (float)this.mGraphView.getGraphContentTop());
            this.mEdgeEffectTop.setSize(this.mGraphView.getGraphContentWidth(), this.mGraphView.getGraphContentHeight());
            if (this.mEdgeEffectTop.draw(canvas)) {
                needsInvalidate = true;
            }
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeEffectLeft.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate((float)this.mGraphView.getGraphContentLeft(), (float)(this.mGraphView.getGraphContentTop() + this.mGraphView.getGraphContentHeight()));
            canvas.rotate(-90.0f, 0.0f, 0.0f);
            this.mEdgeEffectLeft.setSize(this.mGraphView.getGraphContentHeight(), this.mGraphView.getGraphContentWidth());
            if (this.mEdgeEffectLeft.draw(canvas)) {
                needsInvalidate = true;
            }
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeEffectRight.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate((float)(this.mGraphView.getGraphContentLeft() + this.mGraphView.getGraphContentWidth()), (float)this.mGraphView.getGraphContentTop());
            canvas.rotate(90.0f, 0.0f, 0.0f);
            this.mEdgeEffectRight.setSize(this.mGraphView.getGraphContentHeight(), this.mGraphView.getGraphContentWidth());
            if (this.mEdgeEffectRight.draw(canvas)) {
                needsInvalidate = true;
            }
            canvas.restoreToCount(restoreCount);
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this.mGraphView);
        }
    }

    public void drawFirst(Canvas c) {
        if (this.mBackgroundColor != 0) {
            this.mPaint.setColor(this.mBackgroundColor);
            c.drawRect((float)this.mGraphView.getGraphContentLeft(), (float)this.mGraphView.getGraphContentTop(), (float)(this.mGraphView.getGraphContentLeft() + this.mGraphView.getGraphContentWidth()), (float)(this.mGraphView.getGraphContentTop() + this.mGraphView.getGraphContentHeight()), this.mPaint);
        }
        if (this.mDrawBorder) {
            Paint p;
            if (this.mBorderPaint != null) {
                p = this.mBorderPaint;
            } else {
                p = this.mPaint;
                p.setColor(this.getBorderColor());
            }
            c.drawLine((float)this.mGraphView.getGraphContentLeft(), (float)this.mGraphView.getGraphContentTop(), (float)this.mGraphView.getGraphContentLeft(), (float)(this.mGraphView.getGraphContentTop() + this.mGraphView.getGraphContentHeight()), p);
            c.drawLine((float)this.mGraphView.getGraphContentLeft(), (float)(this.mGraphView.getGraphContentTop() + this.mGraphView.getGraphContentHeight()), (float)(this.mGraphView.getGraphContentLeft() + this.mGraphView.getGraphContentWidth()), (float)(this.mGraphView.getGraphContentTop() + this.mGraphView.getGraphContentHeight()), p);
            if (this.mGraphView.mSecondScale != null) {
                c.drawLine((float)(this.mGraphView.getGraphContentLeft() + this.mGraphView.getGraphContentWidth()), (float)this.mGraphView.getGraphContentTop(), (float)(this.mGraphView.getGraphContentLeft() + this.mGraphView.getGraphContentWidth()), (float)(this.mGraphView.getGraphContentTop() + this.mGraphView.getGraphContentHeight()), p);
            }
        }
    }

    public void draw(Canvas c) {
        this.drawEdgeEffectsUnclipped(c);
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(int mBackgroundColor) {
        this.mBackgroundColor = mBackgroundColor;
    }

    public boolean isScalable() {
        return this.mIsScalable;
    }

    public void setScalable(boolean mIsScalable) {
        this.mIsScalable = mIsScalable;
        if (mIsScalable) {
            this.mIsScrollable = true;
            this.setXAxisBoundsManual(true);
        }
    }

    public boolean isXAxisBoundsManual() {
        return this.mXAxisBoundsManual;
    }

    public void setXAxisBoundsManual(boolean mXAxisBoundsManual) {
        this.mXAxisBoundsManual = mXAxisBoundsManual;
        if (mXAxisBoundsManual) {
            this.mXAxisBoundsStatus = AxisBoundsStatus.FIX;
        }
    }

    public boolean isYAxisBoundsManual() {
        return this.mYAxisBoundsManual;
    }

    public void setYAxisBoundsManual(boolean mYAxisBoundsManual) {
        this.mYAxisBoundsManual = mYAxisBoundsManual;
        if (mYAxisBoundsManual) {
            this.mYAxisBoundsStatus = AxisBoundsStatus.FIX;
        }
    }

    public void scrollToEnd() {
        if (this.mXAxisBoundsManual) {
            double size = this.mCurrentViewport.width();
            this.mCurrentViewport.right = this.mCompleteRange.right;
            this.mCurrentViewport.left = this.mCompleteRange.right - size;
            this.mGraphView.onDataChanged(true, false);
        } else {
            Log.w((String)"GraphView", (String)"scrollToEnd works only with manual x axis bounds");
        }
    }

    public OnXAxisBoundsChangedListener getOnXAxisBoundsChangedListener() {
        return this.mOnXAxisBoundsChangedListener;
    }

    public void setOnXAxisBoundsChangedListener(OnXAxisBoundsChangedListener l) {
        this.mOnXAxisBoundsChangedListener = l;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.mDrawBorder = drawBorder;
    }

    public int getBorderColor() {
        if (this.mBorderColor != null) {
            return this.mBorderColor;
        }
        return this.mGraphView.getGridLabelRenderer().getGridColor();
    }

    public void setBorderColor(Integer borderColor) {
        this.mBorderColor = borderColor;
    }

    public void setBorderPaint(Paint borderPaint) {
        this.mBorderPaint = borderPaint;
    }

    public static enum AxisBoundsStatus {
        INITIAL,
        AUTO_ADJUSTED,
        FIX;

    }

    public static interface OnXAxisBoundsChangedListener {
        public void onXAxisBoundsChanged(double var1, double var3, Reason var5);

        public static enum Reason {
            SCROLL,
            SCALE;

        }
    }
}

