/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview.series;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.RectD;
import com.jjoe64.graphview.ValueDependentColor;
import com.jjoe64.graphview.series.BaseSeries;
import com.jjoe64.graphview.series.DataPointInterface;
import com.jjoe64.graphview.series.Series;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class BarGraphSeries<E extends DataPointInterface>
extends BaseSeries<E> {
    private Paint mPaint;
    private Paint mCustomPaint;
    private int mSpacing;
    private ValueDependentColor<E> mValueDependentColor;
    private boolean mDrawValuesOnTop;
    private int mValuesOnTopColor;
    private float mValuesOnTopSize;
    private Map<RectD, E> mDataPoints = new HashMap<RectD, E>();

    public BarGraphSeries() {
        this.mPaint = new Paint();
    }

    public BarGraphSeries(E[] data) {
        super(data);
        this.mPaint = new Paint();
    }

    @Override
    public void draw(GraphView graphView, Canvas canvas, boolean isSecondScale) {
        double minY;
        double maxY;
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        if (this.mValuesOnTopSize == 0.0f) {
            this.mValuesOnTopSize = graphView.getGridLabelRenderer().getTextSize();
        }
        this.mPaint.setTextSize(this.mValuesOnTopSize);
        this.resetDataPoints();
        double maxX = graphView.getViewport().getMaxX(false);
        double minX = graphView.getViewport().getMinX(false);
        if (isSecondScale) {
            maxY = graphView.getSecondScale().getMaxY();
            minY = graphView.getSecondScale().getMinY();
        } else {
            maxY = graphView.getViewport().getMaxY(false);
            minY = graphView.getViewport().getMinY(false);
        }
        int numBarSeries = 0;
        int currentSeriesOrder = 0;
        int numValues = 0;
        TreeSet<Double> xVals = new TreeSet<Double>();
        for (Series inspectedSeries : graphView.getSeries()) {
            boolean isCurrentSeries;
            if (!(inspectedSeries instanceof BarGraphSeries)) continue;
            boolean bl = isCurrentSeries = inspectedSeries == this;
            if (isCurrentSeries) {
                currentSeriesOrder = numBarSeries;
            }
            ++numBarSeries;
            Iterator curValues = inspectedSeries.getValues(minX, maxX);
            if (!curValues.hasNext()) continue;
            xVals.add(((DataPointInterface)curValues.next()).getX());
            if (isCurrentSeries) {
                ++numValues;
            }
            while (curValues.hasNext()) {
                xVals.add(((DataPointInterface)curValues.next()).getX());
                if (!isCurrentSeries) continue;
                ++numValues;
            }
        }
        if (numValues == 0) {
            return;
        }
        Double lastVal = null;
        double minGap = 0.0;
        for (Double curVal : xVals) {
            if (lastVal != null) {
                double curGap = Math.abs(curVal - lastVal);
                if (minGap == 0.0 || curGap > 0.0 && curGap < minGap) {
                    minGap = curGap;
                }
            }
            lastVal = curVal;
        }
        int numBarSlots = minGap == 0.0 ? 1 : (int)Math.round((maxX - minX) / minGap) + 1;
        Iterator values = this.getValues(minX, maxX);
        int barSlotWidth = numBarSlots == 1 ? graphView.getGraphContentWidth() : graphView.getGraphContentWidth() / (numBarSlots - 1);
        double spacing = Math.min((float)(barSlotWidth * this.mSpacing / 100), (float)barSlotWidth * 0.98f);
        double barWidth = ((double)barSlotWidth - spacing) / (double)numBarSeries;
        double offset = barSlotWidth / 2;
        double diffY = maxY - minY;
        double diffX = maxX - minX;
        double contentHeight = graphView.getGraphContentHeight();
        double contentWidth = graphView.getGraphContentWidth();
        double contentLeft = graphView.getGraphContentLeft();
        double contentTop = graphView.getGraphContentTop();
        int i = 0;
        while (values.hasNext()) {
            boolean reverse;
            DataPointInterface value = (DataPointInterface)values.next();
            double valY = value.getY() - minY;
            double ratY = valY / diffY;
            double y = contentHeight * ratY;
            double valY0 = 0.0 - minY;
            double ratY0 = valY0 / diffY;
            double y0 = contentHeight * ratY0;
            double valX = value.getX() - minX;
            double ratX = valX / diffX;
            double x = contentWidth * ratX;
            if (this.getValueDependentColor() != null) {
                this.mPaint.setColor(this.getValueDependentColor().get(value));
            } else {
                this.mPaint.setColor(this.getColor());
            }
            double left = x + contentLeft - offset + spacing / 2.0 + (double)currentSeriesOrder * barWidth;
            double top = contentTop - y + contentHeight;
            double right = left + barWidth;
            double bottom = contentTop - y0 + contentHeight - (double)(graphView.getGridLabelRenderer().isHighlightZeroLines() ? 4 : 1);
            boolean bl = reverse = top > bottom;
            if (reverse) {
                double tmp = top;
                top = bottom + (double)(graphView.getGridLabelRenderer().isHighlightZeroLines() ? 4 : 1);
                bottom = tmp;
            }
            left = Math.max(left, contentLeft);
            right = Math.min(right, contentLeft + contentWidth);
            bottom = Math.min(bottom, contentTop + contentHeight);
            top = Math.max(top, contentTop);
            this.mDataPoints.put(new RectD(left, top, right, bottom), value);
            Paint p = this.mCustomPaint != null ? this.mCustomPaint : this.mPaint;
            canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, p);
            if (this.mDrawValuesOnTop) {
                if (reverse) {
                    top = bottom + (double)this.mValuesOnTopSize + 4.0;
                    if (top > contentTop + contentHeight) {
                        top = contentTop + contentHeight;
                    }
                } else if ((top -= 4.0) <= contentTop) {
                    top += contentTop + 4.0;
                }
                this.mPaint.setColor(this.mValuesOnTopColor);
                canvas.drawText(graphView.getGridLabelRenderer().getLabelFormatter().formatLabel(value.getY(), false), (float)(left + right) / 2.0f, (float)top, this.mPaint);
            }
            ++i;
        }
    }

    public ValueDependentColor<E> getValueDependentColor() {
        return this.mValueDependentColor;
    }

    public void setValueDependentColor(ValueDependentColor<E> mValueDependentColor) {
        this.mValueDependentColor = mValueDependentColor;
    }

    public int getSpacing() {
        return this.mSpacing;
    }

    public void setSpacing(int mSpacing) {
        this.mSpacing = mSpacing;
    }

    public boolean isDrawValuesOnTop() {
        return this.mDrawValuesOnTop;
    }

    public void setDrawValuesOnTop(boolean mDrawValuesOnTop) {
        this.mDrawValuesOnTop = mDrawValuesOnTop;
    }

    public int getValuesOnTopColor() {
        return this.mValuesOnTopColor;
    }

    public void setValuesOnTopColor(int mValuesOnTopColor) {
        this.mValuesOnTopColor = mValuesOnTopColor;
    }

    public float getValuesOnTopSize() {
        return this.mValuesOnTopSize;
    }

    public void setValuesOnTopSize(float mValuesOnTopSize) {
        this.mValuesOnTopSize = mValuesOnTopSize;
    }

    @Override
    protected void resetDataPoints() {
        this.mDataPoints.clear();
    }

    @Override
    protected E findDataPoint(float x, float y) {
        for (Map.Entry<RectD, E> entry : this.mDataPoints.entrySet()) {
            if (!((double)x >= entry.getKey().left) || !((double)x <= entry.getKey().right) || !((double)y >= entry.getKey().top) || !((double)y <= entry.getKey().bottom)) continue;
            return (E)((DataPointInterface)entry.getValue());
        }
        return null;
    }

    public Paint getCustomPaint() {
        return this.mCustomPaint;
    }

    public void setCustomPaint(Paint mCustomPaint) {
        this.mCustomPaint = mCustomPaint;
    }
}

