/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.GraphViewDataInterface;
import com.jjoe64.graphview.GraphViewSeries;

public class LineGraphView
extends GraphView {
    private final Paint paintBackground = new Paint();
    private boolean drawBackground;
    private boolean drawDataPoints;
    private float dataPointsRadius = 10.0f;

    public LineGraphView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.paintBackground.setColor(Color.rgb((int)20, (int)40, (int)60));
        this.paintBackground.setStrokeWidth(4.0f);
        this.paintBackground.setAlpha(128);
    }

    public LineGraphView(Context context, String title) {
        super(context, title);
        this.paintBackground.setColor(Color.rgb((int)20, (int)40, (int)60));
        this.paintBackground.setStrokeWidth(4.0f);
        this.paintBackground.setAlpha(128);
    }

    @Override
    public void drawSeries(Canvas canvas, GraphViewDataInterface[] values, float graphwidth, float graphheight, float border, double minX, double minY, double diffX, double diffY, float horstart, GraphViewSeries.GraphViewSeriesStyle style) {
        double lastEndY = 0.0;
        double lastEndX = 0.0;
        this.paint.setStrokeWidth((float)style.thickness);
        this.paint.setColor(style.color);
        Path bgPath = null;
        if (this.drawBackground) {
            bgPath = new Path();
        }
        lastEndY = 0.0;
        lastEndX = 0.0;
        float firstX = 0.0f;
        for (int i = 0; i < values.length; ++i) {
            double valY = values[i].getY() - minY;
            double ratY = valY / diffY;
            double y = (double)graphheight * ratY;
            double valX = values[i].getX() - minX;
            double ratX = valX / diffX;
            double x = (double)graphwidth * ratX;
            if (i > 0) {
                float startX = (float)lastEndX + (horstart + 1.0f);
                float startY = (float)((double)border - lastEndY) + graphheight;
                float endX = (float)x + (horstart + 1.0f);
                float endY = (float)((double)border - y) + graphheight;
                if (this.drawDataPoints) {
                    canvas.drawCircle(endX, endY, this.dataPointsRadius, this.paint);
                }
                canvas.drawLine(startX, startY, endX, endY, this.paint);
                if (bgPath != null) {
                    if (i == 1) {
                        firstX = startX;
                        bgPath.moveTo(startX, startY);
                    }
                    bgPath.lineTo(endX, endY);
                }
            } else if (this.drawDataPoints) {
                float first_X = (float)x + (horstart + 1.0f);
                float first_Y = (float)((double)border - y) + graphheight;
                canvas.drawCircle(first_X, first_Y, this.dataPointsRadius, this.paint);
            }
            lastEndY = y;
            lastEndX = x;
        }
        if (bgPath != null) {
            bgPath.lineTo((float)lastEndX, graphheight + border);
            bgPath.lineTo(firstX, graphheight + border);
            bgPath.close();
            canvas.drawPath(bgPath, this.paintBackground);
        }
    }

    public int getBackgroundColor() {
        return this.paintBackground.getColor();
    }

    public float getDataPointsRadius() {
        return this.dataPointsRadius;
    }

    public boolean getDrawBackground() {
        return this.drawBackground;
    }

    public boolean getDrawDataPoints() {
        return this.drawDataPoints;
    }

    public void setBackgroundColor(int color) {
        this.paintBackground.setColor(color);
    }

    public void setDataPointsRadius(float dataPointsRadius) {
        this.dataPointsRadius = dataPointsRadius;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public void setDrawDataPoints(boolean drawDataPoints) {
        this.drawDataPoints = drawDataPoints;
    }
}

