/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.jjoe64.graphview.CustomLabelFormatter;
import com.jjoe64.graphview.GraphViewDataInterface;
import com.jjoe64.graphview.GraphViewSeries;
import com.jjoe64.graphview.GraphViewStyle;
import com.jjoe64.graphview.compatible.ScaleGestureDetector;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class GraphView
extends LinearLayout {
    protected final Paint paint;
    private String[] horlabels;
    private String[] verlabels;
    private String title;
    private boolean scrollable;
    private boolean disableTouch;
    private double viewportStart;
    private double viewportSize;
    private final View viewVerLabels;
    private ScaleGestureDetector scaleDetector;
    private boolean scalable;
    private final NumberFormat[] numberformatter = new NumberFormat[2];
    private final List<GraphViewSeries> graphSeries;
    private boolean showLegend = false;
    private float legendWidth = 120.0f;
    private LegendAlign legendAlign = LegendAlign.MIDDLE;
    private boolean manualYAxis;
    private double manualMaxYValue;
    private double manualMinYValue;
    private GraphViewStyle graphViewStyle;
    private final GraphViewContentView graphViewContentView;
    private CustomLabelFormatter customLabelFormatter;
    private Integer textHeight;
    private Integer textWidth;
    private final Rect textBounds = new Rect();
    private boolean staticHorizontalLabels;
    private boolean staticVerticalLabels;

    public GraphView(Context context, AttributeSet attrs) {
        this(context, attrs.getAttributeValue(null, "title"));
        int width = attrs.getAttributeIntValue("android", "layout_width", -1);
        int height = attrs.getAttributeIntValue("android", "layout_height", -1);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height));
    }

    public GraphView(Context context, String title) {
        super(context);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        if (title == null) {
            title = "";
        } else {
            this.title = title;
        }
        this.graphViewStyle = new GraphViewStyle();
        this.paint = new Paint();
        this.graphSeries = new ArrayList<GraphViewSeries>();
        this.viewVerLabels = new VerLabelsView(context);
        this.addView(this.viewVerLabels);
        this.graphViewContentView = new GraphViewContentView(context);
        this.addView(this.graphViewContentView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphViewDataInterface[] _values(int idxSeries) {
        GraphViewDataInterface[] values;
        GraphViewDataInterface[] graphViewDataInterfaceArray = values = this.graphSeries.get((int)idxSeries).values;
        synchronized (values) {
            if (this.viewportStart == 0.0 && this.viewportSize == 0.0) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return values;
            }
            ArrayList<GraphViewDataInterface> listData = new ArrayList<GraphViewDataInterface>();
            int i = 0;
            while (i < values.length) {
                if (values[i].getX() >= this.viewportStart) {
                    if (values[i].getX() > this.viewportStart + this.viewportSize) {
                        listData.add(values[i]);
                        break;
                    }
                    listData.add(values[i]);
                } else {
                    if (listData.isEmpty()) {
                        listData.add(values[i]);
                    }
                    listData.set(0, values[i]);
                }
                ++i;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return listData.toArray(new GraphViewDataInterface[listData.size()]);
        }
    }

    public void addSeries(GraphViewSeries series) {
        series.addGraphView(this);
        this.graphSeries.add(series);
        this.redrawAll();
    }

    protected void drawLegend(Canvas canvas, float height, float width) {
        float lTop;
        int shapeSize = 15;
        this.paint.setARGB(180, 100, 100, 100);
        float legendHeight = (shapeSize + 5) * this.graphSeries.size() + 5;
        float lLeft = width - this.legendWidth - 10.0f;
        switch (this.legendAlign) {
            case TOP: {
                lTop = 10.0f;
                break;
            }
            case MIDDLE: {
                lTop = height / 2.0f - legendHeight / 2.0f;
                break;
            }
            default: {
                lTop = height - 20.0f - legendHeight - 10.0f;
            }
        }
        float lRight = lLeft + this.legendWidth;
        float lBottom = lTop + legendHeight;
        canvas.drawRoundRect(new RectF(lLeft, lTop, lRight, lBottom), 8.0f, 8.0f, this.paint);
        int i = 0;
        while (i < this.graphSeries.size()) {
            this.paint.setColor(this.graphSeries.get((int)i).style.color);
            canvas.drawRect(new RectF(lLeft + 5.0f, lTop + 5.0f + (float)(i * (shapeSize + 5)), lLeft + 5.0f + (float)shapeSize, lTop + (float)((i + 1) * (shapeSize + 5))), this.paint);
            if (this.graphSeries.get((int)i).description != null) {
                this.paint.setColor(-1);
                this.paint.setTextAlign(Paint.Align.LEFT);
                canvas.drawText(this.graphSeries.get((int)i).description, lLeft + 5.0f + (float)shapeSize + 5.0f, lTop + (float)shapeSize + (float)(i * (shapeSize + 5)), this.paint);
            }
            ++i;
        }
    }

    protected abstract void drawSeries(Canvas var1, GraphViewDataInterface[] var2, float var3, float var4, float var5, double var6, double var8, double var10, double var12, float var14, GraphViewSeries.GraphViewSeriesStyle var15);

    @Deprecated
    protected String formatLabel(double value, boolean isValueX) {
        int i;
        String label;
        if (this.customLabelFormatter != null && (label = this.customLabelFormatter.formatLabel(value, isValueX)) != null) {
            return label;
        }
        int n = i = isValueX ? 1 : 0;
        if (this.numberformatter[i] == null) {
            double lowestvalue;
            this.numberformatter[i] = NumberFormat.getNumberInstance();
            double highestvalue = isValueX ? this.getMaxX(false) : this.getMaxY();
            double d = lowestvalue = isValueX ? this.getMinX(false) : this.getMinY();
            if (highestvalue - lowestvalue < 0.1) {
                this.numberformatter[i].setMaximumFractionDigits(6);
            } else if (highestvalue - lowestvalue < 1.0) {
                this.numberformatter[i].setMaximumFractionDigits(4);
            } else if (highestvalue - lowestvalue < 20.0) {
                this.numberformatter[i].setMaximumFractionDigits(3);
            } else if (highestvalue - lowestvalue < 100.0) {
                this.numberformatter[i].setMaximumFractionDigits(1);
            } else {
                this.numberformatter[i].setMaximumFractionDigits(0);
            }
        }
        return this.numberformatter[i].format(value);
    }

    private String[] generateHorlabels(float graphwidth) {
        int numLabels = this.getGraphViewStyle().getNumHorizontalLabels() - 1;
        if (numLabels < 0) {
            numLabels = (int)(graphwidth / (float)(this.textWidth * 2));
        }
        String[] labels = new String[numLabels + 1];
        double min = this.getMinX(false);
        double max = this.getMaxX(false);
        int i = 0;
        while (i <= numLabels) {
            labels[i] = this.formatLabel(min + (max - min) * (double)i / (double)numLabels, true);
            ++i;
        }
        return labels;
    }

    private synchronized String[] generateVerlabels(float graphheight) {
        int numLabels = this.getGraphViewStyle().getNumVerticalLabels() - 1;
        if (numLabels < 0) {
            numLabels = (int)(graphheight / (float)(this.textHeight * 3));
        }
        String[] labels = new String[numLabels + 1];
        double min = this.getMinY();
        double max = this.getMaxY();
        if (max == min) {
            if (max == 0.0) {
                max = 1.0;
                min = 0.0;
            } else {
                max *= 1.05;
                min *= 0.95;
            }
        }
        int i = 0;
        while (i <= numLabels) {
            labels[numLabels - i] = this.formatLabel(min + (max - min) * (double)i / (double)numLabels, false);
            ++i;
        }
        return labels;
    }

    public CustomLabelFormatter getCustomLabelFormatter() {
        return this.customLabelFormatter;
    }

    public GraphViewStyle getGraphViewStyle() {
        return this.graphViewStyle;
    }

    public LegendAlign getLegendAlign() {
        return this.legendAlign;
    }

    public float getLegendWidth() {
        return this.legendWidth;
    }

    protected double getMaxX(boolean ignoreViewport) {
        if (!ignoreViewport && this.viewportSize != 0.0) {
            return this.viewportStart + this.viewportSize;
        }
        double highest = 0.0;
        if (this.graphSeries.size() > 0) {
            GraphViewDataInterface[] values = this.graphSeries.get((int)0).values;
            highest = values.length == 0 ? 0.0 : values[values.length - 1].getX();
            int i = 1;
            while (i < this.graphSeries.size()) {
                values = this.graphSeries.get((int)i).values;
                if (values.length > 0) {
                    highest = Math.max(highest, values[values.length - 1].getX());
                }
                ++i;
            }
        }
        return highest;
    }

    protected double getMaxY() {
        double largest;
        if (this.manualYAxis) {
            largest = this.manualMaxYValue;
        } else {
            largest = -2.147483648E9;
            int i = 0;
            while (i < this.graphSeries.size()) {
                GraphViewDataInterface[] values = this._values(i);
                int ii = 0;
                while (ii < values.length) {
                    if (values[ii].getY() > largest) {
                        largest = values[ii].getY();
                    }
                    ++ii;
                }
                ++i;
            }
        }
        return largest;
    }

    protected double getMinX(boolean ignoreViewport) {
        if (!ignoreViewport && this.viewportSize != 0.0) {
            return this.viewportStart;
        }
        double lowest = 0.0;
        if (this.graphSeries.size() > 0) {
            GraphViewDataInterface[] values = this.graphSeries.get((int)0).values;
            lowest = values.length == 0 ? 0.0 : values[0].getX();
            int i = 1;
            while (i < this.graphSeries.size()) {
                values = this.graphSeries.get((int)i).values;
                if (values.length > 0) {
                    lowest = Math.min(lowest, values[0].getX());
                }
                ++i;
            }
        }
        return lowest;
    }

    protected double getMinY() {
        double smallest;
        if (this.manualYAxis) {
            smallest = this.manualMinYValue;
        } else {
            smallest = 2.147483647E9;
            int i = 0;
            while (i < this.graphSeries.size()) {
                GraphViewDataInterface[] values = this._values(i);
                int ii = 0;
                while (ii < values.length) {
                    if (values[ii].getY() < smallest) {
                        smallest = values[ii].getY();
                    }
                    ++ii;
                }
                ++i;
            }
        }
        return smallest;
    }

    public boolean isDisableTouch() {
        return this.disableTouch;
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void redrawAll() {
        if (!this.staticVerticalLabels) {
            this.verlabels = null;
        }
        if (!this.staticHorizontalLabels) {
            this.horlabels = null;
        }
        this.numberformatter[0] = null;
        this.numberformatter[1] = null;
        this.textHeight = null;
        this.textWidth = null;
        this.invalidate();
        this.viewVerLabels.invalidate();
        this.graphViewContentView.invalidate();
    }

    public void removeAllSeries() {
        for (GraphViewSeries s : this.graphSeries) {
            s.removeGraphView(this);
        }
        while (!this.graphSeries.isEmpty()) {
            this.graphSeries.remove(0);
        }
        this.redrawAll();
    }

    public void removeSeries(GraphViewSeries series) {
        series.removeGraphView(this);
        this.graphSeries.remove(series);
        this.redrawAll();
    }

    public void removeSeries(int index) {
        if (index < 0 || index >= this.graphSeries.size()) {
            throw new IndexOutOfBoundsException("No series at index " + index);
        }
        this.removeSeries(this.graphSeries.get(index));
    }

    public void scrollToEnd() {
        if (!this.scrollable) {
            throw new IllegalStateException("This GraphView is not scrollable.");
        }
        double max = this.getMaxX(true);
        this.viewportStart = max - this.viewportSize;
        this.redrawAll();
    }

    public void setCustomLabelFormatter(CustomLabelFormatter customLabelFormatter) {
        this.customLabelFormatter = customLabelFormatter;
    }

    public void setDisableTouch(boolean disableTouch) {
        this.disableTouch = disableTouch;
    }

    public void setGraphViewStyle(GraphViewStyle style) {
        this.graphViewStyle = style;
        this.textHeight = null;
    }

    public void setHorizontalLabels(String[] horlabels) {
        this.staticHorizontalLabels = horlabels != null;
        this.horlabels = horlabels;
    }

    public void setLegendAlign(LegendAlign legendAlign) {
        this.legendAlign = legendAlign;
    }

    public void setLegendWidth(float legendWidth) {
        this.legendWidth = legendWidth;
    }

    public void setManualYAxis(boolean manualYAxis) {
        this.manualYAxis = manualYAxis;
    }

    public void setManualYAxisBounds(double max, double min) {
        this.manualMaxYValue = max;
        this.manualMinYValue = min;
        this.manualYAxis = true;
    }

    public synchronized void setScalable(boolean scalable) {
        this.scalable = scalable;
        if (scalable && this.scaleDetector == null) {
            this.scrollable = true;
            this.scaleDetector = new ScaleGestureDetector(this.getContext(), new ScaleGestureDetector.SimpleOnScaleGestureListener(){

                @Override
                public boolean onScale(ScaleGestureDetector detector) {
                    double center = GraphView.this.viewportStart + GraphView.this.viewportSize / 2.0;
                    GraphView graphView = GraphView.this;
                    graphView.viewportSize = graphView.viewportSize / detector.getScaleFactor();
                    GraphView.this.viewportStart = center - GraphView.this.viewportSize / 2.0;
                    double minX = GraphView.this.getMinX(true);
                    if (GraphView.this.viewportStart < minX) {
                        GraphView.this.viewportStart = minX;
                    }
                    double maxX = GraphView.this.getMaxX(true);
                    double overlap = GraphView.this.viewportStart + GraphView.this.viewportSize - maxX;
                    if (overlap > 0.0) {
                        if (GraphView.this.viewportStart - overlap > minX) {
                            GraphView graphView2 = GraphView.this;
                            graphView2.viewportStart = graphView2.viewportStart - overlap;
                        } else {
                            GraphView.this.viewportStart = minX;
                            GraphView.this.viewportSize = maxX - GraphView.this.viewportStart;
                        }
                    }
                    GraphView.this.redrawAll();
                    return true;
                }
            });
        }
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVerticalLabels(String[] verlabels) {
        this.staticVerticalLabels = verlabels != null;
        this.verlabels = verlabels;
    }

    public void setViewPort(double start, double size) {
        this.viewportStart = start;
        this.viewportSize = size;
    }

    private static final class GraphViewConfig {
        static final float BORDER = 20.0f;

        private GraphViewConfig() {
        }
    }

    private class GraphViewContentView
    extends View {
        private float lastTouchEventX;
        private float graphwidth;
        private boolean scrollingStarted;

        public GraphViewContentView(Context context) {
            super(context);
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        }

        protected void onDraw(Canvas canvas) {
            GraphView.this.paint.setAntiAlias(true);
            GraphView.this.paint.setStrokeWidth(0.0f);
            float border = 20.0f;
            float horstart = 0.0f;
            float height = this.getHeight();
            float width = this.getWidth() - 1;
            double maxY = GraphView.this.getMaxY();
            double minY = GraphView.this.getMinY();
            double maxX = GraphView.this.getMaxX(false);
            double minX = GraphView.this.getMinX(false);
            double diffX = maxX - minX;
            if (GraphView.this.textHeight == null || GraphView.this.textWidth == null) {
                GraphView.this.paint.setTextSize(GraphView.this.getGraphViewStyle().getTextSize());
                double testX = (GraphView.this.getMaxX(true) - GraphView.this.getMinX(true)) * 0.783 + GraphView.this.getMinX(true);
                String testLabel = GraphView.this.formatLabel(testX, true);
                GraphView.this.paint.getTextBounds(testLabel, 0, testLabel.length(), GraphView.this.textBounds);
                GraphView.this.textHeight = GraphView.this.textBounds.height();
                GraphView.this.textWidth = GraphView.this.textBounds.width();
            }
            float graphheight = height - 2.0f * (border += (float)GraphView.this.textHeight.intValue());
            this.graphwidth = width;
            if (GraphView.this.horlabels == null) {
                GraphView.this.horlabels = GraphView.this.generateHorlabels(this.graphwidth);
            }
            if (GraphView.this.verlabels == null) {
                GraphView.this.verlabels = GraphView.this.generateVerlabels(graphheight);
            }
            GraphView.this.paint.setTextAlign(Paint.Align.LEFT);
            int vers = GraphView.this.verlabels.length - 1;
            int i = 0;
            while (i < GraphView.this.verlabels.length) {
                GraphView.this.paint.setColor(GraphView.this.graphViewStyle.getGridColor());
                float y = graphheight / (float)vers * (float)i + border;
                canvas.drawLine(horstart, y, width, y, GraphView.this.paint);
                ++i;
            }
            int hors = GraphView.this.horlabels.length - 1;
            int i2 = 0;
            while (i2 < GraphView.this.horlabels.length) {
                GraphView.this.paint.setColor(GraphView.this.graphViewStyle.getGridColor());
                float x = this.graphwidth / (float)hors * (float)i2 + horstart;
                canvas.drawLine(x, height - border, x, border, GraphView.this.paint);
                GraphView.this.paint.setTextAlign(Paint.Align.CENTER);
                if (i2 == GraphView.this.horlabels.length - 1) {
                    GraphView.this.paint.setTextAlign(Paint.Align.RIGHT);
                }
                if (i2 == 0) {
                    GraphView.this.paint.setTextAlign(Paint.Align.LEFT);
                }
                GraphView.this.paint.setColor(GraphView.this.graphViewStyle.getHorizontalLabelsColor());
                canvas.drawText(GraphView.this.horlabels[i2], x, height - 4.0f, GraphView.this.paint);
                ++i2;
            }
            GraphView.this.paint.setTextAlign(Paint.Align.CENTER);
            canvas.drawText(GraphView.this.title, this.graphwidth / 2.0f + horstart, border - 4.0f, GraphView.this.paint);
            if (maxY == minY) {
                if (maxY == 0.0) {
                    maxY = 1.0;
                    minY = 0.0;
                } else {
                    maxY *= 1.05;
                    minY *= 0.95;
                }
            }
            double diffY = maxY - minY;
            GraphView.this.paint.setStrokeCap(Paint.Cap.ROUND);
            int i3 = 0;
            while (i3 < GraphView.this.graphSeries.size()) {
                GraphView.this.drawSeries(canvas, GraphView.this._values(i3), this.graphwidth, graphheight, border, minX, minY, diffX, diffY, horstart, ((GraphViewSeries)((GraphView)GraphView.this).graphSeries.get((int)i3)).style);
                ++i3;
            }
            if (GraphView.this.showLegend) {
                GraphView.this.drawLegend(canvas, height, width);
            }
        }

        private void onMoveGesture(float f) {
            if (GraphView.this.viewportSize != 0.0) {
                GraphView graphView = GraphView.this;
                graphView.viewportStart = graphView.viewportStart - (double)f * GraphView.this.viewportSize / (double)this.graphwidth;
                double minX = GraphView.this.getMinX(true);
                double maxX = GraphView.this.getMaxX(true);
                if (GraphView.this.viewportStart < minX) {
                    GraphView.this.viewportStart = minX;
                } else if (GraphView.this.viewportStart + GraphView.this.viewportSize > maxX) {
                    GraphView.this.viewportStart = maxX - GraphView.this.viewportSize;
                }
                if (!GraphView.this.staticHorizontalLabels) {
                    GraphView.this.horlabels = null;
                }
                if (!GraphView.this.staticVerticalLabels) {
                    GraphView.this.verlabels = null;
                }
                GraphView.this.viewVerLabels.invalidate();
            }
            this.invalidate();
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (!GraphView.this.isScrollable() || GraphView.this.isDisableTouch()) {
                return super.onTouchEvent(event);
            }
            boolean handled = false;
            if (GraphView.this.scalable && GraphView.this.scaleDetector != null) {
                GraphView.this.scaleDetector.onTouchEvent(event);
                handled = GraphView.this.scaleDetector.isInProgress();
            }
            if (!handled) {
                Log.d((String)"GraphView", (String)("on touch event scale not handled+" + this.lastTouchEventX));
                event.getAction();
                if (!false) {
                    this.scrollingStarted = true;
                    handled = true;
                }
                if ((event.getAction() & 1) == 1) {
                    this.scrollingStarted = false;
                    this.lastTouchEventX = 0.0f;
                    handled = true;
                }
                if ((event.getAction() & 2) == 2 && this.scrollingStarted) {
                    if (this.lastTouchEventX != 0.0f) {
                        this.onMoveGesture(event.getX() - this.lastTouchEventX);
                    }
                    this.lastTouchEventX = event.getX();
                    handled = true;
                }
                if (handled) {
                    this.invalidate();
                }
            } else {
                this.scrollingStarted = false;
                this.lastTouchEventX = 0.0f;
            }
            return handled;
        }
    }

    public static class GraphViewData
    implements GraphViewDataInterface {
        public final double valueX;
        public final double valueY;

        public GraphViewData(double valueX, double valueY) {
            this.valueX = valueX;
            this.valueY = valueY;
        }

        @Override
        public double getX() {
            return this.valueX;
        }

        @Override
        public double getY() {
            return this.valueY;
        }
    }

    public static enum LegendAlign {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    private class VerLabelsView
    extends View {
        public VerLabelsView(Context context) {
            super(context);
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(GraphView.this.getGraphViewStyle().getVerticalLabelsWidth() == 0 ? 100 : GraphView.this.getGraphViewStyle().getVerticalLabelsWidth(), -1));
        }

        protected void onDraw(Canvas canvas) {
            GraphView.this.paint.setStrokeWidth(0.0f);
            if (GraphView.this.textHeight == null || GraphView.this.textWidth == null) {
                GraphView.this.paint.setTextSize(GraphView.this.getGraphViewStyle().getTextSize());
                double testX = (GraphView.this.getMaxX(true) - GraphView.this.getMinX(true)) * 0.783 + GraphView.this.getMinX(true);
                String testLabel = GraphView.this.formatLabel(testX, true);
                GraphView.this.paint.getTextBounds(testLabel, 0, testLabel.length(), GraphView.this.textBounds);
                GraphView.this.textHeight = GraphView.this.textBounds.height();
                GraphView.this.textWidth = GraphView.this.textBounds.width();
            }
            if (GraphView.this.getGraphViewStyle().getVerticalLabelsWidth() == 0 && (float)this.getLayoutParams().width != (float)GraphView.this.textWidth.intValue() + 20.0f) {
                this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams((int)((float)GraphView.this.textWidth.intValue() + 20.0f), -1));
            } else if (GraphView.this.getGraphViewStyle().getVerticalLabelsWidth() != 0 && GraphView.this.getGraphViewStyle().getVerticalLabelsWidth() != this.getLayoutParams().width) {
                this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(GraphView.this.getGraphViewStyle().getVerticalLabelsWidth(), -1));
            }
            float border = 20.0f;
            float height = this.getHeight();
            float graphheight = height - 2.0f * (border += (float)GraphView.this.textHeight.intValue());
            if (GraphView.this.verlabels == null) {
                GraphView.this.verlabels = GraphView.this.generateVerlabels(graphheight);
            }
            GraphView.this.paint.setTextAlign(Paint.Align.LEFT);
            int vers = GraphView.this.verlabels.length - 1;
            int i = 0;
            while (i < GraphView.this.verlabels.length) {
                float y = graphheight / (float)vers * (float)i + border;
                GraphView.this.paint.setColor(GraphView.this.graphViewStyle.getVerticalLabelsColor());
                canvas.drawText(GraphView.this.verlabels[i], 0.0f, y, GraphView.this.paint);
                ++i;
            }
        }
    }
}

