/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.GraphViewDataInterface;
import com.jjoe64.graphview.ValueDependentColor;
import java.util.ArrayList;
import java.util.List;

public class GraphViewSeries {
    final String description;
    final GraphViewSeriesStyle style;
    GraphViewDataInterface[] values;
    private final List<GraphView> graphViews = new ArrayList<GraphView>();

    public GraphViewSeries(GraphViewDataInterface[] values) {
        this.description = null;
        this.style = new GraphViewSeriesStyle();
        this.values = values;
        this.checkValueOrder();
    }

    public GraphViewSeries(String description, GraphViewSeriesStyle style, GraphViewDataInterface[] values) {
        this.description = description;
        if (style == null) {
            style = new GraphViewSeriesStyle();
        }
        this.style = style;
        this.values = values;
        this.checkValueOrder();
    }

    public void addGraphView(GraphView graphView) {
        this.graphViews.add(graphView);
    }

    @Deprecated
    public void appendData(GraphViewDataInterface value, boolean scrollToEnd) {
        if (value.getX() < this.values[this.values.length - 1].getX()) {
            throw new IllegalArgumentException("new x-value must be greater then the last value. x-values has to be ordered in ASC.");
        }
        GraphViewDataInterface[] newValues = new GraphViewDataInterface[this.values.length + 1];
        int offset = this.values.length;
        System.arraycopy(this.values, 0, newValues, 0, offset);
        newValues[this.values.length] = value;
        this.values = newValues;
        for (GraphView g : this.graphViews) {
            if (!scrollToEnd) continue;
            g.scrollToEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendData(GraphViewDataInterface value, boolean scrollToEnd, int maxDataCount) {
        if (value.getX() < this.values[this.values.length - 1].getX()) {
            throw new IllegalArgumentException("new x-value must be greater then the last value. x-values has to be ordered in ASC.");
        }
        GraphViewDataInterface[] graphViewDataInterfaceArray = this.values;
        synchronized (this.values) {
            GraphViewDataInterface[] newValues;
            int curDataCount = this.values.length;
            if (curDataCount < maxDataCount) {
                newValues = new GraphViewDataInterface[curDataCount + 1];
                System.arraycopy(this.values, 0, newValues, 0, curDataCount);
                newValues[curDataCount] = value;
            } else {
                newValues = new GraphViewDataInterface[maxDataCount];
                System.arraycopy(this.values, 1, newValues, 0, curDataCount - 1);
                newValues[maxDataCount - 1] = value;
            }
            this.values = newValues;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (GraphView g : this.graphViews) {
                if (!scrollToEnd) continue;
                g.scrollToEnd();
            }
            return;
        }
    }

    public GraphViewSeriesStyle getStyle() {
        return this.style;
    }

    public void removeGraphView(GraphView graphView) {
        this.graphViews.remove((Object)graphView);
    }

    public void resetData(GraphViewDataInterface[] values) {
        this.values = values;
        this.checkValueOrder();
        for (GraphView g : this.graphViews) {
            g.redrawAll();
        }
    }

    private void checkValueOrder() {
        if (this.values.length > 0) {
            double lx = this.values[0].getX();
            for (int i = 1; i < this.values.length; ++i) {
                if (lx > this.values[i].getX()) {
                    throw new IllegalArgumentException("The order of the values is not correct. X-Values have to be ordered ASC. First the lowest x value and at least the highest x value.");
                }
                lx = this.values[i].getX();
            }
        }
    }

    public static class GraphViewSeriesStyle {
        public int color = -16746548;
        public int thickness = 3;
        private ValueDependentColor valueDependentColor;

        public GraphViewSeriesStyle() {
        }

        public GraphViewSeriesStyle(int color, int thickness) {
            this.color = color;
            this.thickness = thickness;
        }

        public ValueDependentColor getValueDependentColor() {
            return this.valueDependentColor;
        }

        public void setValueDependentColor(ValueDependentColor valueDependentColor) {
            this.valueDependentColor = valueDependentColor;
        }
    }
}

