/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import com.jjoe64.graphview.LabelFormatter;
import com.jjoe64.graphview.Viewport;
import java.text.NumberFormat;

public class DefaultLabelFormatter
implements LabelFormatter {
    protected NumberFormat[] mNumberFormatter = new NumberFormat[2];
    protected Viewport mViewport;

    public DefaultLabelFormatter() {
    }

    public DefaultLabelFormatter(NumberFormat xFormat, NumberFormat yFormat) {
        this.mNumberFormatter[0] = yFormat;
        this.mNumberFormatter[1] = xFormat;
    }

    @Override
    public void setViewport(Viewport viewport) {
        this.mViewport = viewport;
    }

    @Override
    public String formatLabel(double value, boolean isValueX) {
        int i;
        int n = i = isValueX ? 1 : 0;
        if (this.mNumberFormatter[i] == null) {
            double lowestvalue;
            this.mNumberFormatter[i] = NumberFormat.getNumberInstance();
            double highestvalue = isValueX ? this.mViewport.getMaxX(false) : this.mViewport.getMaxY(false);
            double d = lowestvalue = isValueX ? this.mViewport.getMinX(false) : this.mViewport.getMinY(false);
            if (highestvalue - lowestvalue < 0.1) {
                this.mNumberFormatter[i].setMaximumFractionDigits(6);
            } else if (highestvalue - lowestvalue < 1.0) {
                this.mNumberFormatter[i].setMaximumFractionDigits(4);
            } else if (highestvalue - lowestvalue < 20.0) {
                this.mNumberFormatter[i].setMaximumFractionDigits(3);
            } else if (highestvalue - lowestvalue < 100.0) {
                this.mNumberFormatter[i].setMaximumFractionDigits(1);
            } else {
                this.mNumberFormatter[i].setMaximumFractionDigits(0);
            }
        }
        return this.mNumberFormatter[i].format(value);
    }
}

