/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.jjoe64.graphview.CustomLabelFormatter;
import com.jjoe64.graphview.GraphViewDataInterface;
import com.jjoe64.graphview.GraphViewSeries;
import com.jjoe64.graphview.GraphViewStyle;
import com.jjoe64.graphview.compatible.ScaleGestureDetector;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class GraphView
extends LinearLayout {
    protected final Paint paint;
    private String[] horlabels;
    private String[] verlabels;
    private String title;
    private boolean scrollable;
    private boolean disableTouch;
    private double viewportStart;
    private double viewportSize;
    private final View viewVerLabels;
    private ScaleGestureDetector scaleDetector;
    private boolean scalable;
    private final NumberFormat[] numberformatter = new NumberFormat[2];
    private final List<GraphViewSeries> graphSeries;
    private boolean showLegend = false;
    private LegendAlign legendAlign = LegendAlign.MIDDLE;
    private boolean manualYAxis;
    private boolean manualMaxY;
    private boolean manualMinY;
    private double manualMaxYValue;
    private double manualMinYValue;
    protected GraphViewStyle graphViewStyle;
    private final GraphViewContentView graphViewContentView;
    private CustomLabelFormatter customLabelFormatter;
    private Integer labelTextHeight;
    private Integer horLabelTextWidth;
    private Integer verLabelTextWidth;
    private final Rect textBounds = new Rect();
    private boolean staticHorizontalLabels;
    private boolean staticVerticalLabels;
    private boolean showHorizontalLabels = true;
    private boolean showVerticalLabels = true;

    public GraphView(Context context, AttributeSet attrs) {
        this(context, attrs.getAttributeValue(null, "title"));
        int width = attrs.getAttributeIntValue("android", "layout_width", -1);
        int height = attrs.getAttributeIntValue("android", "layout_height", -1);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height));
    }

    public GraphView(Context context, String title) {
        super(context);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.title = title == null ? "" : title;
        this.graphViewStyle = new GraphViewStyle();
        this.graphViewStyle.useTextColorFromTheme(context);
        this.paint = new Paint();
        this.graphSeries = new ArrayList<GraphViewSeries>();
        this.viewVerLabels = new VerLabelsView(context);
        this.addView(this.viewVerLabels);
        this.graphViewContentView = new GraphViewContentView(context);
        this.addView(this.graphViewContentView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphViewDataInterface[] _values(int idxSeries) {
        GraphViewDataInterface[] values;
        GraphViewDataInterface[] graphViewDataInterfaceArray = values = this.graphSeries.get((int)idxSeries).values;
        synchronized (values) {
            if (this.viewportStart == 0.0 && this.viewportSize == 0.0) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return values;
            }
            ArrayList<GraphViewDataInterface> listData = new ArrayList<GraphViewDataInterface>();
            for (int i = 0; i < values.length; ++i) {
                if (values[i].getX() >= this.viewportStart) {
                    if (values[i].getX() > this.viewportStart + this.viewportSize) {
                        listData.add(values[i]);
                        break;
                    }
                    listData.add(values[i]);
                    continue;
                }
                if (listData.isEmpty()) {
                    listData.add(values[i]);
                }
                listData.set(0, values[i]);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return listData.toArray(new GraphViewDataInterface[listData.size()]);
        }
    }

    public void addSeries(GraphViewSeries series) {
        series.addGraphView(this);
        this.graphSeries.add(series);
        this.redrawAll();
    }

    protected void drawHorizontalLabels(Canvas canvas, float border, float horstart, float height, String[] horlabels, float graphwidth) {
        int hors = horlabels.length - 1;
        for (int i = 0; i < horlabels.length; ++i) {
            this.paint.setColor(this.graphViewStyle.getGridColor());
            float x = graphwidth / (float)hors * (float)i + horstart;
            if (this.graphViewStyle.getGridStyle().drawVertical()) {
                canvas.drawLine(x, height - border, x, border, this.paint);
            }
            if (!this.showHorizontalLabels) continue;
            this.paint.setTextAlign(Paint.Align.CENTER);
            if (i == horlabels.length - 1) {
                this.paint.setTextAlign(Paint.Align.RIGHT);
            }
            if (i == 0) {
                this.paint.setTextAlign(Paint.Align.LEFT);
            }
            this.paint.setColor(this.graphViewStyle.getHorizontalLabelsColor());
            String[] lines = horlabels[i].split("\n");
            for (int li = 0; li < lines.length; ++li) {
                float y = height - 4.0f - (float)(lines.length - li - 1) * this.graphViewStyle.getTextSize() * 1.1f;
                canvas.drawText(lines[li], x, y, this.paint);
            }
        }
    }

    protected void drawLegend(Canvas canvas, float height, float width) {
        float lTop;
        float textSize = this.paint.getTextSize();
        int spacing = this.getGraphViewStyle().getLegendSpacing();
        int border = this.getGraphViewStyle().getLegendBorder();
        int legendWidth = this.getGraphViewStyle().getLegendWidth();
        int shapeSize = (int)((double)textSize * 0.8);
        this.paint.setARGB(180, 100, 100, 100);
        float legendHeight = (shapeSize + spacing) * this.graphSeries.size() + 2 * border - spacing;
        float lLeft = width - (float)legendWidth - (float)(border * 2);
        switch (this.legendAlign) {
            case TOP: {
                lTop = 0.0f;
                break;
            }
            case MIDDLE: {
                lTop = height / 2.0f - legendHeight / 2.0f;
                break;
            }
            default: {
                lTop = height - 20.0f - legendHeight - (float)this.getGraphViewStyle().getLegendMarginBottom();
            }
        }
        float lRight = lLeft + (float)legendWidth;
        float lBottom = lTop + legendHeight;
        canvas.drawRoundRect(new RectF(lLeft, lTop, lRight, lBottom), 8.0f, 8.0f, this.paint);
        for (int i = 0; i < this.graphSeries.size(); ++i) {
            this.paint.setColor(this.graphSeries.get((int)i).style.color);
            canvas.drawRect(new RectF(lLeft + (float)border, lTop + (float)border + (float)(i * (shapeSize + spacing)), lLeft + (float)border + (float)shapeSize, lTop + (float)border + (float)(i * (shapeSize + spacing)) + (float)shapeSize), this.paint);
            if (this.graphSeries.get((int)i).description == null) continue;
            this.paint.setColor(-1);
            this.paint.setTextAlign(Paint.Align.LEFT);
            canvas.drawText(this.graphSeries.get((int)i).description, lLeft + (float)border + (float)shapeSize + (float)spacing, lTop + (float)border + (float)shapeSize + (float)(i * (shapeSize + spacing)), this.paint);
        }
    }

    protected abstract void drawSeries(Canvas var1, GraphViewDataInterface[] var2, float var3, float var4, float var5, double var6, double var8, double var10, double var12, float var14, GraphViewSeries.GraphViewSeriesStyle var15);

    @Deprecated
    protected String formatLabel(double value, boolean isValueX) {
        int i;
        String label;
        if (this.customLabelFormatter != null && (label = this.customLabelFormatter.formatLabel(value, isValueX)) != null) {
            return label;
        }
        int n = i = isValueX ? 1 : 0;
        if (this.numberformatter[i] == null) {
            double lowestvalue;
            this.numberformatter[i] = NumberFormat.getNumberInstance();
            double highestvalue = isValueX ? this.getMaxX(false) : this.getMaxY();
            double d = lowestvalue = isValueX ? this.getMinX(false) : this.getMinY();
            if (highestvalue - lowestvalue < 0.1) {
                this.numberformatter[i].setMaximumFractionDigits(6);
            } else if (highestvalue - lowestvalue < 1.0) {
                this.numberformatter[i].setMaximumFractionDigits(4);
            } else if (highestvalue - lowestvalue < 20.0) {
                this.numberformatter[i].setMaximumFractionDigits(3);
            } else if (highestvalue - lowestvalue < 100.0) {
                this.numberformatter[i].setMaximumFractionDigits(1);
            } else {
                this.numberformatter[i].setMaximumFractionDigits(0);
            }
        }
        return this.numberformatter[i].format(value);
    }

    private String[] generateHorlabels(float graphwidth) {
        int numLabels = this.getGraphViewStyle().getNumHorizontalLabels() - 1;
        if (numLabels < 0) {
            if (graphwidth <= 0.0f) {
                graphwidth = 1.0f;
            }
            numLabels = (int)(graphwidth / (float)(this.horLabelTextWidth * 2));
        }
        String[] labels = new String[numLabels + 1];
        double min = this.getMinX(false);
        double max = this.getMaxX(false);
        for (int i = 0; i <= numLabels; ++i) {
            labels[i] = this.formatLabel(min + (max - min) * (double)i / (double)numLabels, true);
        }
        return labels;
    }

    private synchronized String[] generateVerlabels(float graphheight) {
        int numLabels = this.getGraphViewStyle().getNumVerticalLabels() - 1;
        if (numLabels < 0) {
            if (graphheight <= 0.0f) {
                graphheight = 1.0f;
            }
            if ((numLabels = (int)(graphheight / (float)(this.labelTextHeight * 3))) == 0) {
                Log.w((String)"GraphView", (String)"Height of Graph is smaller than the label text height, so no vertical labels were shown!");
            }
        }
        String[] labels = new String[numLabels + 1];
        double min = this.getMinY();
        double max = this.getMaxY();
        if (max == min) {
            if (max == 0.0) {
                max = 1.0;
                min = 0.0;
            } else {
                max *= 1.05;
                min *= 0.95;
            }
        }
        for (int i = 0; i <= numLabels; ++i) {
            labels[numLabels - i] = this.formatLabel(min + (max - min) * (double)i / (double)numLabels, false);
        }
        return labels;
    }

    public CustomLabelFormatter getCustomLabelFormatter() {
        return this.customLabelFormatter;
    }

    public GraphViewStyle getGraphViewStyle() {
        return this.graphViewStyle;
    }

    public LegendAlign getLegendAlign() {
        return this.legendAlign;
    }

    @Deprecated
    public float getLegendWidth() {
        return this.getGraphViewStyle().getLegendWidth();
    }

    protected double getMaxX(boolean ignoreViewport) {
        if (!ignoreViewport && this.viewportSize != 0.0) {
            return this.viewportStart + this.viewportSize;
        }
        double highest = 0.0;
        if (this.graphSeries.size() > 0) {
            GraphViewDataInterface[] values = this.graphSeries.get((int)0).values;
            highest = values.length == 0 ? 0.0 : values[values.length - 1].getX();
            for (int i = 1; i < this.graphSeries.size(); ++i) {
                values = this.graphSeries.get((int)i).values;
                if (values.length <= 0) continue;
                highest = Math.max(highest, values[values.length - 1].getX());
            }
        }
        return highest;
    }

    protected double getMaxY() {
        double largest;
        if (this.manualYAxis || this.manualMaxY) {
            largest = this.manualMaxYValue;
        } else {
            largest = -2.147483648E9;
            for (int i = 0; i < this.graphSeries.size(); ++i) {
                GraphViewDataInterface[] values = this._values(i);
                for (int ii = 0; ii < values.length; ++ii) {
                    if (!(values[ii].getY() > largest)) continue;
                    largest = values[ii].getY();
                }
            }
        }
        return largest;
    }

    protected double getMinX(boolean ignoreViewport) {
        if (!ignoreViewport && this.viewportSize != 0.0) {
            return this.viewportStart;
        }
        double lowest = 0.0;
        if (this.graphSeries.size() > 0) {
            GraphViewDataInterface[] values = this.graphSeries.get((int)0).values;
            lowest = values.length == 0 ? 0.0 : values[0].getX();
            for (int i = 1; i < this.graphSeries.size(); ++i) {
                values = this.graphSeries.get((int)i).values;
                if (values.length <= 0) continue;
                lowest = Math.min(lowest, values[0].getX());
            }
        }
        return lowest;
    }

    protected double getMinY() {
        double smallest;
        if (this.manualYAxis || this.manualMinY) {
            smallest = this.manualMinYValue;
        } else {
            smallest = 2.147483647E9;
            for (int i = 0; i < this.graphSeries.size(); ++i) {
                GraphViewDataInterface[] values = this._values(i);
                for (int ii = 0; ii < values.length; ++ii) {
                    if (!(values[ii].getY() < smallest)) continue;
                    smallest = values[ii].getY();
                }
            }
        }
        return smallest;
    }

    public double getViewportSize() {
        return this.viewportSize;
    }

    public boolean isDisableTouch() {
        return this.disableTouch;
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void redrawAll() {
        if (!this.staticVerticalLabels) {
            this.verlabels = null;
        }
        if (!this.staticHorizontalLabels) {
            this.horlabels = null;
        }
        this.numberformatter[0] = null;
        this.numberformatter[1] = null;
        this.labelTextHeight = null;
        this.horLabelTextWidth = null;
        this.verLabelTextWidth = null;
        this.invalidate();
        this.viewVerLabels.invalidate();
        this.graphViewContentView.invalidate();
    }

    public void removeAllSeries() {
        for (GraphViewSeries s : this.graphSeries) {
            s.removeGraphView(this);
        }
        while (!this.graphSeries.isEmpty()) {
            this.graphSeries.remove(0);
        }
        this.redrawAll();
    }

    public void removeSeries(GraphViewSeries series) {
        series.removeGraphView(this);
        this.graphSeries.remove(series);
        this.redrawAll();
    }

    public void removeSeries(int index) {
        if (index < 0 || index >= this.graphSeries.size()) {
            throw new IndexOutOfBoundsException("No series at index " + index);
        }
        this.removeSeries(this.graphSeries.get(index));
    }

    public void scrollToEnd() {
        if (!this.scrollable) {
            throw new IllegalStateException("This GraphView is not scrollable.");
        }
        double max = this.getMaxX(true);
        this.viewportStart = max - this.viewportSize;
        if (!this.staticVerticalLabels) {
            this.verlabels = null;
        }
        if (!this.staticHorizontalLabels) {
            this.horlabels = null;
        }
        this.invalidate();
        this.viewVerLabels.invalidate();
        this.graphViewContentView.invalidate();
    }

    public void setCustomLabelFormatter(CustomLabelFormatter customLabelFormatter) {
        this.customLabelFormatter = customLabelFormatter;
    }

    public void setDisableTouch(boolean disableTouch) {
        this.disableTouch = disableTouch;
    }

    public void setGraphViewStyle(GraphViewStyle style) {
        this.graphViewStyle = style;
        this.labelTextHeight = null;
    }

    public void setHorizontalLabels(String[] horlabels) {
        this.staticHorizontalLabels = horlabels != null;
        this.horlabels = horlabels;
    }

    public void setLegendAlign(LegendAlign legendAlign) {
        this.legendAlign = legendAlign;
    }

    @Deprecated
    public void setLegendWidth(float legendWidth) {
        this.getGraphViewStyle().setLegendWidth((int)legendWidth);
    }

    public void setManualYAxis(boolean manualYAxis) {
        this.manualYAxis = manualYAxis;
    }

    public void setManualMaxY(boolean manualMaxY) {
        this.manualMaxY = manualMaxY;
    }

    public void setManualMinY(boolean manualMinY) {
        this.manualMinY = manualMinY;
    }

    public void setManualYAxisBounds(double max, double min) {
        this.manualMaxYValue = max;
        this.manualMinYValue = min;
        this.manualYAxis = true;
    }

    public void setManualYMaxBound(double max) {
        this.manualMaxYValue = max;
        this.manualMaxY = true;
    }

    public void setManualYMinBound(double min) {
        this.manualMinYValue = min;
        this.manualMinY = true;
    }

    public synchronized void setScalable(boolean scalable) {
        this.scalable = scalable;
        if (scalable && this.scaleDetector == null) {
            this.scrollable = true;
            this.scaleDetector = new ScaleGestureDetector(this.getContext(), new ScaleGestureDetector.SimpleOnScaleGestureListener(){

                @Override
                public boolean onScale(ScaleGestureDetector detector) {
                    double overlap;
                    double center = GraphView.this.viewportStart + GraphView.this.viewportSize / 2.0;
                    GraphView.this.viewportSize /= detector.getScaleFactor();
                    GraphView.this.viewportStart = center - GraphView.this.viewportSize / 2.0;
                    double minX = GraphView.this.getMinX(true);
                    if (GraphView.this.viewportStart < minX) {
                        GraphView.this.viewportStart = minX;
                    }
                    double maxX = GraphView.this.getMaxX(true);
                    if (GraphView.this.viewportSize == 0.0) {
                        GraphView.this.viewportSize = maxX;
                    }
                    if ((overlap = GraphView.this.viewportStart + GraphView.this.viewportSize - maxX) > 0.0) {
                        if (GraphView.this.viewportStart - overlap > minX) {
                            GraphView.this.viewportStart -= overlap;
                        } else {
                            GraphView.this.viewportStart = minX;
                            GraphView.this.viewportSize = maxX - GraphView.this.viewportStart;
                        }
                    }
                    GraphView.this.redrawAll();
                    return true;
                }
            });
        }
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVerticalLabels(String[] verlabels) {
        this.staticVerticalLabels = verlabels != null;
        this.verlabels = verlabels;
    }

    public void setViewPort(double start, double size) {
        if (size < 0.0) {
            throw new IllegalArgumentException("Viewport size must be greater than 0!");
        }
        this.viewportStart = start;
        this.viewportSize = size;
    }

    public void setShowHorizontalLabels(boolean showHorizontalLabels) {
        this.showHorizontalLabels = showHorizontalLabels;
        this.redrawAll();
    }

    public boolean getShowHorizontalLabels() {
        return this.showHorizontalLabels;
    }

    public void setShowVerticalLabels(boolean showVerticalLabels) {
        this.showVerticalLabels = showVerticalLabels;
        if (this.showVerticalLabels) {
            this.addView(this.viewVerLabels, 0);
        } else {
            this.removeView(this.viewVerLabels);
        }
    }

    public boolean getShowVerticalLabels() {
        return this.showVerticalLabels;
    }

    static /* synthetic */ String[] access$302(GraphView x0, String[] x1) {
        x0.horlabels = x1;
        return x1;
    }

    static /* synthetic */ String[] access$502(GraphView x0, String[] x1) {
        x0.verlabels = x1;
        return x1;
    }

    private class VerLabelsView
    extends View {
        public VerLabelsView(Context context) {
            super(context);
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(GraphView.this.getGraphViewStyle().getVerticalLabelsWidth() == 0 ? 100 : GraphView.this.getGraphViewStyle().getVerticalLabelsWidth(), -1));
        }

        protected void onDraw(Canvas canvas) {
            GraphView.this.paint.setStrokeWidth(0.0f);
            if (GraphView.this.labelTextHeight == null || GraphView.this.verLabelTextWidth == null) {
                GraphView.this.paint.setTextSize(GraphView.this.getGraphViewStyle().getTextSize());
                double testY = (GraphView.this.getMaxY() - GraphView.this.getMinY()) * 0.783 + GraphView.this.getMinY();
                String testLabel = GraphView.this.formatLabel(testY, false);
                GraphView.this.paint.getTextBounds(testLabel, 0, testLabel.length(), GraphView.this.textBounds);
                GraphView.this.labelTextHeight = GraphView.this.textBounds.height();
                GraphView.this.verLabelTextWidth = GraphView.this.textBounds.width();
            }
            if (GraphView.this.getGraphViewStyle().getVerticalLabelsWidth() == 0 && (float)this.getLayoutParams().width != (float)GraphView.this.verLabelTextWidth.intValue() + 20.0f) {
                this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams((int)((float)GraphView.this.verLabelTextWidth.intValue() + 20.0f), -1));
            } else if (GraphView.this.getGraphViewStyle().getVerticalLabelsWidth() != 0 && GraphView.this.getGraphViewStyle().getVerticalLabelsWidth() != this.getLayoutParams().width) {
                this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(GraphView.this.getGraphViewStyle().getVerticalLabelsWidth(), -1));
            }
            float border = 20.0f;
            float height = this.getHeight();
            float graphheight = height - 2.0f * (border += (float)GraphView.this.labelTextHeight.intValue());
            if (GraphView.this.verlabels == null) {
                GraphView.access$502(GraphView.this, GraphView.this.generateVerlabels(graphheight));
            } else if (GraphView.this.getGraphViewStyle().getNumVerticalLabels() > 0) {
                Log.w((String)"GraphView", (String)"when you use static labels (via setVerticalLabels) the labels will just be shown exactly in that way, that you have set it. setNumVerticalLabels does not have any effect.");
            }
            GraphView.this.paint.setTextAlign(GraphView.this.getGraphViewStyle().getVerticalLabelsAlign());
            int labelsWidth = this.getWidth();
            int labelsOffset = 0;
            if (GraphView.this.getGraphViewStyle().getVerticalLabelsAlign() == Paint.Align.RIGHT) {
                labelsOffset = labelsWidth;
            } else if (GraphView.this.getGraphViewStyle().getVerticalLabelsAlign() == Paint.Align.CENTER) {
                labelsOffset = labelsWidth / 2;
            }
            int vers = GraphView.this.verlabels.length - 1;
            for (int i = 0; i < GraphView.this.verlabels.length; ++i) {
                float y = graphheight / (float)vers * (float)i + border;
                GraphView.this.paint.setColor(GraphView.this.graphViewStyle.getVerticalLabelsColor());
                String[] lines = GraphView.this.verlabels[i].split("\n");
                for (int li = 0; li < lines.length; ++li) {
                    float y2 = y - (float)(lines.length - li - 1) * GraphView.this.graphViewStyle.getTextSize() * 1.1f;
                    canvas.drawText(lines[li], (float)labelsOffset, y2, GraphView.this.paint);
                }
            }
            GraphView.this.paint.setTextAlign(Paint.Align.LEFT);
        }
    }

    public static enum LegendAlign {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    public static class GraphViewData
    implements GraphViewDataInterface {
        public final double valueX;
        public final double valueY;

        public GraphViewData(double valueX, double valueY) {
            this.valueX = valueX;
            this.valueY = valueY;
        }

        @Override
        public double getX() {
            return this.valueX;
        }

        @Override
        public double getY() {
            return this.valueY;
        }
    }

    private class GraphViewContentView
    extends View {
        private float lastTouchEventX;
        private float graphwidth;
        private boolean scrollingStarted;

        public GraphViewContentView(Context context) {
            super(context);
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        }

        protected void onDraw(Canvas canvas) {
            GraphView.this.paint.setAntiAlias(true);
            GraphView.this.paint.setStrokeWidth(0.0f);
            float border = 20.0f;
            float horstart = 0.0f;
            float height = this.getHeight();
            float width = this.getWidth() - 1;
            double maxY = GraphView.this.getMaxY();
            double minY = GraphView.this.getMinY();
            double maxX = GraphView.this.getMaxX(false);
            double minX = GraphView.this.getMinX(false);
            double diffX = maxX - minX;
            if (GraphView.this.labelTextHeight == null || GraphView.this.horLabelTextWidth == null) {
                GraphView.this.paint.setTextSize(GraphView.this.getGraphViewStyle().getTextSize());
                double testX = (GraphView.this.getMaxX(true) - GraphView.this.getMinX(true)) * 0.783 + GraphView.this.getMinX(true);
                String testLabel = GraphView.this.formatLabel(testX, true);
                GraphView.this.paint.getTextBounds(testLabel, 0, testLabel.length(), GraphView.this.textBounds);
                int lines = 1;
                for (byte c : testLabel.getBytes()) {
                    if (c != 10) continue;
                    ++lines;
                }
                GraphView.this.labelTextHeight = GraphView.this.textBounds.height() * lines;
                GraphView.this.horLabelTextWidth = GraphView.this.textBounds.width();
            }
            float graphheight = height - 2.0f * (border += (float)GraphView.this.labelTextHeight.intValue());
            this.graphwidth = width;
            if (GraphView.this.horlabels == null) {
                GraphView.access$302(GraphView.this, GraphView.this.generateHorlabels(this.graphwidth));
            } else if (GraphView.this.getGraphViewStyle().getNumHorizontalLabels() > 0) {
                Log.w((String)"GraphView", (String)"when you use static labels (via setHorizontalLabels) the labels will just be shown exactly in that way, that you have set it. setNumHorizontalLabels does not have any effect.");
            }
            if (GraphView.this.verlabels == null) {
                GraphView.access$502(GraphView.this, GraphView.this.generateVerlabels(graphheight));
            } else if (GraphView.this.getGraphViewStyle().getNumVerticalLabels() > 0) {
                Log.w((String)"GraphView", (String)"when you use static labels (via setVerticalLabels) the labels will just be shown exactly in that way, that you have set it. setNumVerticalLabels does not have any effect.");
            }
            if (GraphView.this.graphViewStyle.getGridStyle().drawHorizontal()) {
                GraphView.this.paint.setTextAlign(Paint.Align.LEFT);
                int vers = GraphView.this.verlabels.length - 1;
                for (int i = 0; i < GraphView.this.verlabels.length; ++i) {
                    GraphView.this.paint.setColor(GraphView.this.graphViewStyle.getGridColor());
                    float y = graphheight / (float)vers * (float)i + border;
                    canvas.drawLine(horstart, y, width, y, GraphView.this.paint);
                }
            }
            GraphView.this.drawHorizontalLabels(canvas, border, horstart, height, GraphView.this.horlabels, this.graphwidth);
            GraphView.this.paint.setColor(GraphView.this.graphViewStyle.getHorizontalLabelsColor());
            GraphView.this.paint.setTextAlign(Paint.Align.CENTER);
            canvas.drawText(GraphView.this.title, this.graphwidth / 2.0f + horstart, border - 4.0f, GraphView.this.paint);
            if (maxY == minY) {
                if (maxY == 0.0) {
                    maxY = 1.0;
                    minY = 0.0;
                } else {
                    maxY *= 1.05;
                    minY *= 0.95;
                }
            }
            double diffY = maxY - minY;
            GraphView.this.paint.setStrokeCap(Paint.Cap.ROUND);
            for (int i = 0; i < GraphView.this.graphSeries.size(); ++i) {
                GraphView.this.drawSeries(canvas, GraphView.this._values(i), this.graphwidth, graphheight, border, minX, minY, diffX, diffY, horstart, ((GraphViewSeries)((GraphView)GraphView.this).graphSeries.get((int)i)).style);
            }
            if (GraphView.this.showLegend) {
                GraphView.this.drawLegend(canvas, height, width);
            }
        }

        private void onMoveGesture(float f) {
            if (GraphView.this.viewportSize != 0.0) {
                GraphView.this.viewportStart -= (double)f * GraphView.this.viewportSize / (double)this.graphwidth;
                double minX = GraphView.this.getMinX(true);
                double maxX = GraphView.this.getMaxX(true);
                if (GraphView.this.viewportStart < minX) {
                    GraphView.this.viewportStart = minX;
                } else if (GraphView.this.viewportStart + GraphView.this.viewportSize > maxX) {
                    GraphView.this.viewportStart = maxX - GraphView.this.viewportSize;
                }
                if (!GraphView.this.staticHorizontalLabels) {
                    GraphView.access$302(GraphView.this, null);
                }
                if (!GraphView.this.staticVerticalLabels) {
                    GraphView.access$502(GraphView.this, null);
                }
                GraphView.this.viewVerLabels.invalidate();
            }
            this.invalidate();
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (!GraphView.this.isScrollable() || GraphView.this.isDisableTouch()) {
                return super.onTouchEvent(event);
            }
            boolean handled = false;
            if (GraphView.this.scalable && GraphView.this.scaleDetector != null) {
                GraphView.this.scaleDetector.onTouchEvent(event);
                handled = GraphView.this.scaleDetector.isInProgress();
            }
            if (!handled) {
                if ((event.getAction() & 0) == 0 && (event.getAction() & 2) == 0) {
                    this.scrollingStarted = true;
                    handled = true;
                }
                if ((event.getAction() & 1) == 1) {
                    this.scrollingStarted = false;
                    this.lastTouchEventX = 0.0f;
                    handled = true;
                }
                if ((event.getAction() & 2) == 2 && this.scrollingStarted) {
                    if (this.lastTouchEventX != 0.0f) {
                        this.onMoveGesture(event.getX() - this.lastTouchEventX);
                    }
                    this.lastTouchEventX = event.getX();
                    handled = true;
                }
                if (handled) {
                    this.invalidate();
                }
            } else {
                this.scrollingStarted = false;
                this.lastTouchEventX = 0.0f;
            }
            return handled;
        }
    }

    private static final class GraphViewConfig {
        static final float BORDER = 20.0f;

        private GraphViewConfig() {
        }
    }
}

