/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.GraphViewDataInterface;
import com.jjoe64.graphview.GraphViewSeries;

public class BarGraphView
extends GraphView {
    public BarGraphView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BarGraphView(Context context, String title) {
        super(context, title);
    }

    @Override
    public void drawSeries(Canvas canvas, GraphViewDataInterface[] values, float graphwidth, float graphheight, float border, double minX, double minY, double diffX, double diffY, float horstart, GraphViewSeries.GraphViewSeriesStyle style) {
        float colwidth = (graphwidth - 2.0f * border) / (float)values.length;
        this.paint.setStrokeWidth((float)style.thickness);
        this.paint.setColor(style.color);
        int i = 0;
        while (i < values.length) {
            float valY = (float)(values[i].getY() - minY);
            float ratY = (float)((double)valY / diffY);
            float y = graphheight * ratY;
            if (style.getValueDependentColor() != null) {
                this.paint.setColor(style.getValueDependentColor().get(values[i]));
            }
            canvas.drawRect((float)i * colwidth + horstart, border - y + graphheight, (float)i * colwidth + horstart + (colwidth - 1.0f), graphheight + border - 1.0f, this.paint);
            ++i;
        }
    }
}

