/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.jjoe64.graphview.GridLabelRenderer;
import com.jjoe64.graphview.LegendRenderer;
import com.jjoe64.graphview.SecondScale;
import com.jjoe64.graphview.Viewport;
import com.jjoe64.graphview.series.Series;
import java.util.ArrayList;
import java.util.List;

public class GraphView
extends View {
    private List<Series> mSeries;
    private GridLabelRenderer mGridLabelRenderer;
    private Viewport mViewport;
    private String mTitle;
    private Styles mStyles;
    protected SecondScale mSecondScale;
    private TapDetector mTapDetector;
    private LegendRenderer mLegendRenderer;
    private Paint mPaintTitle;
    private Paint mPreviewPaint;

    public GraphView(Context context) {
        super(context);
        this.init();
    }

    public GraphView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GraphView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void init() {
        this.mPreviewPaint = new Paint();
        this.mPreviewPaint.setTextAlign(Paint.Align.CENTER);
        this.mPreviewPaint.setColor(-16777216);
        this.mPreviewPaint.setTextSize(50.0f);
        this.mStyles = new Styles();
        this.mViewport = new Viewport(this);
        this.mGridLabelRenderer = new GridLabelRenderer(this);
        this.mLegendRenderer = new LegendRenderer(this);
        this.mSeries = new ArrayList<Series>();
        this.mPaintTitle = new Paint();
        this.mTapDetector = new TapDetector();
        this.loadStyles();
    }

    protected void loadStyles() {
        this.mStyles.titleColor = this.mGridLabelRenderer.getHorizontalLabelsColor();
        this.mStyles.titleTextSize = this.mGridLabelRenderer.getTextSize();
    }

    public GridLabelRenderer getGridLabelRenderer() {
        return this.mGridLabelRenderer;
    }

    public void addSeries(Series s) {
        s.onGraphViewAttached(this);
        this.mSeries.add(s);
        this.onDataChanged(false, false);
    }

    public List<Series> getSeries() {
        return this.mSeries;
    }

    public void onDataChanged(boolean keepLabelsSize, boolean keepViewport) {
        this.mViewport.calcCompleteRange();
        if (this.mSecondScale != null) {
            this.mSecondScale.calcCompleteRange();
        }
        this.mGridLabelRenderer.invalidate(keepLabelsSize, keepViewport);
        this.postInvalidate();
    }

    protected void drawGraphElements(Canvas canvas) {
        if (Build.VERSION.SDK_INT >= 11 && !canvas.isHardwareAccelerated()) {
            throw new IllegalStateException("GraphView must be used in hardware accelerated mode.You can use android:hardwareAccelerated=\"true\" on your activity. Read this for more info:https://developer.android.com/guide/topics/graphics/hardware-accel.html");
        }
        this.drawTitle(canvas);
        this.mViewport.drawFirst(canvas);
        this.mGridLabelRenderer.draw(canvas);
        for (Series s : this.mSeries) {
            s.draw(this, canvas, false);
        }
        if (this.mSecondScale != null) {
            for (Series s : this.mSecondScale.getSeries()) {
                s.draw(this, canvas, true);
            }
        }
        this.mViewport.draw(canvas);
        this.mLegendRenderer.draw(canvas);
    }

    protected void onDraw(Canvas canvas) {
        if (this.isInEditMode()) {
            canvas.drawColor(Color.rgb((int)200, (int)200, (int)200));
            canvas.drawText("GraphView: No Preview available", (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2), this.mPreviewPaint);
        } else {
            this.drawGraphElements(canvas);
        }
    }

    protected void drawTitle(Canvas canvas) {
        if (this.mTitle != null && this.mTitle.length() > 0) {
            this.mPaintTitle.setColor(this.mStyles.titleColor);
            this.mPaintTitle.setTextSize(this.mStyles.titleTextSize);
            this.mPaintTitle.setTextAlign(Paint.Align.CENTER);
            float x = canvas.getWidth() / 2;
            float y = this.mPaintTitle.getTextSize();
            canvas.drawText(this.mTitle, x, y, this.mPaintTitle);
        }
    }

    protected int getTitleHeight() {
        if (this.mTitle != null && this.mTitle.length() > 0) {
            return (int)this.mPaintTitle.getTextSize();
        }
        return 0;
    }

    public Viewport getViewport() {
        return this.mViewport;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.onDataChanged(false, false);
    }

    public int getGraphContentLeft() {
        int border = this.getGridLabelRenderer().getStyles().padding;
        return border + this.getGridLabelRenderer().getLabelVerticalWidth() + this.getGridLabelRenderer().getVerticalAxisTitleWidth();
    }

    public int getGraphContentTop() {
        int border = this.getGridLabelRenderer().getStyles().padding + this.getTitleHeight();
        return border;
    }

    public int getGraphContentHeight() {
        int border = this.getGridLabelRenderer().getStyles().padding;
        int graphheight = this.getHeight() - 2 * border - this.getGridLabelRenderer().getLabelHorizontalHeight() - this.getTitleHeight();
        return graphheight -= this.getGridLabelRenderer().getHorizontalAxisTitleHeight();
    }

    public int getGraphContentWidth() {
        int border = this.getGridLabelRenderer().getStyles().padding;
        int graphwidth = this.getWidth() - 2 * border - this.getGridLabelRenderer().getLabelVerticalWidth();
        if (this.mSecondScale != null) {
            graphwidth -= this.getGridLabelRenderer().getLabelVerticalSecondScaleWidth();
            graphwidth = (int)((float)graphwidth - this.mSecondScale.getVerticalAxisTitleTextSize());
        }
        return graphwidth;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean b = this.mViewport.onTouchEvent(event);
        boolean a = super.onTouchEvent(event);
        if (this.mTapDetector.onTouchEvent(event)) {
            for (Series s : this.mSeries) {
                s.onTap(event.getX(), event.getY());
            }
            if (this.mSecondScale != null) {
                for (Series s : this.mSecondScale.getSeries()) {
                    s.onTap(event.getX(), event.getY());
                }
            }
        }
        return b || a;
    }

    public void computeScroll() {
        super.computeScroll();
        this.mViewport.computeScroll();
    }

    public LegendRenderer getLegendRenderer() {
        return this.mLegendRenderer;
    }

    public void setLegendRenderer(LegendRenderer mLegendRenderer) {
        this.mLegendRenderer = mLegendRenderer;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String mTitle) {
        this.mTitle = mTitle;
    }

    public float getTitleTextSize() {
        return this.mStyles.titleTextSize;
    }

    public void setTitleTextSize(float titleTextSize) {
        this.mStyles.titleTextSize = titleTextSize;
    }

    public int getTitleColor() {
        return this.mStyles.titleColor;
    }

    public void setTitleColor(int titleColor) {
        this.mStyles.titleColor = titleColor;
    }

    public SecondScale getSecondScale() {
        if (this.mSecondScale == null) {
            this.mSecondScale = new SecondScale(this);
            this.mSecondScale.setVerticalAxisTitleTextSize(this.mGridLabelRenderer.mStyles.textSize);
        }
        return this.mSecondScale;
    }

    public void clearSecondScale() {
        if (this.mSecondScale != null) {
            this.mSecondScale.removeAllSeries();
            this.mSecondScale = null;
        }
    }

    public void removeAllSeries() {
        this.mSeries.clear();
        this.onDataChanged(false, false);
    }

    public void removeSeries(Series<?> series) {
        this.mSeries.remove(series);
        this.onDataChanged(false, false);
    }

    private class TapDetector {
        private long lastDown;
        private PointF lastPoint;

        private TapDetector() {
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (event.getAction() == 0) {
                this.lastDown = System.currentTimeMillis();
                this.lastPoint = new PointF(event.getX(), event.getY());
            } else if (this.lastDown > 0L && event.getAction() == 2) {
                if (Math.abs(event.getX() - this.lastPoint.x) > 60.0f || Math.abs(event.getY() - this.lastPoint.y) > 60.0f) {
                    this.lastDown = 0L;
                }
            } else if (event.getAction() == 1 && System.currentTimeMillis() - this.lastDown < 400L) {
                return true;
            }
            return false;
        }
    }

    private static final class Styles {
        float titleTextSize;
        int titleColor;

        private Styles() {
        }
    }
}

