/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview.series;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.ValueDependentColor;
import com.jjoe64.graphview.series.BaseSeries;
import com.jjoe64.graphview.series.DataPointInterface;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BarGraphSeries<E extends DataPointInterface>
extends BaseSeries<E> {
    private Paint mPaint;
    private int mSpacing;
    private ValueDependentColor<E> mValueDependentColor;
    private boolean mDrawValuesOnTop;
    private int mValuesOnTopColor;
    private float mValuesOnTopSize;
    private Map<RectF, E> mDataPoints = new HashMap<RectF, E>();

    public BarGraphSeries() {
        this.mPaint = new Paint();
    }

    public BarGraphSeries(E[] data) {
        super(data);
        this.mPaint = new Paint();
    }

    @Override
    public void draw(GraphView graphView, Canvas canvas, boolean isSecondScale) {
        double minY;
        double maxY;
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        if (this.mValuesOnTopSize == 0.0f) {
            this.mValuesOnTopSize = graphView.getGridLabelRenderer().getTextSize();
        }
        this.mPaint.setTextSize(this.mValuesOnTopSize);
        double maxX = graphView.getViewport().getMaxX(false);
        double minX = graphView.getViewport().getMinX(false);
        if (isSecondScale) {
            maxY = graphView.getSecondScale().getMaxY();
            minY = graphView.getSecondScale().getMinY();
        } else {
            maxY = graphView.getViewport().getMaxY(false);
            minY = graphView.getViewport().getMinY(false);
        }
        Iterator values = this.getValues(minX, maxX);
        int numOfBars = 0;
        while (values.hasNext()) {
            values.next();
            ++numOfBars;
        }
        if (numOfBars == 0) {
            return;
        }
        values = this.getValues(minX, maxX);
        float colwidth = graphView.getGraphContentWidth() / (numOfBars - 1);
        Log.d((String)"BarGraphSeries", (String)("numBars=" + numOfBars));
        float spacing = Math.min(colwidth * (float)this.mSpacing / 100.0f, colwidth * 0.98f);
        float offset = colwidth / 2.0f;
        double diffY = maxY - minY;
        double diffX = maxX - minX;
        float contentHeight = graphView.getGraphContentHeight();
        float contentWidth = graphView.getGraphContentWidth();
        float contentLeft = graphView.getGraphContentLeft();
        float contentTop = graphView.getGraphContentTop();
        int i = 0;
        while (values.hasNext()) {
            boolean reverse;
            DataPointInterface value = (DataPointInterface)values.next();
            double valY = value.getY() - minY;
            double ratY = valY / diffY;
            double y = (double)contentHeight * ratY;
            double valY0 = 0.0 - minY;
            double ratY0 = valY0 / diffY;
            double y0 = (double)contentHeight * ratY0;
            double valX = value.getX() - minX;
            double ratX = valX / diffX;
            double x = (double)contentWidth * ratX;
            if (this.getValueDependentColor() != null) {
                this.mPaint.setColor(this.getValueDependentColor().get(value));
            } else {
                this.mPaint.setColor(this.getColor());
            }
            float left = (float)x + contentLeft - offset + spacing / 2.0f;
            float top = contentTop - (float)y + contentHeight;
            float right = left + colwidth - spacing;
            float bottom = contentTop - (float)y0 + contentHeight - (float)(graphView.getGridLabelRenderer().isHighlightZeroLines() ? 4 : 1);
            boolean bl = reverse = top > bottom;
            if (reverse) {
                float tmp = top;
                top = bottom + (float)(graphView.getGridLabelRenderer().isHighlightZeroLines() ? 4 : 1);
                bottom = tmp;
            }
            left = Math.max(left, contentLeft);
            right = Math.min(right, contentLeft + contentWidth);
            bottom = Math.min(bottom, contentTop + contentHeight);
            top = Math.max(top, contentTop);
            this.mDataPoints.put(new RectF(left, top, right, bottom), value);
            canvas.drawRect(left, top, right, bottom, this.mPaint);
            if (this.mDrawValuesOnTop) {
                if (reverse) {
                    top = bottom + this.mValuesOnTopSize + 4.0f;
                    if (top > contentTop + contentHeight) {
                        top = contentTop + contentHeight;
                    }
                } else if ((top -= 4.0f) <= contentTop) {
                    top += contentTop + 4.0f;
                }
                this.mPaint.setColor(this.mValuesOnTopColor);
                canvas.drawText(graphView.getGridLabelRenderer().getLabelFormatter().formatLabel(value.getY(), false), (left + right) / 2.0f, top, this.mPaint);
            }
            ++i;
        }
    }

    public ValueDependentColor<E> getValueDependentColor() {
        return this.mValueDependentColor;
    }

    public void setValueDependentColor(ValueDependentColor<E> mValueDependentColor) {
        this.mValueDependentColor = mValueDependentColor;
    }

    public int getSpacing() {
        return this.mSpacing;
    }

    public void setSpacing(int mSpacing) {
        this.mSpacing = mSpacing;
    }

    public boolean isDrawValuesOnTop() {
        return this.mDrawValuesOnTop;
    }

    public void setDrawValuesOnTop(boolean mDrawValuesOnTop) {
        this.mDrawValuesOnTop = mDrawValuesOnTop;
    }

    public int getValuesOnTopColor() {
        return this.mValuesOnTopColor;
    }

    public void setValuesOnTopColor(int mValuesOnTopColor) {
        this.mValuesOnTopColor = mValuesOnTopColor;
    }

    public float getValuesOnTopSize() {
        return this.mValuesOnTopSize;
    }

    public void setValuesOnTopSize(float mValuesOnTopSize) {
        this.mValuesOnTopSize = mValuesOnTopSize;
    }

    @Override
    protected void resetDataPoints() {
        this.mDataPoints.clear();
    }

    @Override
    protected E findDataPoint(float x, float y) {
        for (Map.Entry<RectF, E> entry : this.mDataPoints.entrySet()) {
            if (!(x >= entry.getKey().left) || !(x <= entry.getKey().right) || !(y >= entry.getKey().top) || !(y <= entry.getKey().bottom)) continue;
            return (E)((DataPointInterface)entry.getValue());
        }
        return null;
    }
}

