/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import com.jjoe64.graphview.DefaultLabelFormatter;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.LabelFormatter;
import com.jjoe64.graphview.Viewport;
import java.util.LinkedHashMap;
import java.util.Map;

public class GridLabelRenderer {
    protected Styles mStyles;
    private final GraphView mGraphView;
    private Map<Integer, Double> mStepsVertical;
    private Map<Integer, Double> mStepsVerticalSecondScale;
    private Map<Integer, Double> mStepsHorizontal;
    private Paint mPaintLine;
    private Paint mPaintLabel;
    private Paint mPaintAxisTitle;
    private boolean mIsAdjusted;
    private Integer mLabelVerticalWidth;
    private Integer mLabelVerticalHeight;
    private Integer mLabelVerticalSecondScaleWidth;
    private Integer mLabelVerticalSecondScaleHeight;
    private Integer mLabelHorizontalWidth;
    private Integer mLabelHorizontalHeight;
    private LabelFormatter mLabelFormatter;
    private String mHorizontalAxisTitle;
    private String mVerticalAxisTitle;
    private int mNumVerticalLabels;
    private int mNumHorizontalLabels;

    public GridLabelRenderer(GraphView graphView) {
        this.mGraphView = graphView;
        this.setLabelFormatter(new DefaultLabelFormatter());
        this.mStyles = new Styles();
        this.resetStyles();
        this.mNumVerticalLabels = 5;
        this.mNumHorizontalLabels = 5;
    }

    public void resetStyles() {
        int size2;
        int size;
        int color2;
        int color1;
        TypedValue typedValue = new TypedValue();
        this.mGraphView.getContext().getTheme().resolveAttribute(16842818, typedValue, true);
        TypedArray array = null;
        try {
            array = this.mGraphView.getContext().obtainStyledAttributes(typedValue.data, new int[]{16842806, 16842808, 16842901, 16843327});
            color1 = array.getColor(0, -16777216);
            color2 = array.getColor(1, -7829368);
            size = array.getDimensionPixelSize(2, 20);
            size2 = array.getDimensionPixelSize(3, 20);
            array.recycle();
        }
        catch (Exception e) {
            color1 = -16777216;
            color2 = -7829368;
            size = 20;
            size2 = 20;
        }
        this.mStyles.verticalLabelsColor = color1;
        this.mStyles.verticalLabelsSecondScaleColor = color1;
        this.mStyles.horizontalLabelsColor = color1;
        this.mStyles.gridColor = color2;
        this.mStyles.textSize = size;
        this.mStyles.padding = size2;
        this.mStyles.verticalLabelsAlign = Paint.Align.RIGHT;
        this.mStyles.verticalLabelsSecondScaleAlign = Paint.Align.LEFT;
        this.mStyles.highlightZeroLines = true;
        this.mStyles.verticalAxisTitleColor = this.mStyles.verticalLabelsColor;
        this.mStyles.horizontalAxisTitleColor = this.mStyles.horizontalLabelsColor;
        this.mStyles.verticalAxisTitleTextSize = this.mStyles.textSize;
        this.mStyles.horizontalAxisTitleTextSize = this.mStyles.textSize;
        this.mStyles.horizontalLabelsVisible = true;
        this.mStyles.verticalLabelsVisible = true;
        this.mStyles.gridStyle = GridStyle.BOTH;
        this.reloadStyles();
    }

    public void reloadStyles() {
        this.mPaintLine = new Paint();
        this.mPaintLine.setColor(this.mStyles.gridColor);
        this.mPaintLine.setStrokeWidth(0.0f);
        this.mPaintLabel = new Paint();
        this.mPaintLabel.setTextSize(this.getTextSize());
        this.mPaintAxisTitle = new Paint();
        this.mPaintAxisTitle.setTextSize(this.getTextSize());
        this.mPaintAxisTitle.setTextAlign(Paint.Align.CENTER);
    }

    public float getTextSize() {
        return this.mStyles.textSize;
    }

    public int getVerticalLabelsColor() {
        return this.mStyles.verticalLabelsColor;
    }

    public Paint.Align getVerticalLabelsAlign() {
        return this.mStyles.verticalLabelsAlign;
    }

    public int getHorizontalLabelsColor() {
        return this.mStyles.horizontalLabelsColor;
    }

    public void invalidate(boolean keepLabelsSize, boolean keepViewport) {
        if (!keepViewport) {
            this.mIsAdjusted = false;
        }
        if (!keepLabelsSize) {
            this.mLabelVerticalWidth = null;
            this.mLabelVerticalHeight = null;
            this.mLabelVerticalSecondScaleWidth = null;
            this.mLabelVerticalSecondScaleHeight = null;
        }
        this.reloadStyles();
    }

    protected boolean adjustVerticalSecondScale() {
        if (this.mLabelHorizontalHeight == null) {
            return false;
        }
        if (this.mGraphView.mSecondScale == null) {
            return true;
        }
        double minY = this.mGraphView.mSecondScale.getMinY();
        double maxY = this.mGraphView.mSecondScale.getMaxY();
        Log.d((String)"GridLabelRenderer", (String)("minY=" + minY + "/maxY=" + maxY));
        int numVerticalLabels = this.mNumVerticalLabels;
        if (!this.mGraphView.mSecondScale.isYAxisBoundsManual()) {
            throw new IllegalStateException("Not yet implemented");
        }
        double newMinY = minY;
        double rangeY = maxY - newMinY;
        double exactSteps = rangeY / (double)(numVerticalLabels - 1);
        double newMaxY = newMinY + (double)(numVerticalLabels - 1) * exactSteps;
        this.mStepsVerticalSecondScale = new LinkedHashMap<Integer, Double>(numVerticalLabels);
        int height = this.mGraphView.getGraphContentHeight();
        double v = newMaxY;
        int p = this.mGraphView.getGraphContentTop();
        int pixelStep = height / (numVerticalLabels - 1);
        for (int i = 0; i < numVerticalLabels; ++i) {
            this.mStepsVerticalSecondScale.put(p, v);
            p += pixelStep;
            v -= exactSteps;
        }
        return true;
    }

    protected boolean adjustVertical() {
        double exactSteps;
        double newMinY;
        double maxY;
        if (this.mLabelHorizontalHeight == null) {
            return false;
        }
        double minY = this.mGraphView.getViewport().getMinY(false);
        if (minY == (maxY = this.mGraphView.getViewport().getMaxY(false))) {
            return false;
        }
        Log.d((String)"GridLabelRenderer", (String)("minY=" + minY + "/maxY=" + maxY));
        int numVerticalLabels = this.mNumVerticalLabels;
        if (this.mGraphView.getViewport().isYAxisBoundsManual()) {
            newMinY = minY;
            double rangeY = maxY - newMinY;
            exactSteps = rangeY / (double)(numVerticalLabels - 1);
        } else {
            boolean adjusting = true;
            newMinY = minY;
            exactSteps = 0.0;
            while (adjusting) {
                double rangeY = maxY - newMinY;
                exactSteps = rangeY / (double)(numVerticalLabels - 1);
                exactSteps = this.humanRound(exactSteps, true);
                int count = 0;
                if (newMinY >= 0.0) {
                    while (newMinY - exactSteps >= 0.0) {
                        newMinY -= exactSteps;
                        ++count;
                    }
                    newMinY = exactSteps * (double)count;
                } else {
                    ++count;
                    while (newMinY + exactSteps < 0.0) {
                        newMinY += exactSteps;
                        ++count;
                    }
                    newMinY = exactSteps * (double)count * -1.0;
                }
                if (newMinY == minY) {
                    adjusting = false;
                    continue;
                }
                minY = newMinY;
            }
        }
        double newMaxY = newMinY + (double)(numVerticalLabels - 1) * exactSteps;
        this.mGraphView.getViewport().setMinY(newMinY);
        this.mGraphView.getViewport().setMaxY(newMaxY);
        if (!this.mGraphView.getViewport().isYAxisBoundsManual()) {
            this.mGraphView.getViewport().setYAxisBoundsStatus(Viewport.AxisBoundsStatus.AUTO_ADJUSTED);
        }
        this.mStepsVertical = new LinkedHashMap<Integer, Double>(numVerticalLabels);
        int height = this.mGraphView.getGraphContentHeight();
        double v = newMaxY;
        int p = this.mGraphView.getGraphContentTop();
        int pixelStep = height / (numVerticalLabels - 1);
        for (int i = 0; i < numVerticalLabels; ++i) {
            this.mStepsVertical.put(p, v);
            p += pixelStep;
            v -= exactSteps;
        }
        return true;
    }

    protected boolean adjustHorizontal() {
        double exactSteps;
        double newMinX;
        double maxX;
        if (this.mLabelVerticalWidth == null) {
            return false;
        }
        double minX = this.mGraphView.getViewport().getMinX(false);
        if (minX == (maxX = this.mGraphView.getViewport().getMaxX(false))) {
            return false;
        }
        int numHorizontalLabels = this.mNumHorizontalLabels;
        float scalingOffset = 0.0f;
        if (this.mGraphView.getViewport().isXAxisBoundsManual() && this.mGraphView.getViewport().getXAxisBoundsStatus() != Viewport.AxisBoundsStatus.READJUST_AFTER_SCALE) {
            if (this.mGraphView.getViewport().mScalingActive) {
                minX = this.mGraphView.getViewport().mScalingBeginLeft;
                maxX = minX + (double)this.mGraphView.getViewport().mScalingBeginWidth;
                Log.d((String)"GridLabelRenderer", (String)"hhier scaling");
            }
            newMinX = minX;
            double rangeX = maxX - newMinX;
            exactSteps = rangeX / (double)(numHorizontalLabels - 1);
        } else {
            Log.d((String)"GridLabelRenderer", (String)("find good steps for: " + minX + "/" + maxX));
            boolean adjusting = true;
            newMinX = minX;
            exactSteps = 0.0;
            while (adjusting) {
                double rangeX = maxX - newMinX;
                exactSteps = rangeX / (double)(numHorizontalLabels - 1);
                boolean roundAlwaysUp = true;
                if (this.mGraphView.getViewport().getXAxisBoundsStatus() == Viewport.AxisBoundsStatus.READJUST_AFTER_SCALE && this.mGraphView.getViewport().mCurrentViewport.width() < this.mGraphView.getViewport().mScalingBeginWidth) {
                    roundAlwaysUp = false;
                }
                exactSteps = this.humanRound(exactSteps, roundAlwaysUp);
                int count = 0;
                if (newMinX >= 0.0) {
                    while (newMinX - exactSteps >= 0.0) {
                        newMinX -= exactSteps;
                        ++count;
                    }
                    newMinX = exactSteps * (double)count;
                } else {
                    ++count;
                    while (newMinX + exactSteps < 0.0) {
                        newMinX += exactSteps;
                        ++count;
                    }
                    newMinX = exactSteps * (double)count * -1.0;
                }
                if (newMinX == minX) {
                    adjusting = false;
                    continue;
                }
                minX = newMinX;
            }
            double newMaxX = newMinX + (double)(numHorizontalLabels - 1) * exactSteps;
            this.mGraphView.getViewport().setMinX(newMinX);
            this.mGraphView.getViewport().setMaxX(newMaxX);
            if (this.mGraphView.getViewport().getXAxisBoundsStatus() == Viewport.AxisBoundsStatus.READJUST_AFTER_SCALE) {
                this.mGraphView.getViewport().setXAxisBoundsStatus(Viewport.AxisBoundsStatus.FIX);
            } else {
                this.mGraphView.getViewport().setXAxisBoundsStatus(Viewport.AxisBoundsStatus.AUTO_ADJUSTED);
            }
        }
        this.mStepsHorizontal = new LinkedHashMap<Integer, Double>(numHorizontalLabels);
        int width = this.mGraphView.getGraphContentWidth();
        float scrolled = 0.0f;
        float scrolledPixels = 0.0f;
        double v = newMinX;
        int p = this.mGraphView.getGraphContentLeft();
        float pixelStep = width / (numHorizontalLabels - 1);
        if (this.mGraphView.getViewport().mScalingActive) {
            float oldStep = this.mGraphView.getViewport().mScalingBeginWidth / (float)(numHorizontalLabels - 1);
            float factor = (this.mGraphView.getViewport().mCurrentViewport.width() + oldStep) / (this.mGraphView.getViewport().mScalingBeginWidth + oldStep);
            pixelStep *= 1.0f / factor;
            Log.d((String)"GridLabelRenderer", (String)"hhier scaling");
            float newWidth = (float)width * 1.0f / factor;
            scrolledPixels = (newWidth - (float)width) * -0.5f;
        }
        if (!Float.isNaN(this.mGraphView.getViewport().mScrollingReferenceX)) {
            scrolled = this.mGraphView.getViewport().mScrollingReferenceX - (float)newMinX;
            scrolledPixels += scrolled * (pixelStep / (float)exactSteps);
            if ((double)scrolled < 0.0 - exactSteps) {
                this.mGraphView.getViewport().mScrollingReferenceX = (float)((double)this.mGraphView.getViewport().mScrollingReferenceX + exactSteps);
            } else if ((double)scrolled > exactSteps) {
                this.mGraphView.getViewport().mScrollingReferenceX = (float)((double)this.mGraphView.getViewport().mScrollingReferenceX - exactSteps);
            }
        }
        p = (int)((float)p + scrolledPixels);
        v += (double)scrolled;
        for (int i = 0; i < numHorizontalLabels; ++i) {
            if (p >= this.mGraphView.getGraphContentLeft()) {
                this.mStepsHorizontal.put(p, v);
            }
            p = (int)((float)p + pixelStep);
            v += exactSteps;
        }
        return true;
    }

    protected void adjust() {
        this.mIsAdjusted = this.adjustVertical();
        this.mIsAdjusted &= this.adjustVerticalSecondScale();
        this.mIsAdjusted &= this.adjustHorizontal();
    }

    protected void calcLabelVerticalSize(Canvas canvas) {
        String testLabel = this.mLabelFormatter.formatLabel(this.mGraphView.getViewport().getMaxY(false), false);
        Rect textBounds = new Rect();
        this.mPaintLabel.getTextBounds(testLabel, 0, testLabel.length(), textBounds);
        this.mLabelVerticalWidth = textBounds.width();
        this.mLabelVerticalHeight = textBounds.height();
        testLabel = this.mLabelFormatter.formatLabel(this.mGraphView.getViewport().getMinY(false), false);
        this.mPaintLabel.getTextBounds(testLabel, 0, testLabel.length(), textBounds);
        this.mLabelVerticalWidth = Math.max(this.mLabelVerticalWidth, textBounds.width());
        this.mLabelVerticalWidth = this.mLabelVerticalWidth + 6;
        int lines = 1;
        for (byte c : testLabel.getBytes()) {
            if (c != 10) continue;
            ++lines;
        }
        this.mLabelVerticalHeight = this.mLabelVerticalHeight * lines;
    }

    protected void calcLabelVerticalSecondScaleSize(Canvas canvas) {
        if (this.mGraphView.mSecondScale == null) {
            this.mLabelVerticalSecondScaleWidth = 0;
            this.mLabelVerticalSecondScaleHeight = 0;
            return;
        }
        double testY = (this.mGraphView.mSecondScale.getMaxY() - this.mGraphView.mSecondScale.getMinY()) * 0.783 + this.mGraphView.mSecondScale.getMinY();
        String testLabel = this.mLabelFormatter.formatLabel(testY, false);
        Rect textBounds = new Rect();
        this.mPaintLabel.getTextBounds(testLabel, 0, testLabel.length(), textBounds);
        this.mLabelVerticalSecondScaleWidth = textBounds.width();
        this.mLabelVerticalSecondScaleHeight = textBounds.height();
        int lines = 1;
        for (byte c : testLabel.getBytes()) {
            if (c != 10) continue;
            ++lines;
        }
        this.mLabelVerticalSecondScaleHeight = this.mLabelVerticalSecondScaleHeight * lines;
    }

    protected void calcLabelHorizontalSize(Canvas canvas) {
        double testX = (this.mGraphView.getViewport().getMaxX(false) - this.mGraphView.getViewport().getMinX(false)) * 0.783 + this.mGraphView.getViewport().getMinX(false);
        String testLabel = this.mLabelFormatter.formatLabel(testX, true);
        Rect textBounds = new Rect();
        this.mPaintLabel.getTextBounds(testLabel, 0, testLabel.length(), textBounds);
        this.mLabelHorizontalWidth = textBounds.width();
        this.mLabelHorizontalHeight = textBounds.height();
        int lines = 1;
        for (byte c : testLabel.getBytes()) {
            if (c != 10) continue;
            ++lines;
        }
        this.mLabelHorizontalHeight = this.mLabelHorizontalHeight * lines;
    }

    public void draw(Canvas canvas) {
        boolean labelSizeChanged = false;
        if (this.mLabelHorizontalWidth == null) {
            this.calcLabelHorizontalSize(canvas);
            labelSizeChanged = true;
        }
        if (this.mLabelVerticalWidth == null) {
            this.calcLabelVerticalSize(canvas);
            labelSizeChanged = true;
        }
        if (this.mLabelVerticalSecondScaleWidth == null) {
            this.calcLabelVerticalSecondScaleSize(canvas);
            labelSizeChanged = true;
        }
        if (labelSizeChanged) {
            ViewCompat.postInvalidateOnAnimation((View)this.mGraphView);
            return;
        }
        if (!this.mIsAdjusted) {
            this.adjust();
        }
        if (!this.mIsAdjusted) {
            return;
        }
        this.drawVerticalSteps(canvas);
        this.drawVerticalStepsSecondScale(canvas);
        this.drawHorizontalSteps(canvas);
        this.drawHorizontalAxisTitle(canvas);
        this.drawVerticalAxisTitle(canvas);
    }

    protected void drawHorizontalAxisTitle(Canvas canvas) {
        if (this.mHorizontalAxisTitle != null && this.mHorizontalAxisTitle.length() > 0) {
            this.mPaintAxisTitle.setColor(this.getHorizontalAxisTitleColor());
            this.mPaintAxisTitle.setTextSize(this.getHorizontalAxisTitleTextSize());
            float x = canvas.getWidth() / 2;
            float y = canvas.getHeight() - this.mStyles.padding;
            canvas.drawText(this.mHorizontalAxisTitle, x, y, this.mPaintAxisTitle);
        }
    }

    protected void drawVerticalAxisTitle(Canvas canvas) {
        if (this.mVerticalAxisTitle != null && this.mVerticalAxisTitle.length() > 0) {
            this.mPaintAxisTitle.setColor(this.getVerticalAxisTitleColor());
            this.mPaintAxisTitle.setTextSize(this.getVerticalAxisTitleTextSize());
            float x = this.getVerticalAxisTitleWidth();
            float y = canvas.getHeight() / 2;
            canvas.save();
            canvas.rotate(-90.0f, x, y);
            canvas.drawText(this.mVerticalAxisTitle, x, y, this.mPaintAxisTitle);
            canvas.restore();
        }
    }

    public int getHorizontalAxisTitleHeight() {
        if (this.mHorizontalAxisTitle != null && this.mHorizontalAxisTitle.length() > 0) {
            return (int)this.getHorizontalAxisTitleTextSize();
        }
        return 0;
    }

    public int getVerticalAxisTitleWidth() {
        if (this.mVerticalAxisTitle != null && this.mVerticalAxisTitle.length() > 0) {
            return (int)this.getVerticalAxisTitleTextSize();
        }
        return 0;
    }

    protected void drawHorizontalSteps(Canvas canvas) {
        this.mPaintLabel.setColor(this.getHorizontalLabelsColor());
        int i = 0;
        for (Map.Entry<Integer, Double> e : this.mStepsHorizontal.entrySet()) {
            if (this.mStyles.highlightZeroLines) {
                if (e.getValue() == 0.0) {
                    this.mPaintLine.setStrokeWidth(5.0f);
                } else {
                    this.mPaintLine.setStrokeWidth(0.0f);
                }
            }
            if (this.mStyles.gridStyle.drawVertical()) {
                canvas.drawLine((float)e.getKey().intValue(), (float)this.mGraphView.getGraphContentTop(), (float)e.getKey().intValue(), (float)(this.mGraphView.getGraphContentTop() + this.mGraphView.getGraphContentHeight()), this.mPaintLine);
            }
            if (this.isHorizontalLabelsVisible()) {
                this.mPaintLabel.setTextAlign(Paint.Align.CENTER);
                if (i == this.mStepsHorizontal.size() - 1) {
                    this.mPaintLabel.setTextAlign(Paint.Align.RIGHT);
                }
                if (i == 0) {
                    this.mPaintLabel.setTextAlign(Paint.Align.LEFT);
                }
                String[] lines = this.mLabelFormatter.formatLabel(e.getValue(), true).split("\n");
                for (int li = 0; li < lines.length; ++li) {
                    float y = (float)(canvas.getHeight() - this.mStyles.padding - this.getHorizontalAxisTitleHeight()) - (float)(lines.length - li - 1) * this.getTextSize() * 1.1f;
                    canvas.drawText(lines[li], (float)e.getKey().intValue(), y, this.mPaintLabel);
                }
            }
            ++i;
        }
    }

    protected void drawVerticalStepsSecondScale(Canvas canvas) {
        if (this.mGraphView.mSecondScale == null) {
            return;
        }
        float startLeft = this.mGraphView.getGraphContentLeft() + this.mGraphView.getGraphContentWidth();
        this.mPaintLabel.setColor(this.getVerticalLabelsSecondScaleColor());
        this.mPaintLabel.setTextAlign(this.getVerticalLabelsSecondScaleAlign());
        for (Map.Entry<Integer, Double> e : this.mStepsVerticalSecondScale.entrySet()) {
            int labelsWidth = this.mLabelVerticalSecondScaleWidth;
            int labelsOffset = (int)startLeft;
            if (this.getVerticalLabelsSecondScaleAlign() == Paint.Align.RIGHT) {
                labelsOffset += labelsWidth;
            } else if (this.getVerticalLabelsSecondScaleAlign() == Paint.Align.CENTER) {
                labelsOffset += labelsWidth / 2;
            }
            float y = e.getKey().intValue();
            String[] lines = this.mLabelFormatter.formatLabel(e.getValue(), false).split("\n");
            y += (float)lines.length * this.getTextSize() * 1.1f / 2.0f;
            for (int li = 0; li < lines.length; ++li) {
                float y2 = y - (float)(lines.length - li - 1) * this.getTextSize() * 1.1f;
                canvas.drawText(lines[li], (float)labelsOffset, y2, this.mPaintLabel);
            }
        }
    }

    protected void drawVerticalSteps(Canvas canvas) {
        float startLeft = this.mGraphView.getGraphContentLeft();
        this.mPaintLabel.setColor(this.getVerticalLabelsColor());
        this.mPaintLabel.setTextAlign(this.getVerticalLabelsAlign());
        for (Map.Entry<Integer, Double> e : this.mStepsVertical.entrySet()) {
            if (this.mStyles.highlightZeroLines) {
                if (e.getValue() == 0.0) {
                    this.mPaintLine.setStrokeWidth(5.0f);
                } else {
                    this.mPaintLine.setStrokeWidth(0.0f);
                }
            }
            if (this.mStyles.gridStyle.drawHorizontal()) {
                canvas.drawLine(startLeft, (float)e.getKey().intValue(), startLeft + (float)this.mGraphView.getGraphContentWidth(), (float)e.getKey().intValue(), this.mPaintLine);
            }
            if (!this.isVerticalLabelsVisible()) continue;
            int labelsWidth = this.mLabelVerticalWidth;
            int labelsOffset = 0;
            if (this.getVerticalLabelsAlign() == Paint.Align.RIGHT) {
                labelsOffset = labelsWidth;
            } else if (this.getVerticalLabelsAlign() == Paint.Align.CENTER) {
                labelsOffset = labelsWidth / 2;
            }
            labelsOffset += this.mStyles.padding + this.getVerticalAxisTitleWidth();
            float y = e.getKey().intValue();
            String[] lines = this.mLabelFormatter.formatLabel(e.getValue(), false).split("\n");
            y += (float)lines.length * this.getTextSize() * 1.1f / 2.0f;
            for (int li = 0; li < lines.length; ++li) {
                float y2 = y - (float)(lines.length - li - 1) * this.getTextSize() * 1.1f;
                canvas.drawText(lines[li], (float)labelsOffset, y2, this.mPaintLabel);
            }
        }
    }

    protected double humanRound(double in, boolean roundAlwaysUp) {
        int ten = 0;
        while (in >= 10.0) {
            in /= 10.0;
            ++ten;
        }
        while (in < 1.0) {
            in *= 10.0;
            --ten;
        }
        if (roundAlwaysUp) {
            if (in != 1.0) {
                if (in <= 2.0) {
                    in = 2.0;
                } else if (in <= 5.0) {
                    in = 5.0;
                } else if (in < 10.0) {
                    in = 10.0;
                }
            }
        } else {
            Log.d((String)"GridLabelRenderer", (String)("round down " + in));
            if (in != 1.0) {
                if (in <= 4.9) {
                    in = 2.0;
                } else if (in <= 9.9) {
                    in = 5.0;
                } else if (in < 15.0) {
                    in = 10.0;
                }
            }
            Log.d((String)"GridLabelRenderer", (String)("-> " + in));
        }
        return in * Math.pow(10.0, ten);
    }

    public Styles getStyles() {
        return this.mStyles;
    }

    public int getLabelVerticalWidth() {
        return this.mLabelVerticalWidth == null || !this.isVerticalLabelsVisible() ? 0 : this.mLabelVerticalWidth;
    }

    public int getLabelHorizontalHeight() {
        return this.mLabelHorizontalHeight == null || !this.isHorizontalLabelsVisible() ? 0 : this.mLabelHorizontalHeight;
    }

    public int getGridColor() {
        return this.mStyles.gridColor;
    }

    public boolean isHighlightZeroLines() {
        return this.mStyles.highlightZeroLines;
    }

    public int getPadding() {
        return this.mStyles.padding;
    }

    public void setTextSize(float textSize) {
        this.mStyles.textSize = textSize;
    }

    public void setVerticalLabelsAlign(Paint.Align verticalLabelsAlign) {
        this.mStyles.verticalLabelsAlign = verticalLabelsAlign;
    }

    public void setVerticalLabelsColor(int verticalLabelsColor) {
        this.mStyles.verticalLabelsColor = verticalLabelsColor;
    }

    public void setHorizontalLabelsColor(int horizontalLabelsColor) {
        this.mStyles.horizontalLabelsColor = horizontalLabelsColor;
    }

    public void setGridColor(int gridColor) {
        this.mStyles.gridColor = gridColor;
    }

    public void setHighlightZeroLines(boolean highlightZeroLines) {
        this.mStyles.highlightZeroLines = highlightZeroLines;
    }

    public void setPadding(int padding) {
        this.mStyles.padding = padding;
    }

    public LabelFormatter getLabelFormatter() {
        return this.mLabelFormatter;
    }

    public void setLabelFormatter(LabelFormatter mLabelFormatter) {
        this.mLabelFormatter = mLabelFormatter;
        mLabelFormatter.setViewport(this.mGraphView.getViewport());
    }

    public String getHorizontalAxisTitle() {
        return this.mHorizontalAxisTitle;
    }

    public void setHorizontalAxisTitle(String mHorizontalAxisTitle) {
        this.mHorizontalAxisTitle = mHorizontalAxisTitle;
    }

    public String getVerticalAxisTitle() {
        return this.mVerticalAxisTitle;
    }

    public void setVerticalAxisTitle(String mVerticalAxisTitle) {
        this.mVerticalAxisTitle = mVerticalAxisTitle;
    }

    public float getVerticalAxisTitleTextSize() {
        return this.mStyles.verticalAxisTitleTextSize;
    }

    public void setVerticalAxisTitleTextSize(float verticalAxisTitleTextSize) {
        this.mStyles.verticalAxisTitleTextSize = verticalAxisTitleTextSize;
    }

    public int getVerticalAxisTitleColor() {
        return this.mStyles.verticalAxisTitleColor;
    }

    public void setVerticalAxisTitleColor(int verticalAxisTitleColor) {
        this.mStyles.verticalAxisTitleColor = verticalAxisTitleColor;
    }

    public float getHorizontalAxisTitleTextSize() {
        return this.mStyles.horizontalAxisTitleTextSize;
    }

    public void setHorizontalAxisTitleTextSize(float horizontalAxisTitleTextSize) {
        this.mStyles.horizontalAxisTitleTextSize = horizontalAxisTitleTextSize;
    }

    public int getHorizontalAxisTitleColor() {
        return this.mStyles.horizontalAxisTitleColor;
    }

    public void setHorizontalAxisTitleColor(int horizontalAxisTitleColor) {
        this.mStyles.horizontalAxisTitleColor = horizontalAxisTitleColor;
    }

    public Paint.Align getVerticalLabelsSecondScaleAlign() {
        return this.mStyles.verticalLabelsSecondScaleAlign;
    }

    public void setVerticalLabelsSecondScaleAlign(Paint.Align verticalLabelsSecondScaleAlign) {
        this.mStyles.verticalLabelsSecondScaleAlign = verticalLabelsSecondScaleAlign;
    }

    public int getVerticalLabelsSecondScaleColor() {
        return this.mStyles.verticalLabelsSecondScaleColor;
    }

    public void setVerticalLabelsSecondScaleColor(int verticalLabelsSecondScaleColor) {
        this.mStyles.verticalLabelsSecondScaleColor = verticalLabelsSecondScaleColor;
    }

    public int getLabelVerticalSecondScaleWidth() {
        return this.mLabelVerticalSecondScaleWidth;
    }

    public boolean isHorizontalLabelsVisible() {
        return this.mStyles.horizontalLabelsVisible;
    }

    public void setHorizontalLabelsVisible(boolean horizontalTitleVisible) {
        this.mStyles.horizontalLabelsVisible = horizontalTitleVisible;
    }

    public boolean isVerticalLabelsVisible() {
        return this.mStyles.verticalLabelsVisible;
    }

    public void setVerticalLabelsVisible(boolean verticalTitleVisible) {
        this.mStyles.verticalLabelsVisible = verticalTitleVisible;
    }

    public int getNumVerticalLabels() {
        return this.mNumVerticalLabels;
    }

    public void setNumVerticalLabels(int mNumVerticalLabels) {
        this.mNumVerticalLabels = mNumVerticalLabels;
    }

    public int getNumHorizontalLabels() {
        return this.mNumHorizontalLabels;
    }

    public void setNumHorizontalLabels(int mNumHorizontalLabels) {
        this.mNumHorizontalLabels = mNumHorizontalLabels;
    }

    public GridStyle getGridStyle() {
        return this.mStyles.gridStyle;
    }

    public void setGridStyle(GridStyle gridStyle) {
        this.mStyles.gridStyle = gridStyle;
    }

    public static enum GridStyle {
        BOTH,
        VERTICAL,
        HORIZONTAL,
        NONE;


        public boolean drawVertical() {
            return this == BOTH || this == VERTICAL && this != NONE;
        }

        public boolean drawHorizontal() {
            return this == BOTH || this == HORIZONTAL && this != NONE;
        }
    }

    public final class Styles {
        public float textSize;
        public Paint.Align verticalLabelsAlign;
        public Paint.Align verticalLabelsSecondScaleAlign;
        public int verticalLabelsColor;
        public int verticalLabelsSecondScaleColor;
        public int horizontalLabelsColor;
        public int gridColor;
        public boolean highlightZeroLines;
        public int padding;
        public float verticalAxisTitleTextSize;
        public int verticalAxisTitleColor;
        public float horizontalAxisTitleTextSize;
        public int horizontalAxisTitleColor;
        boolean horizontalLabelsVisible;
        boolean verticalLabelsVisible;
        GridStyle gridStyle;
    }
}

