/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.GraphViewDataInterface;
import com.jjoe64.graphview.GraphViewSeries;

public class BarGraphView
extends GraphView {
    private boolean drawValuesOnTop;
    private int valuesOnTopColor = -1;

    public BarGraphView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BarGraphView(Context context, String title) {
        super(context, title);
    }

    @Override
    protected void drawHorizontalLabels(Canvas canvas, float border, float horstart, float height, String[] horlabels, float graphwidth) {
        this.paint.setTextAlign(Paint.Align.CENTER);
        int hors = horlabels.length;
        float barwidth = graphwidth / (float)horlabels.length;
        float textOffset = barwidth / 2.0f;
        for (int i = 0; i < horlabels.length; ++i) {
            float x = graphwidth / (float)hors * (float)i + horstart;
            this.paint.setColor(this.graphViewStyle.getGridColor());
            canvas.drawLine(x, height - border, x, border, this.paint);
            if (!this.getShowHorizontalLabels()) continue;
            x = barwidth * (float)i + textOffset + horstart;
            this.paint.setColor(this.graphViewStyle.getHorizontalLabelsColor());
            canvas.drawText(horlabels[i], x, height - 4.0f, this.paint);
        }
    }

    @Override
    public void drawSeries(Canvas canvas, GraphViewDataInterface[] values, float graphwidth, float graphheight, float border, double minX, double minY, double diffX, double diffY, float horstart, GraphViewSeries.GraphViewSeriesStyle style) {
        float colwidth = graphwidth / (float)values.length;
        this.paint.setStrokeWidth((float)style.thickness);
        float offset = 0.0f;
        for (int i = 0; i < values.length; ++i) {
            float valY = (float)(values[i].getY() - minY);
            float ratY = (float)((double)valY / diffY);
            float y = graphheight * ratY;
            if (style.getValueDependentColor() != null) {
                this.paint.setColor(style.getValueDependentColor().get(values[i]));
            } else {
                this.paint.setColor(style.color);
            }
            float left = (float)i * colwidth + horstart - offset;
            float top = border - y + graphheight;
            float right = (float)i * colwidth + horstart + (colwidth - 1.0f) - offset;
            canvas.drawRect(left, top, right, graphheight + border - 1.0f, this.paint);
            if (!this.drawValuesOnTop) continue;
            if ((top -= 4.0f) <= border) {
                top += border + 4.0f;
            }
            this.paint.setTextAlign(Paint.Align.CENTER);
            this.paint.setColor(this.valuesOnTopColor);
            canvas.drawText(this.formatLabel(values[i].getY(), false), (left + right) / 2.0f, top, this.paint);
        }
    }

    public boolean getDrawValuesOnTop() {
        return this.drawValuesOnTop;
    }

    public int getValuesOnTopColor() {
        return this.valuesOnTopColor;
    }

    public void setDrawValuesOnTop(boolean drawValuesOnTop) {
        this.drawValuesOnTop = drawValuesOnTop;
    }

    public void setValuesOnTopColor(int valuesOnTopColor) {
        this.valuesOnTopColor = valuesOnTopColor;
    }
}

