/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.jjoe64.graphview.DefaultLabelFormatter;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.LabelFormatter;
import com.jjoe64.graphview.RectD;
import com.jjoe64.graphview.series.Series;
import java.util.ArrayList;
import java.util.List;

public class SecondScale {
    protected final GraphView mGraph;
    protected List<Series> mSeries;
    private boolean mYAxisBoundsManual = true;
    protected RectD mCompleteRange = new RectD();
    protected RectD mCurrentViewport = new RectD();
    protected LabelFormatter mLabelFormatter;
    protected double mReferenceY = Double.NaN;
    private Paint mPaintAxisTitle;
    private String mVerticalAxisTitle;
    public float mVerticalAxisTitleTextSize;
    public int mVerticalAxisTitleColor;

    SecondScale(GraphView graph) {
        this.mGraph = graph;
        this.mSeries = new ArrayList<Series>();
        this.mLabelFormatter = new DefaultLabelFormatter();
        this.mLabelFormatter.setViewport(this.mGraph.getViewport());
    }

    public void addSeries(Series s) {
        s.onGraphViewAttached(this.mGraph);
        this.mSeries.add(s);
        this.mGraph.onDataChanged(false, false);
    }

    public void setMinY(double d) {
        this.mReferenceY = d;
        this.mCurrentViewport.bottom = d;
    }

    public void setMaxY(double d) {
        this.mCurrentViewport.top = d;
    }

    public List<Series> getSeries() {
        return this.mSeries;
    }

    public double getMinY(boolean completeRange) {
        return completeRange ? this.mCompleteRange.bottom : this.mCurrentViewport.bottom;
    }

    public double getMaxY(boolean completeRange) {
        return completeRange ? this.mCompleteRange.top : this.mCurrentViewport.top;
    }

    public boolean isYAxisBoundsManual() {
        return this.mYAxisBoundsManual;
    }

    public LabelFormatter getLabelFormatter() {
        return this.mLabelFormatter;
    }

    public void setLabelFormatter(LabelFormatter formatter) {
        this.mLabelFormatter = formatter;
        this.mLabelFormatter.setViewport(this.mGraph.getViewport());
    }

    public void removeAllSeries() {
        this.mSeries.clear();
        this.mGraph.onDataChanged(false, false);
    }

    public void removeSeries(Series series) {
        this.mSeries.remove(series);
        this.mGraph.onDataChanged(false, false);
    }

    public void calcCompleteRange() {
        List<Series> series = this.getSeries();
        this.mCompleteRange.set(0.0, 0.0, 0.0, 0.0);
        if (!series.isEmpty() && !series.get(0).isEmpty()) {
            double d = series.get(0).getLowestValueX();
            for (Series s : series) {
                if (s.isEmpty() || !(d > s.getLowestValueX())) continue;
                d = s.getLowestValueX();
            }
            this.mCompleteRange.left = d;
            d = series.get(0).getHighestValueX();
            for (Series s : series) {
                if (s.isEmpty() || !(d < s.getHighestValueX())) continue;
                d = s.getHighestValueX();
            }
            this.mCompleteRange.right = d;
            if (!series.isEmpty() && !series.get(0).isEmpty()) {
                d = series.get(0).getLowestValueY();
                for (Series s : series) {
                    if (s.isEmpty() || !(d > s.getLowestValueY())) continue;
                    d = s.getLowestValueY();
                }
                this.mCompleteRange.bottom = d;
                d = series.get(0).getHighestValueY();
                for (Series s : series) {
                    if (s.isEmpty() || !(d < s.getHighestValueY())) continue;
                    d = s.getHighestValueY();
                }
                this.mCompleteRange.top = d;
            }
        }
    }

    public String getVerticalAxisTitle() {
        return this.mVerticalAxisTitle;
    }

    public void setVerticalAxisTitle(String mVerticalAxisTitle) {
        if (this.mPaintAxisTitle == null) {
            this.mPaintAxisTitle = new Paint();
            this.mPaintAxisTitle.setTextSize(this.getVerticalAxisTitleTextSize());
            this.mPaintAxisTitle.setTextAlign(Paint.Align.CENTER);
        }
        this.mVerticalAxisTitle = mVerticalAxisTitle;
    }

    public float getVerticalAxisTitleTextSize() {
        if (this.getVerticalAxisTitle() == null || this.getVerticalAxisTitle().length() == 0) {
            return 0.0f;
        }
        return this.mVerticalAxisTitleTextSize;
    }

    public void setVerticalAxisTitleTextSize(float verticalAxisTitleTextSize) {
        this.mVerticalAxisTitleTextSize = verticalAxisTitleTextSize;
    }

    public int getVerticalAxisTitleColor() {
        return this.mVerticalAxisTitleColor;
    }

    public void setVerticalAxisTitleColor(int verticalAxisTitleColor) {
        this.mVerticalAxisTitleColor = verticalAxisTitleColor;
    }

    protected void drawVerticalAxisTitle(Canvas canvas) {
        if (this.mVerticalAxisTitle != null && this.mVerticalAxisTitle.length() > 0) {
            this.mPaintAxisTitle.setColor(this.getVerticalAxisTitleColor());
            this.mPaintAxisTitle.setTextSize(this.getVerticalAxisTitleTextSize());
            float x = (float)canvas.getWidth() - this.getVerticalAxisTitleTextSize() / 2.0f;
            float y = canvas.getHeight() / 2;
            canvas.save();
            canvas.rotate(-90.0f, x, y);
            canvas.drawText(this.mVerticalAxisTitle, x, y, this.mPaintAxisTitle);
            canvas.restore();
        }
    }
}

