/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview;

import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.TypedValue;
import com.jjoe64.graphview.DefaultLabelFormatter;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.LabelFormatter;
import com.jjoe64.graphview.Viewport;
import java.util.LinkedHashMap;
import java.util.Map;

public class GridLabelRenderer {
    protected Styles mStyles;
    private final GraphView mGraphView;
    private Map<Integer, Double> mStepsVertical;
    private Map<Integer, Double> mStepsVerticalSecondScale;
    private Map<Integer, Double> mStepsHorizontal;
    private Paint mPaintLine;
    private Paint mPaintLabel;
    private Paint mPaintAxisTitle;
    protected boolean mIsAdjusted;
    private Integer mLabelVerticalWidth;
    private boolean mLabelVerticalWidthFixed;
    private Integer mLabelVerticalHeight;
    private boolean mLabelHorizontalHeightFixed;
    private Integer mLabelVerticalSecondScaleWidth;
    private Integer mLabelVerticalSecondScaleHeight;
    private Integer mLabelHorizontalWidth;
    private Integer mLabelHorizontalHeight;
    private LabelFormatter mLabelFormatter;
    private String mHorizontalAxisTitle;
    private String mVerticalAxisTitle;
    private int mNumVerticalLabels;
    private int mNumHorizontalLabels;
    private boolean mHumanRounding;

    public void setSecondScaleLabelVerticalWidth(Integer newWidth) {
        this.mLabelVerticalSecondScaleWidth = newWidth;
    }

    public GridLabelRenderer(GraphView graphView) {
        this.mGraphView = graphView;
        this.setLabelFormatter(new DefaultLabelFormatter());
        this.mStyles = new Styles();
        this.resetStyles();
        this.mNumVerticalLabels = 5;
        this.mNumHorizontalLabels = 5;
        this.mHumanRounding = true;
    }

    public void resetStyles() {
        int size2;
        int size;
        int color2;
        int color1;
        TypedValue typedValue = new TypedValue();
        this.mGraphView.getContext().getTheme().resolveAttribute(16842818, typedValue, true);
        TypedArray array = null;
        try {
            array = this.mGraphView.getContext().obtainStyledAttributes(typedValue.data, new int[]{16842806, 16842808, 16842901, 16843327});
            color1 = array.getColor(0, -16777216);
            color2 = array.getColor(1, -7829368);
            size = array.getDimensionPixelSize(2, 20);
            size2 = array.getDimensionPixelSize(3, 20);
            array.recycle();
        }
        catch (Exception e) {
            color1 = -16777216;
            color2 = -7829368;
            size = 20;
            size2 = 20;
        }
        this.mStyles.verticalLabelsColor = color1;
        this.mStyles.verticalLabelsSecondScaleColor = color1;
        this.mStyles.horizontalLabelsColor = color1;
        this.mStyles.gridColor = color2;
        this.mStyles.textSize = size;
        this.mStyles.padding = size2;
        this.mStyles.labelsSpace = (int)this.mStyles.textSize / 5;
        this.mStyles.verticalLabelsAlign = Paint.Align.RIGHT;
        this.mStyles.verticalLabelsSecondScaleAlign = Paint.Align.LEFT;
        this.mStyles.highlightZeroLines = true;
        this.mStyles.verticalAxisTitleColor = this.mStyles.verticalLabelsColor;
        this.mStyles.horizontalAxisTitleColor = this.mStyles.horizontalLabelsColor;
        this.mStyles.verticalAxisTitleTextSize = this.mStyles.textSize;
        this.mStyles.horizontalAxisTitleTextSize = this.mStyles.textSize;
        this.mStyles.horizontalLabelsVisible = true;
        this.mStyles.verticalLabelsVisible = true;
        this.mStyles.horizontalLabelsAngle = 0.0f;
        this.mStyles.gridStyle = GridStyle.BOTH;
        this.reloadStyles();
    }

    public void reloadStyles() {
        this.mPaintLine = new Paint();
        this.mPaintLine.setColor(this.mStyles.gridColor);
        this.mPaintLine.setStrokeWidth(0.0f);
        this.mPaintLabel = new Paint();
        this.mPaintLabel.setTextSize(this.getTextSize());
        this.mPaintLabel.setAntiAlias(true);
        this.mPaintAxisTitle = new Paint();
        this.mPaintAxisTitle.setTextSize(this.getTextSize());
        this.mPaintAxisTitle.setTextAlign(Paint.Align.CENTER);
    }

    public boolean isHumanRounding() {
        return this.mHumanRounding;
    }

    public void setHumanRounding(boolean humanRounding) {
        this.mHumanRounding = humanRounding;
    }

    public float getTextSize() {
        return this.mStyles.textSize;
    }

    public int getVerticalLabelsColor() {
        return this.mStyles.verticalLabelsColor;
    }

    public Paint.Align getVerticalLabelsAlign() {
        return this.mStyles.verticalLabelsAlign;
    }

    public int getHorizontalLabelsColor() {
        return this.mStyles.horizontalLabelsColor;
    }

    public float getHorizontalLabelsAngle() {
        return this.mStyles.horizontalLabelsAngle;
    }

    public void invalidate(boolean keepLabelsSize, boolean keepViewport) {
        if (!keepViewport) {
            this.mIsAdjusted = false;
        }
        if (!keepLabelsSize) {
            if (!this.mLabelVerticalWidthFixed) {
                this.mLabelVerticalWidth = null;
            }
            this.mLabelVerticalHeight = null;
            this.mLabelVerticalSecondScaleWidth = null;
            this.mLabelVerticalSecondScaleHeight = null;
        }
    }

    protected boolean adjustVerticalSecondScale() {
        if (this.mLabelHorizontalHeight == null) {
            return false;
        }
        if (this.mGraphView.mSecondScale == null) {
            return true;
        }
        double minY = this.mGraphView.mSecondScale.getMinY(false);
        double maxY = this.mGraphView.mSecondScale.getMaxY(false);
        int numVerticalLabels = this.mNumVerticalLabels;
        if (!this.mGraphView.mSecondScale.isYAxisBoundsManual()) {
            throw new IllegalStateException("Not yet implemented");
        }
        double exactSteps = (maxY - minY) / (double)(numVerticalLabels - 1);
        exactSteps = (double)Math.round(exactSteps * 1000000.0) / 1000000.0;
        if (this.mStepsVerticalSecondScale != null && this.mStepsVerticalSecondScale.size() > 1) {
            double oldSteps;
            double d1 = 0.0;
            double d2 = 0.0;
            int i = 0;
            for (Double v : this.mStepsVerticalSecondScale.values()) {
                if (i != 0) {
                    d2 = v;
                    break;
                }
                d1 = v;
                ++i;
            }
            if ((oldSteps = d2 - d1) > 0.0) {
                double newSteps = Double.NaN;
                if (oldSteps > exactSteps) {
                    newSteps = oldSteps / 2.0;
                } else if (oldSteps < exactSteps) {
                    newSteps = oldSteps * 2.0;
                }
                int numStepsOld = (int)((maxY - minY) / oldSteps);
                int numStepsNew = (int)((maxY - minY) / newSteps);
                boolean shouldChange = numStepsOld <= numVerticalLabels && numStepsNew <= numVerticalLabels ? numStepsNew > numStepsOld : true;
                exactSteps = newSteps != Double.NaN && shouldChange && numStepsNew <= numVerticalLabels ? newSteps : oldSteps;
            }
        }
        double newMinY = this.mGraphView.getSecondScale().mReferenceY;
        double count = Math.floor((minY - newMinY) / exactSteps);
        newMinY = count * exactSteps + newMinY;
        numVerticalLabels = (int)(this.mGraphView.getSecondScale().mCurrentViewport.height() * -1.0 / exactSteps) + 2;
        if (this.mStepsVerticalSecondScale != null) {
            this.mStepsVerticalSecondScale.clear();
        } else {
            this.mStepsVerticalSecondScale = new LinkedHashMap<Integer, Double>(numVerticalLabels);
        }
        int height = this.mGraphView.getGraphContentHeight();
        double pixelPerData = (double)height / this.mGraphView.getSecondScale().mCurrentViewport.height() * -1.0;
        for (int i = 0; i < numVerticalLabels; ++i) {
            if (newMinY + (double)i * exactSteps > this.mGraphView.getSecondScale().mCurrentViewport.top || newMinY + (double)i * exactSteps < this.mGraphView.getSecondScale().mCurrentViewport.bottom) continue;
            double dataPointPos = newMinY + (double)i * exactSteps;
            double relativeToCurrentViewport = dataPointPos - this.mGraphView.getSecondScale().mCurrentViewport.bottom;
            double pixelPos = relativeToCurrentViewport * pixelPerData;
            this.mStepsVerticalSecondScale.put((int)pixelPos, dataPointPos);
        }
        return true;
    }

    protected boolean adjustVertical(boolean changeBounds) {
        double maxY;
        if (this.mLabelHorizontalHeight == null) {
            return false;
        }
        double minY = this.mGraphView.getViewport().getMinY(false);
        if (minY == (maxY = this.mGraphView.getViewport().getMaxY(false))) {
            return false;
        }
        int numVerticalLabels = this.mNumVerticalLabels;
        double exactSteps = (maxY - minY) / (double)(numVerticalLabels - 1);
        exactSteps = (double)Math.round(exactSteps * 1000000.0) / 1000000.0;
        if (this.isHumanRounding()) {
            exactSteps = this.humanRound(exactSteps, changeBounds);
        } else if (this.mStepsVertical != null && this.mStepsVertical.size() > 1) {
            double oldSteps;
            double d1 = 0.0;
            double d2 = 0.0;
            int i = 0;
            for (Double v : this.mStepsVertical.values()) {
                if (i != 0) {
                    d2 = v;
                    break;
                }
                d1 = v;
                ++i;
            }
            if ((oldSteps = d2 - d1) > 0.0) {
                double newSteps = Double.NaN;
                if (oldSteps > exactSteps) {
                    newSteps = oldSteps / 2.0;
                } else if (oldSteps < exactSteps) {
                    newSteps = oldSteps * 2.0;
                }
                int numStepsOld = (int)((maxY - minY) / oldSteps);
                int numStepsNew = (int)((maxY - minY) / newSteps);
                boolean shouldChange = numStepsOld <= numVerticalLabels && numStepsNew <= numVerticalLabels ? numStepsNew > numStepsOld : true;
                exactSteps = newSteps != Double.NaN && shouldChange && numStepsNew <= numVerticalLabels ? newSteps : oldSteps;
            }
        }
        double newMinY = this.mGraphView.getViewport().getReferenceY();
        double count = Math.floor((minY - newMinY) / exactSteps);
        newMinY = count * exactSteps + newMinY;
        if (changeBounds) {
            this.mGraphView.getViewport().setMinY(newMinY);
            this.mGraphView.getViewport().setMaxY(Math.max(maxY, newMinY + (double)(numVerticalLabels - 1) * exactSteps));
            this.mGraphView.getViewport().mYAxisBoundsStatus = Viewport.AxisBoundsStatus.AUTO_ADJUSTED;
        }
        numVerticalLabels = (int)(this.mGraphView.getViewport().mCurrentViewport.height() * -1.0 / exactSteps) + 2;
        if (this.mStepsVertical != null) {
            this.mStepsVertical.clear();
        } else {
            this.mStepsVertical = new LinkedHashMap<Integer, Double>(numVerticalLabels);
        }
        int height = this.mGraphView.getGraphContentHeight();
        double pixelPerData = (double)height / this.mGraphView.getViewport().mCurrentViewport.height() * -1.0;
        for (int i = 0; i < numVerticalLabels; ++i) {
            if (newMinY + (double)i * exactSteps > this.mGraphView.getViewport().mCurrentViewport.top || newMinY + (double)i * exactSteps < this.mGraphView.getViewport().mCurrentViewport.bottom) continue;
            double dataPointPos = newMinY + (double)i * exactSteps;
            double relativeToCurrentViewport = dataPointPos - this.mGraphView.getViewport().mCurrentViewport.bottom;
            double pixelPos = relativeToCurrentViewport * pixelPerData;
            this.mStepsVertical.put((int)pixelPos, dataPointPos);
        }
        return true;
    }

    protected boolean adjustHorizontal(boolean changeBounds) {
        double maxX;
        if (this.mLabelVerticalWidth == null) {
            return false;
        }
        double minX = this.mGraphView.getViewport().getMinX(false);
        if (minX == (maxX = this.mGraphView.getViewport().getMaxX(false))) {
            return false;
        }
        int numHorizontalLabels = this.mNumHorizontalLabels;
        double exactSteps = (maxX - minX) / (double)(numHorizontalLabels - 1);
        exactSteps = (double)Math.round(exactSteps * 1000000.0) / 1000000.0;
        if (this.isHumanRounding()) {
            exactSteps = this.humanRound(exactSteps, false);
        } else if (this.mStepsHorizontal != null && this.mStepsHorizontal.size() > 1) {
            double oldSteps;
            double d1 = 0.0;
            double d2 = 0.0;
            int i = 0;
            for (Double v : this.mStepsHorizontal.values()) {
                if (i != 0) {
                    d2 = v;
                    break;
                }
                d1 = v;
                ++i;
            }
            if ((oldSteps = d2 - d1) > 0.0) {
                double newSteps = Double.NaN;
                if (oldSteps > exactSteps) {
                    newSteps = oldSteps / 2.0;
                } else if (oldSteps < exactSteps) {
                    newSteps = oldSteps * 2.0;
                }
                int numStepsOld = (int)((maxX - minX) / oldSteps);
                int numStepsNew = (int)((maxX - minX) / newSteps);
                boolean shouldChange = numStepsOld <= numHorizontalLabels && numStepsNew <= numHorizontalLabels ? numStepsNew > numStepsOld : true;
                exactSteps = newSteps != Double.NaN && shouldChange && numStepsNew <= numHorizontalLabels ? newSteps : oldSteps;
            }
        }
        double newMinX = this.mGraphView.getViewport().getReferenceX();
        double count = Math.floor((minX - newMinX) / exactSteps);
        newMinX = count * exactSteps + newMinX;
        if (changeBounds) {
            this.mGraphView.getViewport().setMinX(newMinX);
            this.mGraphView.getViewport().setMaxX(newMinX + (double)(numHorizontalLabels - 1) * exactSteps);
            this.mGraphView.getViewport().mXAxisBoundsStatus = Viewport.AxisBoundsStatus.AUTO_ADJUSTED;
        }
        numHorizontalLabels = (int)(this.mGraphView.getViewport().mCurrentViewport.width() / exactSteps) + 1;
        if (this.mStepsHorizontal != null) {
            this.mStepsHorizontal.clear();
        } else {
            this.mStepsHorizontal = new LinkedHashMap<Integer, Double>(numHorizontalLabels);
        }
        int width = this.mGraphView.getGraphContentWidth();
        double pixelPerData = (double)width / this.mGraphView.getViewport().mCurrentViewport.width();
        for (int i = 0; i < numHorizontalLabels; ++i) {
            if (newMinX + (double)i * exactSteps < this.mGraphView.getViewport().mCurrentViewport.left) continue;
            double dataPointPos = newMinX + (double)i * exactSteps;
            double relativeToCurrentViewport = dataPointPos - this.mGraphView.getViewport().mCurrentViewport.left;
            double pixelPos = relativeToCurrentViewport * pixelPerData;
            this.mStepsHorizontal.put((int)pixelPos, dataPointPos);
        }
        return true;
    }

    protected void adjustSteps() {
        this.mIsAdjusted = this.adjustVertical(!Viewport.AxisBoundsStatus.FIX.equals((Object)this.mGraphView.getViewport().mYAxisBoundsStatus));
        this.mIsAdjusted &= this.adjustVerticalSecondScale();
        this.mIsAdjusted &= this.adjustHorizontal(!Viewport.AxisBoundsStatus.FIX.equals((Object)this.mGraphView.getViewport().mXAxisBoundsStatus));
    }

    protected void calcLabelVerticalSize(Canvas canvas) {
        String testLabel = this.mLabelFormatter.formatLabel(this.mGraphView.getViewport().getMaxY(false), false);
        if (testLabel == null) {
            testLabel = "";
        }
        Rect textBounds = new Rect();
        this.mPaintLabel.getTextBounds(testLabel, 0, testLabel.length(), textBounds);
        this.mLabelVerticalWidth = textBounds.width();
        this.mLabelVerticalHeight = textBounds.height();
        testLabel = this.mLabelFormatter.formatLabel(this.mGraphView.getViewport().getMinY(false), false);
        if (testLabel == null) {
            testLabel = "";
        }
        this.mPaintLabel.getTextBounds(testLabel, 0, testLabel.length(), textBounds);
        this.mLabelVerticalWidth = Math.max(this.mLabelVerticalWidth, textBounds.width());
        this.mLabelVerticalWidth = this.mLabelVerticalWidth + 6;
        this.mLabelVerticalWidth = this.mLabelVerticalWidth + this.mStyles.labelsSpace;
        int lines = 1;
        for (byte c : testLabel.getBytes()) {
            if (c != 10) continue;
            ++lines;
        }
        this.mLabelVerticalHeight = this.mLabelVerticalHeight * lines;
    }

    protected void calcLabelVerticalSecondScaleSize(Canvas canvas) {
        if (this.mGraphView.mSecondScale == null) {
            this.mLabelVerticalSecondScaleWidth = 0;
            this.mLabelVerticalSecondScaleHeight = 0;
            return;
        }
        double testY = (this.mGraphView.mSecondScale.getMaxY(false) - this.mGraphView.mSecondScale.getMinY(false)) * 0.783 + this.mGraphView.mSecondScale.getMinY(false);
        String testLabel = this.mGraphView.mSecondScale.getLabelFormatter().formatLabel(testY, false);
        Rect textBounds = new Rect();
        this.mPaintLabel.getTextBounds(testLabel, 0, testLabel.length(), textBounds);
        this.mLabelVerticalSecondScaleWidth = textBounds.width();
        this.mLabelVerticalSecondScaleHeight = textBounds.height();
        int lines = 1;
        for (byte c : testLabel.getBytes()) {
            if (c != 10) continue;
            ++lines;
        }
        this.mLabelVerticalSecondScaleHeight = this.mLabelVerticalSecondScaleHeight * lines;
    }

    protected void calcLabelHorizontalSize(Canvas canvas) {
        double testX = (this.mGraphView.getViewport().getMaxX(false) - this.mGraphView.getViewport().getMinX(false)) * 0.783 + this.mGraphView.getViewport().getMinX(false);
        String testLabel = this.mLabelFormatter.formatLabel(testX, true);
        if (testLabel == null) {
            testLabel = "";
        }
        Rect textBounds = new Rect();
        this.mPaintLabel.getTextBounds(testLabel, 0, testLabel.length(), textBounds);
        this.mLabelHorizontalWidth = textBounds.width();
        if (!this.mLabelHorizontalHeightFixed) {
            this.mLabelHorizontalHeight = textBounds.height();
            int lines = 1;
            for (byte c : testLabel.getBytes()) {
                if (c != 10) continue;
                ++lines;
            }
            this.mLabelHorizontalHeight = this.mLabelHorizontalHeight * lines;
            this.mLabelHorizontalHeight = (int)Math.max((float)this.mLabelHorizontalHeight.intValue(), this.mStyles.textSize);
        }
        if (this.mStyles.horizontalLabelsAngle > 0.0f && this.mStyles.horizontalLabelsAngle <= 180.0f) {
            int adjHorizontalHeightH = (int)Math.round(Math.abs((double)this.mLabelHorizontalHeight.intValue() * Math.cos(Math.toRadians(this.mStyles.horizontalLabelsAngle))));
            int adjHorizontalHeightW = (int)Math.round(Math.abs((double)this.mLabelHorizontalWidth.intValue() * Math.sin(Math.toRadians(this.mStyles.horizontalLabelsAngle))));
            int adjHorizontalWidthH = (int)Math.round(Math.abs((double)this.mLabelHorizontalHeight.intValue() * Math.sin(Math.toRadians(this.mStyles.horizontalLabelsAngle))));
            int adjHorizontalWidthW = (int)Math.round(Math.abs((double)this.mLabelHorizontalWidth.intValue() * Math.cos(Math.toRadians(this.mStyles.horizontalLabelsAngle))));
            this.mLabelHorizontalHeight = adjHorizontalHeightH + adjHorizontalHeightW;
            this.mLabelHorizontalWidth = adjHorizontalWidthH + adjHorizontalWidthW;
        }
        this.mLabelHorizontalHeight = this.mLabelHorizontalHeight + this.mStyles.labelsSpace;
    }

    public void draw(Canvas canvas) {
        boolean labelSizeChanged = false;
        if (this.mLabelHorizontalWidth == null) {
            this.calcLabelHorizontalSize(canvas);
            labelSizeChanged = true;
        }
        if (this.mLabelVerticalWidth == null) {
            this.calcLabelVerticalSize(canvas);
            labelSizeChanged = true;
        }
        if (this.mLabelVerticalSecondScaleWidth == null) {
            this.calcLabelVerticalSecondScaleSize(canvas);
            labelSizeChanged = true;
        }
        if (labelSizeChanged) {
            this.mGraphView.drawGraphElements(canvas);
            return;
        }
        if (!this.mIsAdjusted) {
            this.adjustSteps();
        }
        if (!this.mIsAdjusted) {
            return;
        }
        this.drawVerticalSteps(canvas);
        this.drawVerticalStepsSecondScale(canvas);
        this.drawHorizontalSteps(canvas);
        this.drawHorizontalAxisTitle(canvas);
        this.drawVerticalAxisTitle(canvas);
        if (this.mGraphView.mSecondScale != null) {
            this.mGraphView.mSecondScale.drawVerticalAxisTitle(canvas);
        }
    }

    protected void drawHorizontalAxisTitle(Canvas canvas) {
        if (this.mHorizontalAxisTitle != null && this.mHorizontalAxisTitle.length() > 0) {
            this.mPaintAxisTitle.setColor(this.getHorizontalAxisTitleColor());
            this.mPaintAxisTitle.setTextSize(this.getHorizontalAxisTitleTextSize());
            float x = canvas.getWidth() / 2;
            float y = canvas.getHeight() - this.mStyles.padding;
            canvas.drawText(this.mHorizontalAxisTitle, x, y, this.mPaintAxisTitle);
        }
    }

    protected void drawVerticalAxisTitle(Canvas canvas) {
        if (this.mVerticalAxisTitle != null && this.mVerticalAxisTitle.length() > 0) {
            this.mPaintAxisTitle.setColor(this.getVerticalAxisTitleColor());
            this.mPaintAxisTitle.setTextSize(this.getVerticalAxisTitleTextSize());
            float x = this.getVerticalAxisTitleWidth();
            float y = canvas.getHeight() / 2;
            canvas.save();
            canvas.rotate(-90.0f, x, y);
            canvas.drawText(this.mVerticalAxisTitle, x, y, this.mPaintAxisTitle);
            canvas.restore();
        }
    }

    public int getHorizontalAxisTitleHeight() {
        if (this.mHorizontalAxisTitle != null && this.mHorizontalAxisTitle.length() > 0) {
            return (int)this.getHorizontalAxisTitleTextSize();
        }
        return 0;
    }

    public int getVerticalAxisTitleWidth() {
        if (this.mVerticalAxisTitle != null && this.mVerticalAxisTitle.length() > 0) {
            return (int)this.getVerticalAxisTitleTextSize();
        }
        return 0;
    }

    protected void drawHorizontalSteps(Canvas canvas) {
        this.mPaintLabel.setColor(this.getHorizontalLabelsColor());
        int i = 0;
        for (Map.Entry<Integer, Double> e : this.mStepsHorizontal.entrySet()) {
            if (this.mStyles.highlightZeroLines) {
                if (e.getValue() == 0.0) {
                    this.mPaintLine.setStrokeWidth(5.0f);
                } else {
                    this.mPaintLine.setStrokeWidth(0.0f);
                }
            }
            if (this.mStyles.gridStyle.drawVertical() && e.getKey() <= this.mGraphView.getGraphContentWidth()) {
                canvas.drawLine((float)(this.mGraphView.getGraphContentLeft() + e.getKey()), (float)this.mGraphView.getGraphContentTop(), (float)(this.mGraphView.getGraphContentLeft() + e.getKey()), (float)(this.mGraphView.getGraphContentTop() + this.mGraphView.getGraphContentHeight()), this.mPaintLine);
            }
            if (this.isHorizontalLabelsVisible()) {
                if (this.mStyles.horizontalLabelsAngle > 0.0f && this.mStyles.horizontalLabelsAngle <= 180.0f) {
                    if (this.mStyles.horizontalLabelsAngle < 90.0f) {
                        this.mPaintLabel.setTextAlign(Paint.Align.RIGHT);
                    } else if (this.mStyles.horizontalLabelsAngle <= 180.0f) {
                        this.mPaintLabel.setTextAlign(Paint.Align.LEFT);
                    }
                } else {
                    this.mPaintLabel.setTextAlign(Paint.Align.CENTER);
                    if (i == this.mStepsHorizontal.size() - 1) {
                        this.mPaintLabel.setTextAlign(Paint.Align.RIGHT);
                    }
                    if (i == 0) {
                        this.mPaintLabel.setTextAlign(Paint.Align.LEFT);
                    }
                }
                String label = this.mLabelFormatter.formatLabel(e.getValue(), true);
                if (label == null) {
                    label = "";
                }
                String[] lines = label.split("\n");
                int labelWidthAdj = 0;
                if (this.mStyles.horizontalLabelsAngle > 0.0f && this.mStyles.horizontalLabelsAngle <= 180.0f) {
                    Rect textBounds = new Rect();
                    this.mPaintLabel.getTextBounds(lines[0], 0, lines[0].length(), textBounds);
                    labelWidthAdj = (int)Math.abs((double)textBounds.width() * Math.cos(Math.toRadians(this.mStyles.horizontalLabelsAngle)));
                }
                for (int li = 0; li < lines.length; ++li) {
                    float y = (float)(canvas.getHeight() - this.mStyles.padding - this.getHorizontalAxisTitleHeight()) - (float)(lines.length - li - 1) * this.getTextSize() * 1.1f + (float)this.mStyles.labelsSpace;
                    float x = this.mGraphView.getGraphContentLeft() + e.getKey();
                    if (this.mStyles.horizontalLabelsAngle > 0.0f && this.mStyles.horizontalLabelsAngle < 90.0f) {
                        canvas.save();
                        canvas.rotate(this.mStyles.horizontalLabelsAngle, x + (float)labelWidthAdj, y);
                        canvas.drawText(lines[li], x + (float)labelWidthAdj, y, this.mPaintLabel);
                        canvas.restore();
                        continue;
                    }
                    if (this.mStyles.horizontalLabelsAngle > 0.0f && this.mStyles.horizontalLabelsAngle <= 180.0f) {
                        canvas.save();
                        canvas.rotate(this.mStyles.horizontalLabelsAngle - 180.0f, x - (float)labelWidthAdj, y);
                        canvas.drawText(lines[li], x - (float)labelWidthAdj, y, this.mPaintLabel);
                        canvas.restore();
                        continue;
                    }
                    canvas.drawText(lines[li], x, y, this.mPaintLabel);
                }
            }
            ++i;
        }
    }

    protected void drawVerticalStepsSecondScale(Canvas canvas) {
        if (this.mGraphView.mSecondScale == null) {
            return;
        }
        float startLeft = this.mGraphView.getGraphContentLeft() + this.mGraphView.getGraphContentWidth();
        this.mPaintLabel.setColor(this.getVerticalLabelsSecondScaleColor());
        this.mPaintLabel.setTextAlign(this.getVerticalLabelsSecondScaleAlign());
        for (Map.Entry<Integer, Double> e : this.mStepsVerticalSecondScale.entrySet()) {
            float posY = this.mGraphView.getGraphContentTop() + this.mGraphView.getGraphContentHeight() - e.getKey();
            int labelsWidth = this.mLabelVerticalSecondScaleWidth;
            int labelsOffset = (int)startLeft;
            if (this.getVerticalLabelsSecondScaleAlign() == Paint.Align.RIGHT) {
                labelsOffset += labelsWidth;
            } else if (this.getVerticalLabelsSecondScaleAlign() == Paint.Align.CENTER) {
                labelsOffset += labelsWidth / 2;
            }
            float y = posY;
            String[] lines = this.mGraphView.mSecondScale.mLabelFormatter.formatLabel(e.getValue(), false).split("\n");
            y += (float)lines.length * this.getTextSize() * 1.1f / 2.0f;
            for (int li = 0; li < lines.length; ++li) {
                float y2 = y - (float)(lines.length - li - 1) * this.getTextSize() * 1.1f;
                canvas.drawText(lines[li], (float)labelsOffset, y2, this.mPaintLabel);
            }
        }
    }

    protected void drawVerticalSteps(Canvas canvas) {
        float startLeft = this.mGraphView.getGraphContentLeft();
        this.mPaintLabel.setColor(this.getVerticalLabelsColor());
        this.mPaintLabel.setTextAlign(this.getVerticalLabelsAlign());
        int numberOfLine = this.mStepsVertical.size();
        int currentLine = 1;
        for (Map.Entry<Integer, Double> e : this.mStepsVertical.entrySet()) {
            float posY = this.mGraphView.getGraphContentTop() + this.mGraphView.getGraphContentHeight() - e.getKey();
            if (this.mStyles.highlightZeroLines) {
                if (e.getValue() == 0.0) {
                    this.mPaintLine.setStrokeWidth(5.0f);
                } else {
                    this.mPaintLine.setStrokeWidth(0.0f);
                }
            }
            if (this.mStyles.gridStyle.drawHorizontal()) {
                canvas.drawLine(startLeft, posY, startLeft + (float)this.mGraphView.getGraphContentWidth(), posY, this.mPaintLine);
            }
            boolean isDrawLabel = true;
            if (this.mStyles.verticalLabelsVAlign == VerticalLabelsVAlign.ABOVE && currentLine == 1 || this.mStyles.verticalLabelsVAlign == VerticalLabelsVAlign.BELOW && currentLine == numberOfLine) {
                isDrawLabel = false;
            }
            if (this.isVerticalLabelsVisible() && isDrawLabel) {
                int labelsWidth = this.mLabelVerticalWidth;
                int labelsOffset = 0;
                if (this.getVerticalLabelsAlign() == Paint.Align.RIGHT) {
                    labelsOffset = labelsWidth;
                    labelsOffset -= this.mStyles.labelsSpace;
                } else if (this.getVerticalLabelsAlign() == Paint.Align.CENTER) {
                    labelsOffset = labelsWidth / 2;
                }
                labelsOffset += this.mStyles.padding + this.getVerticalAxisTitleWidth();
                float y = posY;
                String label = this.mLabelFormatter.formatLabel(e.getValue(), false);
                if (label == null) {
                    label = "";
                }
                String[] lines = label.split("\n");
                switch (this.mStyles.verticalLabelsVAlign) {
                    case MID: {
                        y += (float)lines.length * this.getTextSize() * 1.1f / 2.0f;
                        break;
                    }
                    case ABOVE: {
                        y -= 5.0f;
                        break;
                    }
                    case BELOW: {
                        y += (float)lines.length * this.getTextSize() * 1.1f + 5.0f;
                    }
                }
                for (int li = 0; li < lines.length; ++li) {
                    float y2 = y - (float)(lines.length - li - 1) * this.getTextSize() * 1.1f;
                    canvas.drawText(lines[li], (float)labelsOffset, y2, this.mPaintLabel);
                }
            }
            ++currentLine;
        }
    }

    protected double humanRound(double in, boolean roundAlwaysUp) {
        int ten = 0;
        while (Math.abs(in) >= 10.0) {
            in /= 10.0;
            ++ten;
        }
        while (Math.abs(in) < 1.0) {
            in *= 10.0;
            --ten;
        }
        if (roundAlwaysUp) {
            if (in != 1.0) {
                if (in <= 2.0) {
                    in = 2.0;
                } else if (in <= 5.0) {
                    in = 5.0;
                } else if (in < 10.0) {
                    in = 10.0;
                }
            }
        } else if (in != 1.0) {
            if (in <= 4.9) {
                in = 2.0;
            } else if (in <= 9.9) {
                in = 5.0;
            } else if (in < 15.0) {
                in = 10.0;
            }
        }
        return in * Math.pow(10.0, ten);
    }

    public Styles getStyles() {
        return this.mStyles;
    }

    public int getLabelVerticalWidth() {
        if (this.mStyles.verticalLabelsVAlign == VerticalLabelsVAlign.ABOVE || this.mStyles.verticalLabelsVAlign == VerticalLabelsVAlign.BELOW) {
            return 0;
        }
        return this.mLabelVerticalWidth == null || !this.isVerticalLabelsVisible() ? 0 : this.mLabelVerticalWidth;
    }

    public void setLabelVerticalWidth(Integer width) {
        this.mLabelVerticalWidth = width;
        this.mLabelVerticalWidthFixed = this.mLabelVerticalWidth != null;
    }

    public int getLabelHorizontalHeight() {
        return this.mLabelHorizontalHeight == null || !this.isHorizontalLabelsVisible() ? 0 : this.mLabelHorizontalHeight;
    }

    public void setLabelHorizontalHeight(Integer height) {
        this.mLabelHorizontalHeight = height;
        this.mLabelHorizontalHeightFixed = this.mLabelHorizontalHeight != null;
    }

    public int getGridColor() {
        return this.mStyles.gridColor;
    }

    public boolean isHighlightZeroLines() {
        return this.mStyles.highlightZeroLines;
    }

    public int getPadding() {
        return this.mStyles.padding;
    }

    public void setTextSize(float textSize) {
        this.mStyles.textSize = textSize;
        this.reloadStyles();
    }

    public void setVerticalLabelsAlign(Paint.Align verticalLabelsAlign) {
        this.mStyles.verticalLabelsAlign = verticalLabelsAlign;
    }

    public void setVerticalLabelsColor(int verticalLabelsColor) {
        this.mStyles.verticalLabelsColor = verticalLabelsColor;
    }

    public void setHorizontalLabelsColor(int horizontalLabelsColor) {
        this.mStyles.horizontalLabelsColor = horizontalLabelsColor;
    }

    public void setHorizontalLabelsAngle(int horizontalLabelsAngle) {
        this.mStyles.horizontalLabelsAngle = horizontalLabelsAngle;
    }

    public void setGridColor(int gridColor) {
        this.mStyles.gridColor = gridColor;
        this.reloadStyles();
    }

    public void setHighlightZeroLines(boolean highlightZeroLines) {
        this.mStyles.highlightZeroLines = highlightZeroLines;
    }

    public void setPadding(int padding) {
        this.mStyles.padding = padding;
    }

    public LabelFormatter getLabelFormatter() {
        return this.mLabelFormatter;
    }

    public void setLabelFormatter(LabelFormatter mLabelFormatter) {
        this.mLabelFormatter = mLabelFormatter;
        mLabelFormatter.setViewport(this.mGraphView.getViewport());
    }

    public String getHorizontalAxisTitle() {
        return this.mHorizontalAxisTitle;
    }

    public void setHorizontalAxisTitle(String mHorizontalAxisTitle) {
        this.mHorizontalAxisTitle = mHorizontalAxisTitle;
    }

    public String getVerticalAxisTitle() {
        return this.mVerticalAxisTitle;
    }

    public void setVerticalAxisTitle(String mVerticalAxisTitle) {
        this.mVerticalAxisTitle = mVerticalAxisTitle;
    }

    public float getVerticalAxisTitleTextSize() {
        return this.mStyles.verticalAxisTitleTextSize;
    }

    public void setVerticalAxisTitleTextSize(float verticalAxisTitleTextSize) {
        this.mStyles.verticalAxisTitleTextSize = verticalAxisTitleTextSize;
    }

    public int getVerticalAxisTitleColor() {
        return this.mStyles.verticalAxisTitleColor;
    }

    public void setVerticalAxisTitleColor(int verticalAxisTitleColor) {
        this.mStyles.verticalAxisTitleColor = verticalAxisTitleColor;
    }

    public float getHorizontalAxisTitleTextSize() {
        return this.mStyles.horizontalAxisTitleTextSize;
    }

    public void setHorizontalAxisTitleTextSize(float horizontalAxisTitleTextSize) {
        this.mStyles.horizontalAxisTitleTextSize = horizontalAxisTitleTextSize;
    }

    public int getHorizontalAxisTitleColor() {
        return this.mStyles.horizontalAxisTitleColor;
    }

    public void setHorizontalAxisTitleColor(int horizontalAxisTitleColor) {
        this.mStyles.horizontalAxisTitleColor = horizontalAxisTitleColor;
    }

    public Paint.Align getVerticalLabelsSecondScaleAlign() {
        return this.mStyles.verticalLabelsSecondScaleAlign;
    }

    public void setVerticalLabelsSecondScaleAlign(Paint.Align verticalLabelsSecondScaleAlign) {
        this.mStyles.verticalLabelsSecondScaleAlign = verticalLabelsSecondScaleAlign;
    }

    public int getVerticalLabelsSecondScaleColor() {
        return this.mStyles.verticalLabelsSecondScaleColor;
    }

    public void setVerticalLabelsSecondScaleColor(int verticalLabelsSecondScaleColor) {
        this.mStyles.verticalLabelsSecondScaleColor = verticalLabelsSecondScaleColor;
    }

    public int getLabelVerticalSecondScaleWidth() {
        return this.mLabelVerticalSecondScaleWidth == null ? 0 : this.mLabelVerticalSecondScaleWidth;
    }

    public boolean isHorizontalLabelsVisible() {
        return this.mStyles.horizontalLabelsVisible;
    }

    public void setHorizontalLabelsVisible(boolean horizontalTitleVisible) {
        this.mStyles.horizontalLabelsVisible = horizontalTitleVisible;
    }

    public boolean isVerticalLabelsVisible() {
        return this.mStyles.verticalLabelsVisible;
    }

    public void setVerticalLabelsVisible(boolean verticalTitleVisible) {
        this.mStyles.verticalLabelsVisible = verticalTitleVisible;
    }

    public int getNumVerticalLabels() {
        return this.mNumVerticalLabels;
    }

    public void setNumVerticalLabels(int mNumVerticalLabels) {
        this.mNumVerticalLabels = mNumVerticalLabels;
    }

    public int getNumHorizontalLabels() {
        return this.mNumHorizontalLabels;
    }

    public void setNumHorizontalLabels(int mNumHorizontalLabels) {
        this.mNumHorizontalLabels = mNumHorizontalLabels;
    }

    public GridStyle getGridStyle() {
        return this.mStyles.gridStyle;
    }

    public void setGridStyle(GridStyle gridStyle) {
        this.mStyles.gridStyle = gridStyle;
    }

    public int getLabelsSpace() {
        return this.mStyles.labelsSpace;
    }

    public void setLabelsSpace(int labelsSpace) {
        this.mStyles.labelsSpace = labelsSpace;
    }

    public void setVerticalLabelsVAlign(VerticalLabelsVAlign align) {
        this.mStyles.verticalLabelsVAlign = align;
    }

    public VerticalLabelsVAlign getVerticalLabelsVAlign() {
        return this.mStyles.verticalLabelsVAlign;
    }

    public static enum GridStyle {
        BOTH,
        VERTICAL,
        HORIZONTAL,
        NONE;


        public boolean drawVertical() {
            return this == BOTH || this == VERTICAL && this != NONE;
        }

        public boolean drawHorizontal() {
            return this == BOTH || this == HORIZONTAL && this != NONE;
        }
    }

    public final class Styles {
        public float textSize;
        public Paint.Align verticalLabelsAlign;
        public Paint.Align verticalLabelsSecondScaleAlign;
        public int verticalLabelsColor;
        public int verticalLabelsSecondScaleColor;
        public int horizontalLabelsColor;
        public int gridColor;
        public boolean highlightZeroLines;
        public int padding;
        public float verticalAxisTitleTextSize;
        public int verticalAxisTitleColor;
        public float horizontalAxisTitleTextSize;
        public int horizontalAxisTitleColor;
        public float horizontalLabelsAngle;
        boolean horizontalLabelsVisible;
        boolean verticalLabelsVisible;
        GridStyle gridStyle;
        int labelsSpace;
        VerticalLabelsVAlign verticalLabelsVAlign = VerticalLabelsVAlign.MID;
    }

    public static enum VerticalLabelsVAlign {
        ABOVE,
        MID,
        BELOW;

    }
}

