/*
 * Decompiled with CFR 0.152.
 */
package com.jjoe64.graphview.series;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.series.BaseSeries;
import com.jjoe64.graphview.series.DataPointInterface;
import java.util.Iterator;

public class PointsGraphSeries<E extends DataPointInterface>
extends BaseSeries<E> {
    private Styles mStyles;
    private Paint mPaint;
    private CustomShape mCustomShape;

    public PointsGraphSeries() {
        this.init();
    }

    public PointsGraphSeries(E[] data) {
        super(data);
        this.init();
    }

    protected void init() {
        this.mStyles = new Styles();
        this.mStyles.size = 20.0f;
        this.mPaint = new Paint();
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.setShape(Shape.POINT);
    }

    @Override
    public void draw(GraphView graphView, Canvas canvas, boolean isSecondScale) {
        double minY;
        double maxY;
        this.resetDataPoints();
        double maxX = graphView.getViewport().getMaxX(false);
        double minX = graphView.getViewport().getMinX(false);
        if (isSecondScale) {
            maxY = graphView.getSecondScale().getMaxY();
            minY = graphView.getSecondScale().getMinY();
        } else {
            maxY = graphView.getViewport().getMaxY(false);
            minY = graphView.getViewport().getMinY(false);
        }
        Iterator values = this.getValues(minX, maxX);
        double lastEndY = 0.0;
        double lastEndX = 0.0;
        this.mPaint.setColor(this.getColor());
        double diffY = maxY - minY;
        double diffX = maxX - minX;
        float graphHeight = graphView.getGraphContentHeight();
        float graphWidth = graphView.getGraphContentWidth();
        float graphLeft = graphView.getGraphContentLeft();
        float graphTop = graphView.getGraphContentTop();
        lastEndY = 0.0;
        lastEndX = 0.0;
        float firstX = 0.0f;
        int i = 0;
        while (values.hasNext()) {
            double x;
            DataPointInterface value = (DataPointInterface)values.next();
            double valY = value.getY() - minY;
            double ratY = valY / diffY;
            double y = (double)graphHeight * ratY;
            double valX = value.getX() - minX;
            double ratX = valX / diffX;
            double orgX = x = (double)graphWidth * ratX;
            double orgY = y;
            boolean overdraw = false;
            if (x > (double)graphWidth) {
                overdraw = true;
            }
            if (y < 0.0) {
                overdraw = true;
            }
            if (y > (double)graphHeight) {
                overdraw = true;
            }
            float endX = (float)x + (graphLeft + 1.0f);
            float endY = (float)((double)graphTop - y) + graphHeight;
            this.registerDataPoint(endX, endY, value);
            if (!overdraw) {
                if (this.mCustomShape != null) {
                    this.mCustomShape.draw(canvas, this.mPaint, endX, endY);
                } else if (this.mStyles.shape == Shape.POINT) {
                    canvas.drawCircle(endX, endY, this.mStyles.size, this.mPaint);
                } else if (this.mStyles.shape == Shape.RECTANGLE) {
                    canvas.drawRect(endX - this.mStyles.size, endY - this.mStyles.size, endX + this.mStyles.size, endY + this.mStyles.size, this.mPaint);
                } else if (this.mStyles.shape == Shape.TRIANGLE) {
                    Point[] points = new Point[]{new Point((int)endX, (int)(endY - this.getSize())), new Point((int)(endX + this.getSize()), (int)((double)endY + (double)this.getSize() * 0.67)), new Point((int)(endX - this.getSize()), (int)((double)endY + (double)this.getSize() * 0.67))};
                    this.drawArrows(points, canvas, this.mPaint);
                }
            }
            ++i;
        }
    }

    private void drawArrows(Point[] point, Canvas canvas, Paint paint) {
        float[] points = new float[]{point[0].x, point[0].y, point[1].x, point[1].y, point[2].x, point[2].y, point[0].x, point[0].y};
        canvas.drawVertices(Canvas.VertexMode.TRIANGLES, 8, points, 0, null, 0, null, 0, null, 0, 0, paint);
        Path path = new Path();
        path.moveTo((float)point[0].x, (float)point[0].y);
        path.lineTo((float)point[1].x, (float)point[1].y);
        path.lineTo((float)point[2].x, (float)point[2].y);
        canvas.drawPath(path, paint);
    }

    public float getSize() {
        return this.mStyles.size;
    }

    public void setSize(float radius) {
        this.mStyles.size = radius;
    }

    public Shape getShape() {
        return this.mStyles.shape;
    }

    public void setShape(Shape s) {
        this.mStyles.shape = s;
    }

    public void setCustomShape(CustomShape shape) {
        this.mCustomShape = shape;
    }

    private final class Styles {
        float size;
        Shape shape;

        private Styles() {
        }
    }

    public static enum Shape {
        POINT,
        TRIANGLE,
        RECTANGLE;

    }

    public static interface CustomShape {
        public void draw(Canvas var1, Paint var2, float var3, float var4);
    }
}

