from config import DebugConfig
from flask import Flask
from flask_migrate import Migrate
from importlib import import_module
from logging import basicConfig, DEBUG, getLogger, StreamHandler
from os.path import abspath, dirname, join, pardir
import sys
from flask import jsonify, render_template, request, json

# added imports 
from datetime import time

# prevent python from writing *.pyc files / __pycache__ folders
sys.dont_write_bytecode = True

path_source = dirname(abspath(__file__))
path_parent = abspath(join(path_source, pardir))
if path_source not in sys.path:
    sys.path.append(path_source)

from database import db, create_database
from base.routes import login_manager


def register_extensions(app):
    db.init_app(app)
    login_manager.init_app(app)


def register_blueprints(app):
    for module_name in ('forms', 'ui', 'home', 'tables', 'data', 'additional', 'base'):
        module = import_module('{}.routes'.format(module_name))
        app.register_blueprint(module.blueprint)


def configure_login_manager(app, User):
    @login_manager.user_loader
    def user_loader(id):
        return db.session.query(User).filter_by(id=id).first()

    @login_manager.request_loader
    def request_loader(request):
        username = request.form.get('username')
        user = db.session.query(User).filter_by(username=username).first()
        return user if user else None


def configure_database(app):
    create_database()
    Migrate(app, db)

    @app.teardown_request
    def shutdown_session(exception=None):
        db.session.remove()


def configure_logs(app):
    basicConfig(filename='error.log', level=DEBUG)
    logger = getLogger()
    logger.addHandler(StreamHandler())


def create_app(selenium=False):
    app = Flask(__name__, static_folder='base/static')
    app.config.from_object(DebugConfig)
    if selenium:
        app.config['LOGIN_DISABLED'] = True
    register_extensions(app)
    register_blueprints(app)
    from base.models import User
    configure_login_manager(app, User)
    configure_database(app)
    configure_logs(app)
    return app




app = create_app()
#############################################################################

import numpy as np
import pandas as pd


cols = ['Date', 'Sensor_Glucose','Bolus','BG-Calib','Heart-Rate', 'Metabolic','Calories-Out', 'Step-Count',\
        'CalOut_OutOfRange','CalOut_FatBurn','CalOut_Cardio','CalOut_Peak','Minutes_OutOfRange','Minutes_FatBurn',\
        'Minutes_Cardio','Minutes_Peak','max_OutOfRange','max_FatBurn','max_Cardio','max_Peak','min_OutOfRange',\
        'min_FatBurn','min_Cardio','min_Peak','ActivDist_Total','tracker','loggedActivities','veryActive','moderatelyActive',\
        'lightlyActivity','sedentaryActive',\
        'AwakeCount', 'AwakeDuration', 'AwakeningsCount', 'Duration','Efficiency',\
        'IsMainSleep', 'MinutesAfterWakeUp', 'MinutesAsleep','MinutesAwake',\
        'MinutesToFallAsleep', 'RestlessCount','RestlessDuration', 'TimeInBed',\
        'BMI', 'Weight','Fat']


def correcting_year_datetime(string_timestamp):
    timestamp = [datetime.strptime(date, '%Y-%m-%d').date() for date in string_timestamp]

    new_dates_list = []
    for item in timestamp:
        month = '{:%m}'.format(item)
        day = '{:%d}'.format(item)
        year = '{:%Y}'.format(item)
        dates = date(int(year)-1, int(month), int(day))
        new_dates_list.append(dates)
    return new_dates_list



import os, sys


# directory =  "/home/cowboyuniverse/Workspace/LearningJournal/SeniorDesign/github/Proj/Insight_Engine/csv/original-csv-files/"
directory = "/home/medtronic/CSV_DATA/all_patient_daily_avg_total_df/"
total_df = pd.DataFrame()
mean_df = pd.DataFrame()

for filename in os.listdir(directory):
    if filename.endswith(".csv"): 
#         print(os.path.join(directory, filename))

        patient_id = filename.split('.')[0]
#         print(patient_id)
        csv_df = pd.read_csv(os.path.join(directory, filename))
        csv_df = csv_df.drop('Unnamed: 0', 1)
        csv_df['Patient_id'] = patient_id
        mean_list = csv_df.mean()

        total_df = total_df.append(csv_df)
        
#         mean_list= csv_df.sum()
        mean_one_patient = pd.DataFrame()
        mean_one_patient= mean_list.to_frame(name=None)
        mean_one_patient = mean_one_patient.transpose()
        mean_one_patient['Patient_id'] = patient_id
        mean_df = mean_df.append(mean_one_patient) 

    else:
        continue

df_new = pd.DataFrame()
df_new = mean_df.loc[mean_df['Patient_id'] == '1']
df_new
    

new_weight = df_new['Weight'].mean()
new_duration = df_new['Duration'].mean()
new_max_cardio = df_new['max_Cardio'].mean()
new_min_fatBurn = df_new['Minutes_FatBurn'].mean()
new_sg = df_new['Sensor_Glucose'].mean()

weight = mean_df['Weight'].mean()
duration = mean_df['Duration'].mean()
max_cardio = mean_df['max_Cardio'].mean()
min_fatBurn = mean_df['Minutes_FatBurn'].mean()
sg = mean_df['Sensor_Glucose'].mean()


new_weight = df_new['Weight'].mean()
new_duration = df_new['Duration'].mean()
new_max_cardio = df_new['max_Cardio'].mean()
new_min_fatBurn = df_new['Minutes_FatBurn'].mean()
new_sg = df_new['Sensor_Glucose'].mean()

weight = mean_df['Weight'].mean()
duration = mean_df['Duration'].mean()
max_cardio = mean_df['max_Cardio'].mean()
min_fatBurn = mean_df['Minutes_FatBurn'].mean()
sg = mean_df['Sensor_Glucose'].mean()


from random import sample


@app.route('/signUpUser', methods=['POST'])
def signUpUser():
    user =  request.form['username'];
    password = request.form['password'];
    return json.dumps({'status':'OK','user':user,'pass':password});



@app.route('/_add_numbers')
def add_numbers():
    a = request.args.get('a', 0, type=int)
    b = request.args.get('b', 0, type=int)
    return jsonify(result=a + b)


new_fiber= df_new['fiber'].mean()
new_lipids = df_new['lipids'].mean()
new_sugars= df_new['sugars'].mean()
new_Carb = df_new['Carb'].mean()
new_Saturatedfattyacids= df_new['Saturatedfattyacids'].mean()

fiber = mean_df['fiber'].mean()
lipids = mean_df['lipids'].mean()
sugars = mean_df['sugars'].mean()
Carb = mean_df['Carb'].mean()
Saturatedfattyacids = mean_df['Saturatedfattyacids'].mean()

@app.route('/dashboard')
def dashboard():
    radar_labels1=['Weight','Duration','max_Cardio','Minutes_FatBurn','Sensor_Glucose']
    radar_value1=[new_weight,new_duration ,new_max_cardio,new_min_fatBurn,new_sg]
    radar_value2=[weight,duration ,max_cardio,min_fatBurn,sg_mean]

    radar_labels2=["fiber","lipids ","sugars","Carb","Saturatedfattyacids"]
    radar2_value1=[new_fiber,new_lipids ,new_sugars,new_Carb,new_Saturatedfattyacids]
    radar2_value2=[fiber,lipids ,sugars,Carb,Saturatedfattyacids]
    return render_template('dashboard.html', radar_labels1 = radar_labels1, radar_labels2 = radar_labels2, radar2_value1=radar2_value1, radar2_value2=radar2_value2,radar_value1=radar_value1, radar_value2=radar_value2, radar_labels=radar_labels)



@app.route('/radar2')
def radar2():
#     radar_labels=["Step-Count","Calories-Out","AwakeDuration","Heart-Rate","Sensor_Glucose"]
    radar_labels=["fiber","lipids ","sugars","Carb","Saturatedfattyacids"]
    radar_value1=[new_fiber,new_lipids ,new_sugars,new_Carb,new_Saturatedfattyacids]
    radar_value2=[fiber,lipids ,sugars,Carb,Saturatedfattyacids]

    return render_template("index6.html",value1=radar_value1,value2=radar_value2,labels=radar_labels)


# ///////////////////////////////////////////////////////////////////


if __name__ == '__main__':
    app.run(host='167.114.135.209', port=8080, threaded=True)

