// Generated by CoffeeScript 1.8.0
var DEBUG, ES, baseStream;

ES = require('event-stream');

baseStream = require('stream');

DEBUG = process.env.NODE_ENV === 'development';


/*
 * Taps into the pipeline and allows user to easily route data through
 * another stream or change content.
 */

module.exports = function(lambda) {
  var cache, id, modifyFile, utils;
  id = 1;
  cache = {};
  utils = function(tapStream, file) {
    return {

      /*
       * Routes through another stream. The filter must not be
       * created. This will create the filter as needed and
       * cache when it can.
       *
       * @param filter {stream}
       * @param args {Array} Array containg arguments to apply to filter.
       *
       * @example
       *   t.through coffee, [{bare: true}]
       */
      through: function(filter, args) {
        var stream;
        if (filter.__tapId) {
          stream = cache[filter.__tapId];
          if (!stream) {
            cache[filter.__tapId] = null;
          }
        }
        if (stream) {

        } else {
          if (DEBUG) {
            if (!Array.isArray(args)) {
              throw new Error("Args must be an array to `apply` to the filter");
            }
          }
          stream = filter.apply(null, args);
          stream.on("error", function(err) {
            return tapStream.emit("error", err);
          });
          filter.__tapId = "" + id;
          cache[filter.__tapId] = stream;
          id += 1;
          stream.pipe(tapStream);
        }
        stream.write(file);
        return stream;
      }
    };
  };
  modifyFile = function(file) {
    var inst, obj;
    inst = {
      file: file
    };
    obj = lambda(inst.file, utils(this, inst.file), inst);
    if (!(obj instanceof baseStream)) {
      return this.emit('data', inst.file);
    }
  };
  return ES.through(modifyFile);
};

//# sourceMappingURL=tap.js.map
