/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function n(e){return e+" is required, actual value was undefined"}function r(e,t,n){return"Expected "+n+" to be typeof "+t+", actual typeof was "+e}var i={};return i.typeOf={},i.defined=function(r,i){if(!e(i))throw new t(n(r))},i.typeOf.func=function(e,n){if("function"!=typeof n)throw new t(r(typeof n,"function",e))},i.typeOf.string=function(e,n){if("string"!=typeof n)throw new t(r(typeof n,"string",e))},i.typeOf.number=function(e,n){if("number"!=typeof n)throw new t(r(typeof n,"number",e))},i.typeOf.number.lessThan=function(e,n,r){if(i.typeOf.number(e,n),n>=r)throw new t("Expected "+e+" to be less than "+r+", actual value was "+n)},i.typeOf.number.lessThanOrEquals=function(e,n,r){if(i.typeOf.number(e,n),n>r)throw new t("Expected "+e+" to be less than or equal to "+r+", actual value was "+n)},i.typeOf.number.greaterThan=function(e,n,r){if(i.typeOf.number(e,n),n<=r)throw new t("Expected "+e+" to be greater than "+r+", actual value was "+n)},i.typeOf.number.greaterThanOrEquals=function(e,n,r){if(i.typeOf.number(e,n),n<r)throw new t("Expected "+e+" to be greater than or equal to"+r+", actual value was "+n)},i.typeOf.object=function(e,n){if("object"!=typeof n)throw new t(r(typeof n,"object",e))},i.typeOf.bool=function(e,n){if("boolean"!=typeof n)throw new t(r(typeof n,"boolean",e))},i}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^t[1&e];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:e<0?-1:0},i.signNotZero=function(e){return e<0?-1:1},i.toSNorm=function(e,n){return n=t(n,255),Math.round((.5*i.clamp(e,-1,1)+.5)*n)},i.fromSNorm=function(e,n){return n=t(n,255),i.clamp(e,0,n)/n*2-1},i.sinh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t-n)},i.cosh=function(e){var t=Math.pow(Math.E,e),n=Math.pow(Math.E,-1*e);return.5*(t+n)},i.lerp=function(e,t,n){return(1-n)*e+n*t},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){var t=i.TWO_PI,n=e-Math.floor(e/t)*t;return n<-Math.PI?n+t:n>=Math.PI?n-t:n},i.clampToLatitudeRange=function(e){return i.clamp(e,-1*i.PI_OVER_TWO,i.PI_OVER_TWO)},i.negativePiToPi=function(e){return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){var t=i.mod(e,i.TWO_PI);return Math.abs(t)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:t},i.mod=function(e,t){return(e%t+t)%t},i.equalsEpsilon=function(e,n,r,i){i=t(i,r);var a=Math.abs(e-n);return a<=i||a<=r*Math.max(Math.abs(e),Math.abs(n))};var a=[1];i.factorial=function(e){var t=a.length;if(e>=t)for(var n=a[t-1],r=t;r<=e;r++)a.push(n*r);return a[e]},i.incrementWrap=function(e,n,r){return r=t(r,0),++e,e>n&&(e=r),e},i.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,t,n){return e<t?t:e>n?n:e};var o=new e;return i.setRandomNumberSeed=function(t){o=new e(t)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},i.logBase=function(e,t){return Math.log(e)/Math.log(t)},i.fog=function(e,t){var n=e*t;return 1-Math.exp(-(n*n))},i}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i,a){"use strict";function o(e,n,r){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0)}o.fromSpherical=function(e,r){n(r)||(r=new o);var i=e.clock,a=e.cone,u=t(e.magnitude,1),s=u*Math.sin(a);return r.x=s*Math.cos(i),r.y=s*Math.sin(i),r.z=u*Math.cos(a),r},o.fromElements=function(e,t,r,i){return n(i)?(i.x=e,i.y=t,i.z=r,i):new o(e,t,r)},o.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z)},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(e,n,r){return r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r]=e.z,n},o.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new o),i.x=e[r++],i.y=e[r++],i.z=e[r],i},o.packArray=function(e,t){var r=e.length;n(t)?t.length=3*r:t=new Array(3*r);for(var i=0;i<r;++i)o.pack(e[i],t,3*i);return t},o.unpackArray=function(e,t){var r=e.length;n(t)?t.length=r/3:t=new Array(r/3);for(var i=0;i<r;i+=3){var a=i/3;t[a]=o.unpack(e,i,t[a])}return t},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n},o.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(e,t){var n=o.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},o.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n},o.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n.z=e.z/t.z,n},o.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n},o.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n},o.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n},o.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var s=new o;o.lerp=function(e,t,n,r){return o.multiplyByScalar(t,n,s),r=o.multiplyByScalar(e,1-n,r),o.add(s,r,r)};var c=new o,l=new o;o.angleBetween=function(e,t){o.normalize(e,c),o.normalize(t,l);var n=o.dot(c,l),r=o.magnitude(o.cross(c,l,c));return Math.atan2(r,n)};var f=new o;o.mostOrthogonalAxis=function(e,t){var n=o.normalize(e,f);return o.abs(n,n),t=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,t):o.clone(o.UNIT_Z,t):n.y<=n.z?o.clone(o.UNIT_Y,t):o.clone(o.UNIT_Z,t)},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]},o.equalsEpsilon=function(e,t,r,i){return e===t||n(e)&&n(t)&&a.equalsEpsilon(e.x,t.x,r,i)&&a.equalsEpsilon(e.y,t.y,r,i)&&a.equalsEpsilon(e.z,t.z,r,i)},o.cross=function(e,t,n){var r=e.x,i=e.y,a=e.z,o=t.x,u=t.y,s=t.z,c=i*s-a*u,l=a*o-r*s,f=r*u-i*o;return n.x=c,n.y=l,n.z=f,n},o.fromDegrees=function(e,t,n,r,i){return e=a.toRadians(e),t=a.toRadians(t),o.fromRadians(e,t,n,r,i)};var h=new o,d=new o,p=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(e,r,i,a,u){i=t(i,0);var s=n(a)?a.radiiSquared:p,c=Math.cos(r);h.x=c*Math.cos(e),h.y=c*Math.sin(e),h.z=Math.sin(r),h=o.normalize(h,h),o.multiplyComponents(s,h,d);var l=Math.sqrt(o.dot(h,d));return d=o.divideByScalar(d,l,d),h=o.multiplyByScalar(h,i,h),n(u)||(u=new o),o.add(d,h,u)},o.fromDegreesArray=function(e,t,r){var i=e.length;n(r)?r.length=i/2:r=new Array(i/2);for(var a=0;a<i;a+=2){var u=e[a],s=e[a+1],c=a/2;r[c]=o.fromDegrees(u,s,0,t,r[c])}return r},o.fromRadiansArray=function(e,t,r){var i=e.length;n(r)?r.length=i/2:r=new Array(i/2);for(var a=0;a<i;a+=2){var u=e[a],s=e[a+1],c=a/2;r[c]=o.fromRadians(u,s,0,t,r[c])}return r},o.fromDegreesArrayHeights=function(e,t,r){var i=e.length;n(r)?r.length=i/3:r=new Array(i/3);for(var a=0;a<i;a+=3){var u=e[a],s=e[a+1],c=e[a+2],l=a/3;r[l]=o.fromDegrees(u,s,c,t,r[l])}return r},o.fromRadiansArrayHeights=function(e,t,r){var i=e.length;n(r)?r.length=i/3:r=new Array(i/3);for(var a=0;a<i;a+=3){var u=e[a],s=e[a+1],c=e[a+2],l=a/3;r[l]=o.fromRadians(u,s,c,t,r[l])}return r},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,n){return o.equalsEpsilon(this,e,t,n)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,n,r){"use strict";function i(n,i,u,s,c){var l=n.x,f=n.y,h=n.z,d=i.x,p=i.y,y=i.z,E=l*l*d*d,m=f*f*p*p,_=h*h*y*y,v=E+m+_,T=Math.sqrt(1/v),R=e.multiplyByScalar(n,T,a);if(v<s)return isFinite(T)?e.clone(R,c):void 0;var g=u.x,A=u.y,S=u.z,N=o;N.x=R.x*g*2,N.y=R.y*A*2,N.z=R.z*S*2;var x,I,O,w,M,C,P,D,L,U,b,F=(1-T)*e.magnitude(n)/(.5*e.magnitude(N)),z=0;do{F-=z,O=1/(1+F*g),w=1/(1+F*A),M=1/(1+F*S),C=O*O,P=w*w,D=M*M,L=C*O,U=P*w,b=D*M,x=E*C+m*P+_*D-1,I=E*L*g+m*U*A+_*b*S;var B=-2*I;z=x/B}while(Math.abs(x)>r.EPSILON12);return t(c)?(c.x=l*O,c.y=f*w,c.z=h*M,c):new e(l*O,f*w,h*M)}var a=new e,o=new e;return i}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,i,a,o){"use strict";function u(e,n,r){this.longitude=t(e,0),this.latitude=t(n,0),this.height=t(r,0)}u.fromRadians=function(e,r,i,a){return i=t(i,0),n(a)?(a.longitude=e,a.latitude=r,a.height=i,a):new u(e,r,i)},u.fromDegrees=function(e,t,n,r){return e=a.toRadians(e),t=a.toRadians(t),u.fromRadians(e,t,n,r)};var s=new e,c=new e,l=new e,f=new e(1/6378137,1/6378137,1/6356752.314245179),h=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),d=a.EPSILON1;return u.fromCartesian=function(t,r,i){var p=n(r)?r.oneOverRadii:f,y=n(r)?r.oneOverRadiiSquared:h,E=n(r)?r._centerToleranceSquared:d,m=o(t,p,y,E,c);if(n(m)){var _=e.multiplyComponents(m,y,s);_=e.normalize(_,_);var v=e.subtract(t,m,l),T=Math.atan2(_.y,_.x),R=Math.asin(_.z),g=a.sign(e.dot(v,t))*e.magnitude(v);return n(i)?(i.longitude=T,i.latitude=R,i.height=g,i):new u(T,R,g)}},u.clone=function(e,t){if(n(e))return n(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||n(e)&&n(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e.longitude-t.longitude)<=r&&Math.abs(e.latitude-t.latitude)<=r&&Math.abs(e.height-t.height)<=r},u.ZERO=i(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),n=Object.defineProperties;return t&&e(n)||(n=function(e){return e}),n}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,n,r,i,a,o,u,s){"use strict";function c(t,r,i,a){r=n(r,0),i=n(i,0),a=n(a,0),t._radii=new e(r,i,a),t._radiiSquared=new e(r*r,i*i,a*a),t._radiiToTheFourth=new e(r*r*r*r,i*i*i*i,a*a*a*a),t._oneOverRadii=new e(0===r?0:1/r,0===i?0:1/i,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===r?0:1/(r*r),0===i?0:1/(i*i),0===a?0:1/(a*a)),t._minimumRadius=Math.min(r,i,a),t._maximumRadius=Math.max(r,i,a),t._centerToleranceSquared=u.EPSILON1,0!==t._radiiSquared.z&&(t._sqauredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._sqauredXOverSquaredZ=void 0,c(this,e,t,n)}i(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,n){if(r(t)){var i=t._radii;return r(n)?(e.clone(i,n._radii),e.clone(t._radiiSquared,n._radiiSquared),e.clone(t._radiiToTheFourth,n._radiiToTheFourth),e.clone(t._oneOverRadii,n._oneOverRadii),e.clone(t._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=t._minimumRadius,n._maximumRadius=t._maximumRadius,n._centerToleranceSquared=t._centerToleranceSquared,n):new l(i.x,i.y,i.z)}},l.fromCartesian3=function(e,t){return r(t)||(t=new l),r(e)?(c(t,e.x,e.y,e.z),t):t},l.WGS84=o(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=o(new l(1,1,1)),l.MOON=o(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,r,i){return i=n(i,0),e.pack(t._radii,r,i),r},l.unpack=function(t,r,i){r=n(r,0);var a=e.unpack(t,r);return l.fromCartesian3(a,i)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,n){var i=t.longitude,a=t.latitude,o=Math.cos(a),u=o*Math.cos(i),s=o*Math.sin(i),c=Math.sin(a);return r(n)||(n=new e),n.x=u,n.y=s,n.z=c,e.normalize(n,n)},l.prototype.geodeticSurfaceNormal=function(t,n){return r(n)||(n=new e),n=e.multiplyComponents(t,this._oneOverRadiiSquared,n),e.normalize(n,n)};var f=new e,h=new e;l.prototype.cartographicToCartesian=function(t,n){var i=f,a=h;this.geodeticSurfaceNormalCartographic(t,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,t.height,i),r(n)||(n=new e),e.add(a,i,n)},l.prototype.cartographicArrayToCartesianArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var i=0;i<n;i++)t[i]=this.cartographicToCartesian(e[i],t[i]);return t};var d=new e,p=new e,y=new e;return l.prototype.cartesianToCartographic=function(n,i){var a=this.scaleToGeodeticSurface(n,p);if(r(a)){var o=this.geodeticSurfaceNormal(a,d),s=e.subtract(n,a,y),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),f=u.sign(e.dot(s,n))*e.magnitude(s);return r(i)?(i.longitude=c,i.latitude=l,i.height=f,i):new t(c,l,f)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){var n=e.length;r(t)?t.length=n:t=new Array(n);for(var i=0;i<n;++i)t[i]=this.cartesianToCartographic(e[i],t[i]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return s(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,n){r(n)||(n=new e);var i=t.x,a=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(i*i*u.x+a*a*u.y+o*o*u.z);return e.multiplyByScalar(t,s,n)},l.prototype.transformPositionToScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._oneOverRadii,n)},l.prototype.transformPositionFromScaledSpace=function(t,n){return r(n)||(n=new e),e.multiplyComponents(t,this._radii,n)},l.prototype.equals=function(t){return this===t||r(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,i,a){i=n(i,0);var o=this._sqauredXOverSquaredZ;if(r(a)||(a=new e),a.x=0,a.y=0,a.z=t.z*(1-o),!(Math.abs(a.z)>=this._radii.z-i))return a},l}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i,a){"use strict";function o(e,n){this.x=t(e,0),this.y=t(n,0)}o.fromElements=function(e,t,r){return n(r)?(r.x=e,r.y=t,r):new o(e,t)},o.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y)},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(e,n,r){return r=t(r,0),n[r++]=e.x,n[r]=e.y,n},o.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new o),i.x=e[r++],i.y=e[r],i},o.packArray=function(e,t){var r=e.length;n(t)?t.length=2*r:t=new Array(2*r);for(var i=0;i<r;++i)o.pack(e[i],t,2*i);return t},o.unpackArray=function(e,t){var r=e.length;n(t)?t.length=r/2:t=new Array(r/2);for(var i=0;i<r;i+=2){var a=i/2;t[a]=o.unpack(e,i,t[a])}return t},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y)},o.minimumComponent=function(e){return Math.min(e.x,e.y)},o.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n},o.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(e,t){var n=o.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y},o.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n},o.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n},o.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n},o.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n},o.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n},o.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var s=new o;o.lerp=function(e,t,n,r){return o.multiplyByScalar(t,n,s),r=o.multiplyByScalar(e,1-n,r),o.add(s,r,r)};var c=new o,l=new o;o.angleBetween=function(e,t){return o.normalize(e,c),o.normalize(t,l),a.acosClamped(o.dot(c,l))};var f=new o;return o.mostOrthogonalAxis=function(e,t){var n=o.normalize(e,f);return o.abs(n,n),t=n.x<=n.y?o.clone(o.UNIT_X,t):o.clone(o.UNIT_Y,t)},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]},o.equalsEpsilon=function(e,t,r,i){return e===t||n(e)&&n(t)&&a.equalsEpsilon(e.x,t.x,r,i)&&a.equalsEpsilon(e.y,t.y,r,i)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,n){return o.equalsEpsilon(this,e,t,n)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,n,r,i,a,o){"use strict";function u(e){this._ellipsoid=n(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,n){var i=this._semimajorAxis,a=t.longitude*i,o=t.latitude*i,u=t.height;return r(n)?(n.x=a,n.y=o,n.z=u,n):new e(a,o,u)},u.prototype.unproject=function(e,n){var i=this._oneOverSemimajorAxis,a=e.x*i,o=e.y*i,u=e.z;return r(n)?(n.longitude=a,n.latitude=o,n.height=u,n):new t(a,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,n,r,i,a,o,u,s){"use strict";function c(e,t,r,i){this.west=n(e,0),this.south=n(t,0),this.east=n(r,0),this.north=n(i,0)}i(c.prototype,{width:{get:function(){return c.computeWidth(this)}},height:{get:function(){return c.computeHeight(this)}}}),c.packedLength=4,c.pack=function(e,t,r){return r=n(r,0),t[r++]=e.west,t[r++]=e.south,t[r++]=e.east,t[r]=e.north,t},c.unpack=function(e,t,i){return t=n(t,0),r(i)||(i=new c),i.west=e[t++],i.south=e[t++],i.east=e[t++],i.north=e[t],i},c.computeWidth=function(e){var t=e.east,n=e.west;return t<n&&(t+=s.TWO_PI),t-n},c.computeHeight=function(e){return e.north-e.south},c.fromDegrees=function(e,t,i,a,o){return e=s.toRadians(n(e,0)),t=s.toRadians(n(t,0)),i=s.toRadians(n(i,0)),a=s.toRadians(n(a,0)),r(o)?(o.west=e,o.south=t,o.east=i,o.north=a,o):new c(e,t,i,a)},c.fromRadians=function(e,t,i,a,o){return r(o)?(o.west=n(e,0),o.south=n(t,0),o.east=n(i,0),o.north=n(a,0),o):new c(e,t,i,a)},c.fromCartographicArray=function(e,t){for(var n=Number.MAX_VALUE,i=-Number.MAX_VALUE,a=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=Number.MAX_VALUE,l=-Number.MAX_VALUE,f=0,h=e.length;f<h;f++){var d=e[f];n=Math.min(n,d.longitude),i=Math.max(i,d.longitude),u=Math.min(u,d.latitude),l=Math.max(l,d.latitude);var p=d.longitude>=0?d.longitude:d.longitude+s.TWO_PI;a=Math.min(a,p),o=Math.max(o,p)}return i-n>o-a&&(n=a,i=o,i>s.PI&&(i-=s.TWO_PI),n>s.PI&&(n-=s.TWO_PI)),r(t)?(t.west=n,t.south=u,t.east=i,t.north=l,t):new c(n,u,i,l)},c.fromCartesianArray=function(e,t,n){for(var i=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,u=-Number.MAX_VALUE,l=Number.MAX_VALUE,f=-Number.MAX_VALUE,h=0,d=e.length;h<d;h++){var p=t.cartesianToCartographic(e[h]);i=Math.min(i,p.longitude),a=Math.max(a,p.longitude),l=Math.min(l,p.latitude),f=Math.max(f,p.latitude);var y=p.longitude>=0?p.longitude:p.longitude+s.TWO_PI;o=Math.min(o,y),u=Math.max(u,y)}return a-i>u-o&&(i=o,a=u,a>s.PI&&(a-=s.TWO_PI),i>s.PI&&(i-=s.TWO_PI)),r(n)?(n.west=i,n.south=l,n.east=a,n.north=f,n):new c(i,l,a,f)},c.clone=function(e,t){if(r(e))return r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new c(e.west,e.south,e.east,e.north)},c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},c.prototype.equalsEpsilon=function(e,t){return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},c.validate=function(e){},c.southwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.south,n.height=0,n):new e(t.west,t.south)},c.northwest=function(t,n){return r(n)?(n.longitude=t.west,n.latitude=t.north,n.height=0,n):new e(t.west,t.north)},c.northeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.north,n.height=0,n):new e(t.east,t.north)},c.southeast=function(t,n){return r(n)?(n.longitude=t.east,n.latitude=t.south,n.height=0,n):new e(t.east,t.south)},c.center=function(t,n){var i=t.east,a=t.west;i<a&&(i+=s.TWO_PI);var o=s.negativePiToPi(.5*(a+i)),u=.5*(t.south+t.north);return r(n)?(n.longitude=o,n.latitude=u,n.height=0,n):new e(o,u)},c.intersection=function(e,t,n){var i=e.east,a=e.west,o=t.east,u=t.west;i<a&&o>0?i+=s.TWO_PI:o<u&&i>0&&(o+=s.TWO_PI),i<a&&u<0?u+=s.TWO_PI:o<u&&a<0&&(a+=s.TWO_PI);var l=s.negativePiToPi(Math.max(a,u)),f=s.negativePiToPi(Math.min(i,o));if(!((e.west<e.east||t.west<t.east)&&f<=l)){var h=Math.max(e.south,t.south),d=Math.min(e.north,t.north);if(!(h>=d))return r(n)?(n.west=l,n.south=h,n.east=f,n.north=d,n):new c(l,h,f,d)}},c.simpleIntersection=function(e,t,n){var i=Math.max(e.west,t.west),a=Math.max(e.south,t.south),o=Math.min(e.east,t.east),u=Math.min(e.north,t.north);if(!(a>=u||i>=o))return r(n)?(n.west=i,n.south=a,n.east=o,n.north=u,n):new c(i,a,o,u)},c.union=function(e,t,n){r(n)||(n=new c);var i=e.east,a=e.west,o=t.east,u=t.west;i<a&&o>0?i+=s.TWO_PI:o<u&&i>0&&(o+=s.TWO_PI),i<a&&u<0?u+=s.TWO_PI:o<u&&a<0&&(a+=s.TWO_PI);var l=s.convertLongitudeRange(Math.min(a,u)),f=s.convertLongitudeRange(Math.max(i,o));return n.west=l,n.south=Math.min(e.south,t.south),n.east=f,n.north=Math.max(e.north,t.north),n},c.expand=function(e,t,n){return r(n)||(n=new c),n.west=Math.min(e.west,t.longitude),n.south=Math.min(e.south,t.latitude),n.east=Math.max(e.east,t.longitude),n.north=Math.max(e.north,t.latitude),n},c.contains=function(e,t){var n=t.longitude,r=t.latitude,i=e.west,a=e.east;return a<i&&(a+=s.TWO_PI,n<0&&(n+=s.TWO_PI)),(n>i||s.equalsEpsilon(n,i,s.EPSILON14))&&(n<a||s.equalsEpsilon(n,a,s.EPSILON14))&&r>=e.south&&r<=e.north};var l=new e;return c.subsample=function(e,t,i,a){t=n(t,o.WGS84),i=n(i,0),r(a)||(a=[]);var u=0,f=e.north,h=e.south,d=e.east,p=e.west,y=l;y.height=i,y.longitude=p,y.latitude=f,a[u]=t.cartographicToCartesian(y,a[u]),u++,y.longitude=d,a[u]=t.cartographicToCartesian(y,a[u]),u++,y.latitude=h,a[u]=t.cartographicToCartesian(y,a[u]),u++,y.longitude=p,a[u]=t.cartographicToCartesian(y,a[u]),u++,f<0?y.latitude=f:h>0?y.latitude=h:y.latitude=0;for(var E=1;E<8;++E)y.longitude=-Math.PI+E*s.PI_OVER_TWO,c.contains(e,y)&&(a[u]=t.cartographicToCartesian(y,a[u]),u++);return 0===y.latitude&&(y.longitude=p,a[u]=t.cartographicToCartesian(y,a[u]),u++,y.longitude=d,a[u]=t.cartographicToCartesian(y,a[u]),u++),a.length=u,a},c.MAX_VALUE=u(new c(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),c}),define("Core/BoundingRectangle",["./Cartesian2","./Cartographic","./Check","./defaultValue","./defined","./GeographicProjection","./Intersect","./Rectangle"],function(e,t,n,r,i,a,o,u){"use strict";function s(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.width=r(n,0),this.height=r(i,0)}s.packedLength=4,s.pack=function(e,t,n){return n=r(n,0),t[n++]=e.x,t[n++]=e.y,t[n++]=e.width,t[n]=e.height,t},s.unpack=function(e,t,n){return t=r(t,0),i(n)||(n=new s),n.x=e[t++],n.y=e[t++],n.width=e[t++],n.height=e[t],n},s.fromPoints=function(e,t){if(i(t)||(t=new s),!i(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;for(var n=e.length,r=e[0].x,a=e[0].y,o=e[0].x,u=e[0].y,c=1;c<n;c++){var l=e[c],f=l.x,h=l.y;r=Math.min(f,r),o=Math.max(f,o),a=Math.min(h,a),u=Math.max(h,u)}return t.x=r,t.y=a,t.width=o-r,t.height=u-a,t};var c=new a,l=new t,f=new t;return s.fromRectangle=function(t,n,a){if(i(a)||(a=new s),!i(t))return a.x=0,a.y=0,a.width=0,a.height=0,a;n=r(n,c);var o=n.project(u.southwest(t,l)),h=n.project(u.northeast(t,f));return e.subtract(h,o,h),a.x=o.x,a.y=o.y,a.width=h.x,a.height=h.y,a},s.clone=function(e,t){if(i(e))return i(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new s(e.x,e.y,e.width,e.height)},s.union=function(e,t,n){i(n)||(n=new s);var r=Math.min(e.x,t.x),a=Math.min(e.y,t.y),o=Math.max(e.x+e.width,t.x+t.width),u=Math.max(e.y+e.height,t.y+t.height);return n.x=r,n.y=a,n.width=o-r,n.height=u-a,n},s.expand=function(e,t,n){n=s.clone(e,n);var r=t.x-n.x,i=t.y-n.y;return r>n.width?n.width=r:r<0&&(n.width-=r,n.x=t.x),i>n.height?n.height=i:i<0&&(n.height-=i,n.y=t.y),n},s.intersect=function(e,t){var n=e.x,r=e.y,i=t.x,a=t.y;return n>i+t.width||n+e.width<i||r+e.height<a||r>a+t.height?o.OUTSIDE:o.INTERSECTING},s.equals=function(e,t){return e===t||i(e)&&i(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.intersect=function(e){return s.intersect(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,n){this.start=e(t,0),this.stop=e(n,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i,a,o,u){"use strict";function s(e,t,r,i,a,o,u,s,c){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(u,0),this[3]=n(t,0),this[4]=n(a,0),this[5]=n(s,0),this[6]=n(r,0),this[7]=n(o,0),this[8]=n(c,0)}function c(e){for(var t=0,n=0;n<9;++n){var r=e[n];t+=r*r}return Math.sqrt(t)}function l(e){for(var t=0,n=0;n<3;++n){var r=e[s.getElementIndex(y[n],p[n])];t+=2*r*r}return Math.sqrt(t)}function f(e,t){for(var n=u.EPSILON15,r=0,i=1,a=0;a<3;++a){var o=Math.abs(e[s.getElementIndex(y[a],p[a])]);o>r&&(i=a,r=o)}var c=1,l=0,f=p[i],h=y[i];if(Math.abs(e[s.getElementIndex(h,f)])>n){var d,E=e[s.getElementIndex(h,h)],m=e[s.getElementIndex(f,f)],_=e[s.getElementIndex(h,f)],v=(E-m)/2/_;d=v<0?-1/(-v+Math.sqrt(1+v*v)):1/(v+Math.sqrt(1+v*v)),c=1/Math.sqrt(1+d*d),l=d*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(f,f)]=t[s.getElementIndex(h,h)]=c,t[s.getElementIndex(h,f)]=l,t[s.getElementIndex(f,h)]=-l,t}s.packedLength=9,s.pack=function(e,t,r){return r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t},s.unpack=function(e,t,i){return t=n(t,0),r(i)||(i=new s),i[0]=e[t++],i[1]=e[t++],i[2]=e[t++],i[3]=e[t++],i[4]=e[t++],i[5]=e[t++],i[6]=e[t++],i[7]=e[t++],i[8]=e[t++],i},s.clone=function(e,t){if(r(e))return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,t,i){return t=n(t,0),r(i)||(i=new s),i[0]=e[t],i[1]=e[t+1],i[2]=e[t+2],i[3]=e[t+3],i[4]=e[t+4],i[5]=e[t+5],i[6]=e[t+6],i[7]=e[t+7],i[8]=e[t+8],i},s.fromColumnMajorArray=function(e,t){return s.clone(e,t)},s.fromRowMajorArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],
t[8]=e[8],t):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,t){var n=e.x*e.x,i=e.x*e.y,a=e.x*e.z,o=e.x*e.w,u=e.y*e.y,c=e.y*e.z,l=e.y*e.w,f=e.z*e.z,h=e.z*e.w,d=e.w*e.w,p=n-u-f+d,y=2*(i-h),E=2*(a+l),m=2*(i+h),_=-n+u-f+d,v=2*(c-o),T=2*(a-l),R=2*(c+o),g=-n-u+f+d;return r(t)?(t[0]=p,t[1]=m,t[2]=T,t[3]=y,t[4]=_,t[5]=R,t[6]=E,t[7]=v,t[8]=g,t):new s(p,y,E,m,_,v,T,R,g)},s.fromHeadingPitchRoll=function(e,t){var n=Math.cos(-e.pitch),i=Math.cos(-e.heading),a=Math.cos(e.roll),o=Math.sin(-e.pitch),u=Math.sin(-e.heading),c=Math.sin(e.roll),l=n*i,f=-a*u+c*o*i,h=c*u+a*o*i,d=n*u,p=a*i+c*o*u,y=-o*a+a*o*u,E=-o,m=c*n,_=a*n;return r(t)?(t[0]=l,t[1]=d,t[2]=E,t[3]=f,t[4]=p,t[5]=m,t[6]=h,t[7]=y,t[8]=_,t):new s(l,f,h,d,p,y,E,m,_)},s.fromScale=function(e,t){return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,t){return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,t){return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=i,t[6]=0,t[7]=-i,t[8]=n,t):new s(1,0,0,0,n,-i,0,i,n)},s.fromRotationY=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-i,t[3]=0,t[4]=1,t[5]=0,t[6]=i,t[7]=0,t[8]=n,t):new s(n,0,i,0,1,0,-i,0,n)},s.fromRotationZ=function(e,t){var n=Math.cos(e),i=Math.sin(e);return r(t)?(t[0]=n,t[1]=i,t[2]=0,t[3]=-i,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new s(n,-i,0,i,n,0,0,0,1)},s.toArray=function(e,t){return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,t){return 3*e+t},s.getColumn=function(e,t,n){var r=3*t,i=e[r],a=e[r+1],o=e[r+2];return n.x=i,n.y=a,n.z=o,n},s.setColumn=function(e,t,n,r){r=s.clone(e,r);var i=3*t;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r},s.getRow=function(e,t,n){var r=e[t],i=e[t+3],a=e[t+6];return n.x=r,n.y=i,n.z=a,n},s.setRow=function(e,t,n,r){return r=s.clone(e,r),r[t]=n.x,r[t+3]=n.y,r[t+6]=n.z,r};var h=new e;s.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],h)),n.y=e.magnitude(e.fromElements(t[3],t[4],t[5],h)),n.z=e.magnitude(e.fromElements(t[6],t[7],t[8],h)),n};var d=new e;s.getMaximumScale=function(t){return s.getScale(t,d),e.maximumComponent(d)},s.multiply=function(e,t,n){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],i=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],a=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],f=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=i,n[2]=a,n[3]=o,n[4]=u,n[5]=s,n[6]=c,n[7]=l,n[8]=f,n},s.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},s.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},s.multiplyByVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[3]*i+e[6]*a,u=e[1]*r+e[4]*i+e[7]*a,s=e[2]*r+e[5]*i+e[8]*a;return n.x=o,n.y=u,n.z=s,n},s.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},s.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},s.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},s.transpose=function(e,t){var n=e[0],r=e[3],i=e[6],a=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=n,t[1]=r,t[2]=i,t[3]=a,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var p=[1,0,0],y=[2,2,1],E=new s,m=new s;return s.computeEigenDecomposition=function(e,t){var n=u.EPSILON20,i=10,a=0,o=0;r(t)||(t={});for(var h=t.unitary=s.clone(s.IDENTITY,t.unitary),d=t.diagonal=s.clone(e,t.diagonal),p=n*c(d);o<i&&l(d)>p;)f(d,E),s.transpose(E,m),s.multiply(d,E,d),s.multiply(m,d,d),s.multiply(h,E,h),++a>2&&(++o,a=0);return t},s.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},s.determinant=function(e){var t=e[0],n=e[3],r=e[6],i=e[1],a=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(a*c-s*o)+i*(s*r-n*c)+u*(n*o-a*r)},s.inverse=function(e,t){var n=e[0],r=e[1],i=e[2],a=e[3],o=e[4],u=e[5],c=e[6],l=e[7],f=e[8],h=s.determinant(e);t[0]=o*f-l*u,t[1]=l*i-r*f,t[2]=r*u-o*i,t[3]=c*u-a*f,t[4]=n*f-c*i,t[5]=a*i-n*u,t[6]=a*l-c*o,t[7]=c*r-n*l,t[8]=n*o-a*r;var d=1/h;return s.multiplyByScalar(t,d,t)},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,i(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,n,r,i,a){"use strict";function o(e,n,r,i){this.x=t(e,0),this.y=t(n,0),this.z=t(r,0),this.w=t(i,0)}o.fromElements=function(e,t,r,i,a){return n(a)?(a.x=e,a.y=t,a.z=r,a.w=i,a):new o(e,t,r,i)},o.fromColor=function(e,t){return n(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){if(n(e))return n(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w)},o.packedLength=4,o.pack=function(e,n,r){return r=t(r,0),n[r++]=e.x,n[r++]=e.y,n[r++]=e.z,n[r]=e.w,n},o.unpack=function(e,r,i){return r=t(r,0),n(i)||(i=new o),i.x=e[r++],i.y=e[r++],i.z=e[r++],i.w=e[r],i},o.packArray=function(e,t){var r=e.length;n(t)?t.length=4*r:t=new Array(4*r);for(var i=0;i<r;++i)o.pack(e[i],t,4*i);return t},o.unpackArray=function(e,t){var r=e.length;n(t)?t.length=r/4:t=new Array(r/4);for(var i=0;i<r;i+=4){var a=i/4;t[a]=o.unpack(e,i,t[a])}return t},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},o.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(e,t){var n=o.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},o.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},o.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n.z=e.z/t.z,n.w=e.w/t.w,n},o.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},o.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},o.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},o.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var s=new o;o.lerp=function(e,t,n,r){return o.multiplyByScalar(t,n,s),r=o.multiplyByScalar(e,1-n,r),o.add(s,r,r)};var c=new o;return o.mostOrthogonalAxis=function(e,t){var n=o.normalize(e,c);return o.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,t):o.clone(o.UNIT_W,t):n.z<=n.w?o.clone(o.UNIT_Z,t):o.clone(o.UNIT_W,t):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,t):o.clone(o.UNIT_W,t):n.z<=n.w?o.clone(o.UNIT_Z,t):o.clone(o.UNIT_W,t)},o.equals=function(e,t){return e===t||n(e)&&n(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},o.equalsEpsilon=function(e,t,r,i){return e===t||n(e)&&n(t)&&a.equalsEpsilon(e.x,t.x,r,i)&&a.equalsEpsilon(e.y,t.y,r,i)&&a.equalsEpsilon(e.z,t.z,r,i)&&a.equalsEpsilon(e.w,t.w,r,i)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,n){return o.equalsEpsilon(this,e,t,n)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,n,r,i,a,o,u,s,c,l){"use strict";function f(e,t,n,i,a,o,u,s,c,l,f,h,d,p,y,E){this[0]=r(e,0),this[1]=r(a,0),this[2]=r(c,0),this[3]=r(d,0),this[4]=r(t,0),this[5]=r(o,0),this[6]=r(l,0),this[7]=r(p,0),this[8]=r(n,0),this[9]=r(u,0),this[10]=r(f,0),this[11]=r(y,0),this[12]=r(i,0),this[13]=r(s,0),this[14]=r(h,0),this[15]=r(E,0)}f.packedLength=16,f.pack=function(e,t,n){return n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15],t},f.unpack=function(e,t,n){return t=r(t,0),i(n)||(n=new f),n[0]=e[t++],n[1]=e[t++],n[2]=e[t++],n[3]=e[t++],n[4]=e[t++],n[5]=e[t++],n[6]=e[t++],n[7]=e[t++],n[8]=e[t++],n[9]=e[t++],n[10]=e[t++],n[11]=e[t++],n[12]=e[t++],n[13]=e[t++],n[14]=e[t++],n[15]=e[t],n},f.clone=function(e,t){if(i(e))return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,t){return f.clone(e,t)},f.fromRowMajorArray=function(e,t){return i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(t,n,a){return n=r(n,e.ZERO),i(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=n.x,a[13]=n.y,a[14]=n.z,a[15]=1,a):new f(t[0],t[3],t[6],n.x,t[1],t[4],t[7],n.y,t[2],t[5],t[8],n.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,t,n,r){i(r)||(r=new f);var a=n.x,o=n.y,u=n.z,s=t.x*t.x,c=t.x*t.y,l=t.x*t.z,h=t.x*t.w,d=t.y*t.y,p=t.y*t.z,y=t.y*t.w,E=t.z*t.z,m=t.z*t.w,_=t.w*t.w,v=s-d-E+_,T=2*(c-m),R=2*(l+y),g=2*(c+m),A=-s+d-E+_,S=2*(p-h),N=2*(l-y),x=2*(p+h),I=-s-d+E+_;return r[0]=v*a,r[1]=g*a,r[2]=N*a,r[3]=0,r[4]=T*o,r[5]=A*o,r[6]=x*o,r[7]=0,r[8]=R*u,r[9]=S*u,r[10]=I*u,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r},f.fromTranslationRotationScale=function(e,t){return f.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},f.fromTranslation=function(e,t){return f.fromRotationTranslation(c.IDENTITY,e,t)},f.fromScale=function(e,t){return i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,t){return i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var h=new e,d=new e,p=new e;f.fromCamera=function(t,n){var r=t.position,a=t.direction,o=t.up;e.normalize(a,h),e.normalize(e.cross(h,o,d),d),e.normalize(e.cross(d,h,p),p);var u=d.x,s=d.y,c=d.z,l=h.x,y=h.y,E=h.z,m=p.x,_=p.y,v=p.z,T=r.x,R=r.y,g=r.z,A=u*-T+s*-R+c*-g,S=m*-T+_*-R+v*-g,N=l*T+y*R+E*g;return i(n)?(n[0]=u,n[1]=m,n[2]=-l,n[3]=0,n[4]=s,n[5]=_,n[6]=-y,n[7]=0,n[8]=c,n[9]=v,n[10]=-E,n[11]=0,n[12]=A,n[13]=S,n[14]=N,n[15]=1,n):new f(u,s,c,A,m,_,v,S,-l,-y,-E,N,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,t,n,r,i){var a=Math.tan(.5*e),o=1/a,u=o/t,s=(r+n)/(n-r),c=2*r*n/(n-r);return i[0]=u,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=o,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=s,i[11]=-1,i[12]=0,i[13]=0,i[14]=c,i[15]=0,i},f.computeOrthographicOffCenter=function(e,t,n,r,i,a,o){var u=1/(t-e),s=1/(r-n),c=1/(a-i),l=-(t+e)*u,f=-(r+n)*s,h=-(a+i)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=f,o[14]=h,o[15]=1,o},f.computePerspectiveOffCenter=function(e,t,n,r,i,a,o){var u=2*i/(t-e),s=2*i/(r-n),c=(t+e)/(t-e),l=(r+n)/(r-n),f=-(a+i)/(a-i),h=-1,d=-2*a*i/(a-i);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=f,o[11]=h,o[12]=0,o[13]=0,o[14]=d,o[15]=0,o},f.computeInfinitePerspectiveOffCenter=function(e,t,n,r,i,a){var o=2*i/(t-e),u=2*i/(r-n),s=(t+e)/(t-e),c=(r+n)/(r-n),l=-1,f=-1,h=-2*i;return a[0]=o,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=s,a[9]=c,a[10]=l,a[11]=f,a[12]=0,a[13]=0,a[14]=h,a[15]=0,a},f.computeViewportTransformation=function(e,t,n,i){e=r(e,r.EMPTY_OBJECT);var a=r(e.x,0),o=r(e.y,0),u=r(e.width,0),s=r(e.height,0);t=r(t,0),n=r(n,1);var c=.5*u,l=.5*s,f=.5*(n-t),h=c,d=l,p=f,y=a+c,E=o+l,m=t+f,_=1;return i[0]=h,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=d,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=p,i[11]=0,i[12]=y,i[13]=E,i[14]=m,i[15]=_,i},f.computeView=function(t,n,r,i,a){return a[0]=i.x,a[1]=r.x,a[2]=-n.x,a[3]=0,a[4]=i.y,a[5]=r.y,a[6]=-n.y,a[7]=0,a[8]=i.z,a[9]=r.z,a[10]=-n.z,a[11]=0,a[12]=-e.dot(i,t),a[13]=-e.dot(r,t),a[14]=e.dot(n,t),a[15]=1,a},f.toArray=function(e,t){return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,t){return 4*e+t},f.getColumn=function(e,t,n){var r=4*t,i=e[r],a=e[r+1],o=e[r+2],u=e[r+3];return n.x=i,n.y=a,n.z=o,n.w=u,n},f.setColumn=function(e,t,n,r){r=f.clone(e,r);var i=4*t;return r[i]=n.x,r[i+1]=n.y,r[i+2]=n.z,r[i+3]=n.w,r},f.setTranslation=function(e,t,n){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n},f.getRow=function(e,t,n){var r=e[t],i=e[t+4],a=e[t+8],o=e[t+12];return n.x=r,n.y=i,n.z=a,n.w=o,n},f.setRow=function(e,t,n,r){return r=f.clone(e,r),r[t]=n.x,r[t+4]=n.y,r[t+8]=n.z,r[t+12]=n.w,r};var y=new e;f.getScale=function(t,n){return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],y)),n.y=e.magnitude(e.fromElements(t[4],t[5],t[6],y)),n.z=e.magnitude(e.fromElements(t[8],t[9],t[10],y)),n};var E=new e;f.getMaximumScale=function(t){return f.getScale(t,E),e.maximumComponent(E)},f.multiply=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],f=e[8],h=e[9],d=e[10],p=e[11],y=e[12],E=e[13],m=e[14],_=e[15],v=t[0],T=t[1],R=t[2],g=t[3],A=t[4],S=t[5],N=t[6],x=t[7],I=t[8],O=t[9],w=t[10],M=t[11],C=t[12],P=t[13],D=t[14],L=t[15],U=r*v+u*T+f*R+y*g,b=i*v+s*T+h*R+E*g,F=a*v+c*T+d*R+m*g,z=o*v+l*T+p*R+_*g,B=r*A+u*S+f*N+y*x,G=i*A+s*S+h*N+E*x,q=a*A+c*S+d*N+m*x,W=o*A+l*S+p*N+_*x,V=r*I+u*O+f*w+y*M,H=i*I+s*O+h*w+E*M,X=a*I+c*O+d*w+m*M,Y=o*I+l*O+p*w+_*M,k=r*C+u*P+f*D+y*L,Z=i*C+s*P+h*D+E*L,j=a*C+c*P+d*D+m*L,K=o*C+l*P+p*D+_*L;return n[0]=U,n[1]=b,n[2]=F,n[3]=z,n[4]=B,n[5]=G,n[6]=q,n[7]=W,n[8]=V,n[9]=H,n[10]=X,n[11]=Y,n[12]=k,n[13]=Z,n[14]=j,n[15]=K,n},f.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},f.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},f.multiplyTransformation=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=e[12],d=e[13],p=e[14],y=t[0],E=t[1],m=t[2],_=t[4],v=t[5],T=t[6],R=t[8],g=t[9],A=t[10],S=t[12],N=t[13],x=t[14],I=r*y+o*E+c*m,O=i*y+u*E+l*m,w=a*y+s*E+f*m,M=r*_+o*v+c*T,C=i*_+u*v+l*T,P=a*_+s*v+f*T,D=r*R+o*g+c*A,L=i*R+u*g+l*A,U=a*R+s*g+f*A,b=r*S+o*N+c*x+h,F=i*S+u*N+l*x+d,z=a*S+s*N+f*x+p;return n[0]=I,n[1]=O,n[2]=w,n[3]=0,n[4]=M,n[5]=C,n[6]=P,n[7]=0,n[8]=D,n[9]=L,n[10]=U,n[11]=0,n[12]=b,n[13]=F,n[14]=z,n[15]=1,n},f.multiplyByMatrix3=function(e,t,n){var r=e[0],i=e[1],a=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],f=e[10],h=t[0],d=t[1],p=t[2],y=t[3],E=t[4],m=t[5],_=t[6],v=t[7],T=t[8],R=r*h+o*d+c*p,g=i*h+u*d+l*p,A=a*h+s*d+f*p,S=r*y+o*E+c*m,N=i*y+u*E+l*m,x=a*y+s*E+f*m,I=r*_+o*v+c*T,O=i*_+u*v+l*T,w=a*_+s*v+f*T;return n[0]=R,n[1]=g,n[2]=A,n[3]=0,n[4]=S,n[5]=N,n[6]=x,n[7]=0,n[8]=I,n[9]=O,n[10]=w,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},f.multiplyByTranslation=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=r*e[0]+i*e[4]+a*e[8]+e[12],u=r*e[1]+i*e[5]+a*e[9]+e[13],s=r*e[2]+i*e[6]+a*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=o,n[13]=u,n[14]=s,n[15]=e[15],n};var m=new e;f.multiplyByUniformScale=function(e,t,n){return m.x=t,m.y=t,m.z=t,f.multiplyByScale(e,m,n)},f.multiplyByScale=function(e,t,n){var r=t.x,i=t.y,a=t.z;return 1===r&&1===i&&1===a?f.clone(e,n):(n[0]=r*e[0],n[1]=r*e[1],n[2]=r*e[2],n[3]=0,n[4]=i*e[4],n[5]=i*e[5],n[6]=i*e[6],n[7]=0,n[8]=a*e[8],n[9]=a*e[9],n[10]=a*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},f.multiplyByVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=t.w,u=e[0]*r+e[4]*i+e[8]*a+e[12]*o,s=e[1]*r+e[5]*i+e[9]*a+e[13]*o,c=e[2]*r+e[6]*i+e[10]*a+e[14]*o,l=e[3]*r+e[7]*i+e[11]*a+e[15]*o;return n.x=u,n.y=s,n.z=c,n.w=l,n},f.multiplyByPointAsVector=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[4]*i+e[8]*a,u=e[1]*r+e[5]*i+e[9]*a,s=e[2]*r+e[6]*i+e[10]*a;return n.x=o,n.y=u,n.z=s,n},f.multiplyByPoint=function(e,t,n){var r=t.x,i=t.y,a=t.z,o=e[0]*r+e[4]*i+e[8]*a+e[12],u=e[1]*r+e[5]*i+e[9]*a+e[13],s=e[2]*r+e[6]*i+e[10]*a+e[14];return n.x=o,n.y=u,n.z=s,n},f.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},f.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},f.transpose=function(e,t){var n=e[1],r=e[2],i=e[3],a=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=a,t[10]=e[10],t[11]=e[14],t[12]=i,t[13]=o,t[14]=u,t[15]=e[15],t},f.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},f.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},f.equalsEpsilon=function(e,t,n){return e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},f.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},f.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var _=new c,v=new c,T=new t,R=new t(0,0,0,1);return f.inverse=function(e,n){if(c.equalsEpsilon(f.getRotation(e,_),v,s.EPSILON7)&&t.equals(f.getRow(e,3,T),R))return n[0]=0,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=0,n[11]=0,n[12]=-e[12],n[13]=-e[13],n[14]=-e[14],n[15]=1,n;var r=e[0],i=e[4],a=e[8],o=e[12],u=e[1],h=e[5],d=e[9],p=e[13],y=e[2],E=e[6],m=e[10],g=e[14],A=e[3],S=e[7],N=e[11],x=e[15],I=m*x,O=g*N,w=E*x,M=g*S,C=E*N,P=m*S,D=y*x,L=g*A,U=y*N,b=m*A,F=y*S,z=E*A,B=I*h+M*d+C*p-(O*h+w*d+P*p),G=O*u+D*d+b*p-(I*u+L*d+U*p),q=w*u+L*h+F*p-(M*u+D*h+z*p),W=P*u+U*h+z*d-(C*u+b*h+F*d),V=O*i+w*a+P*o-(I*i+M*a+C*o),H=I*r+L*a+U*o-(O*r+D*a+b*o),X=M*r+D*i+z*o-(w*r+L*i+F*o),Y=C*r+b*i+F*a-(P*r+U*i+z*a);I=a*p,O=o*d,w=i*p,M=o*h,C=i*d,P=a*h,D=r*p,L=o*u,U=r*d,b=a*u,F=r*h,z=i*u;var k=I*S+M*N+C*x-(O*S+w*N+P*x),Z=O*A+D*N+b*x-(I*A+L*N+U*x),j=w*A+L*S+F*x-(M*A+D*S+z*x),K=P*A+U*S+z*N-(C*A+b*S+F*N),J=w*m+P*g+O*E-(C*g+I*E+M*m),Q=U*g+I*y+L*m-(D*m+b*g+O*y),$=D*E+z*g+M*y-(F*g+w*y+L*E),ee=F*m+C*y+b*E-(U*E+z*m+P*y),te=r*B+i*G+a*q+o*W;if(Math.abs(te)<s.EPSILON20)throw new l("matrix is not invertible because its determinate is zero.");return te=1/te,n[0]=B*te,n[1]=G*te,n[2]=q*te,n[3]=W*te,n[4]=V*te,n[5]=H*te,n[6]=X*te,n[7]=Y*te,n[8]=k*te,n[9]=Z*te,n[10]=j*te,n[11]=K*te,n[12]=J*te,n[13]=Q*te,n[14]=$*te,n[15]=ee*te,n},f.inverseTransformation=function(e,t){var n=e[0],r=e[1],i=e[2],a=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],f=e[12],h=e[13],d=e[14],p=-n*f-r*h-i*d,y=-a*f-o*h-u*d,E=-s*f-c*h-l*d;return t[0]=n,t[1]=a,t[2]=s,t[3]=0,t[4]=r,t[5]=o,t[6]=c,t[7]=0,t[8]=i,t[9]=u,t[10]=l,t[11]=0,t[12]=p,t[13]=y,t[14]=E,t[15]=1,t},f.IDENTITY=u(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=u(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,a(f.prototype,{length:{get:function(){return f.packedLength}}}),f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},f.prototype.equalsEpsilon=function(e,t){return f.equalsEpsilon(this,e,t)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Rectangle"],function(e,t,n,r,i,a,o,u,s,c,l,f){"use strict";function h(t,n){this.center=e.clone(r(t,e.ZERO)),this.radius=r(n,0)}var d=new e,p=new e,y=new e,E=new e,m=new e,_=new e,v=new e,T=new e,R=new e,g=new e,A=new e,S=new e;h.fromPoints=function(t,n){if(i(n)||(n=new h),!i(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;for(var r=e.clone(t[0],v),a=e.clone(r,d),o=e.clone(r,p),u=e.clone(r,y),s=e.clone(r,E),c=e.clone(r,m),l=e.clone(r,_),f=t.length,N=1;N<f;N++){e.clone(t[N],r);var x=r.x,I=r.y,O=r.z;x<a.x&&e.clone(r,a),x>s.x&&e.clone(r,s),I<o.y&&e.clone(r,o),I>c.y&&e.clone(r,c),O<u.z&&e.clone(r,u),O>l.z&&e.clone(r,l)}var w=e.magnitudeSquared(e.subtract(s,a,T)),M=e.magnitudeSquared(e.subtract(c,o,T)),C=e.magnitudeSquared(e.subtract(l,u,T)),P=a,D=s,L=w;M>L&&(L=M,P=o,D=c),C>L&&(L=C,P=u,D=l);var U=R;U.x=.5*(P.x+D.x),U.y=.5*(P.y+D.y),U.z=.5*(P.z+D.z);var b=e.magnitudeSquared(e.subtract(D,U,T)),F=Math.sqrt(b),z=g;z.x=a.x,z.y=o.y,z.z=u.z;var B=A;B.x=s.x,B.y=c.y,B.z=l.z;var G=e.multiplyByScalar(e.add(z,B,T),.5,S),q=0;for(N=0;N<f;N++){e.clone(t[N],r);var W=e.magnitude(e.subtract(r,G,T));W>q&&(q=W);var V=e.magnitudeSquared(e.subtract(r,U,T));if(V>b){var H=Math.sqrt(V);F=.5*(F+H),b=F*F;var X=H-F;U.x=(F*U.x+X*r.x)/H,U.y=(F*U.y+X*r.y)/H,U.z=(F*U.z+X*r.z)/H}}return F<q?(e.clone(U,n.center),n.radius=F):(e.clone(G,n.center),n.radius=q),n};var N=new o,x=new e,I=new e,O=new t,w=new t;h.fromRectangle2D=function(e,t,n){return h.fromRectangleWithHeights2D(e,t,0,0,n)},h.fromRectangleWithHeights2D=function(t,n,a,o,u){if(i(u)||(u=new h),!i(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;n=r(n,N),f.southwest(t,O),O.height=a,f.northeast(t,w),w.height=o;var s=n.project(O,x),c=n.project(w,I),l=c.x-s.x,d=c.y-s.y,p=c.z-s.z;u.radius=.5*Math.sqrt(l*l+d*d+p*p);var y=u.center;return y.x=s.x+.5*l,y.y=s.y+.5*d,y.z=s.z+.5*p,u};var M=[];h.fromRectangle3D=function(e,t,n,o){t=r(t,a.WGS84),n=r(n,0);var u;return i(e)&&(u=f.subsample(e,t,n,M)),h.fromPoints(u,o)},h.fromVertices=function(t,n,a,o){if(i(o)||(o=new h),!i(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;n=r(n,e.ZERO),a=r(a,3);var u=v;u.x=t[0]+n.x,u.y=t[1]+n.y,u.z=t[2]+n.z;for(var s=e.clone(u,d),c=e.clone(u,p),l=e.clone(u,y),f=e.clone(u,E),N=e.clone(u,m),x=e.clone(u,_),I=t.length,O=0;O<I;O+=a){var w=t[O]+n.x,M=t[O+1]+n.y,C=t[O+2]+n.z;u.x=w,u.y=M,u.z=C,w<s.x&&e.clone(u,s),w>f.x&&e.clone(u,f),M<c.y&&e.clone(u,c),M>N.y&&e.clone(u,N),C<l.z&&e.clone(u,l),C>x.z&&e.clone(u,x)}var P=e.magnitudeSquared(e.subtract(f,s,T)),D=e.magnitudeSquared(e.subtract(N,c,T)),L=e.magnitudeSquared(e.subtract(x,l,T)),U=s,b=f,F=P;D>F&&(F=D,U=c,b=N),L>F&&(F=L,U=l,b=x);var z=R;z.x=.5*(U.x+b.x),z.y=.5*(U.y+b.y),z.z=.5*(U.z+b.z);var B=e.magnitudeSquared(e.subtract(b,z,T)),G=Math.sqrt(B),q=g;q.x=s.x,q.y=c.y,q.z=l.z;var W=A;W.x=f.x,W.y=N.y,W.z=x.z;var V=e.multiplyByScalar(e.add(q,W,T),.5,S),H=0;for(O=0;O<I;O+=a){u.x=t[O]+n.x,u.y=t[O+1]+n.y,u.z=t[O+2]+n.z;var X=e.magnitude(e.subtract(u,V,T));X>H&&(H=X);var Y=e.magnitudeSquared(e.subtract(u,z,T));if(Y>B){var k=Math.sqrt(Y);G=.5*(G+k),B=G*G;var Z=k-G;z.x=(G*z.x+Z*u.x)/k,z.y=(G*z.y+Z*u.y)/k,z.z=(G*z.z+Z*u.z)/k}}return G<H?(e.clone(z,o.center),o.radius=G):(e.clone(V,o.center),o.radius=H),o},h.fromEncodedCartesianVertices=function(t,n,r){if(i(r)||(r=new h),!i(t)||!i(n)||t.length!==n.length||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var a=v;a.x=t[0]+n[0],a.y=t[1]+n[1],a.z=t[2]+n[2];for(var o=e.clone(a,d),u=e.clone(a,p),s=e.clone(a,y),c=e.clone(a,E),l=e.clone(a,m),f=e.clone(a,_),N=t.length,x=0;x<N;x+=3){var I=t[x]+n[x],O=t[x+1]+n[x+1],w=t[x+2]+n[x+2];a.x=I,a.y=O,a.z=w,I<o.x&&e.clone(a,o),I>c.x&&e.clone(a,c),O<u.y&&e.clone(a,u),O>l.y&&e.clone(a,l),w<s.z&&e.clone(a,s),w>f.z&&e.clone(a,f)}var M=e.magnitudeSquared(e.subtract(c,o,T)),C=e.magnitudeSquared(e.subtract(l,u,T)),P=e.magnitudeSquared(e.subtract(f,s,T)),D=o,L=c,U=M;C>U&&(U=C,D=u,L=l),P>U&&(U=P,D=s,L=f);var b=R;b.x=.5*(D.x+L.x),b.y=.5*(D.y+L.y),b.z=.5*(D.z+L.z);var F=e.magnitudeSquared(e.subtract(L,b,T)),z=Math.sqrt(F),B=g;B.x=o.x,B.y=u.y,B.z=s.z;var G=A;G.x=c.x,G.y=l.y,G.z=f.z;var q=e.multiplyByScalar(e.add(B,G,T),.5,S),W=0;for(x=0;x<N;x+=3){a.x=t[x]+n[x],a.y=t[x+1]+n[x+1],a.z=t[x+2]+n[x+2];var V=e.magnitude(e.subtract(a,q,T));V>W&&(W=V);var H=e.magnitudeSquared(e.subtract(a,b,T));if(H>F){var X=Math.sqrt(H);z=.5*(z+X),F=z*z;var Y=X-z;b.x=(z*b.x+Y*a.x)/X,b.y=(z*b.y+Y*a.y)/X,b.z=(z*b.z+Y*a.z)/X}}return z<W?(e.clone(b,r.center),r.radius=z):(e.clone(q,r.center),r.radius=W),r},h.fromCornerPoints=function(t,n,r){i(r)||(r=new h);var a=r.center;return e.add(t,n,a),e.multiplyByScalar(a,.5,a),r.radius=e.distance(a,n),r},h.fromEllipsoid=function(t,n){return i(n)||(n=new h),e.clone(e.ZERO,n.center),n.radius=t.maximumRadius,n};var C=new e;h.fromBoundingSpheres=function(t,n){if(i(n)||(n=new h),!i(t)||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var r=t.length;if(1===r)return h.clone(t[0],n);if(2===r)return h.union(t[0],t[1],n);for(var a=[],o=0;o<r;o++)a.push(t[o].center);n=h.fromPoints(a,n);var u=n.center,s=n.radius;for(o=0;o<r;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,C)+c.radius)}return n.radius=s,n};var P=new e,D=new e,L=new e;h.fromOrientedBoundingBox=function(t,n){i(n)||(n=new h);var r=t.halfAxes,a=c.getColumn(r,0,P),o=c.getColumn(r,1,D),u=c.getColumn(r,2,L),s=e.magnitude(a),l=e.magnitude(o),f=e.magnitude(u);return n.center=e.clone(t.center,n.center),n.radius=Math.max(s,l,f),n},h.clone=function(t,n){if(i(t))return i(n)?(n.center=e.clone(t.center,n.center),n.radius=t.radius,n):new h(t.center,t.radius)},h.packedLength=4,h.pack=function(e,t,n){n=r(n,0);var i=e.center;return t[n++]=i.x,t[n++]=i.y,t[n++]=i.z,t[n]=e.radius,t},h.unpack=function(e,t,n){t=r(t,0),i(n)||(n=new h);var a=n.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],n.radius=e[t],n};var U=new e,b=new e;h.union=function(t,n,r){i(r)||(r=new h);var a=t.center,o=t.radius,u=n.center,s=n.radius,c=e.subtract(u,a,U),l=e.magnitude(c);if(o>=l+s)return t.clone(r),r;if(s>=l+o)return n.clone(r),r;var f=.5*(o+l+s),d=e.multiplyByScalar(c,(-o+f)/l,b);return e.add(d,a,d),e.clone(d,r.center),r.radius=f,r};var F=new e;h.expand=function(t,n,r){r=h.clone(t,r);var i=e.magnitude(e.subtract(n,r.center,F));return i>r.radius&&(r.radius=i),r},h.intersectPlane=function(t,n){var r=t.center,i=t.radius,a=n.normal,o=e.dot(a,r)+n.distance;return o<-i?u.OUTSIDE:o<i?u.INTERSECTING:u.INSIDE},h.transform=function(e,t,n){return i(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=l.getMaximumScale(t)*e.radius,n};var z=new e;h.distanceSquaredTo=function(t,n){var r=e.subtract(t.center,n,z);return e.magnitudeSquared(r)-t.radius*t.radius;
},h.transformWithoutScale=function(e,t,n){return i(n)||(n=new h),n.center=l.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var B=new e;h.computePlaneDistances=function(t,n,r,a){i(a)||(a=new s);var o=e.subtract(t.center,n,B),u=e.dot(r,o);return a.start=u-t.radius,a.stop=u+t.radius,a};for(var G=new e,q=new e,W=new e,V=new e,H=new e,X=new t,Y=new Array(8),k=0;k<8;++k)Y[k]=new e;var Z=new o;return h.projectTo2D=function(t,n,i){n=r(n,Z);var a=n.ellipsoid,o=t.center,u=t.radius,s=a.geodeticSurfaceNormal(o,G),c=e.cross(e.UNIT_Z,s,q);e.normalize(c,c);var l=e.cross(s,c,W);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var f=e.negate(l,H),d=e.negate(c,V),p=Y,y=p[0];e.add(s,l,y),e.add(y,c,y),y=p[1],e.add(s,l,y),e.add(y,d,y),y=p[2],e.add(s,f,y),e.add(y,d,y),y=p[3],e.add(s,f,y),e.add(y,c,y),e.negate(s,s),y=p[4],e.add(s,l,y),e.add(y,c,y),y=p[5],e.add(s,l,y),e.add(y,d,y),y=p[6],e.add(s,f,y),e.add(y,d,y),y=p[7],e.add(s,f,y),e.add(y,c,y);for(var E=p.length,m=0;m<E;++m){var _=p[m];e.add(o,_,_);var v=a.cartesianToCartographic(_,X);n.project(v,_)}i=h.fromPoints(p,i),o=i.center;var T=o.x,R=o.y,g=o.z;return o.x=g,o.y=T,o.z=R,i},h.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},h.equals=function(t,n){return t===n||i(t)&&i(n)&&e.equals(t.center,n.center)&&t.radius===n.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,t,n){return h.computePlaneDistances(this,e,t,n)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var n,r={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return t(i,{element:{get:function(){if(i.supportsFullscreen())return document[r.fullscreenElement]}},changeEventName:{get:function(){if(i.supportsFullscreen())return r.fullscreenchange}},errorEventName:{get:function(){if(i.supportsFullscreen())return r.fullscreenerror}},enabled:{get:function(){if(i.supportsFullscreen())return document[r.fullscreenEnabled]}},fullscreen:{get:function(){if(i.supportsFullscreen())return null!==i.element}}}),i.supportsFullscreen=function(){if(e(n))return n;n=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return r.requestFullscreen="requestFullscreen",r.exitFullscreen="exitFullscreen",r.fullscreenEnabled="fullscreenEnabled",r.fullscreenElement="fullscreenElement",r.fullscreenchange="fullscreenchange",r.fullscreenerror="fullscreenerror",n=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;o<u;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof t[i]?(r.requestFullscreen=i,n=!0):(i=s+"RequestFullScreen","function"==typeof t[i]&&(r.requestFullscreen=i,n=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?r.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(r.exitFullscreen=i)),i=s+"FullscreenEnabled",void 0!==document[i]?r.fullscreenEnabled=i:(i=s+"FullScreenEnabled",void 0!==document[i]&&(r.fullscreenEnabled=i)),i=s+"FullscreenElement",void 0!==document[i]?r.fullscreenElement=i:(i=s+"FullScreenElement",void 0!==document[i]&&(r.fullscreenElement=i)),i=s+"fullscreenchange",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenChange"),r.fullscreenchange=i),i=s+"fullscreenerror",void 0!==document["on"+i]&&("ms"===s&&(i="MSFullscreenError"),r.fullscreenerror=i)}return n},i.requestFullscreen=function(e,t){i.supportsFullscreen()&&e[r.requestFullscreen]({vrDisplay:t})},i.exitFullscreen=function(){i.supportsFullscreen()&&document[r.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,n){"use strict";function r(e){for(var t=e.split("."),n=0,r=t.length;n<r;++n)t[n]=parseInt(t[n],10);return t}function i(){if(!t(R)&&(R=!1,!h())){var e=/ Chrome\/([\.0-9]+)/.exec(T.userAgent);null!==e&&(R=!0,g=r(e[1]))}return R}function a(){return i()&&g}function o(){if(!t(A)&&(A=!1,!i()&&!h()&&/ Safari\/[\.0-9]+/.test(T.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(T.userAgent);null!==e&&(A=!0,S=r(e[1]))}return A}function u(){return o()&&S}function s(){if(!t(N)){N=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(T.userAgent);null!==e&&(N=!0,x=r(e[1]),x.isNightly=!!e[2])}return N}function c(){return s()&&x}function l(){if(!t(I)){I=!1;var e;"Microsoft Internet Explorer"===T.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(T.userAgent),null!==e&&(I=!0,O=r(e[1]))):"Netscape"===T.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(T.userAgent),null!==e&&(I=!0,O=r(e[1])))}return I}function f(){return l()&&O}function h(){if(!t(w)){w=!1;var e=/ Edge\/([\.0-9]+)/.exec(T.userAgent);null!==e&&(w=!0,M=r(e[1]))}return w}function d(){return h()&&M}function p(){if(!t(C)){C=!1;var e=/Firefox\/([\.0-9]+)/.exec(T.userAgent);null!==e&&(C=!0,P=r(e[1]))}return C}function y(){return t(D)||(D=/Windows/i.test(T.appVersion)),D}function E(){return p()&&P}function m(){return t(L)||(L="undefined"!=typeof PointerEvent&&(!t(T.pointerEnabled)||T.pointerEnabled)),L}function _(){if(!t(b)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var n=e.style.imageRendering;b=t(n)&&""!==n,b&&(U=n)}return b}function v(){return _()?U:void 0}var T;T="undefined"!=typeof navigator?navigator:{};var R,g,A,S,N,x,I,O,w,M,C,P,D,L,U,b,F={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:f,isEdge:h,edgeVersion:d,isFirefox:p,firefoxVersion:E,isWindows:y,hardwareConcurrency:e(T.hardwareConcurrency,3),supportsPointerEvents:m,supportsImageRenderingPixelated:_,imageRenderingValue:v};return F.supportsFullscreen=function(){return n.supportsFullscreen()},F.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},F.supportsWebWorkers=function(){return"undefined"!=typeof Worker},F}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,n,r,i,a){"use strict";if(!r.supportsTypedArrays())return{};var o={BYTE:a.BYTE,UNSIGNED_BYTE:a.UNSIGNED_BYTE,SHORT:a.SHORT,UNSIGNED_SHORT:a.UNSIGNED_SHORT,INT:a.INT,UNSIGNED_INT:a.UNSIGNED_INT,FLOAT:a.FLOAT,DOUBLE:a.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.INT:return new Int32Array(t);case o.UNSIGNED_INT:return new Uint32Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t)}},o.createArrayBufferView=function(t,n,r,i){switch(r=e(r,0),i=e(i,(n.byteLength-r)/o.getSizeInBytes(t)),t){case o.BYTE:return new Int8Array(n,r,i);case o.UNSIGNED_BYTE:return new Uint8Array(n,r,i);case o.SHORT:return new Int16Array(n,r,i);case o.UNSIGNED_SHORT:return new Uint16Array(n,r,i);case o.INT:return new Int32Array(n,r,i);case o.UNSIGNED_INT:return new Uint32Array(n,r,i);case o.FLOAT:return new Float32Array(n,r,i);case o.DOUBLE:return new Float64Array(n,r,i)}},o.fromName=function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE}},i(o)}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Intersect"],function(e,t,n,r,i){"use strict";function a(r,i,a){this.minimum=e.clone(t(r,e.ZERO)),this.maximum=e.clone(t(i,e.ZERO)),n(a)?a=e.clone(a):(a=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(a,.5,a)),this.center=a}a.fromPoints=function(t,r){if(n(r)||(r=new a),!n(t)||0===t.length)return r.minimum=e.clone(e.ZERO,r.minimum),r.maximum=e.clone(e.ZERO,r.maximum),r.center=e.clone(e.ZERO,r.center),r;for(var i=t[0].x,o=t[0].y,u=t[0].z,s=t[0].x,c=t[0].y,l=t[0].z,f=t.length,h=1;h<f;h++){var d=t[h],p=d.x,y=d.y,E=d.z;i=Math.min(p,i),s=Math.max(p,s),o=Math.min(y,o),c=Math.max(y,c),u=Math.min(E,u),l=Math.max(E,l)}var m=r.minimum;m.x=i,m.y=o,m.z=u;var _=r.maximum;_.x=s,_.y=c,_.z=l;var v=e.add(m,_,r.center);return e.multiplyByScalar(v,.5,v),r},a.clone=function(t,r){if(n(t))return n(r)?(r.minimum=e.clone(t.minimum,r.minimum),r.maximum=e.clone(t.maximum,r.maximum),r.center=e.clone(t.center,r.center),r):new a(t.minimum,t.maximum)},a.equals=function(t,r){return t===r||n(t)&&n(r)&&e.equals(t.center,r.center)&&e.equals(t.minimum,r.minimum)&&e.equals(t.maximum,r.maximum)};var o=new e;return a.intersectPlane=function(t,n){o=e.subtract(t.maximum,t.minimum,o);var r=e.multiplyByScalar(o,.5,o),a=n.normal,u=r.x*Math.abs(a.x)+r.y*Math.abs(a.y)+r.z*Math.abs(a.z),s=e.dot(t.center,a)+n.distance;return s-u>0?i.INSIDE:s+u<0?i.OUTSIDE:i.INTERSECTING},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.intersectPlane=function(e){return a.intersectPlane(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function n(e,n,r){var i=e+n;return t.sign(e)!==t.sign(n)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(n)))<r?0:i}var r={};return r.computeDiscriminant=function(e,t,n){var r=t*t-4*e*n;return r},r.computeRealRoots=function(e,r,i){var a;if(0===e)return 0===r?[]:[-i/r];if(0===r){if(0===i)return[0,0];var o=Math.abs(i),u=Math.abs(e);if(o<u&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(a=-i/e,a<0)return[];var s=Math.sqrt(a);return[-s,s]}if(0===i)return a=-r/e,a<0?[a,0]:[0,a];var c=r*r,l=4*e*i,f=n(c,-l,t.EPSILON14);if(f<0)return[];var h=-.5*n(r,t.sign(r)*Math.sqrt(f),t.EPSILON14);return r>0?[h/e,i/h]:[i/h,h/e]},r}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function n(e,t,n,r){var i,a,o=e,u=t/3,s=n/3,c=r,l=o*s,f=u*c,h=u*u,d=s*s,p=o*s-h,y=o*c-u*s,E=u*c-d,m=4*p*E-y*y;if(m<0){var _,v,T;h*f>=l*d?(_=o,v=p,T=-2*u*p+o*y):(_=c,v=E,T=-c*y+2*s*E);var R=T<0?-1:1,g=-R*Math.abs(_)*Math.sqrt(-m);a=-T+g;var A=a/2,S=A<0?-Math.pow(-A,1/3):Math.pow(A,1/3),N=a===g?-S:-v/S;return i=v<=0?S+N:-T/(S*S+N*N+v),h*f>=l*d?[(i-u)/o]:[-c/(i+s)]}var x=p,I=-2*u*p+o*y,O=E,w=-c*y+2*s*E,M=Math.sqrt(m),C=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*M,-I)/3);i=2*Math.sqrt(-x);var D=Math.cos(P);a=i*D;var L=i*(-D/2-C*Math.sin(P)),U=a+L>2*u?a-u:L-u,b=o,F=U/b;P=Math.abs(Math.atan2(c*M,-w)/3),i=2*Math.sqrt(-O),D=Math.cos(P),a=i*D,L=i*(-D/2-C*Math.sin(P));var z=-c,B=a+L<2*s?a+s:L+s,G=z/B,q=b*B,W=-U*B-b*z,V=U*z,H=(s*W-u*V)/(-u*W+s*q);return F<=H?F<=G?H<=G?[F,H,G]:[F,G,H]:[G,F,H]:F<=G?[H,F,G]:H<=G?[H,G,F]:[G,H,F]}var r={};return r.computeDiscriminant=function(e,t,n,r){var i=e*e,a=t*t,o=n*n,u=r*r,s=18*e*t*n*r+a*o-27*i*u-4*(e*o*n+a*t*r);return s},r.computeRealRoots=function(e,r,i,a){var o,u;if(0===e)return t.computeRealRoots(r,i,a);if(0===r){if(0===i){if(0===a)return[0,0,0];u=-a/e;var s=u<0?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===a?(o=t.computeRealRoots(e,0,i),0===o.Length?[0]:[o[0],0,o[1]]):n(e,0,i,a)}return 0===i?0===a?(u=-r/e,u<0?[u,0,0]:[0,0,u]):n(e,r,0,a):0===a?(o=t.computeRealRoots(e,r,i),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):n(e,r,i,a)},r}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,n,r){"use strict";function i(t,i,a,o){var u=t*t,s=i-3*u/8,c=a-i*t/2+u*t/8,l=o-a*t/4+i*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(f.length>0){var h=-t/4,d=f[f.length-1];if(Math.abs(d)<n.EPSILON14){var p=r.computeRealRoots(1,s,l);if(2===p.length){var y,E=p[0],m=p[1];if(E>=0&&m>=0){var _=Math.sqrt(E),v=Math.sqrt(m);return[h-v,h-_,h+_,h+v]}if(E>=0&&m<0)return y=Math.sqrt(E),[h-y,h+y];if(E<0&&m>=0)return y=Math.sqrt(m),[h-y,h+y]}return[]}if(d>0){var T=Math.sqrt(d),R=(s+d-c/T)/2,g=(s+d+c/T)/2,A=r.computeRealRoots(1,T,R),S=r.computeRealRoots(1,-T,g);return 0!==A.length?(A[0]+=h,A[1]+=h,0!==S.length?(S[0]+=h,S[1]+=h,A[1]<=S[0]?[A[0],A[1],S[0],S[1]]:S[1]<=A[0]?[S[0],S[1],A[0],A[1]]:A[0]>=S[0]&&A[1]<=S[1]?[S[0],A[0],A[1],S[1]]:S[0]>=A[0]&&S[1]<=A[1]?[A[0],S[0],S[1],A[1]]:A[0]>S[0]&&A[0]<S[1]?[S[0],A[0],S[1],A[1]]:[A[0],S[0],A[1],S[1]]):A):0!==S.length?(S[0]+=h,S[1]+=h,S):[]}}return[]}function a(t,i,a,o){var u=a*a,s=i*i,c=t*t,l=-2*i,f=a*t+s-4*o,h=c*o-a*i*t+u,d=e.computeRealRoots(1,l,f,h);if(d.length>0){var p,y,E=d[0],m=i-E,_=m*m,v=t/2,T=m/2,R=_-4*o,g=_+4*Math.abs(o),A=c-4*E,S=c+4*Math.abs(E);if(E<0||R*S<A*g){var N=Math.sqrt(A);p=N/2,y=0===N?0:(t*T-a)/N}else{var x=Math.sqrt(R);p=0===x?0:(t*T-a)/x,y=x/2}var I,O;0===v&&0===p?(I=0,O=0):n.sign(v)===n.sign(p)?(I=v+p,O=E/I):(O=v-p,I=E/O);var w,M;0===T&&0===y?(w=0,M=0):n.sign(T)===n.sign(y)?(w=T+y,M=o/w):(M=T-y,w=o/M);var C=r.computeRealRoots(1,I,w),P=r.computeRealRoots(1,O,M);if(0!==C.length)return 0!==P.length?C[1]<=P[0]?[C[0],C[1],P[0],P[1]]:P[1]<=C[0]?[P[0],P[1],C[0],C[1]]:C[0]>=P[0]&&C[1]<=P[1]?[P[0],C[0],C[1],P[1]]:P[0]>=C[0]&&P[1]<=C[1]?[C[0],P[0],P[1],C[1]]:C[0]>P[0]&&C[0]<P[1]?[P[0],C[0],P[1],C[1]]:[C[0],P[0],C[1],P[1]]:C;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,t,n,r,i){var a=e*e,o=a*e,u=t*t,s=u*t,c=n*n,l=c*n,f=r*r,h=f*r,d=i*i,p=d*i,y=u*c*f-4*s*h-4*e*l*f+18*e*t*n*h-27*a*f*f+256*o*p+i*(18*s*n*r-4*u*l+16*e*c*c-80*e*t*c*r-6*e*u*f+144*a*n*f)+d*(144*e*u*n-27*u*u-128*a*c-192*a*t*r);return y},o.computeRealRoots=function(t,r,o,u,s){if(Math.abs(t)<n.EPSILON15)return e.computeRealRoots(r,o,u,s);var c=r/t,l=o/t,f=u/t,h=s/t,d=c<0?1:0;switch(d+=l<0?d+1:d,d+=f<0?d+1:d,d+=h<0?d+1:d){case 0:return i(c,l,f,h);case 1:return a(c,l,f,h);case 2:return a(c,l,f,h);case 3:return i(c,l,f,h);case 4:return i(c,l,f,h);case 5:return a(c,l,f,h);case 6:return i(c,l,f,h);case 7:return i(c,l,f,h);case 8:return a(c,l,f,h);case 9:return i(c,l,f,h);case 10:return i(c,l,f,h);case 11:return a(c,l,f,h);case 12:return i(c,l,f,h);case 13:return i(c,l,f,h);case 14:return i(c,l,f,h);case 15:return i(c,l,f,h);default:return}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";function i(n,r){r=e.clone(t(r,e.ZERO)),e.equals(r,e.ZERO)||e.normalize(r,r),this.origin=e.clone(t(n,e.ZERO)),this.direction=r}return i.getPoint=function(t,r,i){return n(i)||(i=new e),i=e.multiplyByScalar(t.direction,r,i),e.add(t.origin,i,i)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,n,r,i,a,o,u,s,c,l){"use strict";function f(e,t,n,r){var i=t*t-4*e*n;if(!(i<0)){if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-t+o)*a,s=(-t-o)*a;return u<s?(r.root0=u,r.root1=s):(r.root0=s,r.root1=u),r}var c=-t/(2*e);if(0!==c)return r.root0=r.root1=c,r}}function h(t,n,i){r(i)||(i=new a);var o=t.origin,u=t.direction,s=n.center,c=n.radius*n.radius,l=e.subtract(o,s,_),h=e.dot(u,u),d=2*e.dot(u,l),p=e.magnitudeSquared(l)-c,y=f(h,d,p,g);if(r(y))return i.start=y.root0,i.stop=y.root1,i}function d(e,t,n){var r=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(r/Math.max(Math.abs(e),Math.abs(t)))<n?0:r}function p(t,n,r,i,a){var l,f=i*i,h=a*a,p=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*h,y=a*(i*d(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],o.EPSILON15)+n.y),E=t[u.COLUMN0ROW0]*f+t[u.COLUMN2ROW2]*h+i*n.x+r,m=h*d(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],o.EPSILON15),_=a*(i*d(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+n.z),v=[];if(0===_&&0===m){if(l=s.computeRealRoots(p,y,E),0===l.length)return v;var T=l[0],R=Math.sqrt(Math.max(1-T*T,0));if(v.push(new e(i,a*T,a*-R)),v.push(new e(i,a*T,a*R)),2===l.length){var g=l[1],A=Math.sqrt(Math.max(1-g*g,0));v.push(new e(i,a*g,a*-A)),v.push(new e(i,a*g,a*A))}return v}var S=_*_,N=m*m,x=p*p,I=_*m,O=x+N,w=2*(y*p+I),M=2*E*p+y*y-N+S,C=2*(E*y-I),P=E*E-S;if(0===O&&0===w&&0===M&&0===C)return v;l=c.computeRealRoots(O,w,M,C,P);var D=l.length;if(0===D)return v;for(var L=0;L<D;++L){var U,b=l[L],F=b*b,z=Math.max(1-F,0),B=Math.sqrt(z);U=o.sign(p)===o.sign(E)?d(p*F+E,y*b,o.EPSILON12):o.sign(E)===o.sign(y*b)?d(p*F,y*b+E,o.EPSILON12):d(p*F+y*b,E,o.EPSILON12);var G=d(m*b,_,o.EPSILON15),q=U*G;q<0?v.push(new e(i,a*b,a*B)):q>0?v.push(new e(i,a*b,a*-B)):0!==B?(v.push(new e(i,a*b,a*-B)),v.push(new e(i,a*b,a*B)),++L):v.push(new e(i,a*b,a*B))}return v}var y={};y.rayPlane=function(t,n,i){r(i)||(i=new e);var a=t.origin,u=t.direction,s=n.normal,c=e.dot(s,u);if(!(Math.abs(c)<o.EPSILON15)){var l=(-n.distance-e.dot(s,a))/c;if(!(l<0))return i=e.multiplyByScalar(u,l,i),e.add(a,i,i)}};var E=new e,m=new e,_=new e,v=new e,T=new e;y.rayTriangleParametric=function(t,r,i,a,u){u=n(u,!1);var s,c,l,f,h,d=t.origin,p=t.direction,y=e.subtract(i,r,E),R=e.subtract(a,r,m),g=e.cross(p,R,_),A=e.dot(y,g);if(u){if(A<o.EPSILON6)return;if(s=e.subtract(d,r,v),l=e.dot(s,g),l<0||l>A)return;if(c=e.cross(s,y,T),f=e.dot(p,c),f<0||l+f>A)return;h=e.dot(R,c)/A}else{if(Math.abs(A)<o.EPSILON6)return;var S=1/A;if(s=e.subtract(d,r,v),l=e.dot(s,g)*S,l<0||l>1)return;if(c=e.cross(s,y,T),f=e.dot(p,c)*S,f<0||l+f>1)return;h=e.dot(R,c)*S}return h},y.rayTriangle=function(t,n,i,a,o,u){var s=y.rayTriangleParametric(t,n,i,a,o);if(r(s)&&!(s<0))return r(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var R=new l;y.lineSegmentTriangle=function(t,n,i,a,o,u,s){var c=R;e.clone(t,c.origin),e.subtract(n,t,c.direction),e.normalize(c.direction,c.direction);var l=y.rayTriangleParametric(c,i,a,o,u);if(!(!r(l)||l<0||l>e.distance(t,n)))return r(s)||(s=new e),e.multiplyByScalar(c.direction,l,s),e.add(c.origin,s,s)};var g={root0:0,root1:0};y.raySphere=function(e,t,n){if(n=h(e,t,n),
r(n)&&!(n.stop<0))return n.start=Math.max(n.start,0),n};var A=new l;y.lineSegmentSphere=function(t,n,i,a){var o=A;e.clone(t,o.origin);var u=e.subtract(n,t,o.direction),s=e.magnitude(u);if(e.normalize(u,u),a=h(o,i,a),!(!r(a)||a.stop<0||a.start>s))return a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,s),a};var S=new e,N=new e;y.rayEllipsoid=function(t,n){var r,i,o,u,s,c=n.oneOverRadii,l=e.multiplyComponents(c,t.origin,S),f=e.multiplyComponents(c,t.direction,N),h=e.magnitudeSquared(l),d=e.dot(l,f);if(h>1){if(d>=0)return;var p=d*d;if(r=h-1,i=e.magnitudeSquared(f),o=i*r,p<o)return;if(p>o){u=d*d-o,s=-d+Math.sqrt(u);var y=s/i,E=r/s;return y<E?new a(y,E):{start:E,stop:y}}var m=Math.sqrt(r/i);return new a(m,m)}return h<1?(r=h-1,i=e.magnitudeSquared(f),o=i*r,u=d*d-o,s=-d+Math.sqrt(u),new a(0,s/i)):d<0?(i=e.magnitudeSquared(f),new a(0,-d/i)):void 0};var x=new e,I=new e,O=new e,w=new e,M=new e,C=new u,P=new u,D=new u,L=new u,U=new u,b=new u,F=new u,z=new e,B=new e,G=new t;y.grazingAltitudeLocation=function(t,n){var i=t.origin,a=t.direction;if(!e.equals(i,e.ZERO)){var s=n.geodeticSurfaceNormal(i,x);if(e.dot(a,s)>=0)return i}var c=r(this.rayEllipsoid(t,n)),l=n.transformPositionToScaledSpace(a,x),f=e.normalize(l,l),h=e.mostOrthogonalAxis(l,w),d=e.normalize(e.cross(h,f,I),I),y=e.normalize(e.cross(f,d,O),O),E=C;E[0]=f.x,E[1]=f.y,E[2]=f.z,E[3]=d.x,E[4]=d.y,E[5]=d.z,E[6]=y.x,E[7]=y.y,E[8]=y.z;var m=u.transpose(E,P),_=u.fromScale(n.radii,D),v=u.fromScale(n.oneOverRadii,L),T=U;T[0]=0,T[1]=-a.z,T[2]=a.y,T[3]=a.z,T[4]=0,T[5]=-a.x,T[6]=-a.y,T[7]=a.x,T[8]=0;var R,g,A=u.multiply(u.multiply(m,v,b),T,b),S=u.multiply(u.multiply(A,_,F),E,F),N=u.multiplyByVector(A,i,M),q=p(S,e.negate(N,x),0,0,1),W=q.length;if(W>0){for(var V=e.clone(e.ZERO,B),H=Number.NEGATIVE_INFINITY,X=0;X<W;++X){R=u.multiplyByVector(_,u.multiplyByVector(E,q[X],z),z);var Y=e.normalize(e.subtract(R,i,w),w),k=e.dot(Y,a);k>H&&(H=k,V=e.clone(R,V))}var Z=n.cartesianToCartographic(V,G);return H=o.clamp(H,0,1),g=e.magnitude(e.subtract(V,i,w))*Math.sqrt(1-H*H),g=c?-g:g,Z.height=g,n.cartographicToCartesian(Z,new e)}};var q=new e;return y.lineSegmentPlane=function(t,n,i,a){r(a)||(a=new e);var u=e.subtract(n,t,q),s=i.normal,c=e.dot(s,u);if(!(Math.abs(c)<o.EPSILON6)){var l=e.dot(s,t),f=-(i.distance+l)/c;if(!(f<0||f>1))return e.multiplyByScalar(u,f,a),e.add(t,a,a),a}},y.trianglePlaneIntersection=function(t,n,r,i){var a=i.normal,o=i.distance,u=e.dot(a,t)+o<0,s=e.dot(a,n)+o<0,c=e.dot(a,r)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var f,h;if(1!==l&&2!==l||(f=new e,h=new e),1===l){if(u)return y.lineSegmentPlane(t,n,i,f),y.lineSegmentPlane(t,r,i,h),{positions:[t,n,r,f,h],indices:[0,3,4,1,2,4,1,4,3]};if(s)return y.lineSegmentPlane(n,r,i,f),y.lineSegmentPlane(n,t,i,h),{positions:[t,n,r,f,h],indices:[1,3,4,2,0,4,2,4,3]};if(c)return y.lineSegmentPlane(r,t,i,f),y.lineSegmentPlane(r,n,i,h),{positions:[t,n,r,f,h],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return y.lineSegmentPlane(n,t,i,f),y.lineSegmentPlane(r,t,i,h),{positions:[t,n,r,f,h],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return y.lineSegmentPlane(r,n,i,f),y.lineSegmentPlane(t,n,i,h),{positions:[t,n,r,f,h],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return y.lineSegmentPlane(t,r,i,f),y.lineSegmentPlane(n,r,i,h),{positions:[t,n,r,f,h],indices:[0,1,4,0,4,3,2,3,4]}}},y}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r){"use strict";function i(t,n){this.normal=e.clone(t),this.distance=n}i.fromPointNormal=function(n,r,a){var o=-e.dot(r,n);return t(a)?(e.clone(r,a.normal),a.distance=o,a):new i(r,o)};var a=new e;return i.fromCartesian4=function(n,r){var o=e.fromCartesian4(n,a),u=n.w;return t(r)?(e.clone(o,r.normal),r.distance=u,r):new i(o,u)},i.getPointDistance=function(t,n){return e.dot(t.normal,n)+t.distance},i.ORIGIN_XY_PLANE=r(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=r(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=r(new i(e.UNIT_Y,0)),i}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,n,r,i){return t(e).then(n,r,i)}function t(e){var t,n;return e instanceof r?t=e:u(e)?(n=o(),e.then(function(e){n.resolve(e)},function(e){n.reject(e)},function(e){n.progress(e)}),t=n.promise):t=i(e),t}function n(t){return e(t,a)}function r(e){this.then=e}function i(e){var n=new r(function(n){try{return t(n?n(e):e)}catch(e){return a(e)}});return n}function a(e){var n=new r(function(n,r){try{return r?t(r(e)):a(e)}catch(e){return a(e)}});return n}function o(){function e(e,t,n){return h(e,t,n)}function n(e){return p(e)}function i(e){return p(a(e))}function u(e){return d(e)}var s,c,l,f,h,d,p;return c=new r(e),s={then:e,resolve:n,reject:i,progress:u,promise:c,resolver:{resolve:n,reject:i,progress:u}},l=[],f=[],h=function(e,t,n){var r,i;return r=o(),i="function"==typeof n?function(e){try{r.progress(n(e))}catch(e){r.progress(e)}}:function(e){r.progress(e)},l.push(function(n){n.then(e,t).then(r.resolve,r.reject,i)}),f.push(i),r.promise},d=function(e){return y(f,e),e},p=function(e){return e=t(e),h=e.then,p=t,d=m,y(l,e),f=l=R,e},s}function u(e){return e&&"function"==typeof e.then}function s(t,n,r,i,a){return E(2,arguments),e(t,function(t){function u(e){y(e)}function s(e){p(e)}var c,l,f,h,d,p,y,E,_,v;if(_=t.length>>>0,c=Math.max(0,Math.min(n,_)),f=[],l=_-c+1,h=[],d=o(),c)for(E=d.progress,y=function(e){h.push(e),--l||(p=y=m,d.reject(h))},p=function(e){f.push(e),--c||(p=y=m,d.resolve(f))},v=0;v<_;++v)v in t&&e(t[v],s,u,E);else d.resolve(f);return d.then(r,i,a)})}function c(e,t,n,r){function i(e){return t?t(e[0]):e[0]}return s(e,1,i,n,r)}function l(e,t,n,r){return E(1,arguments),h(e,_).then(t,n,r)}function f(){return h(arguments,_)}function h(t,n){return e(t,function(t){var r,i,a,u,s,c;if(a=i=t.length>>>0,r=[],c=o(),a)for(u=function(t,i){e(t,n).then(function(e){r[i]=e,--a||c.resolve(r)},c.reject)},s=0;s<i;s++)s in t?u(t[s],s):--a;else c.resolve(r);return c.promise})}function d(t,n){var r=T.call(arguments,1);return e(t,function(t){var i;return i=t.length,r[0]=function(t,r,a){return e(t,function(t){return e(r,function(e){return n(t,e,a,i)})})},v.apply(t,r)})}function p(t,n,r){var i=arguments.length>2;return e(t,function(e){return e=i?r:e,n.resolve(e),e},function(e){return n.reject(e),a(e)},n.progress)}function y(e,t){for(var n,r=0;n=e[r++];)n(t)}function E(e,t){for(var n,r=t.length;r>e;)if(n=t[--r],null!=n&&"function"!=typeof n)throw new Error("arg "+r+" must be a function")}function m(){}function _(e){return e}var v,T,R;return e.defer=o,e.resolve=t,e.reject=n,e.join=f,e.all=l,e.map=h,e.reduce=d,e.any=c,e.some=s,e.chain=p,e.isPromise=u,r.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(R,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return l(t,function(t){return e.apply(R,t)})})}},T=[].slice,v=[].reduce||function(e){var t,n,r,i,a;if(a=0,t=Object(this),i=t.length>>>0,n=arguments,n.length<=1)for(;;){if(a in t){r=t[a++];break}if(++a>=i)throw new TypeError}else r=n[1];for(;a<i;++a)a in t&&(r=e(r,t[a],a,t));return r},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";function n(e,t,n){for(var r,i,a=0,o=e.length-1;a<=o;)if(r=~~((a+o)/2),i=n(e[r],t),i<0)a=r+1;else{if(!(i>0))return r;o=r-1}return~(o+1)}return n}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";function e(e,t,n,r,i){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=n,this.yPoleOffset=r,this.ut1MinusUtc=i}return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,n=0,r=t[n++],i=function(e,t,n,r){n||(n=" ");var i=e.length>=t?"":Array(1+t-e.length>>>0).join(n);return r?e+i:i+e},a=function(e,t,n,r,a,o){var u=r-e.length;return u>0&&(e=n||!a?i(e,r,o,n):e.slice(0,t.length)+i("",u,"0",!0)+e.slice(t.length)),e},o=function(e,t,n,r,o,u,s){var c=e>>>0;return n=n&&c&&{2:"0b",8:"0",16:"0x"}[t]||"",e=n+i(c.toString(t),u||0,"0",!1),a(e,n,r,o,s)},u=function(e,t,n,r,i,o){return null!=r&&(e=e.slice(0,r)),a(e,"",t,n,i,o)},s=function(e,r,s,c,l,f,h){var d,p,y,E,m;if("%%"==e)return"%";for(var _=!1,v="",T=!1,R=!1,g=" ",A=s.length,S=0;s&&S<A;S++)switch(s.charAt(S)){case" ":v=" ";break;case"+":v="+";break;case"-":_=!0;break;case"'":g=s.charAt(S+1);break;case"0":T=!0;break;case"#":R=!0}if(c=c?"*"==c?+t[n++]:"*"==c.charAt(0)?+t[c.slice(1,-1)]:+c:0,c<0&&(c=-c,_=!0),!isFinite(c))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+t[n++]:"*"==f.charAt(0)?+t[f.slice(1,-1)]:+f:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,m=r?t[r.slice(0,-1)]:t[n++],h){case"s":return u(String(m),_,c,f,T,g);case"c":return u(String.fromCharCode(+m),_,c,f,T);case"b":return o(m,2,R,_,c,f,T);case"o":return o(m,8,R,_,c,f,T);case"x":return o(m,16,R,_,c,f,T);case"X":return o(m,16,R,_,c,f,T).toUpperCase();case"u":return o(m,10,R,_,c,f,T);case"i":case"d":return d=+m||0,d=Math.round(d-d%1),p=d<0?"-":v,m=p+i(String(Math.abs(d)),f,"0",!1),a(m,p,_,c,T);case"e":case"E":case"f":case"F":case"g":case"G":return d=+m,p=d<0?"-":v,y=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],E=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],m=p+Math.abs(d)[y](f),a(m,p,_,c,T)[E]();default:return e}};return r.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";function e(e,t,n,r,i,a,o,u){this.year=e,this.month=t,this.day=n,this.hour=r,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=u}return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(e){return e%4===0&&e%100!==0||e%400===0}return t}),define("Core/LeapSecond",[],function(){"use strict";function e(e,t){this.julianDate=e,this.offset=t}return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,n,r,i,a,o,u,s,c){"use strict";function l(e,t){return y.compare(e.julianDate,t.julianDate)}function f(e){v.julianDate=e;var n=y.leapSeconds,r=t(n,v,l);r<0&&(r=~r),r>=n.length&&(r=n.length-1);var i=n[r].offset;if(r>0){var a=y.secondsDifference(n[r].julianDate,e);a>i&&(r--,i=n[r].offset)}y.addSeconds(e,i,e)}function h(e,n){v.julianDate=e;var r=y.leapSeconds,i=t(r,v,l);if(i<0&&(i=~i),0===i)return y.addSeconds(e,-r[0].offset,n);if(i>=r.length)return y.addSeconds(e,-r[i-1].offset,n);var a=y.secondsDifference(r[i].julianDate,e);return 0===a?y.addSeconds(e,-r[i].offset,n):a<=1?void 0:y.addSeconds(e,-r[--i].offset,n)}function d(e,t,n){var r=t/s.SECONDS_PER_DAY|0;return e+=r,t-=s.SECONDS_PER_DAY*r,t<0&&(e--,t+=s.SECONDS_PER_DAY),n.dayNumber=e,n.secondsOfDay=t,n}function p(e,t,n,r,i,a,o){var u=(t-14)/12|0,c=e+4800+u,l=(1461*c/4|0)+(367*(t-2-12*u)/12|0)-(3*((c+100)/100|0)/4|0)+n-32075;r-=12,r<0&&(r+=24);var f=a+(r*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(l-=1),[l,f]}function y(e,t,r){this.dayNumber=void 0,this.secondsOfDay=void 0,e=n(e,0),t=n(t,0),r=n(r,c.UTC);var i=0|e;t+=(e-i)*s.SECONDS_PER_DAY,d(i,t,this),r===c.UTC&&f(this)}var E=new a,m=[31,28,31,30,31,30,31,31,30,31,30,31],_=29,v=new u,T=/^(\d{4})$/,R=/^(\d{4})-(\d{2})$/,g=/^(\d{4})-?(\d{3})$/,A=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,S=/^(\d{4})-?(\d{2})-?(\d{2})$/,N=/([Z+\-])?(\d{2})?:?(\d{2})?$/,x=/^(\d{2})(\.\d+)?/.source+N.source,I=/^(\d{2}):?(\d{2})(\.\d+)?/.source+N.source,O=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+N.source;y.fromDate=function(e,t){var n=p(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return r(t)?(d(n[0],n[1],t),f(t),t):new y(n[0],n[1],c.UTC)},y.fromIso8601=function(e,t){e=e.replace(",",".");var n,i,a,u=e.split("T"),s=1,l=1,h=0,E=0,v=0,N=0,w=u[0],M=u[1];if(u=w.match(S),null!==u)n=+u[1],s=+u[2],l=+u[3];else if(u=w.match(R),null!==u)n=+u[1],s=+u[2];else if(u=w.match(T),null!==u)n=+u[1];else{var C;if(u=w.match(g),null!==u)n=+u[1],C=+u[2],a=o(n);else if(u=w.match(A),null!==u){n=+u[1];var P=+u[2],D=+u[3]||0,L=new Date(Date.UTC(n,0,4));C=7*P+D-L.getUTCDay()-3}i=new Date(Date.UTC(n,0,1)),i.setUTCDate(C),s=i.getUTCMonth()+1,l=i.getUTCDate()}a=o(n);var U;if(r(M)){u=M.match(O),null!==u?(h=+u[1],E=+u[2],v=+u[3],N=1e3*+(u[4]||0),U=5):(u=M.match(I),null!==u?(h=+u[1],E=+u[2],v=60*+(u[3]||0),U=4):(u=M.match(x),null!==u&&(h=+u[1],E=60*+(u[2]||0),U=3)));var b=u[U],F=+u[U+1],z=+(u[U+2]||0);switch(b){case"+":h-=F,E-=z;break;case"-":h+=F,E+=z;break;case"Z":break;default:E+=new Date(Date.UTC(n,s-1,l,h,E)).getTimezoneOffset()}}else E+=new Date(n,s-1,l).getTimezoneOffset();var B=60===v;for(B&&v--;E>=60;)E-=60,h++;for(;h>=24;)h-=24,l++;for(i=a&&2===s?_:m[s-1];l>i;)l-=i,s++,s>12&&(s-=12,n++),i=a&&2===s?_:m[s-1];for(;E<0;)E+=60,h--;for(;h<0;)h+=24,l--;for(;l<1;)s--,s<1&&(s+=12,n--),i=a&&2===s?_:m[s-1],l+=i;var G=p(n,s,l,h,E,v,N);return r(t)?(d(G[0],G[1],t),f(t)):t=new y(G[0],G[1],c.UTC),B&&y.addSeconds(t,1,t),t},y.now=function(e){return y.fromDate(new Date,e)};var w=new y(0,0,c.TAI);return y.toGregorianDate=function(e,t){var n=!1,i=h(e,w);r(i)||(y.addSeconds(e,-1,w),i=h(w,w),n=!0);var o=i.dayNumber,u=i.secondsOfDay;u>=43200&&(o+=1);var c=o+68569|0,l=4*c/146097|0;c=c-((146097*l+3)/4|0)|0;var f=4e3*(c+1)/1461001|0;c=c-(1461*f/4|0)+31|0;var d=80*c/2447|0,p=c-(2447*d/80|0)|0;c=d/11|0;var E=d+2-12*c|0,m=100*(l-49)+f+c|0,_=u/s.SECONDS_PER_HOUR|0,v=u-_*s.SECONDS_PER_HOUR,T=v/s.SECONDS_PER_MINUTE|0;v-=T*s.SECONDS_PER_MINUTE;var R=0|v,g=(v-R)/s.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),n&&(R+=1),r(t)?(t.year=m,t.month=E,t.day=p,t.hour=_,t.minute=T,t.second=R,t.millisecond=g,t.isLeapSecond=n,t):new a(m,E,p,_,T,R,g,n)},y.toDate=function(e){var t=y.toGregorianDate(e,E),n=t.second;return t.isLeapSecond&&(n-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,n,t.millisecond))},y.toIso8601=function(t,n){var i,a=y.toGregorianDate(t,a);return r(n)||0===a.millisecond?r(n)&&0!==n?(i=(.01*a.millisecond).toFixed(n).replace(".","").slice(0,n),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a.year,a.month,a.day,a.hour,a.minute,a.second,i)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",a.year,a.month,a.day,a.hour,a.minute,a.second):(i=(.01*a.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a.year,a.month,a.day,a.hour,a.minute,a.second,i))},y.clone=function(e,t){if(r(e))return r(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new y(e.dayNumber,e.secondsOfDay,c.TAI)},y.compare=function(e,t){var n=e.dayNumber-t.dayNumber;return 0!==n?n:e.secondsOfDay-t.secondsOfDay},y.equals=function(e,t){return e===t||r(e)&&r(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},y.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(y.secondsDifference(e,t))<=n},y.totalDays=function(e){return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},y.secondsDifference=function(e,t){var n=(e.dayNumber-t.dayNumber)*s.SECONDS_PER_DAY;return n+(e.secondsOfDay-t.secondsOfDay)},y.daysDifference=function(e,t){var n=e.dayNumber-t.dayNumber,r=(e.secondsOfDay-t.secondsOfDay)/s.SECONDS_PER_DAY;return n+r},y.computeTaiMinusUtc=function(e){v.julianDate=e;var n=y.leapSeconds,r=t(n,v,l);return r<0&&(r=~r,--r,r<0&&(r=0)),n[r].offset},y.addSeconds=function(e,t,n){return d(e.dayNumber,e.secondsOfDay+t,n)},y.addMinutes=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_MINUTE;return d(e.dayNumber,r,n)},y.addHours=function(e,t,n){var r=e.secondsOfDay+t*s.SECONDS_PER_HOUR;return d(e.dayNumber,r,n)},y.addDays=function(e,t,n){var r=e.dayNumber+t;return d(r,e.secondsOfDay,n)},y.lessThan=function(e,t){return y.compare(e,t)<0},y.lessThanOrEquals=function(e,t){return y.compare(e,t)<=0},y.greaterThan=function(e,t){return y.compare(e,t)>0},y.greaterThanOrEquals=function(e,t){return y.compare(e,t)>=0},y.prototype.clone=function(e){return y.clone(this,e)},y.prototype.equals=function(e){return y.equals(this,e)},y.prototype.equalsEpsilon=function(e,t){return y.equalsEpsilon(this,e,t)},y.prototype.toString=function(){return y.toIso8601(this)},y.leapSeconds=[new u(new y(2441317,43210,c.TAI),10),new u(new y(2441499,43211,c.TAI),11),new u(new y(2441683,43212,c.TAI),12),new u(new y(2442048,43213,c.TAI),13),new u(new y(2442413,43214,c.TAI),14),new u(new y(2442778,43215,c.TAI),15),new u(new y(2443144,43216,c.TAI),16),new u(new y(2443509,43217,c.TAI),17),new u(new y(2443874,43218,c.TAI),18),new u(new y(2444239,43219,c.TAI),19),new u(new y(2444786,43220,c.TAI),20),new u(new y(2445151,43221,c.TAI),21),new u(new y(2445516,43222,c.TAI),22),new u(new y(2446247,43223,c.TAI),23),new u(new y(2447161,43224,c.TAI),24),new u(new y(2447892,43225,c.TAI),25),new u(new y(2448257,43226,c.TAI),26),new u(new y(2448804,43227,c.TAI),27),new u(new y(2449169,43228,c.TAI),28),new u(new y(2449534,43229,c.TAI),29),new u(new y(2450083,43230,c.TAI),30),new u(new y(2450630,43231,c.TAI),31),new u(new y(2451179,43232,c.TAI),32),new u(new y(2453736,43233,c.TAI),33),new u(new y(2454832,43234,c.TAI),34),new u(new y(2456109,43235,c.TAI),35),new u(new y(2457204,43236,c.TAI),36),new u(new y(2457754,43237,c.TAI),37)],y}),define("Core/clone",["./defaultValue"],function(e){"use strict";function t(n,r){if(null===n||"object"!=typeof n)return n;r=e(r,!1);var i=new n.constructor;for(var a in n)if(n.hasOwnProperty(a)){var o=n[a];r&&(o=t(o,r)),i[a]=o}return i}return t}),define("Core/parseResponseHeaders",[],function(){"use strict";function e(e){var t={};if(!e)return t;for(var n=e.split("\r\n"),r=0;r<n.length;++r){var i=n[r],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);t[o]=u}}return t}return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";function n(e,n,r){this.statusCode=e,this.response=n,this.responseHeaders=r,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders))}return n.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},n}),define("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var n=r.exec(t);this.scheme=n[1],this.authority=n[2],this.path=n[3],this.query=n[4],this.fragment=n[5]}}function t(e){var t=unescape(e);return a.test(t)?t:e.toUpperCase()}function n(e,t,n,r){return(t||"")+n.toLowerCase()+(r||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var r=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,n).replace(i,t)),this.path&&(this.path=this.path.replace(i,t)),this.query&&(this.query=this.query.replace(i,t)),this.fragment&&(this.fragment=this.fragment.replace(i,t))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var n=new e;return this.scheme?(n.scheme=this.scheme,n.authority=this.authority,n.path=this.path,n.query=this.query):(n.scheme=t.scheme,this.authority?(n.authority=this.authority,n.path=this.path,n.query=this.query):(n.authority=t.authority,""==this.path?(n.path=t.path,n.query=this.query||t.query):("/"==this.path.charAt(0)?(n.path=this.path,n.removeDotSegments()):(t.authority&&""==t.path?n.path="/"+this.path:n.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,n.removeDotSegments()),n.query=this.query))),n.fragment=this.fragment,n},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),n=[],r=""==t[0];r&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?n.pop():"."!=e&&n.push(e);"."!=e&&".."!=e||n.push(""),r&&n.unshift(""),this.path=n.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/TrustedServers",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,n){"use strict";function r(n){var r=new e(n);r.normalize();var i=r.getAuthority();if(t(i)){if(i.indexOf("@")!==-1){var a=i.split("@");i=a[1]}if(i.indexOf(":")===-1){var o=r.getScheme();if(t(o)||(o=window.location.protocol,o=o.substring(0,o.length-1)),"http"===o)i+=":80";else{if("https"!==o)return;i+=":443"}}return i}}var i={},a={};return i.add=function(e,n){var r=e.toLowerCase()+":"+n;t(a[r])||(a[r]=!0)},i.remove=function(e,n){var r=e.toLowerCase()+":"+n;t(a[r])&&delete a[r]},i.contains=function(e){var n=r(e);return!(!t(n)||!t(a[n]))},i.clear=function(){a={}},i}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError","./TrustedServers"],function(e,t,n,r,i,a,o){"use strict";function u(n){n=t(n,t.EMPTY_OBJECT);var r=n.responseType,i=t(n.method,"GET"),a=n.data,o=n.headers,s=n.overrideMimeType;return e(n.url,function(t){var n=e.defer();return u.load(t,r,i,a,o,n,s),n.promise})}function s(e,t){var n=decodeURIComponent(t);return e?atob(n):n}function c(e,t){for(var n=s(e,t),r=new ArrayBuffer(n.length),i=new Uint8Array(r),a=0;a<n.length;a++)i[a]=n.charCodeAt(a);return r}function l(e,n){n=t(n,"");var r=e[1],i=!!e[2],a=e[3];switch(n){case"":case"text":return s(i,a);case"arraybuffer":return c(i,a);case"blob":var o=c(i,a);return new Blob([o],{type:r});case"document":var u=new DOMParser;return u.parseFromString(s(i,a),r);case"json":return JSON.parse(s(i,a))}}var f=/^data:(.*?)(;base64)?,(.*)$/;return u.load=function(e,t,r,u,s,c,h){var d=f.exec(e);if(null!==d)return void c.resolve(l(d,t));var p=new XMLHttpRequest;if(o.contains(e)&&(p.withCredentials=!0),n(h)&&n(p.overrideMimeType)&&p.overrideMimeType(h),p.open(r,e,!0),n(s))for(var y in s)s.hasOwnProperty(y)&&p.setRequestHeader(y,s[y]);n(t)&&(p.responseType=t),p.onload=function(){if(p.status<200||p.status>=300)return void c.reject(new i(p.status,p.response,p.getAllResponseHeaders()));var e=p.response,r=p.responseType;if(!n(e)||n(t)&&r!==t)if("json"===t&&"string"==typeof e)try{c.resolve(JSON.parse(e))}catch(e){c.reject(e)}else(""===r||"document"===r)&&n(p.responseXML)&&p.responseXML.hasChildNodes()?c.resolve(p.responseXML):""!==r&&"text"!==r||!n(p.responseText)?c.reject(new a("Invalid XMLHttpRequest response type.")):c.resolve(p.responseText);else c.resolve(e)},p.onerror=function(e){c.reject(new i)},p.send(u)},u.defaultLoad=u.load,u}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";function t(t,n){return e({url:t,headers:n})}return t}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,n,r){"use strict";function i(n,i){return t(i)?t(i.Accept)||(i=e(i),i.Accept=a.Accept):i=a,r(n,i).then(function(e){return JSON.parse(e)})}var a={Accept:"application/json,*/*;q=0.01"};return i}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,n,r,i,a,o,u,s,c,l,f){"use strict";function h(t){if(t=n(t,n.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=n(t.addNewLeapSeconds,!0),r(t.data))p(this,t.data);else if(r(t.url)){var i=this;this._downloadPromise=e(s(t.url),function(e){p(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else p(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function d(e,t){return o.compare(e.julianDate,t)}function p(e,n){if(!r(n.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!r(n.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var i=n.columnNames.indexOf("modifiedJulianDateUtc"),a=n.columnNames.indexOf("xPoleWanderRadians"),s=n.columnNames.indexOf("yPoleWanderRadians"),c=n.columnNames.indexOf("ut1MinusUtcSeconds"),h=n.columnNames.indexOf("xCelestialPoleOffsetRadians"),p=n.columnNames.indexOf("yCelestialPoleOffsetRadians"),y=n.columnNames.indexOf("taiMinusUtcSeconds");if(i<0||a<0||s<0||c<0||h<0||p<0||y<0)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var E=e._samples=n.samples,m=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=c,e._xCelestialPoleOffsetRadiansColumn=h,e._yCelestialPoleOffsetRadiansColumn=p,e._taiMinusUtcSecondsColumn=y,e._columnCount=n.columnNames.length,e._lastIndex=void 0;for(var _,v=e._addNewLeapSeconds,T=0,R=E.length;T<R;T+=e._columnCount){var g=E[T+i],A=E[T+y],S=g+l.MODIFIED_JULIAN_DATE_DIFFERENCE,N=new o(S,A,f.TAI);if(m.push(N),v){if(A!==_&&r(_)){var x=o.leapSeconds,I=t(x,N,d);if(I<0){var O=new u(N,A);x.splice(~I,0,O)}}_=A}}}function y(e,t,n,r,i){var a=n*r;i.xPoleWander=t[a+e._xPoleWanderRadiansColumn],i.yPoleWander=t[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=t[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=t[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=t[a+e._ut1MinusUtcSecondsColumn]}function E(e,t,n){return t+e*(n-t)}function m(e,t,n,r,i,a,u){var s=e._columnCount;if(a>t.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var c=t[i],l=t[a];if(c.equals(l)||r.equals(c))return y(e,n,i,s,u),u;if(r.equals(l))return y(e,n,a,s,u),u;var f=o.secondsDifference(r,c)/o.secondsDifference(l,c),h=i*s,d=a*s,p=n[h+e._ut1MinusUtcSecondsColumn],m=n[d+e._ut1MinusUtcSecondsColumn],_=m-p;if(_>.5||_<-.5){var v=n[h+e._taiMinusUtcSecondsColumn],T=n[d+e._taiMinusUtcSecondsColumn];v!==T&&(l.equals(r)?p=m:m-=T-v)}return u.xPoleWander=E(f,n[h+e._xPoleWanderRadiansColumn],n[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=E(f,n[h+e._yPoleWanderRadiansColumn],n[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=E(f,n[h+e._xCelestialPoleOffsetRadiansColumn],n[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=E(f,n[h+e._yCelestialPoleOffsetRadiansColumn],n[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=E(f,p,m),u}return h.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,t){return r(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new i(0,0,0,0,0),t}}),h.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},h.prototype.compute=function(e,n){if(r(this._samples)){if(r(n)||(n=new i(0,0,0,0,0)),0===this._samples.length)return n.xPoleWander=0,n.yPoleWander=0,n.xPoleOffset=0,n.yPoleOffset=0,n.ut1MinusUtc=0,n;var a=this._dates,u=this._lastIndex,s=0,l=0;if(r(u)){var f=a[u],h=a[u+1],d=o.lessThanOrEquals(f,e),p=!r(h),y=p||o.greaterThanOrEquals(h,e);if(d&&y)return s=u,!p&&h.equals(e)&&++s,l=s+1,m(this,a,this._samples,e,s,l,n),n}var E=t(a,e,o.compare,this._dateColumn);return E>=0?(E<a.length-1&&a[E+1].equals(e)&&++E,s=E,l=E):(l=~E,s=l-1,s<0&&(s=0)),this._lastIndex=s,m(this,a,this._samples,e,s,l,n),n}if(r(this._dataError))throw new c(this._dataError)},h}),define("Core/HeadingPitchRoll",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,n,r){"use strict";function i(t,n,r){this.heading=e(t,0),this.pitch=e(n,0),this.roll=e(r,0)}return i.fromQuaternion=function(e,n){t(n)||(n=new i);var r=2*(e.w*e.y-e.z*e.x),a=1-2*(e.x*e.x+e.y*e.y),o=2*(e.w*e.x+e.y*e.z),u=1-2*(e.y*e.y+e.z*e.z),s=2*(e.w*e.z+e.x*e.y);return n.heading=-Math.atan2(s,u),n.roll=Math.atan2(o,a),n.pitch=-Math.asin(r),n},i.fromDegrees=function(e,n,a,o){return t(o)||(o=new i),o.heading=e*r.RADIANS_PER_DEGREE,o.pitch=n*r.RADIANS_PER_DEGREE,o.roll=a*r.RADIANS_PER_DEGREE,o},i.clone=function(e,n){if(t(e))return t(n)?(n.heading=e.heading,n.pitch=e.pitch,n.roll=e.roll,n):new i(e.heading,e.pitch,e.roll)},i.equals=function(e,n){return e===n||t(e)&&t(n)&&e.heading===n.heading&&e.pitch===n.pitch&&e.roll===n.roll},i.equalsEpsilon=function(e,n,i,a){return e===n||t(e)&&t(n)&&r.equalsEpsilon(e.heading,n.heading,i,a)&&r.equalsEpsilon(e.pitch,n.pitch,i,a)&&r.equalsEpsilon(e.roll,n.roll,i,a)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.equalsEpsilon=function(e,t,n){return i.equalsEpsilon(this,e,t,n)},i.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"},i}),define("Core/getAbsoluteUri",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";function i(n,r){r=t(r,document.location.href);var i=new e(r),a=new e(n);return a.resolve(i).toString()}return i}),define("Core/joinUrls",["../ThirdParty/Uri","./defaultValue","./defined","./DeveloperError"],function(e,t,n,r){"use strict";function i(r,i,a){a=t(a,!0),r instanceof e||(r=new e(r)),i instanceof e||(i=new e(i)),n(i.authority)&&!n(i.scheme)&&("undefined"!=typeof document&&n(document.location)&&n(document.location.href)?i.scheme=new e(document.location.href).scheme:i.scheme=r.scheme);var o=r;i.isAbsolute()&&(o=i);var u="";n(o.scheme)&&(u+=o.scheme+":"),n(o.authority)&&(u+="//"+o.authority,""!==o.path&&"/"!==o.path&&(u=u.replace(/\/?$/,"/"),o.path=o.path.replace(/^\/?/g,""))),u+=o===r?a?r.path.replace(/\/?$/,"/")+i.path.replace(/^\/?/g,""):r.path+i.path:i.path;var s=n(r.query),c=n(i.query);s&&c?u+="?"+r.query+"&"+i.query:s&&!c?u+="?"+r.query:!s&&c&&(u+="?"+i.query);var l=n(i.fragment);return n(r.fragment)&&!l?u+="#"+r.fragment:l&&(u+="#"+i.fragment),u}return i}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","./getAbsoluteUri","./joinUrls","require"],function(e,t,n,r,i,a){"use strict";function o(){for(var e=document.getElementsByTagName("script"),t=0,n=e.length;t<n;++t){var r=e[t].getAttribute("src"),i=p.exec(r);if(null!==i)return i[1]}}function u(){if(t(f))return f;var n;return n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:o(),f=new e(r(n))}function s(e){return a.toUrl("../"+e)}function c(e){return i(u(),e)}function l(e){t(h)||(h=t(a.toUrl)?s:c),t(d)||(d=document.createElement("a"));
var n=h(e);return d.href=n,d.href=d.href,d.href}var f,h,d,p=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i;return l._cesiumScriptRegex=p,l.setBaseUrl=function(t){f=new e(t).resolve(new e(document.location.href))},l}),define("Core/Iau2006XysSample",[],function(){"use strict";function e(e,t,n){this.x=e,this.y=t,this.s=n}return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,n,r,i,a,o,u){"use strict";function s(e){e=n(e,n.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=n(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=n(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=n(e.stepSizeDays,1),this._samplesPerXysFile=n(e.samplesPerXysFile,1e3),this._totalSamples=n(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,r=this._denominators=new Array(t+1),i=this._xTable=new Array(t+1),o=Math.pow(this._stepSizeDays,t),s=0;s<=t;++s){r[s]=o,i[s]=s*this._stepSizeDays;for(var c=0;c<=t;++c)c!==s&&(r[s]*=s-c);r[s]=1/r[s]}this._work=new Array(t+1),this._coef=new Array(t+1)}function c(e,t,n){var r=f;return r.dayNumber=t,r.secondsOfDay=n,a.daysDifference(r,e._sampleZeroDateTT)}function l(n,i){if(n._chunkDownloadsInProgress[i])return n._chunkDownloadsInProgress[i];var a=e.defer();n._chunkDownloadsInProgress[i]=a;var u,s=n._xysFileUrlTemplate;return u=r(s)?s.replace("{0}",i):t("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),e(o(u),function(e){n._chunkDownloadsInProgress[i]=!1;for(var t=n._samples,r=e.samples,o=i*n._samplesPerXysFile*3,u=0,s=r.length;u<s;++u)t[o+u]=r[u];a.resolve()}),a.promise}var f=new a(0,0,u.TAI);return s.prototype.preload=function(t,n,r,i){var a=c(this,t,n),o=c(this,r,i),u=a/this._stepSizeDays-this._interpolationOrder/2|0;u<0&&(u=0);var s=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;s>=this._totalSamples&&(s=this._totalSamples-1);for(var f=u/this._samplesPerXysFile|0,h=s/this._samplesPerXysFile|0,d=[],p=f;p<=h;++p)d.push(l(this,p));return e.all(d)},s.prototype.computeXysRadians=function(e,t,n){var a=c(this,e,t);if(!(a<0)){var o=a/this._stepSizeDays|0;if(!(o>=this._totalSamples)){var u=this._interpolationOrder,s=o-(u/2|0);s<0&&(s=0);var f=s+u;f>=this._totalSamples&&(f=this._totalSamples-1,s=f-u,s<0&&(s=0));var h=!1,d=this._samples;if(r(d[3*s])||(l(this,s/this._samplesPerXysFile|0),h=!0),r(d[3*f])||(l(this,f/this._samplesPerXysFile|0),h=!0),!h){r(n)?(n.x=0,n.y=0,n.s=0):n=new i(0,0,0);var p,y,E=a-s*this._stepSizeDays,m=this._work,_=this._denominators,v=this._coef,T=this._xTable;for(p=0;p<=u;++p)m[p]=E-T[p];for(p=0;p<=u;++p){for(v[p]=1,y=0;y<=u;++y)y!==p&&(v[p]*=m[y]);v[p]*=_[p];var R=3*(s+p);n.x+=v[p]*d[R++],n.y+=v[p]*d[R++],n.s+=v[p]*d[R]}return n}}}},s}),define("Core/Quaternion",["./Cartesian3","./Check","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,n,r,i,a,o,u,s){"use strict";function c(e,t,r,i){this.x=n(e,0),this.y=n(t,0),this.z=n(r,0),this.w=n(i,0)}var l=new e;c.fromAxisAngle=function(t,n,i){var a=n/2,o=Math.sin(a);l=e.normalize(t,l);var u=l.x*o,s=l.y*o,f=l.z*o,h=Math.cos(a);return r(i)?(i.x=u,i.y=s,i.z=f,i.w=h,i):new c(u,s,f,h)};var f=[1,2,0],h=new Array(3);c.fromRotationMatrix=function(e,t){var n,i,a,o,u,l=e[s.COLUMN0ROW0],d=e[s.COLUMN1ROW1],p=e[s.COLUMN2ROW2],y=l+d+p;if(y>0)n=Math.sqrt(y+1),u=.5*n,n=.5/n,i=(e[s.COLUMN1ROW2]-e[s.COLUMN2ROW1])*n,a=(e[s.COLUMN2ROW0]-e[s.COLUMN0ROW2])*n,o=(e[s.COLUMN0ROW1]-e[s.COLUMN1ROW0])*n;else{var E=f,m=0;d>l&&(m=1),p>l&&p>d&&(m=2);var _=E[m],v=E[_];n=Math.sqrt(e[s.getElementIndex(m,m)]-e[s.getElementIndex(_,_)]-e[s.getElementIndex(v,v)]+1);var T=h;T[m]=.5*n,n=.5/n,u=(e[s.getElementIndex(v,_)]-e[s.getElementIndex(_,v)])*n,T[_]=(e[s.getElementIndex(_,m)]+e[s.getElementIndex(m,_)])*n,T[v]=(e[s.getElementIndex(v,m)]+e[s.getElementIndex(m,v)])*n,i=-T[0],a=-T[1],o=-T[2]}return r(t)?(t.x=i,t.y=a,t.z=o,t.w=u,t):new c(i,a,o,u)};var d=new c;c.fromHeadingPitchRoll=function(t,n,r,i){var a=c.fromAxisAngle(e.UNIT_X,r,d),o=c.fromAxisAngle(e.UNIT_Y,-n,i);i=c.multiply(o,a,o);var u=c.fromAxisAngle(e.UNIT_Z,-t,d);return c.multiply(u,i,i)};var p=new e,y=new e,E=new c,m=new c,_=new c;c.packedLength=4,c.pack=function(e,t,r){return r=n(r,0),t[r++]=e.x,t[r++]=e.y,t[r++]=e.z,t[r]=e.w,t},c.unpack=function(e,t,i){return t=n(t,0),r(i)||(i=new c),i.x=e[t],i.y=e[t+1],i.z=e[t+2],i.w=e[t+3],i},c.packedInterpolationLength=3,c.convertPackedArrayForInterpolation=function(e,t,n,r){c.unpack(e,4*n,_),c.conjugate(_,_);for(var i=0,a=n-t+1;i<a;i++){var o=3*i;c.unpack(e,4*(t+i),E),c.multiply(E,_,E),E.w<0&&c.negate(E,E),c.computeAxis(E,p);var u=c.computeAngle(E);r[o]=p.x*u,r[o+1]=p.y*u,r[o+2]=p.z*u}},c.unpackInterpolationResult=function(t,n,i,a,o){r(o)||(o=new c),e.fromArray(t,0,y);var u=e.magnitude(y);return c.unpack(n,4*a,m),0===u?c.clone(c.IDENTITY,E):c.fromAxisAngle(y,u,E),c.multiply(E,m,o)},c.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new c(e.x,e.y,e.z,e.w)},c.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},c.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},c.magnitude=function(e){return Math.sqrt(c.magnitudeSquared(e))},c.normalize=function(e,t){var n=1/c.magnitude(e),r=e.x*n,i=e.y*n,a=e.z*n,o=e.w*n;return t.x=r,t.y=i,t.z=a,t.w=o,t},c.inverse=function(e,t){var n=c.magnitudeSquared(e);return t=c.conjugate(e,t),c.multiplyByScalar(t,1/n,t)},c.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},c.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},c.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},c.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},c.multiply=function(e,t,n){var r=e.x,i=e.y,a=e.z,o=e.w,u=t.x,s=t.y,c=t.z,l=t.w,f=o*u+r*l+i*c-a*s,h=o*s-r*c+i*l+a*u,d=o*c+r*s-i*u+a*l,p=o*l-r*u-i*s-a*c;return n.x=f,n.y=h,n.z=d,n.w=p,n},c.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},c.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},c.computeAxis=function(e,t){var n=e.w;if(Math.abs(n-1)<u.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-n*n);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},c.computeAngle=function(e){return Math.abs(e.w-1)<u.EPSILON6?0:2*Math.acos(e.w)};var v=new c;c.lerp=function(e,t,n,r){return v=c.multiplyByScalar(t,n,v),r=c.multiplyByScalar(e,1-n,r),c.add(v,r,r)};var T=new c,R=new c,g=new c;c.slerp=function(e,t,n,r){var i=c.dot(e,t),a=t;if(i<0&&(i=-i,a=T=c.negate(t,T)),1-i<u.EPSILON6)return c.lerp(e,a,n,r);var o=Math.acos(i);return R=c.multiplyByScalar(e,Math.sin((1-n)*o),R),g=c.multiplyByScalar(a,Math.sin(n*o),g),r=c.add(R,g,r),c.multiplyByScalar(r,1/Math.sin(o),r)},c.log=function(t,n){var r=u.acosClamped(t.w),i=0;return 0!==r&&(i=r/Math.sin(r)),e.multiplyByScalar(t,i,n)},c.exp=function(t,n){var r=e.magnitude(t),i=0;return 0!==r&&(i=Math.sin(r)/r),n.x=t.x*i,n.y=t.y*i,n.z=t.z*i,n.w=Math.cos(r),n};var A=new e,S=new e,N=new c,x=new c;c.computeInnerQuadrangle=function(t,n,r,i){var a=c.conjugate(n,N);c.multiply(a,r,x);var o=c.log(x,A);c.multiply(a,t,x);var u=c.log(x,S);return e.add(o,u,o),e.multiplyByScalar(o,.25,o),e.negate(o,o),c.exp(o,N),c.multiply(n,N,i)},c.squad=function(e,t,n,r,i,a){var o=c.slerp(e,t,i,N),u=c.slerp(n,r,i,x);return c.slerp(o,u,2*i*(1-i),a)};for(var I=new c,O=1.9011074535173003,w=a.supportsTypedArrays()?new Float32Array(8):[],M=a.supportsTypedArrays()?new Float32Array(8):[],C=a.supportsTypedArrays()?new Float32Array(8):[],P=a.supportsTypedArrays()?new Float32Array(8):[],D=0;D<7;++D){var L=D+1,U=2*L+1;w[D]=1/(L*U),M[D]=L/U}return w[7]=O/136,M[7]=8*O/17,c.fastSlerp=function(e,t,n,r){var i,a=c.dot(e,t);a>=0?i=1:(i=-1,a=-a);for(var o=a-1,u=1-n,s=n*n,l=u*u,f=7;f>=0;--f)C[f]=(w[f]*s-M[f])*o,P[f]=(w[f]*l-M[f])*o;var h=i*n*(1+C[0]*(1+C[1]*(1+C[2]*(1+C[3]*(1+C[4]*(1+C[5]*(1+C[6]*(1+C[7])))))))),d=u*(1+P[0]*(1+P[1]*(1+P[2]*(1+P[3]*(1+P[4]*(1+P[5]*(1+P[6]*(1+P[7])))))))),p=c.multiplyByScalar(e,d,I);return c.multiplyByScalar(t,h,r),c.add(p,r,r)},c.fastSquad=function(e,t,n,r,i,a){var o=c.fastSlerp(e,t,i,N),u=c.fastSlerp(n,r,i,x);return c.fastSlerp(o,u,2*i*(1-i),a)},c.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},c.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},c.ZERO=o(new c(0,0,0,0)),c.IDENTITY=o(new c(0,0,0,1)),c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.prototype.equalsEpsilon=function(e,t){return c.equalsEpsilon(this,e,t)},c.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},c}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./Check","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./HeadingPitchRoll","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,n,r,i,a,o,u,s,c,l,f,h,d,p,y,E,m,_,v,T){"use strict";var R={},g=new n,A=new n,S=new n;R.eastNorthUpToFixedFrame=function(e,t,r){if(E.equalsEpsilon(e.x,0,E.EPSILON14)&&E.equalsEpsilon(e.y,0,E.EPSILON14)){var i=E.sign(e.z);return u(r)?(r[0]=0,r[1]=1,r[2]=0,r[3]=0,r[4]=-i,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=i,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(0,-i,0,e.x,1,0,0,e.y,0,0,i,e.z,0,0,0,1)}var a=g,s=A,c=S;return t=o(t,f.WGS84),t.geodeticSurfaceNormal(e,a),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(a,s,c),u(r)?(r[0]=s.x,r[1]=s.y,r[2]=s.z,r[3]=0,r[4]=c.x,r[5]=c.y,r[6]=c.z,r[7]=0,r[8]=a.x,r[9]=a.y,r[10]=a.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(s.x,c.x,a.x,e.x,s.y,c.y,a.y,e.y,s.z,c.z,a.z,e.z,0,0,0,1)};var N=new n,x=new n,I=new n;R.northEastDownToFixedFrame=function(e,t,r){if(E.equalsEpsilon(e.x,0,E.EPSILON14)&&E.equalsEpsilon(e.y,0,E.EPSILON14)){var i=E.sign(e.z);return u(r)?(r[0]=-i,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=1,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=-i,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(-i,0,0,e.x,0,1,0,e.y,0,0,-i,e.z,0,0,0,1)}var a=N,s=x,c=I;return t=o(t,f.WGS84),t.geodeticSurfaceNormal(e,a),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(a,s,c),u(r)?(r[0]=c.x,r[1]=c.y,r[2]=c.z,r[3]=0,r[4]=s.x,r[5]=s.y,r[6]=s.z,r[7]=0,r[8]=-a.x,r[9]=-a.y,r[10]=-a.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(c.x,s.x,-a.x,e.x,c.y,s.y,-a.y,e.y,c.z,s.z,-a.z,e.z,0,0,0,1)},R.northUpEastToFixedFrame=function(e,t,r){if(E.equalsEpsilon(e.x,0,E.EPSILON14)&&E.equalsEpsilon(e.y,0,E.EPSILON14)){var i=E.sign(e.z);return u(r)?(r[0]=-i,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=i,r[7]=0,r[8]=0,r[9]=1,r[10]=0,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(-i,0,0,e.x,0,0,1,e.y,0,i,0,e.z,0,0,0,1)}var a=g,s=A,c=S;return t=o(t,f.WGS84),t.geodeticSurfaceNormal(e,a),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(a,s,c),u(r)?(r[0]=c.x,r[1]=c.y,r[2]=c.z,r[3]=0,r[4]=a.x,r[5]=a.y,r[6]=a.z,r[7]=0,r[8]=s.x,r[9]=s.y,r[10]=s.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(c.x,a.x,s.x,e.x,c.y,a.y,s.y,e.y,c.z,a.z,s.z,e.z,0,0,0,1)},R.northWestUpToFixedFrame=function(e,t,r){if(E.equalsEpsilon(e.x,0,E.EPSILON14)&&E.equalsEpsilon(e.y,0,E.EPSILON14)){var i=E.sign(e.z);return u(r)?(r[0]=-i,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=-1,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=i,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(-i,0,0,e.x,0,-1,0,e.y,0,0,i,e.z,0,0,0,1)}var a=g,s=A,c=S;return t=o(t,f.WGS84),t.geodeticSurfaceNormal(e,a),s.x=-e.y,s.y=e.x,s.z=0,n.normalize(s,s),n.cross(a,s,c),u(r)?(r[0]=c.x,r[1]=c.y,r[2]=c.z,r[3]=0,r[4]=-s.x,r[5]=-s.y,r[6]=-s.z,r[7]=0,r[8]=a.x,r[9]=a.y,r[10]=a.z,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r):new _(c.x,-s.x,a.x,e.x,c.y,-s.y,a.y,e.y,c.z,-s.z,a.z,e.z,0,0,0,1)};var O=new v,w=new n(1,1,1),M=new _;R.headingPitchRollToFixedFrame=function(e,t,r,i){a.typeOf.object("headingPitchRoll",t);var o=t.heading,u=t.pitch,s=t.roll,c=v.fromHeadingPitchRoll(o,u,s,O),l=_.fromTranslationQuaternionRotationScale(n.ZERO,c,w,M);return i=R.eastNorthUpToFixedFrame(e,r,i),_.multiply(i,l,i)};var C=new _,P=new m;R.headingPitchRollQuaternion=function(e,t,n,r){a.typeOf.object("headingPitchRoll",t);var i=R.headingPitchRollToFixedFrame(e,t,n,C),o=_.getRotation(i,P);return v.fromRotationMatrix(o,r)};var D=24110.54841,L=8640184.812866,U=.093104,b=-62e-7,F=1.1772758384668e-19,z=72921158553e-15,B=E.TWO_PI/86400,G=new y;R.computeTemeToPseudoFixedMatrix=function(e,t){G=y.addSeconds(e,-y.computeTaiMinusUtc(e),G);var n,r=G.dayNumber,i=G.secondsOfDay,a=r-2451545;n=i>=43200?(a+.5)/T.DAYS_PER_JULIAN_CENTURY:(a-.5)/T.DAYS_PER_JULIAN_CENTURY;var o=D+n*(L+n*(U+n*b)),s=o*B%E.TWO_PI,c=z+F*(r-2451545.5),l=(i+.5*T.SECONDS_PER_DAY)%T.SECONDS_PER_DAY,f=s+c*l,h=Math.cos(f),d=Math.sin(f);return u(t)?(t[0]=h,t[1]=-d,t[2]=0,t[3]=d,t[4]=h,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new m(h,d,0,-d,h,0,0,0,1)},R.iau2006XysData=new d,R.earthOrientationParameters=c.NONE;var q=32.184,W=2451545;R.preloadIcrfFixed=function(t){var n=t.start.dayNumber,r=t.start.secondsOfDay+q,i=t.stop.dayNumber,a=t.stop.secondsOfDay+q,o=R.iau2006XysData.preload(n,r,i,a),u=R.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},R.computeIcrfToFixedMatrix=function(e,t){u(t)||(t=new m);var n=R.computeFixedToIcrfMatrix(e,t);if(u(n))return m.transpose(n,t)};var V=new p(0,0,0),H=new l(0,0,0,0,0,0),X=new m,Y=new m;R.computeFixedToIcrfMatrix=function(e,t){u(t)||(t=new m);var n=R.earthOrientationParameters.compute(e,H);if(u(n)){var r=e.dayNumber,i=e.secondsOfDay+q,a=R.iau2006XysData.computeXysRadians(r,i,V);if(u(a)){var o=a.x+n.xPoleOffset,s=a.y+n.yPoleOffset,c=1/(1+Math.sqrt(1-o*o-s*s)),l=X;l[0]=1-c*o*o,l[3]=-c*o*s,l[6]=o,l[1]=-c*o*s,l[4]=1-c*s*s,l[7]=s,l[2]=-o,l[5]=-s,l[8]=1-c*(o*o+s*s);var f=m.fromRotationZ(-a.s,Y),h=m.multiply(l,f,X),d=e.dayNumber,p=e.secondsOfDay-y.computeTaiMinusUtc(e)+n.ut1MinusUtc,_=d-2451545,v=p/T.SECONDS_PER_DAY,g=.779057273264+v+.00273781191135448*(_+v);g=g%1*E.TWO_PI;var A=m.fromRotationZ(g,Y),S=m.multiply(h,A,X),N=Math.cos(n.xPoleWander),x=Math.cos(n.yPoleWander),I=Math.sin(n.xPoleWander),O=Math.sin(n.yPoleWander),w=r-W+i/T.SECONDS_PER_DAY;w/=36525;var M=-47e-6*w*E.RADIANS_PER_DEGREE/3600,C=Math.cos(M),P=Math.sin(M),D=Y;return D[0]=N*C,D[1]=N*P,D[2]=I,D[3]=-x*P+O*I*C,D[4]=x*C+O*I*P,D[5]=-O*N,D[6]=-O*P-x*I*C,D[7]=O*C-x*I*P,D[8]=x*N,m.multiply(S,D,t)}}};var k=new r;R.pointToWindowCoordinates=function(e,t,n,r){return r=R.pointToGLWindowCoordinates(e,t,n,r),r.y=2*t[5]-r.y,r},R.pointToGLWindowCoordinates=function(e,n,i,a){u(a)||(a=new t);var o=k;return _.multiplyByVector(e,r.fromElements(i.x,i.y,i.z,1,o),o),r.multiplyByScalar(o,1/o.w,o),_.multiplyByVector(n,o,o),t.fromCartesian4(o,a)};var Z=new n,j=new n,K=new n;R.rotationMatrixFromPositionVelocity=function(e,t,r,i){var a=o(r,f.WGS84).geodeticSurfaceNormal(e,Z),s=n.cross(t,a,j);n.equalsEpsilon(s,n.ZERO,E.EPSILON6)&&(s=n.clone(n.UNIT_X,s));var c=n.cross(s,t,K);return n.cross(t,c,s),n.negate(s,s),u(i)||(i=new m),i[0]=t.x,i[1]=t.y,i[2]=t.z,i[3]=s.x,i[4]=s.y,i[5]=s.z,i[6]=c.x,i[7]=c.y,i[8]=c.z,i};var J=new i,Q=new n,$=new n,ee=new r,te=new r,ne=new r,re=new r,ie=new r,ae=new _,oe=new _;R.basisTo2D=function(e,t,i){var a=e.ellipsoid,o=_.getColumn(t,3,ee),u=a.cartesianToCartographic(o,J),s=R.eastNorthUpToFixedFrame(o,a,ae),c=_.inverseTransformation(s,oe),l=e.project(u,Q),f=te;f.x=l.z,f.y=l.x,f.z=l.y,f.w=1;var h=_.getColumn(t,0,$),d=n.magnitude(h),p=_.multiplyByVector(c,h,ne);r.fromElements(p.z,p.x,p.y,0,p);var y=_.getColumn(t,1,$),E=n.magnitude(y),m=_.multiplyByVector(c,y,re);r.fromElements(m.z,m.x,m.y,0,m);var v=_.getColumn(t,2,$),T=n.magnitude(v),g=ie;return n.cross(p,m,g),n.normalize(g,g),n.cross(m,g,p),n.normalize(p,p),n.cross(g,p,m),n.normalize(m,m),n.multiplyByScalar(p,d,p),n.multiplyByScalar(m,E,m),n.multiplyByScalar(g,T,g),_.setColumn(i,0,p,i),_.setColumn(i,1,m,i),_.setColumn(i,2,g,i),_.setColumn(i,3,f,i),i};var ue=new _(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1);return R.wgs84To2DModelMatrix=function(e,t,n){var r=e.ellipsoid,i=R.eastNorthUpToFixedFrame(t,r,ae),a=_.inverseTransformation(i,oe),o=r.cartesianToCartographic(t,J),u=e.project(o,Q),s=te;s.x=u.z,s.y=u.x,s.z=u.y,s.w=1;var c=_.fromTranslation(s,ae);return _.multiply(ue,a,n),_.multiply(c,n,n),n},R}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,n,r,i,a,o,u,s,c,l,f,h,d){"use strict";function p(e,t){t=i(t,s.WGS84),e=t.scaleToGeodeticSurface(e);var r=d.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=n.fromCartesian4(l.getColumn(r,0,y)),this._yAxis=n.fromCartesian4(l.getColumn(r,1,y));var a=n.fromCartesian4(l.getColumn(r,2,y));this._plane=f.fromPointNormal(e,a)}var y=new r;o(p.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var E=new e;p.fromPoints=function(t,n){var r=e.fromPoints(t,E);return new p(r.center,n)};var m=new h,_=new n;p.prototype.projectPointOntoPlane=function(e,r){var i=m;i.origin=e,n.normalize(e,i.direction);var o=c.rayPlane(i,this._plane,_);if(a(o)||(n.negate(i.direction,i.direction),o=c.rayPlane(i,this._plane,_)),a(o)){var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return a(r)?(r.x=s,r.y=l,r):new t(s,l)}},p.prototype.projectPointsOntoPlane=function(e,t){a(t)||(t=[]);for(var n=0,r=e.length,i=0;i<r;i++){var o=this.projectPointOntoPlane(e[i],t[n]);a(o)&&(t[n]=o,n++)}return t.length=n,t},p.prototype.projectPointToNearestOnPlane=function(e,r){a(r)||(r=new t);var i=m;i.origin=e,n.clone(this._plane.normal,i.direction);var o=c.rayPlane(i,this._plane,_);a(o)||(n.negate(i.direction,i.direction),o=c.rayPlane(i,this._plane,_));var u=n.subtract(o,this._origin,o),s=n.dot(this._xAxis,u),l=n.dot(this._yAxis,u);return r.x=s,r.y=l,r},p.prototype.projectPointsToNearestOnPlane=function(e,t){a(t)||(t=[]);var n=e.length;t.length=n;for(var r=0;r<n;r++)t[r]=this.projectPointToNearestOnPlane(e[r],t[r]);return t};var v=new n;return p.prototype.projectPointsOntoEllipsoid=function(e,t){var r=e.length;a(t)?t.length=r:t=new Array(r);for(var i=this._ellipsoid,o=this._origin,u=this._xAxis,s=this._yAxis,c=v,l=0;l<r;++l){var f=e[l];n.multiplyByScalar(u,f.x,c),a(t[l])||(t[l]=new n);var h=n.add(o,c,t[l]);n.multiplyByScalar(s,f.y,c),n.add(h,c,h),i.scaleToGeocentricSurface(h,h)}return t},p}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var n={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===n.POINTS||e===n.LINES||e===n.LINE_LOOP||e===n.LINE_STRIP||e===n.TRIANGLES||e===n.TRIANGLE_STRIP||e===n.TRIANGLE_FAN}};return e(n)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,n,r,i){"use strict";function a(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,i.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,r.NONE),this.boundingSphereCV=t.boundingSphereCV}return a.computeNumberOfVertices=function(e){var n=-1;for(var r in e.attributes)if(e.attributes.hasOwnProperty(r)&&t(e.attributes[r])&&t(e.attributes[r].values)){var i=e.attributes[r],a=i.values.length/i.componentsPerAttribute;n=a}return n},a}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,n){"use strict";function r(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values}return r}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,n,r){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.geometry=t.geometry,this.modelMatrix=r.clone(e(t.modelMatrix,r.IDENTITY)),this.id=t.id,this.pickPrimitive=t.pickPrimitive,this.attributes=e(t.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}return i}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,n,r,i){"use strict";var a={};a.octEncodeInRange=function(e,t,n){if(n.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),n.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var r=n.x,a=n.y;n.x=(1-Math.abs(a))*i.signNotZero(r),n.y=(1-Math.abs(r))*i.signNotZero(a)}return n.x=i.toSNorm(n.x,t),n.y=i.toSNorm(n.y,t),n},a.octEncode=function(e,t){return a.octEncodeInRange(e,255,t)},a.octDecodeInRange=function(e,n,r,a){if(a.x=i.fromSNorm(e,r),a.y=i.fromSNorm(n,r),a.z=1-(Math.abs(a.x)+Math.abs(a.y)),a.z<0){var o=a.x;a.x=(1-Math.abs(a.y))*i.signNotZero(o),a.y=(1-Math.abs(o))*i.signNotZero(a.y)}return t.normalize(a,a)},a.octDecode=function(e,t,n){return a.octDecodeInRange(e,t,255,n)},a.octPackFloat=function(e){return 256*e.x+e.y};var o=new e;return a.octEncodeFloat=function(e){return a.octEncode(e,o),a.octPackFloat(o)},a.octDecodeFloat=function(e,t){var n=e/256,r=Math.floor(n),i=256*(n-r);return a.octDecode(r,i,t)},a.octPack=function(e,t,n,r){var i=a.octEncodeFloat(e),u=a.octEncodeFloat(t),s=a.octEncode(n,o);return r.x=65536*s.x+i,r.y=65536*s.y+u,r},a.octUnpack=function(e,t,n,r){var i=e.x/65536,o=Math.floor(i),u=65536*(i-o);i=e.y/65536;var s=Math.floor(i),c=65536*(i-s);a.octDecodeFloat(u,t),a.octDecodeFloat(c,n),a.octDecode(o,s,r)},a.compressTextureCoordinates=function(e){var t=4095*e.x|0,n=4095*e.y|0;return 4096*t+n},a.decompressTextureCoordinates=function(e,t){var n=e/4096,r=Math.floor(n);return t.x=r/4095,t.y=(e-4096*r)/4095,t},a}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,n,r){"use strict";function i(r,i,s,c,l){n(l)||(l=new t);var f,h,d,p,y,E,m,_;n(i.z)?(f=t.subtract(s,i,a),h=t.subtract(c,i,o),d=t.subtract(r,i,u),p=t.dot(f,f),y=t.dot(f,h),E=t.dot(f,d),m=t.dot(h,h),_=t.dot(h,d)):(f=e.subtract(s,i,a),h=e.subtract(c,i,o),d=e.subtract(r,i,u),p=e.dot(f,f),y=e.dot(f,h),E=e.dot(f,d),m=e.dot(h,h),_=e.dot(h,d));var v=1/(p*m-y*y);return l.y=(m*E-y*_)*v,l.z=(p*_-y*E)*v,l.x=1-l.y-l.z,l}var a=new t,o=new t,u=new t;return i}),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],function(e,t,n){"use strict";function r(n,r){t(i[n])||(i[n]=!0,console.warn(e(r,n)))}var i={};return r.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",r}),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],function(e,t,n){"use strict";function r(e,t){n(e,t)}return r}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,n){"use strict";function r(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}r.encode=function(e,n){t(n)||(n={high:0,low:0});var r;return e>=0?(r=65536*Math.floor(e/65536),n.high=r,n.low=e-r):(r=65536*Math.floor(-e/65536),n.high=-r,n.low=e+r),n};var i={high:0,low:0};r.fromCartesian=function(e,n){t(n)||(n=new r);var a=n.high,o=n.low;return r.encode(e.x,i),a.x=i.high,o.x=i.low,r.encode(e.y,i),a.y=i.high,o.y=i.low,r.encode(e.z,i),a.z=i.high,o.z=i.low,n};var a=new r;return r.writeElements=function(e,t,n){r.fromCartesian(e,a);var i=a.high,o=a.low;t[n]=i.x,t[n+1]=i.y,t[n+2]=i.z,t[n+3]=o.x,t[n+4]=o.y,t[n+5]=o.z},r}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,n,r,i){"use strict";var a={UNSIGNED_BYTE:i.UNSIGNED_BYTE,UNSIGNED_SHORT:i.UNSIGNED_SHORT,UNSIGNED_INT:i.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},a.validate=function(t){return e(t)&&(t===a.UNSIGNED_BYTE||t===a.UNSIGNED_SHORT||t===a.UNSIGNED_INT)},a.createTypedArray=function(e,t){return e>=r.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},a.createTypedArrayFromArrayBuffer=function(e,t,n,i){return e>=r.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,n,i):new Uint16Array(t,n,i)},n(a)}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,n){"use strict";var r={};return r.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var r=n.indices,i=n.maximumIndex,a=e(n.cacheSize,24),o=r.length;if(!t(i)){i=0;for(var u=0,s=r[u];u<o;)s>i&&(i=s),++u,s=r[u]}for(var c=[],l=0;l<i+1;l++)c[l]=0;for(var f=a+1,h=0;h<o;++h)f-c[r[h]]>a&&(c[r[h]]=f,++f);return(f-a+1)/(o/3)},r.tipsify=function(n){function r(e,t,n,r){for(;t.length>=1;){var i=t[t.length-1];if(t.splice(t.length-1,1),e[i].numLiveTriangles>0)return i}for(;a<r;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function i(e,t,n,i,a,o,u){for(var s,c=-1,l=-1,f=0;f<n.length;){var h=n[f];i[h].numLiveTriangles&&(s=0,a-i[h].timeStamp+2*i[h].numLiveTriangles<=t&&(s=a-i[h].timeStamp),(s>l||l===-1)&&(l=s,c=h)),++f}return c===-1?r(i,o,e,u):c}n=e(n,e.EMPTY_OBJECT);var a,o=n.indices,u=n.maximumIndex,s=e(n.cacheSize,24),c=o.length,l=0,f=0,h=o[f],d=c;if(t(u))l=u+1;else{for(;f<d;)h>l&&(l=h),++f,h=o[f];if(l===-1)return 0;++l}for(var p=[],y=0;y<l;y++)p[y]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};f=0;for(var E=0;f<d;)p[o[f]].vertexTriangles.push(E),++p[o[f]].numLiveTriangles,p[o[f+1]].vertexTriangles.push(E),++p[o[f+1]].numLiveTriangles,p[o[f+2]].vertexTriangles.push(E),++p[o[f+2]].numLiveTriangles,++E,f+=3;var m=0,_=s+1;a=1;var v,T,R=[],g=[],A=0,S=[],N=c/3,x=[];for(y=0;y<N;y++)x[y]=!1;for(var I,O;m!==-1;){R=[],T=p[m],O=T.vertexTriangles.length;for(var w=0;w<O;++w)if(E=T.vertexTriangles[w],!x[E]){x[E]=!0,f=E+E+E;for(var M=0;M<3;++M)I=o[f],R.push(I),g.push(I),S[A]=I,++A,v=p[I],--v.numLiveTriangles,_-v.timeStamp>s&&(v.timeStamp=_,++_),++f}m=i(o,s,R,p,_,g,l)}return S},r}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,n,r,i,a,o,u,s,c,l,f,h,d,p,y,E,m,_,v,T,R,g,A,S,N){"use strict";function x(e,t,n,r,i){e[t++]=n,e[t++]=r,e[t++]=r,e[t++]=i,e[t++]=i,e[t]=n}function I(e){for(var t=e.length,n=t/3*6,r=m.createTypedArray(t,n),i=0,a=0;a<t;a+=3,i+=6)x(r,i,e[a],e[a+1],e[a+2]);return r}function O(e){var t=e.length;if(t>=3){var n=6*(t-2),r=m.createTypedArray(t,n);x(r,0,e[0],e[1],e[2]);for(var i=6,a=3;a<t;++a,i+=6)x(r,i,e[a-1],e[a],e[a-2]);return r}return new Uint16Array}function w(e){if(e.length>0){for(var t=e.length-1,n=6*(t-1),r=m.createTypedArray(t,n),i=e[0],a=0,o=1;o<t;++o,a+=6)x(r,a,i,e[o],e[o+1]);return r}return new Uint16Array}function M(e){var t={};for(var n in e)if(e.hasOwnProperty(n)&&c(e[n])&&c(e[n].values)){var r=e[n];t[n]=new y({componentDatatype:r.componentDatatype,componentsPerAttribute:r.componentsPerAttribute,normalize:r.normalize,values:[]})}return t}function C(e,t,n){for(var r in t)if(t.hasOwnProperty(r)&&c(t[r])&&c(t[r].values))for(var i=t[r],a=0;a<i.componentsPerAttribute;++a)e[r].values.push(i.values[n*i.componentsPerAttribute+a])}function P(e,t){if(c(t))for(var n=t.values,r=n.length,a=0;a<r;a+=3)i.unpack(n,a,oe),g.multiplyByPoint(e,oe,oe),i.pack(oe,n,a)}function D(e,t){if(c(t))for(var n=t.values,r=n.length,a=0;a<r;a+=3)i.unpack(n,a,oe),R.multiplyByVector(e,oe,oe),oe=i.normalize(oe,oe),i.pack(oe,n,a)}function L(e,t){var n,r=e.length,i={},a=e[0][t].attributes;for(n in a)if(a.hasOwnProperty(n)&&c(a[n])&&c(a[n].values)){for(var o=a[n],s=o.values.length,l=!0,f=1;f<r;++f){var h=e[f][t].attributes[n];if(!c(h)||o.componentDatatype!==h.componentDatatype||o.componentsPerAttribute!==h.componentsPerAttribute||o.normalize!==h.normalize){l=!1;break}s+=h.values.length}l&&(i[n]=new y({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return i}function U(e,t){var r,a,o,u,s,l,f,h=e.length,d=(e[0].modelMatrix,c(e[0][t].indices)),y=e[0][t].primitiveType,E=L(e,t);for(r in E)if(E.hasOwnProperty(r))for(s=E[r].values,u=0,a=0;a<h;++a)for(l=e[a][t].attributes[r].values,f=l.length,o=0;o<f;++o)s[u++]=l[o];var _;if(d){var v=0;for(a=0;a<h;++a)v+=e[a][t].indices.length;var T=p.computeNumberOfVertices(new p({attributes:E,primitiveType:S.POINTS})),R=m.createTypedArray(T,v),g=0,A=0;for(a=0;a<h;++a){var N=e[a][t].indices,x=N.length;for(u=0;u<x;++u)R[g++]=A+N[u];A+=p.computeNumberOfVertices(e[a][t])}_=R}var I,O=new i,w=0;for(a=0;a<h;++a){if(I=e[a][t].boundingSphere,!c(I)){O=void 0;break}i.add(I.center,O,O)}if(c(O))for(i.divideByScalar(O,h,O),a=0;a<h;++a){I=e[a][t].boundingSphere;var M=i.magnitude(i.subtract(I.center,O,ce))+I.radius;M>w&&(w=M)}return new p({attributes:E,indices:_,primitiveType:y,boundingSphere:c(O)?new n(O,w):void 0})}function b(e){if(c(e.indices))return e;for(var t=p.computeNumberOfVertices(e),n=m.createTypedArray(t,t),r=0;r<t;++r)n[r]=r;return e.indices=n,e}function F(e){var t=p.computeNumberOfVertices(e),n=m.createTypedArray(t,3*(t-2));n[0]=1,n[1]=0,n[2]=2;for(var r=3,i=3;i<t;++i)n[r++]=i-1,n[r++]=0,n[r++]=i;return e.indices=n,e.primitiveType=S.TRIANGLES,e}function z(e){var t=p.computeNumberOfVertices(e),n=m.createTypedArray(t,3*(t-2));n[0]=0,n[1]=1,n[2]=2,t>3&&(n[3]=0,n[4]=2,n[5]=3);for(var r=6,i=3;i<t-1;i+=2)n[r++]=i,n[r++]=i-1,n[r++]=i+1,i+2<t&&(n[r++]=i,n[r++]=i+1,n[r++]=i+2);return e.indices=n,e.primitiveType=S.TRIANGLES,e}function B(e){if(c(e.indices))return e;for(var t=p.computeNumberOfVertices(e),n=m.createTypedArray(t,t),r=0;r<t;++r)n[r]=r;return e.indices=n,e}function G(e){var t=p.computeNumberOfVertices(e),n=m.createTypedArray(t,2*(t-1));n[0]=0,n[1]=1;for(var r=2,i=2;i<t;++i)n[r++]=i-1,n[r++]=i;return e.indices=n,e.primitiveType=S.LINES,e}function q(e){var t=p.computeNumberOfVertices(e),n=m.createTypedArray(t,2*t);n[0]=0,n[1]=1;for(var r=2,i=2;i<t;++i)n[r++]=i-1,n[r++]=i;return n[r++]=t-1,n[r]=0,e.indices=n,e.primitiveType=S.LINES,e}function W(e){switch(e.primitiveType){case S.TRIANGLE_FAN:return F(e);case S.TRIANGLE_STRIP:return z(e);case S.TRIANGLES:return b(e);case S.LINE_STRIP:return G(e);case S.LINE_LOOP:return q(e);case S.LINES:return B(e)}return e}function V(e,t){Math.abs(e.y)<T.EPSILON6&&(t?e.y=-T.EPSILON6:e.y=T.EPSILON6)}function H(e,t,n){if(0!==e.y&&0!==t.y&&0!==n.y)return V(e,e.y<0),V(t,t.y<0),void V(n,n.y<0);var r,i=Math.abs(e.y),a=Math.abs(t.y),o=Math.abs(n.y);r=i>a?i>o?T.sign(e.y):T.sign(n.y):a>o?T.sign(t.y):T.sign(n.y);var u=r<0;V(e,u),V(t,u),V(n,u)}function X(e,t,n,r){i.add(e,i.multiplyByScalar(i.subtract(t,e,ge),e.y/(e.y-t.y),ge),n),i.clone(n,r),V(n,!0),V(r,!1)}function Y(e,t,n){if(!(e.x>=0||t.x>=0||n.x>=0)){H(e,t,n);var r=e.y<0,i=t.y<0,a=n.y<0,o=0;o+=r?1:0,o+=i?1:0,o+=a?1:0;var u=Ie.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,
u[7]=6,u[8]=5,r?(X(e,t,Ae,Ne),X(e,n,Se,xe),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(X(t,n,Ae,Ne),X(t,e,Se,xe),u[0]=1,u[3]=2,u[4]=0,u[6]=2):a&&(X(n,e,Ae,Ne),X(n,t,Se,xe),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,r?i?a||(X(n,e,Ae,Ne),X(n,t,Se,xe),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(X(t,n,Ae,Ne),X(t,e,Se,xe),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(X(e,t,Ae,Ne),X(e,n,Se,xe),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Ie.positions;return s[0]=e,s[1]=t,s[2]=n,s.length=3,1!==o&&2!==o||(s[3]=Ae,s[4]=Se,s[5]=Ne,s[6]=xe,s.length=7),Ie}}function k(e,t){var r=e.attributes;if(0!==r.position.values.length){for(var i in r)if(r.hasOwnProperty(i)&&c(r[i])&&c(r[i].values)){var a=r[i];a.values=u.createTypedArray(a.componentDatatype,a.values)}var o=p.computeNumberOfVertices(e);return e.indices=m.createTypedArray(o,e.indices),t&&(e.boundingSphere=n.fromVertices(r.position.values)),e}}function Z(e){var t=e.attributes,n={};for(var r in t)if(t.hasOwnProperty(r)&&c(t[r])&&c(t[r].values)){var i=t[r];n[r]=new y({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new p({attributes:n,indices:[],primitiveType:e.primitiveType})}function j(e,t,n){var r=c(e.geometry.boundingSphere);t=k(t,r),n=k(n,r),c(n)&&!c(t)?e.geometry=n:!c(n)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=n,e.geometry=void 0)}function K(e,n,a,o,u,s,l,f,h,d,p,y){if(c(s)||c(l)||c(f)||c(h)||c(d)){var E=i.fromArray(u,3*e,Oe),m=i.fromArray(u,3*n,we),_=i.fromArray(u,3*a,Me),v=t(o,E,m,_,Ce);if(c(s)){var T=i.fromArray(s,3*e,Oe),R=i.fromArray(s,3*n,we),g=i.fromArray(s,3*a,Me);i.multiplyByScalar(T,v.x,T),i.multiplyByScalar(R,v.y,R),i.multiplyByScalar(g,v.z,g);var A=i.add(T,R,T);i.add(A,g,A),i.normalize(A,A),i.pack(A,p.normal.values,3*y)}if(c(d)){var S=i.fromArray(d,3*e,Oe),N=i.fromArray(d,3*n,we),x=i.fromArray(d,3*a,Me);i.multiplyByScalar(S,v.x,S),i.multiplyByScalar(N,v.y,N),i.multiplyByScalar(x,v.z,x);var I;i.equals(S,i.ZERO)&&i.equals(N,i.ZERO)&&i.equals(x,i.ZERO)?(I=Oe,I.x=0,I.y=0,I.z=0):(I=i.add(S,N,S),i.add(I,x,I),i.normalize(I,I)),i.pack(I,p.extrudeDirection.values,3*y)}if(c(l)){var O=i.fromArray(l,3*e,Oe),w=i.fromArray(l,3*n,we),M=i.fromArray(l,3*a,Me);i.multiplyByScalar(O,v.x,O),i.multiplyByScalar(w,v.y,w),i.multiplyByScalar(M,v.z,M);var C=i.add(O,w,O);i.add(C,M,C),i.normalize(C,C),i.pack(C,p.tangent.values,3*y)}if(c(f)){var P=i.fromArray(f,3*e,Oe),D=i.fromArray(f,3*n,we),L=i.fromArray(f,3*a,Me);i.multiplyByScalar(P,v.x,P),i.multiplyByScalar(D,v.y,D),i.multiplyByScalar(L,v.z,L);var U=i.add(P,D,P);i.add(U,L,U),i.normalize(U,U),i.pack(U,p.bitangent.values,3*y)}if(c(h)){var b=r.fromArray(h,2*e,Pe),F=r.fromArray(h,2*n,De),z=r.fromArray(h,2*a,Le);r.multiplyByScalar(b,v.x,b),r.multiplyByScalar(F,v.y,F),r.multiplyByScalar(z,v.z,z);var B=r.add(b,F,b);r.add(B,z,B),r.pack(B,p.st.values,2*y)}}}function J(e,t,n,r,i,a){var o=e.position.values.length/3;if(i!==-1){var u=r[i],s=n[u];return s===-1?(n[u]=o,e.position.values.push(a.x,a.y,a.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(a.x,a.y,a.z),t.push(o),o}function Q(e){var t,n,r,a,o,u=e.geometry,s=u.attributes,l=s.position.values,f=c(s.normal)?s.normal.values:void 0,h=c(s.bitangent)?s.bitangent.values:void 0,d=c(s.tangent)?s.tangent.values:void 0,p=c(s.st)?s.st.values:void 0,y=c(s.extrudeDirection)?s.extrudeDirection.values:void 0,E=u.indices,m=Z(u),_=Z(u),v=[];v.length=l.length/3;var T=[];for(T.length=l.length/3,o=0;o<v.length;++o)v[o]=-1,T[o]=-1;var R=E.length;for(o=0;o<R;o+=3){var g=E[o],A=E[o+1],S=E[o+2],N=i.fromArray(l,3*g),x=i.fromArray(l,3*A),I=i.fromArray(l,3*S),O=Y(N,x,I);if(c(O)&&O.positions.length>3)for(var w=O.positions,M=O.indices,C=M.length,P=0;P<C;++P){var D=M[P],L=w[D];L.y<0?(t=_.attributes,n=_.indices,r=v):(t=m.attributes,n=m.indices,r=T),a=J(t,n,r,E,D<3?o+D:-1,L),K(g,A,S,L,l,f,d,h,p,y,t,a)}else c(O)&&(N=O.positions[0],x=O.positions[1],I=O.positions[2]),N.y<0?(t=_.attributes,n=_.indices,r=v):(t=m.attributes,n=m.indices,r=T),a=J(t,n,r,E,o,N),K(g,A,S,N,l,f,d,h,p,y,t,a),a=J(t,n,r,E,o+1,x),K(g,A,S,x,l,f,d,h,p,y,t,a),a=J(t,n,r,E,o+2,I),K(g,A,S,I,l,f,d,h,p,y,t,a)}j(e,_,m)}function $(e){var t,n=e.geometry,r=n.attributes,a=r.position.values,o=n.indices,u=Z(n),s=Z(n),l=o.length,f=[];f.length=a.length/3;var h=[];for(h.length=a.length/3,t=0;t<f.length;++t)f[t]=-1,h[t]=-1;for(t=0;t<l;t+=2){var d=o[t],p=o[t+1],y=i.fromArray(a,3*d,Oe),E=i.fromArray(a,3*p,we);Math.abs(y.y)<T.EPSILON6&&(y.y<0?y.y=-T.EPSILON6:y.y=T.EPSILON6),Math.abs(E.y)<T.EPSILON6&&(E.y<0?E.y=-T.EPSILON6:E.y=T.EPSILON6);var m=u.attributes,_=u.indices,R=h,g=s.attributes,A=s.indices,S=f,N=v.lineSegmentPlane(y,E,Ue,Me);if(c(N)){var x=i.multiplyByScalar(i.UNIT_Y,5*T.EPSILON9,be);y.y<0&&(i.negate(x,x),m=s.attributes,_=s.indices,R=f,g=u.attributes,A=u.indices,S=h);var I=i.add(N,x,Fe);J(m,_,R,o,t,y),J(m,_,R,o,-1,I),i.negate(x,x),i.add(N,x,I),J(g,A,S,o,-1,I),J(g,A,S,o,t+1,E)}else{var O,w,M;y.y<0?(O=s.attributes,w=s.indices,M=f):(O=u.attributes,w=u.indices,M=h),J(O,w,M,o,t,y),J(O,w,M,o,t+1,E)}}j(e,s,u)}function ee(e){for(var t=e.attributes,n=t.position.values,r=t.prevPosition.values,a=t.nextPosition.values,o=n.length,u=0;u<o;u+=3){var s=i.unpack(n,u,Ge);if(!(s.x>0)){var c=i.unpack(r,u,qe);(s.y<0&&c.y>0||s.y>0&&c.y<0)&&(u-3>0?(r[u]=n[u-3],r[u+1]=n[u-2],r[u+2]=n[u-1]):i.pack(s,r,u));var l=i.unpack(a,u,We);(s.y<0&&l.y>0||s.y>0&&l.y<0)&&(u+3<o?(a[u]=n[u+3],a[u+1]=n[u+4],a[u+2]=n[u+5]):i.pack(s,a,u))}}}function te(e){var t,n,o,u=e.geometry,s=u.attributes,l=s.position.values,f=s.prevPosition.values,h=s.nextPosition.values,d=s.expandAndWidth.values,p=c(s.st)?s.st.values:void 0,y=c(s.color)?s.color.values:void 0,E=Z(u),m=Z(u),_=!1,R=l.length/3;for(t=0;t<R;t+=4){var g=t,A=t+2,S=i.fromArray(l,3*g,Ge),N=i.fromArray(l,3*A,qe);if(Math.abs(S.y)<Ze)for(S.y=Ze*(N.y<0?-1:1),l[3*t+1]=S.y,l[3*(t+1)+1]=S.y,n=3*g;n<3*g+12;n+=3)f[n]=l[3*t],f[n+1]=l[3*t+1],f[n+2]=l[3*t+2];if(Math.abs(N.y)<Ze)for(N.y=Ze*(S.y<0?-1:1),l[3*(t+2)+1]=N.y,l[3*(t+3)+1]=N.y,n=3*g;n<3*g+12;n+=3)h[n]=l[3*(t+2)],h[n+1]=l[3*(t+2)+1],h[n+2]=l[3*(t+2)+2];var x=E.attributes,I=E.indices,O=m.attributes,w=m.indices,M=v.lineSegmentPlane(S,N,Ue,Ve);if(c(M)){_=!0;var C=i.multiplyByScalar(i.UNIT_Y,ke,He);S.y<0&&(i.negate(C,C),x=m.attributes,I=m.indices,O=E.attributes,w=E.indices);var P=i.add(M,C,Xe);x.position.values.push(S.x,S.y,S.z,S.x,S.y,S.z),x.position.values.push(P.x,P.y,P.z),x.position.values.push(P.x,P.y,P.z),x.prevPosition.values.push(f[3*g],f[3*g+1],f[3*g+2]),x.prevPosition.values.push(f[3*g+3],f[3*g+4],f[3*g+5]),x.prevPosition.values.push(S.x,S.y,S.z,S.x,S.y,S.z),x.nextPosition.values.push(P.x,P.y,P.z),x.nextPosition.values.push(P.x,P.y,P.z),x.nextPosition.values.push(P.x,P.y,P.z),x.nextPosition.values.push(P.x,P.y,P.z),i.negate(C,C),i.add(M,C,P),O.position.values.push(P.x,P.y,P.z),O.position.values.push(P.x,P.y,P.z),O.position.values.push(N.x,N.y,N.z,N.x,N.y,N.z),O.prevPosition.values.push(P.x,P.y,P.z),O.prevPosition.values.push(P.x,P.y,P.z),O.prevPosition.values.push(P.x,P.y,P.z),O.prevPosition.values.push(P.x,P.y,P.z),O.nextPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),O.nextPosition.values.push(h[3*A],h[3*A+1],h[3*A+2]),O.nextPosition.values.push(h[3*A+3],h[3*A+4],h[3*A+5]);var D=r.fromArray(d,2*g,ze),L=Math.abs(D.y);x.expandAndWidth.values.push(-1,L,1,L),x.expandAndWidth.values.push(-1,-L,1,-L),O.expandAndWidth.values.push(-1,L,1,L),O.expandAndWidth.values.push(-1,-L,1,-L);var U=i.magnitudeSquared(i.subtract(M,S,We));if(U/=i.magnitudeSquared(i.subtract(N,S,We)),c(y)){var b=a.fromArray(y,4*g,Ye),F=a.fromArray(y,4*A,Ye),z=T.lerp(b.x,F.x,U),B=T.lerp(b.y,F.y,U),G=T.lerp(b.z,F.z,U),q=T.lerp(b.w,F.w,U);for(n=4*g;n<4*g+8;++n)x.color.values.push(y[n]);for(x.color.values.push(z,B,G,q),x.color.values.push(z,B,G,q),O.color.values.push(z,B,G,q),O.color.values.push(z,B,G,q),n=4*A;n<4*A+8;++n)O.color.values.push(y[n])}if(c(p)){var W=r.fromArray(p,2*g,ze),V=r.fromArray(p,2*(t+3),Be),H=T.lerp(W.x,V.x,U);for(n=2*g;n<2*g+4;++n)x.st.values.push(p[n]);for(x.st.values.push(H,W.y),x.st.values.push(H,V.y),O.st.values.push(H,W.y),O.st.values.push(H,V.y),n=2*A;n<2*A+4;++n)O.st.values.push(p[n])}o=x.position.values.length/3-4,I.push(o,o+2,o+1),I.push(o+1,o+2,o+3),o=O.position.values.length/3-4,w.push(o,o+2,o+1),w.push(o+1,o+2,o+3)}else{var X,Y;for(S.y<0?(X=m.attributes,Y=m.indices):(X=E.attributes,Y=E.indices),X.position.values.push(S.x,S.y,S.z),X.position.values.push(S.x,S.y,S.z),X.position.values.push(N.x,N.y,N.z),X.position.values.push(N.x,N.y,N.z),n=3*t;n<3*t+12;++n)X.prevPosition.values.push(f[n]),X.nextPosition.values.push(h[n]);for(n=2*t;n<2*t+8;++n)X.expandAndWidth.values.push(d[n]),c(p)&&X.st.values.push(p[n]);if(c(y))for(n=4*t;n<4*t+16;++n)X.color.values.push(y[n]);o=X.position.values.length/3-4,Y.push(o,o+2,o+1),Y.push(o+1,o+2,o+3)}}_&&(ee(m),ee(E)),j(e,m,E)}var ne={};ne.toWireframe=function(e){var t=e.indices;if(c(t)){switch(e.primitiveType){case S.TRIANGLES:e.indices=I(t);break;case S.TRIANGLE_STRIP:e.indices=O(t);break;case S.TRIANGLE_FAN:e.indices=w(t)}e.primitiveType=S.LINES}return e},ne.createLineSegmentsForVectors=function(e,t,r){t=s(t,"normal"),r=s(r,1e4);for(var i=e.attributes.position.values,a=e.attributes[t].values,o=i.length,l=new Float64Array(2*o),f=0,h=0;h<o;h+=3)l[f++]=i[h],l[f++]=i[h+1],l[f++]=i[h+2],l[f++]=i[h]+a[h]*r,l[f++]=i[h+1]+a[h+1]*r,l[f++]=i[h+2]+a[h+2]*r;var d,E=e.boundingSphere;return c(E)&&(d=new n(E.center,E.radius+r)),new p({attributes:{position:new y({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:S.LINES,boundingSphere:d})},ne.createAttributeLocations=function(e){var t,n=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],r=e.attributes,i={},a=0,o=n.length;for(t=0;t<o;++t){var u=n[t];c(r[u])&&(i[u]=a++)}for(var s in r)r.hasOwnProperty(s)&&!c(i[s])&&(i[s]=a++);return i},ne.reorderForPreVertexCache=function(e){var t=p.computeNumberOfVertices(e),n=e.indices;if(c(n)){for(var r=new Int32Array(t),i=0;i<t;i++)r[i]=-1;for(var a,o=n,s=o.length,l=m.createTypedArray(t,s),f=0,h=0,d=0;f<s;)a=r[o[f]],a!==-1?l[h]=a:(a=o[f],r[a]=d,l[h]=d,++d),++f,++h;e.indices=l;var y=e.attributes;for(var E in y)if(y.hasOwnProperty(E)&&c(y[E])&&c(y[E].values)){for(var _=y[E],v=_.values,T=0,R=_.componentsPerAttribute,g=u.createTypedArray(_.componentDatatype,d*R);T<t;){var A=r[T];if(A!==-1)for(i=0;i<R;i++)g[R*A+i]=v[R*T+i];++T}_.values=g}}return e},ne.reorderForPostVertexCache=function(e,t){var n=e.indices;if(e.primitiveType===S.TRIANGLES&&c(n)){for(var r=n.length,i=0,a=0;a<r;a++)n[a]>i&&(i=n[a]);e.indices=N.tipsify({indices:n,maximumIndex:i,cacheSize:t})}return e},ne.fitToUnsignedShortIndices=function(e){var t=[],n=p.computeNumberOfVertices(e);if(c(e.indices)&&n>=T.SIXTY_FOUR_KILOBYTES){var r,i=[],a=[],o=0,u=M(e.attributes),s=e.indices,l=s.length;e.primitiveType===S.TRIANGLES?r=3:e.primitiveType===S.LINES?r=2:e.primitiveType===S.POINTS&&(r=1);for(var f=0;f<l;f+=r){for(var h=0;h<r;++h){var d=s[f+h],y=i[d];c(y)||(y=o++,i[d]=y,C(u,e.attributes,d)),a.push(y)}o+r>=T.SIXTY_FOUR_KILOBYTES&&(t.push(new p({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],a=[],o=0,u=M(e.attributes))}0!==a.length&&t.push(new p({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var re=new i,ie=new o;ne.projectTo2D=function(e,t,n,r,a){var o=e.attributes[t];a=c(a)?a:new d;for(var s=a.ellipsoid,l=o.values,f=new Float64Array(l.length),h=0,p=0;p<l.length;p+=3){var E=i.fromArray(l,p,re),m=s.cartesianToCartographic(E,ie),_=a.project(m,re);f[h++]=_.x,f[h++]=_.y,f[h++]=_.z}return e.attributes[n]=o,e.attributes[r]=new y({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:f}),delete e.attributes[t],e};var ae={high:0,low:0};ne.encodeAttribute=function(e,t,n,r){for(var i=e.attributes[t],a=i.values,o=a.length,s=new Float32Array(o),c=new Float32Array(o),l=0;l<o;++l)h.encode(a[l],ae),s[l]=ae.high,c[l]=ae.low;var f=i.componentsPerAttribute;return e.attributes[n]=new y({componentDatatype:u.FLOAT,componentsPerAttribute:f,values:s}),e.attributes[r]=new y({componentDatatype:u.FLOAT,componentsPerAttribute:f,values:c}),delete e.attributes[t],e};var oe=new i,ue=new g,se=new R;ne.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(g.equals(t,g.IDENTITY))return e;var r=e.geometry.attributes;P(t,r.position),P(t,r.prevPosition),P(t,r.nextPosition),(c(r.normal)||c(r.tangent)||c(r.bitangent))&&(g.inverse(t,ue),g.transpose(ue,ue),g.getRotation(ue,se),D(se,r.normal),D(se,r.tangent),D(se,r.bitangent));var i=e.geometry.boundingSphere;return c(i)&&(e.geometry.boundingSphere=n.transform(i,t,i)),e.modelMatrix=g.clone(g.IDENTITY),e};var ce=new i;ne.combineInstances=function(e){for(var t=[],n=[],r=e.length,i=0;i<r;++i){var a=e[i];c(a.geometry)?t.push(a):c(a.westHemisphereGeometry)&&c(a.eastHemisphereGeometry)&&n.push(a)}var o=[];return t.length>0&&o.push(U(t,"geometry")),n.length>0&&(o.push(U(n,"westHemisphereGeometry")),o.push(U(n,"eastHemisphereGeometry"))),o};var le=new i,fe=new i,he=new i,de=new i;ne.computeNormal=function(e){for(var t=e.indices,n=e.attributes,r=n.position.values,a=n.position.values.length/3,o=t.length,s=new Array(a),c=new Array(o/3),l=new Array(o),f=0;f<a;f++)s[f]={indexOffset:0,count:0,currentCount:0};var h=0;for(f=0;f<o;f+=3){var d=t[f],p=t[f+1],E=t[f+2],m=3*d,_=3*p,v=3*E;fe.x=r[m],fe.y=r[m+1],fe.z=r[m+2],he.x=r[_],he.y=r[_+1],he.z=r[_+2],de.x=r[v],de.y=r[v+1],de.z=r[v+2],s[d].count++,s[p].count++,s[E].count++,i.subtract(he,fe,he),i.subtract(de,fe,de),c[h]=i.cross(he,de,new i),h++}var T=0;for(f=0;f<a;f++)s[f].indexOffset+=T,T+=s[f].count;h=0;var R;for(f=0;f<o;f+=3){R=s[t[f]];var g=R.indexOffset+R.currentCount;l[g]=h,R.currentCount++,R=s[t[f+1]],g=R.indexOffset+R.currentCount,l[g]=h,R.currentCount++,R=s[t[f+2]],g=R.indexOffset+R.currentCount,l[g]=h,R.currentCount++,h++}var A=new Float32Array(3*a);for(f=0;f<a;f++){var S=3*f;if(R=s[f],R.count>0){for(i.clone(i.ZERO,le),h=0;h<R.count;h++)i.add(le,c[l[R.indexOffset+h]],le);i.normalize(le,le),A[S]=le.x,A[S+1]=le.y,A[S+2]=le.z}else A[S]=0,A[S+1]=0,A[S+2]=1}return e.attributes.normal=new y({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:A}),e};var pe=new i,ye=new i,Ee=new i;ne.computeTangentAndBitangent=function(e){for(var t=(e.attributes,e.indices),n=e.attributes.position.values,r=e.attributes.normal.values,a=e.attributes.st.values,o=e.attributes.position.values.length/3,s=t.length,c=new Array(3*o),l=0;l<c.length;l++)c[l]=0;var f,h,d;for(l=0;l<s;l+=3){var p=t[l],E=t[l+1],m=t[l+2];f=3*p,h=3*E,d=3*m;var _=2*p,v=2*E,T=2*m,R=n[f],g=n[f+1],A=n[f+2],S=a[_],N=a[_+1],x=a[v+1]-N,I=a[T+1]-N,O=1/((a[v]-S)*I-(a[T]-S)*x),w=(I*(n[h]-R)-x*(n[d]-R))*O,M=(I*(n[h+1]-g)-x*(n[d+1]-g))*O,C=(I*(n[h+2]-A)-x*(n[d+2]-A))*O;c[f]+=w,c[f+1]+=M,c[f+2]+=C,c[h]+=w,c[h+1]+=M,c[h+2]+=C,c[d]+=w,c[d+1]+=M,c[d+2]+=C}var P=new Float32Array(3*o),D=new Float32Array(3*o);for(l=0;l<o;l++){f=3*l,h=f+1,d=f+2;var L=i.fromArray(r,f,pe),U=i.fromArray(c,f,Ee),b=i.dot(L,U);i.multiplyByScalar(L,b,ye),i.normalize(i.subtract(U,ye,U),U),P[f]=U.x,P[h]=U.y,P[d]=U.z,i.normalize(i.cross(L,U,U),U),D[f]=U.x,D[h]=U.y,D[d]=U.z}return e.attributes.tangent=new y({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:P}),e.attributes.bitangent=new y({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:D}),e},ne.computeBinormalAndTangent=function(e){return l("computeBinormalAndTangent","computeBinormalAndTangent was deprecated in 1.30.  It will be removed in 1.31.  Use a computeTangentAndBitangent."),ne.computeTangentAndBitangent(e),e.attributes.binormal=e.attributes.bitangent,e};var me=new r,_e=new i,ve=new i,Te=new i,Re=new r;ne.compressVertices=function(t){var n,a,o=t.attributes.extrudeDirection;if(c(o)){var s=o.values;a=s.length/3;var l=new Float32Array(2*a),f=0;for(n=0;n<a;++n)i.fromArray(s,3*n,_e),i.equals(_e,i.ZERO)?f+=2:(Re=e.octEncodeInRange(_e,65535,Re),l[f++]=Re.x,l[f++]=Re.y);return t.attributes.compressedAttributes=new y({componentDatatype:u.FLOAT,componentsPerAttribute:2,values:l}),delete t.attributes.extrudeDirection,t}var h=t.attributes.normal,d=t.attributes.st,p=c(h),E=c(d);if(!p&&!E)return t;var m,_,v,T,R=t.attributes.tangent,g=t.attributes.bitangent,A=c(R),S=c(g);p&&(m=h.values),E&&(_=d.values),A&&(v=R.values),S&&(T=g.values);var N=p?m.length:_.length,x=p?3:2;a=N/x;var I=a,O=E&&p?2:1;O+=A||S?1:0,I*=O;var w=new Float32Array(I),M=0;for(n=0;n<a;++n){E&&(r.fromArray(_,2*n,me),w[M++]=e.compressTextureCoordinates(me));var C=3*n;p&&c(v)&&c(T)?(i.fromArray(m,C,_e),i.fromArray(v,C,ve),i.fromArray(T,C,Te),e.octPack(_e,ve,Te,me),w[M++]=me.x,w[M++]=me.y):(p&&(i.fromArray(m,C,_e),w[M++]=e.octEncodeFloat(_e)),A&&(i.fromArray(v,C,_e),w[M++]=e.octEncodeFloat(_e)),S&&(i.fromArray(T,C,_e),w[M++]=e.octEncodeFloat(_e)))}return t.attributes.compressedAttributes=new y({componentDatatype:u.FLOAT,componentsPerAttribute:O,values:w}),p&&delete t.attributes.normal,E&&delete t.attributes.st,S&&delete t.attributes.bitangent,A&&delete t.attributes.tangent,t};var ge=new i,Ae=new i,Se=new i,Ne=new i,xe=new i,Ie={positions:new Array(7),indices:new Array(9)},Oe=new i,we=new i,Me=new i,Ce=new i,Pe=new r,De=new r,Le=new r,Ue=A.fromPointNormal(i.ZERO,i.UNIT_Y),be=new i,Fe=new i,ze=new r,Be=new r,Ge=new i,qe=new i,We=new i,Ve=new i,He=new i,Xe=new i,Ye=new a,ke=5*T.EPSILON9,Ze=T.EPSILON6;return ne.splitLongitude=function(e){var t=e.geometry,r=t.boundingSphere;if(c(r)){var i=r.center.x-r.radius;if(i>0||n.intersectPlane(r,A.ORIGIN_ZX_PLANE)!==_.INTERSECTING)return e}if(t.geometryType!==E.NONE)switch(t.geometryType){case E.POLYLINES:te(e);break;case E.TRIANGLES:Q(e);break;case E.LINES:$(e)}else W(t),t.primitiveType===S.TRIANGLES?Q(e):t.primitiveType===S.LINES&&$(e);return e},ne}),define("Core/arrayRemoveDuplicates",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,n,r){"use strict";function i(n,r,i){if(t(n)){i=e(i,!1);var o=n.length;if(o<2)return n;var u,s,c;for(u=1;u<o&&(s=n[u-1],c=n[u],!r(s,c,a));++u);if(u===o)return i&&r(n[0],n[n.length-1],a)?n.slice(1):n;for(var l=n.slice(0,u);u<o;++u)c=n[u],r(s,c,a)||(l.push(c),s=c);return i&&l.length>1&&r(l[0],l[l.length-1],a)&&l.shift(),l}}var a=r.EPSILON10;return i}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("ThirdParty/earcut-2.1.1",[],function(){"use strict";function e(e,n,i){i=i||2;var a=n&&n.length,o=a?n[0]*i:e.length,u=t(e,0,o,i,!0),c=[];if(!u)return c;var l,f,h,d,p,y,E;if(a&&(u=s(e,n,u,i)),e.length>80*i){l=h=e[0],f=d=e[1];for(var m=i;m<o;m+=i)p=e[m],y=e[m+1],p<l&&(l=p),y<f&&(f=y),p>h&&(h=p),y>d&&(d=y);E=Math.max(h-l,d-f)}return r(u,c,i,l,f,E),c}function t(e,t,n,r,i){var a,o;if(i===O(e,t,n,r)>0)for(a=t;a<n;a+=r)o=N(a,e[a],e[a+1],o);else for(a=n-r;a>=t;a-=r)o=N(a,e[a],e[a+1],o);return o&&v(o,o.next)&&(x(o),o=o.next),o}function n(e,t){if(!e)return e;t||(t=e);var n,r=e;do if(n=!1,r.steiner||!v(r,r.next)&&0!==_(r.prev,r,r.next))r=r.next;else{if(x(r),r=t=r.prev,r===r.next)return null;n=!0}while(n||r!==t);return t}function r(e,t,s,c,l,f,d){if(e){!d&&f&&h(e,c,l,f);for(var p,y,E=e;e.prev!==e.next;)if(p=e.prev,y=e.next,f?a(e,c,l,f):i(e))t.push(p.i/s),t.push(e.i/s),t.push(y.i/s),x(e),e=y.next,E=y.next;else if(e=y,e===E){d?1===d?(e=o(e,t,s),r(e,t,s,c,l,f,2)):2===d&&u(e,t,s,c,l,f):r(n(e),t,s,c,l,f,1);break}}}function i(e){var t=e.prev,n=e,r=e.next;if(_(t,n,r)>=0)return!1;for(var i=e.next.next;i!==e.prev;){if(E(t.x,t.y,n.x,n.y,r.x,r.y,i.x,i.y)&&_(i.prev,i,i.next)>=0)return!1;i=i.next}return!0}function a(e,t,n,r){var i=e.prev,a=e,o=e.next;if(_(i,a,o)>=0)return!1;for(var u=i.x<a.x?i.x<o.x?i.x:o.x:a.x<o.x?a.x:o.x,s=i.y<a.y?i.y<o.y?i.y:o.y:a.y<o.y?a.y:o.y,c=i.x>a.x?i.x>o.x?i.x:o.x:a.x>o.x?a.x:o.x,l=i.y>a.y?i.y>o.y?i.y:o.y:a.y>o.y?a.y:o.y,f=p(u,s,t,n,r),h=p(c,l,t,n,r),d=e.nextZ;d&&d.z<=h;){if(d!==e.prev&&d!==e.next&&E(i.x,i.y,a.x,a.y,o.x,o.y,d.x,d.y)&&_(d.prev,d,d.next)>=0)return!1;d=d.nextZ}for(d=e.prevZ;d&&d.z>=f;){if(d!==e.prev&&d!==e.next&&E(i.x,i.y,a.x,a.y,o.x,o.y,d.x,d.y)&&_(d.prev,d,d.next)>=0)return!1;d=d.prevZ}return!0}function o(e,t,n){var r=e;do{var i=r.prev,a=r.next.next;!v(i,a)&&T(i,r,r.next,a)&&g(i,a)&&g(a,i)&&(t.push(i.i/n),t.push(r.i/n),t.push(a.i/n),x(r),x(r.next),r=e=a),r=r.next}while(r!==e);return r}function u(e,t,i,a,o,u){var s=e;do{for(var c=s.next.next;c!==s.prev;){if(s.i!==c.i&&m(s,c)){var l=S(s,c);return s=n(s,s.next),l=n(l,l.next),r(s,t,i,a,o,u),void r(l,t,i,a,o,u)}c=c.next}s=s.next}while(s!==e)}function s(e,r,i,a){var o,u,s,f,h,d=[];for(o=0,u=r.length;o<u;o++)s=r[o]*a,f=o<u-1?r[o+1]*a:e.length,h=t(e,s,f,a,!1),h===h.next&&(h.steiner=!0),d.push(y(h));for(d.sort(c),o=0;o<d.length;o++)l(d[o],i),i=n(i,i.next);return i}function c(e,t){return e.x-t.x}function l(e,t){if(t=f(e,t)){var r=S(t,e);n(r,r.next)}}function f(e,t){var n,r=t,i=e.x,a=e.y,o=-(1/0);do{if(a<=r.y&&a>=r.next.y){var u=r.x+(a-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(u<=i&&u>o){if(o=u,u===i){if(a===r.y)return r;if(a===r.next.y)return r.next}n=r.x<r.next.x?r:r.next}}r=r.next}while(r!==t);if(!n)return null;if(i===o)return n.prev;var s,c=n,l=n.x,f=n.y,h=1/0;for(r=n.next;r!==c;)i>=r.x&&r.x>=l&&E(a<f?i:o,a,l,f,a<f?o:i,a,r.x,r.y)&&(s=Math.abs(a-r.y)/(i-r.x),(s<h||s===h&&r.x>n.x)&&g(r,e)&&(n=r,h=s)),r=r.next;return n}function h(e,t,n,r){var i=e;do null===i.z&&(i.z=p(i.x,i.y,t,n,r)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;while(i!==e);i.prevZ.nextZ=null,i.prevZ=null,d(i)}function d(e){var t,n,r,i,a,o,u,s,c=1;do{for(n=e,e=null,a=null,o=0;n;){for(o++,r=n,u=0,t=0;t<c&&(u++,r=r.nextZ,r);t++);for(s=c;u>0||s>0&&r;)0===u?(i=r,r=r.nextZ,s--):0!==s&&r?n.z<=r.z?(i=n,n=n.nextZ,u--):(i=r,r=r.nextZ,s--):(i=n,n=n.nextZ,u--),a?a.nextZ=i:e=i,i.prevZ=a,a=i;n=r}a.nextZ=null,c*=2}while(o>1);return e}function p(e,t,n,r,i){return e=32767*(e-n)/i,t=32767*(t-r)/i,e=16711935&(e|e<<8),e=252645135&(e|e<<4),e=858993459&(e|e<<2),e=1431655765&(e|e<<1),t=16711935&(t|t<<8),t=252645135&(t|t<<4),t=858993459&(t|t<<2),t=1431655765&(t|t<<1),e|t<<1}function y(e){var t=e,n=e;do t.x<n.x&&(n=t),t=t.next;while(t!==e);return n}function E(e,t,n,r,i,a,o,u){return(i-o)*(t-u)-(e-o)*(a-u)>=0&&(e-o)*(r-u)-(n-o)*(t-u)>=0&&(n-o)*(a-u)-(i-o)*(r-u)>=0}function m(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!R(e,t)&&g(e,t)&&g(t,e)&&A(e,t)}function _(e,t,n){return(t.y-e.y)*(n.x-t.x)-(t.x-e.x)*(n.y-t.y)}function v(e,t){return e.x===t.x&&e.y===t.y}function T(e,t,n,r){return!!(v(e,t)&&v(n,r)||v(e,r)&&v(n,t))||_(e,t,n)>0!=_(e,t,r)>0&&_(n,r,e)>0!=_(n,r,t)>0}function R(e,t){var n=e;do{if(n.i!==e.i&&n.next.i!==e.i&&n.i!==t.i&&n.next.i!==t.i&&T(n,n.next,e,t))return!0;n=n.next}while(n!==e);return!1}function g(e,t){return _(e.prev,e,e.next)<0?_(e,t,e.next)>=0&&_(e,e.prev,t)>=0:_(e,t,e.prev)<0||_(e,e.next,t)<0}function A(e,t){var n=e,r=!1,i=(e.x+t.x)/2,a=(e.y+t.y)/2;do n.y>a!=n.next.y>a&&i<(n.next.x-n.x)*(a-n.y)/(n.next.y-n.y)+n.x&&(r=!r),n=n.next;while(n!==e);return r}function S(e,t){var n=new I(e.i,e.x,e.y),r=new I(t.i,t.x,t.y),i=e.next,a=t.prev;return e.next=t,t.prev=e,n.next=i,i.prev=n,r.next=n,n.prev=r,a.next=r,r.prev=a,r}function N(e,t,n,r){var i=new I(e,t,n);return r?(i.next=r.next,i.prev=r,r.next.prev=i,r.next=i):(i.prev=i,i.next=i),i}function x(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function I(e,t,n){this.i=e,this.x=t,this.y=n,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}function O(e,t,n,r){for(var i=0,a=t,o=n-r;a<n;a+=r)i+=(e[o]-e[a])*(e[a+1]+e[o+1]),o=a;return i}return e.deviation=function(e,t,n,r){var i=t&&t.length,a=i?t[0]*n:e.length,o=Math.abs(O(e,0,a,n));if(i)for(var u=0,s=t.length;u<s;u++){var c=t[u]*n,l=u<s-1?t[u+1]*n:e.length;o-=Math.abs(O(e,c,l,n))}var f=0;for(u=0;u<r.length;u+=3){var h=r[u]*n,d=r[u+1]*n,p=r[u+2]*n;f+=Math.abs((e[h]-e[p])*(e[d+1]-e[h+1])-(e[h]-e[d])*(e[p+1]-e[h+1]))}return 0===o&&0===f?0:Math.abs((f-o)/o)},e.flatten=function(e){for(var t=e[0][0].length,n={vertices:[],holes:[],dimensions:t},r=0,i=0;i<e.length;i++){for(var a=0;a<e[i].length;a++)for(var o=0;o<t;o++)n.vertices.push(e[i][a][o]);i>0&&(r+=e[i-1].length,n.holes.push(r))}return n},e}),define("Core/WindingOrder",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var n={CLOCKWISE:t.CW,COUNTER_CLOCKWISE:t.CCW,validate:function(e){return e===n.CLOCKWISE||e===n.COUNTER_CLOCKWISE}};return e(n)}),define("Core/PolygonPipeline",["../ThirdParty/earcut-2.1.1","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./Math","./PrimitiveType","./WindingOrder"],function(e,t,n,r,i,a,o,u,s,c,l,f,h){"use strict";var d=new n,p=new n,y={};y.computeArea2D=function(e){for(var t=e.length,n=0,r=t-1,i=0;i<t;r=i++){var a=e[r],o=e[i];n+=a.x*o.y-o.x*a.y}return.5*n},y.computeWindingOrder2D=function(e){var t=y.computeArea2D(e);return t>0?h.COUNTER_CLOCKWISE:h.CLOCKWISE},y.triangulate=function(n,r){var i=t.packArray(n);return e(i,r,2)};var E=new n,m=new n,_=new n,v=new n,T=new n,R=new n,g=new n;return y.computeSubdivision=function(e,t,o,u){u=i(u,l.RADIANS_PER_DEGREE);var h,d=o.slice(0),p=t.length,y=new Array(3*p),A=0;for(h=0;h<p;h++){var S=t[h];y[A++]=S.x,y[A++]=S.y,y[A++]=S.z}for(var N=[],x={},I=e.maximumRadius,O=l.chordLength(u,I),w=O*O;d.length>0;){var M,C,P=d.pop(),D=d.pop(),L=d.pop(),U=n.fromArray(y,3*L,E),b=n.fromArray(y,3*D,m),F=n.fromArray(y,3*P,_),z=n.multiplyByScalar(n.normalize(U,v),I,v),B=n.multiplyByScalar(n.normalize(b,T),I,T),G=n.multiplyByScalar(n.normalize(F,R),I,R),q=n.magnitudeSquared(n.subtract(z,B,g)),W=n.magnitudeSquared(n.subtract(B,G,g)),V=n.magnitudeSquared(n.subtract(G,z,g)),H=Math.max(q,W,V);H>w?q===H?(M=Math.min(L,D)+" "+Math.max(L,D),h=x[M],a(h)||(C=n.add(U,b,g),n.multiplyByScalar(C,.5,C),y.push(C.x,C.y,C.z),h=y.length/3-1,x[M]=h),d.push(L,h,P),d.push(h,D,P)):W===H?(M=Math.min(D,P)+" "+Math.max(D,P),h=x[M],a(h)||(C=n.add(b,F,g),n.multiplyByScalar(C,.5,C),y.push(C.x,C.y,C.z),h=y.length/3-1,x[M]=h),d.push(D,h,L),d.push(h,P,L)):V===H&&(M=Math.min(P,L)+" "+Math.max(P,L),h=x[M],a(h)||(C=n.add(F,U,g),n.multiplyByScalar(C,.5,C),y.push(C.x,C.y,C.z),h=y.length/3-1,x[M]=h),d.push(P,h,D),d.push(h,L,D)):(N.push(L),N.push(D),N.push(P))}return new s({attributes:{position:new c({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:y})},indices:N,primitiveType:f.TRIANGLES})},y.scaleToGeodeticHeight=function(e,t,r,o){r=i(r,u.WGS84);var s=d,c=p;if(t=i(t,0),o=i(o,!0),a(e))for(var l=e.length,f=0;f<l;f+=3)n.fromArray(e,f,c),o&&(c=r.scaleToGeodeticSurface(c,c)),0!==t&&(s=r.geodeticSurfaceNormal(c,s),n.multiplyByScalar(s,t,s),n.add(c,s,c)),e[f]=c.x,e[f+1]=c.y,e[f+2]=c.z;return e},y}),define("Core/Queue",["./defineProperties"],function(e){"use strict";function t(){this._array=[],this._offset=0,this._length=0}return e(t.prototype,{length:{get:function(){return this._length}}}),t.prototype.enqueue=function(e){this._array.push(e),this._length++},t.prototype.dequeue=function(){if(0!==this._length){var e=this._array,t=this._offset,n=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this._length--,n}},t.prototype.peek=function(){if(0!==this._length)return this._array[this._offset]},t.prototype.contains=function(e){return this._array.indexOf(e)!==-1},t.prototype.clear=function(){this._array.length=this._offset=this._length=0},t.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},t}),define("Core/PolygonGeometryLibrary",["./arrayRemoveDuplicates","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryPipeline","./IndexDatatype","./Math","./PolygonPipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,n,r,i,a,o,u,s,c,l,f,h,d,p,y){"use strict";function E(e,n,r,i){return t.subtract(n,e,_),t.multiplyByScalar(_,r/i,_),t.add(e,_,_),[_.x,_.y,_.z]}var m={};m.computeHierarchyPackedLength=function(e){for(var n=0,r=[e];r.length>0;){var a=r.pop();if(i(a)){n+=2;var o=a.positions,u=a.holes;if(i(o)&&(n+=o.length*t.packedLength),i(u))for(var s=u.length,c=0;c<s;++c)r.push(u[c])}}return n},m.packPolygonHierarchy=function(e,n,r){for(var a=[e];a.length>0;){var o=a.pop();if(i(o)){var u=o.positions,s=o.holes;if(n[r++]=i(u)?u.length:0,n[r++]=i(s)?s.length:0,i(u))for(var c=u.length,l=0;l<c;++l,r+=3)t.pack(u[l],n,r);if(i(s))for(var f=s.length,h=0;h<f;++h)a.push(s[h])}}return r},m.unpackPolygonHierarchy=function(e,n){for(var r=e[n++],i=e[n++],a=new Array(r),o=i>0?new Array(i):void 0,u=0;u<r;++u,n+=t.packedLength)a[u]=t.unpack(e,n);for(var s=0;s<i;++s)o[s]=m.unpackPolygonHierarchy(e,n),n=o[s].startingIndex,delete o[s].startingIndex;return{positions:a,holes:o,startingIndex:n}};var _=new t;m.subdivideLineCount=function(e,n,r){var i=t.distance(e,n),a=i/r,o=Math.max(0,Math.ceil(Math.log(a)/Math.log(2)));return Math.pow(2,o)},m.subdivideLine=function(e,n,r,a){var o=m.subdivideLineCount(e,n,r),u=t.distance(e,n),s=u/o;i(a)||(a=[]);var c=a;c.length=3*o;for(var l=0,f=0;f<o;f++){var h=E(e,n,f*s,u);c[l++]=h[0],c[l++]=h[1],c[l++]=h[2]}return c};var v=new t,T=new t,R=new t,g=new t;m.scaleToGeodeticHeightExtruded=function(e,n,o,u,s){u=r(u,a.WGS84);var c=v,l=T,f=R,h=g;if(i(e)&&i(e.attributes)&&i(e.attributes.position))for(var d=e.attributes.position.values,p=d.length/2,y=0;y<p;y+=3)t.fromArray(d,y,f),u.geodeticSurfaceNormal(f,c),h=u.scaleToGeodeticSurface(f,h),l=t.multiplyByScalar(c,o,l),l=t.add(h,l,l),d[y+p]=l.x,d[y+1+p]=l.y,d[y+2+p]=l.z,s&&(h=t.clone(f,h)),l=t.multiplyByScalar(c,n,l),l=t.add(h,l,l),d[y]=l.x,d[y+1]=l.y,d[y+2]=l.z;return e},m.polygonsFromHierarchy=function(n,r,a,o){var u=[],s=[],c=new p;for(c.enqueue(n);0!==c.length;){var l=c.dequeue(),f=l.positions,d=l.holes;if(f=e(f,t.equalsEpsilon,!0),!(f.length<3)){var E=a.projectPointsOntoPlane(f),m=[],_=h.computeWindingOrder2D(E);_===y.CLOCKWISE&&(E.reverse(),f=f.slice().reverse());var v,T,R=f.slice(),g=i(d)?d.length:0,A=[];for(v=0;v<g;v++){var S=d[v],N=e(S.positions,t.equalsEpsilon,!0);if(!(N.length<3)){var x=a.projectPointsOntoPlane(N);_=h.computeWindingOrder2D(x),_===y.CLOCKWISE&&(x.reverse(),N=N.slice().reverse()),A.push(N),m.push(R.length),R=R.concat(N),E=E.concat(x);var I=0;for(i(S.holes)&&(I=S.holes.length),T=0;T<I;T++)c.enqueue(S.holes[T])}}if(!r){for(v=0;v<f.length;v++)o.scaleToGeodeticSurface(f[v],f[v]);for(v=0;v<A.length;v++){var O=A[v];for(T=0;T<O.length;++T)o.scaleToGeodeticSurface(O[T],O[T])}}u.push({outerRing:f,holes:A}),s.push({positions:R,positions2D:E,holes:m})}}return{hierarchy:u,polygons:s}},m.createGeometryFromPositions=function(e,t,r,i,a){var s=h.triangulate(t.positions2D,t.holes);s.length<3&&(s=[0,1,2]);var l=t.positions;if(i){for(var f=l.length,p=new Array(3*f),y=0,E=0;E<f;E++){var m=l[E];p[y++]=m.x,p[y++]=m.y,p[y++]=m.z}var _=new o({attributes:{position:new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:p})},indices:s,primitiveType:d.TRIANGLES});return a.normal?c.computeNormal(_):_}return h.computeSubdivision(e,l,s,r)};var A=[],S=new t,N=new t;return m.computeWallGeometry=function(e,r,i,a){var c,h,p,y,E,_=e.length,v=0;if(a)for(h=3*_*2,c=new Array(2*h),p=0;p<_;p++)y=e[p],E=e[(p+1)%_],c[v]=c[v+h]=y.x,++v,c[v]=c[v+h]=y.y,++v,c[v]=c[v+h]=y.z,++v,c[v]=c[v+h]=E.x,++v,c[v]=c[v+h]=E.y,++v,c[v]=c[v+h]=E.z,++v;else{var T=f.chordLength(i,r.maximumRadius),R=0;for(p=0;p<_;p++)R+=m.subdivideLineCount(e[p],e[(p+1)%_],T);for(h=3*(R+_),c=new Array(2*h),p=0;p<_;p++){y=e[p],E=e[(p+1)%_];for(var g=m.subdivideLine(y,E,T,A),x=g.length,I=0;I<x;++I,++v)c[v]=g[I],c[v+h]=g[I];c[v]=E.x,c[v+h]=E.x,++v,c[v]=E.y,c[v+h]=E.y,++v,c[v]=E.z,c[v+h]=E.z,++v}}_=c.length;var O=l.createTypedArray(_/3,_-6*e.length),w=0;
for(_/=6,p=0;p<_;p++){var M=p,C=M+1,P=M+_,D=P+1;y=t.fromArray(c,3*M,S),E=t.fromArray(c,3*C,N),t.equalsEpsilon(y,E,f.EPSILON14)||(O[w++]=M,O[w++]=P,O[w++]=C,O[w++]=C,O[w++]=P,O[w++]=D)}return new o({attributes:new s({position:new u({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:c})}),indices:O,primitiveType:d.TRIANGLES})},m}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,n,r){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.bitangent=e(t.bitangent,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)}return i.POSITION_ONLY=r(new i({position:!0})),i.POSITION_AND_NORMAL=r(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=r(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=r(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=r(new i({position:!0,color:!0})),i.ALL=r(new i({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(t,n,r){return r=e(r,0),n[r++]=t.position?1:0,n[r++]=t.normal?1:0,n[r++]=t.st?1:0,n[r++]=t.tangent?1:0,n[r++]=t.bitangent?1:0,n[r++]=t.color?1:0,n},i.unpack=function(n,r,a){return r=e(r,0),t(a)||(a=new i),a.position=1===n[r++],a.normal=1===n[r++],a.st=1===n[r++],a.tangent=1===n[r++],a.bitangent=1===n[r++],a.color=1===n[r++],a},i.clone=function(e,n){if(t(e))return t(n)||(n=new i),n.position=e.position,n.normal=e.normal,n.st=e.st,n.tangent=e.tangent,n.bitangent=e.bitangent,n.color=e.color,n},i}),define("Core/PolygonGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./Check","./ComponentDatatype","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PolygonGeometryLibrary","./PolygonPipeline","./Quaternion","./Rectangle","./VertexFormat","./WindingOrder"],function(e,t,n,r,i,a,o,u,s,c,l,f,h,d,p,y,E,m,_,v,T,R,g,A,S,N){"use strict";function x(e,t,n,i){for(var a=g.fromAxisAngle(e._plane.normal,n,D),o=v.fromQuaternion(a,L),u=Number.POSITIVE_INFINITY,c=Number.NEGATIVE_INFINITY,l=Number.POSITIVE_INFINITY,f=Number.NEGATIVE_INFINITY,h=t.length,d=0;d<h;++d){var p=r.clone(t[d],P);v.multiplyByVector(o,p,p);var y=e.projectPointOntoPlane(p,C);s(y)&&(u=Math.min(u,y.x),c=Math.max(c,y.x),l=Math.min(l,y.y),f=Math.max(f,y.y))}return i.x=u,i.y=l,i.width=c-u,i.height=f-l,i}function I(e,t,n,r){var i=r.cartesianToCartographic(e,U),a=i.height,o=r.cartesianToCartographic(t,b);o.height=a,r.cartographicToCartesian(o,t);var u=r.cartesianToCartographic(n,b);u.height=a-100,r.cartographicToCartesian(u,n)}function O(e){var t=e.vertexFormat,i=e.geometry,a=e.shadowVolume;if(t.st||t.normal||t.tangent||t.bitangent||a){var u=e.boundingRectangle,s=e.tangentPlane,c=e.ellipsoid,l=e.stRotation,f=e.wall,h=e.top||f,d=e.bottom||f,y=e.perPositionHeight,E=k;E.x=u.x,E.y=u.y;var m,T=i.attributes.position.values,R=T.length,A=t.st?new Float32Array(2*(R/3)):void 0;t.normal&&(m=y&&h&&!f?i.attributes.normal.values:new Float32Array(R));var S=t.tangent?new Float32Array(R):void 0,N=t.bitangent?new Float32Array(R):void 0,x=a?new Float32Array(R):void 0,O=0,w=0,M=B,C=G,P=q,D=!0,L=g.fromAxisAngle(s._plane.normal,l,K),U=v.fromQuaternion(L,J),b=0,F=0;h&&d&&(b=R/2,F=R/3,R/=2);for(var Q=0;Q<R;Q+=3){var $=r.fromArray(T,Q,j);if(t.st){var ee=v.multiplyByVector(U,$,z);ee=c.scaleToGeodeticSurface(ee,ee);var te=s.projectPointOntoPlane(ee,Z);n.subtract(te,E,te);var ne=_.clamp(te.x/u.width,0,1),re=_.clamp(te.y/u.height,0,1);d&&(A[O+F]=ne,A[O+1+F]=re),h&&(A[O]=ne,A[O+1]=re),O+=2}if(t.normal||t.tangent||t.bitangent||a){var ie=w+1,ae=w+2;if(f){if(Q+3<R){var oe=r.fromArray(T,Q+3,W);if(D){var ue=r.fromArray(T,Q+R,V);y&&I($,oe,ue,c),r.subtract(oe,$,oe),r.subtract(ue,$,ue),M=r.normalize(r.cross(ue,oe,M),M),D=!1}r.equalsEpsilon(oe,$,_.EPSILON10)&&(D=!0)}(t.tangent||t.bitangent)&&(P=c.geodeticSurfaceNormal($,P),t.tangent&&(C=r.normalize(r.cross(P,M,C),C)))}else M=c.geodeticSurfaceNormal($,M),(t.tangent||t.bitangent)&&(y&&(H=r.fromArray(m,w,H),X=r.cross(r.UNIT_Z,H,X),X=r.normalize(v.multiplyByVector(U,X,X),X),t.bitangent&&(Y=r.normalize(r.cross(H,X,Y),Y))),C=r.cross(r.UNIT_Z,M,C),C=r.normalize(v.multiplyByVector(U,C,C),C),t.bitangent&&(P=r.normalize(r.cross(M,C,P),P)));t.normal&&(e.wall?(m[w+b]=M.x,m[ie+b]=M.y,m[ae+b]=M.z):d&&(m[w+b]=-M.x,m[ie+b]=-M.y,m[ae+b]=-M.z),(h&&!y||f)&&(m[w]=M.x,m[ie]=M.y,m[ae]=M.z)),a&&(f&&(M=c.geodeticSurfaceNormal($,M)),x[w+b]=-M.x,x[ie+b]=-M.y,x[ae+b]=-M.z),t.tangent&&(e.wall?(S[w+b]=C.x,S[ie+b]=C.y,S[ae+b]=C.z):d&&(S[w+b]=-C.x,S[ie+b]=-C.y,S[ae+b]=-C.z),h&&(y?(S[w]=X.x,S[ie]=X.y,S[ae]=X.z):(S[w]=C.x,S[ie]=C.y,S[ae]=C.z))),t.bitangent&&(d&&(N[w+b]=P.x,N[ie+b]=P.y,N[ae+b]=P.z),h&&(y?(N[w]=Y.x,N[ie]=Y.y,N[ae]=Y.z):(N[w]=P.x,N[ie]=P.y,N[ae]=P.z))),w+=3}}t.st&&(i.attributes.st=new p({componentDatatype:o.FLOAT,componentsPerAttribute:2,values:A})),t.normal&&(i.attributes.normal=new p({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:m})),t.tangent&&(i.attributes.tangent=new p({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:S})),t.bitangent&&(i.attributes.bitangent=new p({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:N})),a&&(i.attributes.extrudeDirection=new p({componentDatatype:o.FLOAT,componentsPerAttribute:3,values:x}))}return i}function w(e,t,n,r,i,a,o,u){var s,c={walls:[]};if(a||o){var l,f,d=T.createGeometryFromPositions(e,t,n,i,u),p=d.attributes.position.values,E=d.indices;if(a&&o){var _=p.concat(p);l=_.length/3,f=m.createTypedArray(l,2*E.length),f.set(E);var v=E.length,g=l/2;for(s=0;s<v;s+=3){var A=f[s]+g,S=f[s+1]+g,x=f[s+2]+g;f[s+v]=x,f[s+1+v]=S,f[s+2+v]=A}if(d.attributes.position.values=_,i){var I=d.attributes.normal.values;d.attributes.normal.values=new Float32Array(_.length),d.attributes.normal.values.set(I)}d.indices=f}else if(o){for(l=p.length/3,f=m.createTypedArray(l,E.length),s=0;s<E.length;s+=3)f[s]=E[s+2],f[s+1]=E[s+1],f[s+2]=E[s];d.indices=f}c.topAndBottom=new y({geometry:d})}var O=r.outerRing,w=h.fromPoints(O,e),M=w.projectPointsOntoPlane(O,Q),C=R.computeWindingOrder2D(M);C===N.CLOCKWISE&&(O=O.slice().reverse());var P=T.computeWallGeometry(O,e,n,i);c.walls.push(new y({geometry:P}));var D=r.holes;for(s=0;s<D.length;s++){var L=D[s];w=h.fromPoints(L,e),M=w.projectPointsOntoPlane(L,Q),C=R.computeWindingOrder2D(M),C===N.COUNTER_CLOCKWISE&&(L=L.slice().reverse()),P=T.computeWallGeometry(L,e,n),c.walls.push(new y({geometry:P}))}return c}function M(e){var t=e.polygonHierarchy,n=u(e.vertexFormat,S.DEFAULT),r=u(e.ellipsoid,f.WGS84),i=u(e.granularity,_.RADIANS_PER_DEGREE),a=u(e.stRotation,0),o=u(e.height,0),c=u(e.perPositionHeight,!1),l=e.extrudedHeight,h=s(l);if(!c&&h)if(_.equalsEpsilon(o,l,_.EPSILON10))l=void 0,h=!1;else{var d=l;l=Math.min(d,o),o=Math.max(d,o)}this._vertexFormat=S.clone(n),this._ellipsoid=f.clone(r),this._granularity=i,this._stRotation=a,this._height=o,this._extrudedHeight=u(l,0),this._extrude=h,this._closeTop=u(e.closeTop,!0),this._closeBottom=u(e.closeBottom,!0),this._polygonHierarchy=t,this._perPositionHeight=c,this._shadowVolume=u(e.shadowVolume,!1),this._workerName="createPolygonGeometry";var p=t.positions;!s(p)||p.length<3?this._rectangle=new A:this._rectangle=A.fromCartesianArray(p,r),this.packedLength=T.computeHierarchyPackedLength(t)+f.packedLength+S.packedLength+A.packedLength+10}var C=new n,P=new r,D=new g,L=new v,U=new i,b=new i,F=new e,z=new r,B=new r,G=new r,q=new r,W=new r,V=new r,H=new r,X=new r,Y=new r,k=new n,Z=new n,j=new r,K=new g,J=new v,Q=[];M.fromPositions=function(e){e=u(e,u.EMPTY_OBJECT);var t={polygonHierarchy:{positions:e.positions},height:e.height,extrudedHeight:e.extrudedHeight,vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight,closeTop:e.closeTop,closeBottom:e.closeBottom};return new M(t)},M.pack=function(e,t,n){return n=u(n,0),n=T.packPolygonHierarchy(e._polygonHierarchy,t,n),f.pack(e._ellipsoid,t,n),n+=f.packedLength,S.pack(e._vertexFormat,t,n),n+=S.packedLength,A.pack(e._rectangle,t,n),n+=A.packedLength,t[n++]=e._height,t[n++]=e._extrudedHeight,t[n++]=e._granularity,t[n++]=e._stRotation,t[n++]=e._extrude?1:0,t[n++]=e._perPositionHeight?1:0,t[n++]=e._closeTop?1:0,t[n++]=e._closeBottom?1:0,t[n++]=e._shadowVolume?1:0,t[n]=e.packedLength,t};var $=f.clone(f.UNIT_SPHERE),ee=new S,te=new A,ne={polygonHierarchy:{}};return M.unpack=function(e,t,n){t=u(t,0);var r=T.unpackPolygonHierarchy(e,t);t=r.startingIndex,delete r.startingIndex;var i=f.unpack(e,t,$);t+=f.packedLength;var a=S.unpack(e,t,ee);t+=S.packedLength;var o=A.unpack(e,t,te);t+=A.packedLength;var c=e[t++],l=e[t++],h=e[t++],d=e[t++],p=1===e[t++],y=1===e[t++],E=1===e[t++],m=1===e[t++],_=1===e[t++],v=e[t];return s(n)||(n=new M(ne)),n._polygonHierarchy=r,n._ellipsoid=f.clone(i,n._ellipsoid),n._vertexFormat=S.clone(a,n._vertexFormat),n._height=c,n._extrudedHeight=l,n._granularity=h,n._stRotation=d,n._extrude=p,n._perPositionHeight=y,n._closeTop=E,n._closeBottom=m,n._rectangle=A.clone(o),n._shadowVolume=_,n.packedLength=v,n},M.createGeometry=function(e){var n=e._vertexFormat,r=e._ellipsoid,i=e._granularity,a=e._stRotation,o=e._height,u=e._extrudedHeight,s=e._extrude,c=e._polygonHierarchy,l=e._perPositionHeight,f=e._closeTop,p=e._closeBottom,_=c.positions;if(!(_.length<3)){var v=h.fromPoints(_,r),g=T.polygonsFromHierarchy(c,l,v,r),A=g.hierarchy,S=g.polygons;if(0!==A.length){_=A[0].outerRing;var N,I,M=x(v,_,a,F),C=[],P={perPositionHeight:l,vertexFormat:n,geometry:void 0,tangentPlane:v,boundingRectangle:M,ellipsoid:r,stRotation:a,bottom:!1,top:!0,wall:!1};if(s)for(P.top=f,P.bottom=p,P.shadowVolume=e._shadowVolume,I=0;I<S.length;I++){N=w(r,S[I],i,A[I],l,f,p,n);var D;f&&p?(D=N.topAndBottom,P.geometry=T.scaleToGeodeticHeightExtruded(D.geometry,o,u,r,l)):f?(D=N.topAndBottom,D.geometry.attributes.position.values=R.scaleToGeodeticHeight(D.geometry.attributes.position.values,o,r,!l),P.geometry=D.geometry):p&&(D=N.topAndBottom,D.geometry.attributes.position.values=R.scaleToGeodeticHeight(D.geometry.attributes.position.values,u,r,!0),P.geometry=D.geometry),(f||p)&&(P.wall=!1,D.geometry=O(P),C.push(D));var L=N.walls;P.wall=!0;for(var U=0;U<L.length;U++){var b=L[U];P.geometry=T.scaleToGeodeticHeightExtruded(b.geometry,o,u,r,l),b.geometry=O(P),C.push(b)}}else for(I=0;I<S.length;I++)N=new y({geometry:T.createGeometryFromPositions(r,S[I],i,l,n)}),N.geometry.attributes.position.values=R.scaleToGeodeticHeight(N.geometry.attributes.position.values,o,r,!l),P.geometry=N.geometry,N.geometry=O(P),C.push(N);N=E.combineInstances(C)[0],N.attributes.position.values=new Float64Array(N.attributes.position.values),N.indices=m.createTypedArray(N.attributes.position.values.length/3,N.indices);var z=N.attributes,B=t.fromVertices(z.position.values);return n.position||delete z.position,new d({attributes:z,indices:N.indices,primitiveType:N.primitiveType,boundingSphere:B})}}},M.createShadowVolume=function(e,t,n){var r=e._granularity,i=e._ellipsoid,a=t(r,i),o=n(r,i);return new M({polygonHierarchy:e._polygonHierarchy,ellipsoid:i,stRotation:e._stRotation,granularity:r,perPositionHeight:!1,extrudedHeight:a,height:o,vertexFormat:S.POSITION_ONLY,shadowVolume:!0})},c(M.prototype,{rectangle:{get:function(){return this._rectangle}}}),M}),define("Workers/createPolygonGeometry",["../Core/defined","../Core/Ellipsoid","../Core/PolygonGeometry"],function(e,t,n){"use strict";function r(r,i){return e(i)&&(r=n.unpack(r,i)),r._ellipsoid=t.clone(r._ellipsoid),n.createGeometry(r)}return r})}();