/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";function e(e){return void 0!==e&&null!==e}return e}),define("Core/DeveloperError",["./defined"],function(e){"use strict";function t(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),define("Core/Check",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e){return e+" is required, actual value was undefined"}function n(e,t,r){return"Expected "+r+" to be typeof "+t+", actual typeof was "+e}var a={};return a.typeOf={},a.defined=function(n,a){if(!e(a))throw new t(r(n))},a.typeOf.func=function(e,r){if("function"!=typeof r)throw new t(n(typeof r,"function",e))},a.typeOf.string=function(e,r){if("string"!=typeof r)throw new t(n(typeof r,"string",e))},a.typeOf.number=function(e,r){if("number"!=typeof r)throw new t(n(typeof r,"number",e))},a.typeOf.number.lessThan=function(e,r,n){if(a.typeOf.number(e,r),r>=n)throw new t("Expected "+e+" to be less than "+n+", actual value was "+r)},a.typeOf.number.lessThanOrEquals=function(e,r,n){if(a.typeOf.number(e,r),r>n)throw new t("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)},a.typeOf.number.greaterThan=function(e,r,n){if(a.typeOf.number(e,r),r<=n)throw new t("Expected "+e+" to be greater than "+n+", actual value was "+r)},a.typeOf.number.greaterThanOrEquals=function(e,r,n){if(a.typeOf.number(e,r),r<n)throw new t("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)},a.typeOf.object=function(e,r){if("object"!=typeof r)throw new t(n(typeof r,"object",e))},a.typeOf.bool=function(e,r){if("boolean"!=typeof r)throw new t(n(typeof r,"boolean",e))},a}),define("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";function t(e,t){return void 0!==e?e:t}return t.EMPTY_OBJECT=e({}),t}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";var a={};a.EPSILON1=.1,a.EPSILON2=.01,a.EPSILON3=.001,a.EPSILON4=1e-4,a.EPSILON5=1e-5,a.EPSILON6=1e-6,a.EPSILON7=1e-7,a.EPSILON8=1e-8,a.EPSILON9=1e-9,a.EPSILON10=1e-10,a.EPSILON11=1e-11,a.EPSILON12=1e-12,a.EPSILON13=1e-13,a.EPSILON14=1e-14,a.EPSILON15=1e-15,a.EPSILON16=1e-16,a.EPSILON17=1e-17,a.EPSILON18=1e-18,a.EPSILON19=1e-19,a.EPSILON20=1e-20,a.GRAVITATIONALPARAMETER=3986004418e5,a.SOLAR_RADIUS=6955e5,a.LUNAR_RADIUS=1737400,a.SIXTY_FOUR_KILOBYTES=65536,a.sign=function(e){return e>0?1:e<0?-1:0},a.signNotZero=function(e){return e<0?-1:1},a.toSNorm=function(e,r){return r=t(r,255),Math.round((.5*a.clamp(e,-1,1)+.5)*r)},a.fromSNorm=function(e,r){return r=t(r,255),a.clamp(e,0,r)/r*2-1},a.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},a.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},a.lerp=function(e,t,r){return(1-r)*e+r*t},a.PI=Math.PI,a.ONE_OVER_PI=1/Math.PI,a.PI_OVER_TWO=.5*Math.PI,a.PI_OVER_THREE=Math.PI/3,a.PI_OVER_FOUR=Math.PI/4,a.PI_OVER_SIX=Math.PI/6,a.THREE_PI_OVER_TWO=3*Math.PI*.5,a.TWO_PI=2*Math.PI,a.ONE_OVER_TWO_PI=1/(2*Math.PI),a.RADIANS_PER_DEGREE=Math.PI/180,a.DEGREES_PER_RADIAN=180/Math.PI,a.RADIANS_PER_ARCSECOND=a.RADIANS_PER_DEGREE/3600,a.toRadians=function(e){return e*a.RADIANS_PER_DEGREE},a.toDegrees=function(e){return e*a.DEGREES_PER_RADIAN},a.convertLongitudeRange=function(e){var t=a.TWO_PI,r=e-Math.floor(e/t)*t;return r<-Math.PI?r+t:r>=Math.PI?r-t:r},a.clampToLatitudeRange=function(e){return a.clamp(e,-1*a.PI_OVER_TWO,a.PI_OVER_TWO)},a.negativePiToPi=function(e){return a.zeroToTwoPi(e+a.PI)-a.PI},a.zeroToTwoPi=function(e){var t=a.mod(e,a.TWO_PI);return Math.abs(t)<a.EPSILON14&&Math.abs(e)>a.EPSILON14?a.TWO_PI:t},a.mod=function(e,t){return(e%t+t)%t},a.equalsEpsilon=function(e,r,n,a){a=t(a,n);var i=Math.abs(e-r);return i<=a||i<=n*Math.max(Math.abs(e),Math.abs(r))};var i=[1];a.factorial=function(e){var t=i.length;if(e>=t)for(var r=i[t-1],n=t;n<=e;n++)i.push(r*n);return i[e]},a.incrementWrap=function(e,r,n){return n=t(n,0),++e,e>r&&(e=n),e},a.isPowerOfTwo=function(e){return 0!==e&&0===(e&e-1)},a.nextPowerOfTwo=function(e){return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},a.clamp=function(e,t,r){return e<t?t:e>r?r:e};var o=new e;return a.setRandomNumberSeed=function(t){o=new e(t)},a.nextRandomNumber=function(){return o.random()},a.acosClamped=function(e){return Math.acos(a.clamp(e,-1,1))},a.asinClamped=function(e){return Math.asin(a.clamp(e,-1,1))},a.chordLength=function(e,t){return 2*t*Math.sin(.5*e)},a.logBase=function(e,t){return Math.log(e)/Math.log(t)},a.fog=function(e,t){var r=e*t;return 1-Math.exp(-(r*r))},a}),define("Core/Cartesian3",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e,r,n){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0)}o.fromSpherical=function(e,n){r(n)||(n=new o);var a=e.clock,i=e.cone,u=t(e.magnitude,1),s=u*Math.sin(i);return n.x=s*Math.cos(a),n.y=s*Math.sin(a),n.z=u*Math.cos(i),n},o.fromElements=function(e,t,n,a){return r(a)?(a.x=e,a.y=t,a.z=n,a):new o(e,t,n)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z)},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(e,r,n){return n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n]=e.z,r},o.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new o),a.x=e[n++],a.y=e[n++],a.z=e[n],a},o.packArray=function(e,t){var n=e.length;r(t)?t.length=3*n:t=new Array(3*n);for(var a=0;a<n;++a)o.pack(e[a],t,3*a);return t},o.unpackArray=function(e,t){var n=e.length;r(t)?t.length=n/3:t=new Array(n/3);for(var a=0;a<n;a+=3){var i=a/3;t[i]=o.unpack(e,a,t[i])}return t},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r},o.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(e,t){var r=o.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z},o.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r},o.divideComponents=function(e,t,r){return r.x=e.x/t.x,r.y=e.y/t.y,r.z=e.z/t.z,r},o.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r},o.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r},o.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r},o.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t};var s=new o;o.lerp=function(e,t,r,n){return o.multiplyByScalar(t,r,s),n=o.multiplyByScalar(e,1-r,n),o.add(s,n,n)};var c=new o,l=new o;o.angleBetween=function(e,t){o.normalize(e,c),o.normalize(t,l);var r=o.dot(c,l),n=o.magnitude(o.cross(c,l,c));return Math.atan2(n,r)};var E=new o;o.mostOrthogonalAxis=function(e,t){var r=o.normalize(e,E);return o.abs(r,r),t=r.x<=r.y?r.x<=r.z?o.clone(o.UNIT_X,t):o.clone(o.UNIT_Z,t):r.y<=r.z?o.clone(o.UNIT_Y,t):o.clone(o.UNIT_Z,t)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)&&i.equalsEpsilon(e.z,t.z,n,a)},o.cross=function(e,t,r){var n=e.x,a=e.y,i=e.z,o=t.x,u=t.y,s=t.z,c=a*s-i*u,l=i*o-n*s,E=n*u-a*o;return r.x=c,r.y=l,r.z=E,r},o.fromDegrees=function(e,t,r,n,a){return e=i.toRadians(e),t=i.toRadians(t),o.fromRadians(e,t,r,n,a)};var f=new o,h=new o,d=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(e,n,a,i,u){a=t(a,0);var s=r(i)?i.radiiSquared:d,c=Math.cos(n);f.x=c*Math.cos(e),f.y=c*Math.sin(e),f.z=Math.sin(n),f=o.normalize(f,f),o.multiplyComponents(s,f,h);var l=Math.sqrt(o.dot(f,h));return h=o.divideByScalar(h,l,h),f=o.multiplyByScalar(f,a,f),r(u)||(u=new o),o.add(h,f,u)},o.fromDegreesArray=function(e,t,n){var a=e.length;r(n)?n.length=a/2:n=new Array(a/2);for(var i=0;i<a;i+=2){var u=e[i],s=e[i+1],c=i/2;n[c]=o.fromDegrees(u,s,0,t,n[c])}return n},o.fromRadiansArray=function(e,t,n){var a=e.length;r(n)?n.length=a/2:n=new Array(a/2);for(var i=0;i<a;i+=2){var u=e[i],s=e[i+1],c=i/2;n[c]=o.fromRadians(u,s,0,t,n[c])}return n},o.fromDegreesArrayHeights=function(e,t,n){var a=e.length;r(n)?n.length=a/3:n=new Array(a/3);for(var i=0;i<a;i+=3){var u=e[i],s=e[i+1],c=e[i+2],l=i/3;n[l]=o.fromDegrees(u,s,c,t,n[l])}return n},o.fromRadiansArrayHeights=function(e,t,n){var a=e.length;r(n)?n.length=a/3:n=new Array(a/3);for(var i=0;i<a;i+=3){var u=e[i],s=e[i+1],c=e[i+2],l=i/3;n[l]=o.fromRadians(u,s,c,t,n[l])}return n},o.ZERO=a(new o(0,0,0)),o.UNIT_X=a(new o(1,0,0)),o.UNIT_Y=a(new o(0,1,0)),o.UNIT_Z=a(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/scaleToGeodeticSurface",["./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n){"use strict";function a(r,a,u,s,c){var l=r.x,E=r.y,f=r.z,h=a.x,d=a.y,p=a.z,m=l*l*h*h,_=E*E*d*d,T=f*f*p*p,y=m+_+T,R=Math.sqrt(1/y),A=e.multiplyByScalar(r,R,i);if(y<s)return isFinite(R)?e.clone(A,c):void 0;var v=u.x,N=u.y,S=u.z,I=o;I.x=A.x*v*2,I.y=A.y*N*2,I.z=A.z*S*2;var g,M,O,C,w,x,P,L,b,U,F,D=(1-R)*e.magnitude(r)/(.5*e.magnitude(I)),B=0;do{D-=B,O=1/(1+D*v),C=1/(1+D*N),w=1/(1+D*S),x=O*O,P=C*C,L=w*w,b=x*O,U=P*C,F=L*w,g=m*x+_*P+T*L-1,M=m*b*v+_*U*N+T*F*S;var z=-2*M;B=g/z}while(Math.abs(g)>n.EPSILON12);return t(c)?(c.x=l*O,c.y=E*C,c.z=f*w,c):new e(l*O,E*C,f*w)}var i=new e,o=new e;return a}),define("Core/Cartographic",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,a,i,o){"use strict";function u(e,r,n){this.longitude=t(e,0),this.latitude=t(r,0),this.height=t(n,0)}u.fromRadians=function(e,n,a,i){return a=t(a,0),r(i)?(i.longitude=e,i.latitude=n,i.height=a,i):new u(e,n,a)},u.fromDegrees=function(e,t,r,n){return e=i.toRadians(e),t=i.toRadians(t),u.fromRadians(e,t,r,n)};var s=new e,c=new e,l=new e,E=new e(1/6378137,1/6378137,1/6356752.314245179),f=new e(1/40680631590769,1/40680631590769,1/40408299984661.445),h=i.EPSILON1;return u.fromCartesian=function(t,n,a){var d=r(n)?n.oneOverRadii:E,p=r(n)?n.oneOverRadiiSquared:f,m=r(n)?n._centerToleranceSquared:h,_=o(t,d,p,m,c);if(r(_)){var T=e.multiplyComponents(_,p,s);T=e.normalize(T,T);var y=e.subtract(t,_,l),R=Math.atan2(T.y,T.x),A=Math.asin(T.z),v=i.sign(e.dot(y,t))*e.magnitude(y);return r(a)?(a.longitude=R,a.latitude=A,a.height=v,a):new u(R,A,v)}},u.clone=function(e,t){if(r(e))return r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new u(e.longitude,e.latitude,e.height)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},u.equalsEpsilon=function(e,t,n){return e===t||r(e)&&r(t)&&Math.abs(e.longitude-t.longitude)<=n&&Math.abs(e.latitude-t.latitude)<=n&&Math.abs(e.height-t.height)<=n},u.ZERO=a(new u(0,0,0)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},u}),define("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./scaleToGeodeticSurface"],function(e,t,r,n,a,i,o,u,s){"use strict";function c(t,n,a,i){n=r(n,0),a=r(a,0),i=r(i,0),t._radii=new e(n,a,i),t._radiiSquared=new e(n*n,a*a,i*i),t._radiiToTheFourth=new e(n*n*n*n,a*a*a*a,i*i*i*i),t._oneOverRadii=new e(0===n?0:1/n,0===a?0:1/a,0===i?0:1/i),t._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===a?0:1/(a*a),0===i?0:1/(i*i)),t._minimumRadius=Math.min(n,a,i),t._maximumRadius=Math.max(n,a,i),t._centerToleranceSquared=u.EPSILON1,0!==t._radiiSquared.z&&(t._sqauredXOverSquaredZ=t._radiiSquared.x/t._radiiSquared.z)}function l(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._sqauredXOverSquaredZ=void 0,c(this,e,t,r)}a(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(n(t)){var a=t._radii;return n(r)?(e.clone(a,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(a.x,a.y,a.z)}},l.fromCartesian3=function(e,t){return n(t)||(t=new l),n(e)?(c(t,e.x,e.y,e.z),t):t},l.WGS84=o(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=o(new l(1,1,1)),l.MOON=o(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,n,a){return a=r(a,0),e.pack(t._radii,n,a),n},l.unpack=function(t,n,a){n=r(n,0);var i=e.unpack(t,n);return l.fromCartesian3(i,a)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,r){var a=t.longitude,i=t.latitude,o=Math.cos(i),u=o*Math.cos(a),s=o*Math.sin(a),c=Math.sin(i);return n(r)||(r=new e),r.x=u,r.y=s,r.z=c,e.normalize(r,r)},l.prototype.geodeticSurfaceNormal=function(t,r){return n(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var E=new e,f=new e;l.prototype.cartographicToCartesian=function(t,r){var a=E,i=f;this.geodeticSurfaceNormalCartographic(t,a),e.multiplyComponents(this._radiiSquared,a,i);var o=Math.sqrt(e.dot(a,i));return e.divideByScalar(i,o,i),e.multiplyByScalar(a,t.height,a),n(r)||(r=new e),e.add(i,a,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;a<r;a++)t[a]=this.cartographicToCartesian(e[a],t[a]);return t};var h=new e,d=new e,p=new e;return l.prototype.cartesianToCartographic=function(r,a){var i=this.scaleToGeodeticSurface(r,d);if(n(i)){var o=this.geodeticSurfaceNormal(i,h),s=e.subtract(r,i,p),c=Math.atan2(o.y,o.x),l=Math.asin(o.z),E=u.sign(e.dot(s,r))*e.magnitude(s);return n(a)?(a.longitude=c,a.latitude=l,a.height=E,a):new t(c,l,E)}},l.prototype.cartesianArrayToCartographicArray=function(e,t){var r=e.length;n(t)?t.length=r:t=new Array(r);for(var a=0;a<r;++a)t[a]=this.cartesianToCartographic(e[a],t[a]);return t},l.prototype.scaleToGeodeticSurface=function(e,t){return s(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,t)},l.prototype.scaleToGeocentricSurface=function(t,r){n(r)||(r=new e);var a=t.x,i=t.y,o=t.z,u=this._oneOverRadiiSquared,s=1/Math.sqrt(a*a*u.x+i*i*u.y+o*o*u.z);return e.multiplyByScalar(t,s,r)},l.prototype.transformPositionToScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return n(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||n(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l.prototype.getSurfaceNormalIntersectionWithZAxis=function(t,a,i){a=r(a,0);var o=this._sqauredXOverSquaredZ;if(n(i)||(i=new e),i.x=0,i.y=0,i.z=t.z*(1-o),!(Math.abs(i.z)>=this._radii.z-a))return i},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,n,a,i,o){"use strict";function u(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return a(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(t,r){var a=this._semimajorAxis,i=t.longitude*a,o=t.latitude*a,u=t.height;return n(r)?(r.x=i,r.y=o,r.z=u,r):new e(i,o,u)},u.prototype.unproject=function(e,r){var a=this._oneOverSemimajorAxis,i=e.x*a,o=e.y*a,u=e.z;return n(r)?(r.longitude=i,r.latitude=o,r.height=u,r):new t(i,o,u)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";function t(t,r){this.start=e(t,0),this.stop=e(r,0)}return t}),define("Core/Matrix3",["./Cartesian3","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(e,t,n,a,i,o,u,s,c){this[0]=r(e,0),this[1]=r(a,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(i,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(c,0)}function c(e){for(var t=0,r=0;r<9;++r){var n=e[r];t+=n*n}return Math.sqrt(t)}function l(e){for(var t=0,r=0;r<3;++r){var n=e[s.getElementIndex(p[r],d[r])];t+=2*n*n}return Math.sqrt(t)}function E(e,t){for(var r=u.EPSILON15,n=0,a=1,i=0;i<3;++i){var o=Math.abs(e[s.getElementIndex(p[i],d[i])]);o>n&&(a=i,n=o)}var c=1,l=0,E=d[a],f=p[a];if(Math.abs(e[s.getElementIndex(f,E)])>r){var h,m=e[s.getElementIndex(f,f)],_=e[s.getElementIndex(E,E)],T=e[s.getElementIndex(f,E)],y=(m-_)/2/T;h=y<0?-1/(-y+Math.sqrt(1+y*y)):1/(y+Math.sqrt(1+y*y)),c=1/Math.sqrt(1+h*h),l=h*c}return t=s.clone(s.IDENTITY,t),t[s.getElementIndex(E,E)]=t[s.getElementIndex(f,f)]=c,t[s.getElementIndex(f,E)]=l,t[s.getElementIndex(E,f)]=-l,t}s.packedLength=9,s.pack=function(e,t,n){return n=r(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t},s.unpack=function(e,t,a){return t=r(t,0),n(a)||(a=new s),a[0]=e[t++],a[1]=e[t++],a[2]=e[t++],a[3]=e[t++],a[4]=e[t++],a[5]=e[t++],a[6]=e[t++],a[7]=e[t++],a[8]=e[t++],a},s.clone=function(e,t){if(n(e))return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new s(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},s.fromArray=function(e,t,a){return t=r(t,0),n(a)||(a=new s),a[0]=e[t],a[1]=e[t+1],a[2]=e[t+2],a[3]=e[t+3],a[4]=e[t+4],a[5]=e[t+5],a[6]=e[t+6],a[7]=e[t+7],a[8]=e[t+8],a},s.fromColumnMajorArray=function(e,t){return s.clone(e,t)},s.fromRowMajorArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new s(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},s.fromQuaternion=function(e,t){var r=e.x*e.x,a=e.x*e.y,i=e.x*e.z,o=e.x*e.w,u=e.y*e.y,c=e.y*e.z,l=e.y*e.w,E=e.z*e.z,f=e.z*e.w,h=e.w*e.w,d=r-u-E+h,p=2*(a-f),m=2*(i+l),_=2*(a+f),T=-r+u-E+h,y=2*(c-o),R=2*(i-l),A=2*(c+o),v=-r-u+E+h;return n(t)?(t[0]=d,t[1]=_,t[2]=R,t[3]=p,t[4]=T,t[5]=A,t[6]=m,t[7]=y,t[8]=v,t):new s(d,p,m,_,T,y,R,A,v)},s.fromHeadingPitchRoll=function(e,t){var r=Math.cos(-e.pitch),a=Math.cos(-e.heading),i=Math.cos(e.roll),o=Math.sin(-e.pitch),u=Math.sin(-e.heading),c=Math.sin(e.roll),l=r*a,E=-i*u+c*o*a,f=c*u+i*o*a,h=r*u,d=i*a+c*o*u,p=-o*i+i*o*u,m=-o,_=c*r,T=i*r;return n(t)?(t[0]=l,t[1]=h,t[2]=m,t[3]=E,t[4]=d,t[5]=_,t[6]=f,t[7]=p,t[8]=T,t):new s(l,E,f,h,d,p,m,_,T)},s.fromScale=function(e,t){return n(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new s(e.x,0,0,0,e.y,0,0,0,e.z)},s.fromUniformScale=function(e,t){return n(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new s(e,0,0,0,e,0,0,0,e)},s.fromCrossProduct=function(e,t){return n(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new s(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},s.fromRotationX=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=r,t[5]=a,t[6]=0,t[7]=-a,t[8]=r,t):new s(1,0,0,0,r,-a,0,a,r)},s.fromRotationY=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=0,t[2]=-a,t[3]=0,t[4]=1,t[5]=0,t[6]=a,t[7]=0,t[8]=r,t):new s(r,0,a,0,1,0,-a,0,r)},s.fromRotationZ=function(e,t){var r=Math.cos(e),a=Math.sin(e);return n(t)?(t[0]=r,t[1]=a,t[2]=0,t[3]=-a,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new s(r,-a,0,a,r,0,0,0,1)},s.toArray=function(e,t){return n(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},s.getElementIndex=function(e,t){return 3*e+t},s.getColumn=function(e,t,r){var n=3*t,a=e[n],i=e[n+1],o=e[n+2];return r.x=a,r.y=i,r.z=o,r},s.setColumn=function(e,t,r,n){n=s.clone(e,n);var a=3*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n},s.getRow=function(e,t,r){var n=e[t],a=e[t+3],i=e[t+6];return r.x=n,r.y=a,r.z=i,r},s.setRow=function(e,t,r,n){return n=s.clone(e,n),n[t]=r.x,n[t+3]=r.y,n[t+6]=r.z,n};var f=new e;s.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],f)),r.y=e.magnitude(e.fromElements(t[3],t[4],t[5],f)),r.z=e.magnitude(e.fromElements(t[6],t[7],t[8],f)),r};var h=new e;s.getMaximumScale=function(t){return s.getScale(t,h),e.maximumComponent(h)},s.multiply=function(e,t,r){var n=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],o=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],u=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],s=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],c=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],l=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],E=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return r[0]=n,r[1]=a,r[2]=i,r[3]=o,r[4]=u,r[5]=s,r[6]=c,r[7]=l,r[8]=E,r},s.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r},s.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r},s.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[3]*a+e[6]*i,u=e[1]*n+e[4]*a+e[7]*i,s=e[2]*n+e[5]*a+e[8]*i;return r.x=o,r.y=u,r.z=s,r},s.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r},s.multiplyByScale=function(e,t,r){return r[0]=e[0]*t.x,r[1]=e[1]*t.x,r[2]=e[2]*t.x,r[3]=e[3]*t.y,r[4]=e[4]*t.y,r[5]=e[5]*t.y,r[6]=e[6]*t.z,r[7]=e[7]*t.z,r[8]=e[8]*t.z,r},s.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},s.transpose=function(e,t){var r=e[0],n=e[3],a=e[6],i=e[1],o=e[4],u=e[7],s=e[2],c=e[5],l=e[8];return t[0]=r,t[1]=n,t[2]=a,t[3]=i,t[4]=o,t[5]=u,t[6]=s,t[7]=c,t[8]=l,t};var d=[1,0,0],p=[2,2,1],m=new s,_=new s;return s.computeEigenDecomposition=function(e,t){var r=u.EPSILON20,a=10,i=0,o=0;n(t)||(t={});for(var f=t.unitary=s.clone(s.IDENTITY,t.unitary),h=t.diagonal=s.clone(e,t.diagonal),d=r*c(h);o<a&&l(h)>d;)E(h,m),s.transpose(m,_),s.multiply(h,m,h),s.multiply(_,h,h),s.multiply(f,m,f),++i>2&&(++o,i=0);return t},s.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},s.determinant=function(e){var t=e[0],r=e[3],n=e[6],a=e[1],i=e[4],o=e[7],u=e[2],s=e[5],c=e[8];return t*(i*c-s*o)+a*(s*n-r*c)+u*(r*o-i*n)},s.inverse=function(e,t){var r=e[0],n=e[1],a=e[2],i=e[3],o=e[4],u=e[5],c=e[6],l=e[7],E=e[8],f=s.determinant(e);t[0]=o*E-l*u,t[1]=l*a-n*E,t[2]=n*u-o*a,t[3]=c*u-i*E,t[4]=r*E-c*a,t[5]=i*a-r*u,t[6]=i*l-c*o,t[7]=c*n-r*l,t[8]=r*o-i*n;var h=1/f;return s.multiplyByScalar(t,h,t)},s.equals=function(e,t){return e===t||n(e)&&n(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},s.equalsEpsilon=function(e,t,r){return e===t||n(e)&&n(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r},s.IDENTITY=o(new s(1,0,0,0,1,0,0,0,1)),s.ZERO=o(new s(0,0,0,0,0,0,0,0,0)),s.COLUMN0ROW0=0,s.COLUMN0ROW1=1,s.COLUMN0ROW2=2,s.COLUMN1ROW0=3,s.COLUMN1ROW1=4,s.COLUMN1ROW2=5,s.COLUMN2ROW0=6,s.COLUMN2ROW1=7,s.COLUMN2ROW2=8,a(s.prototype,{length:{get:function(){return s.packedLength}}}),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},s.prototype.equalsEpsilon=function(e,t){return s.equalsEpsilon(this,e,t)},s.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},s}),define("Core/Cartesian4",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e,r,n,a){this.x=t(e,0),this.y=t(r,0),this.z=t(n,0),this.w=t(a,0)}o.fromElements=function(e,t,n,a,i){return r(i)?(i.x=e,i.y=t,i.z=n,i.w=a,i):new o(e,t,n,a)},o.fromColor=function(e,t){return r(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w)},o.packedLength=4,o.pack=function(e,r,n){return n=t(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w,r},o.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new o),a.x=e[n++],a.y=e[n++],a.z=e[n++],a.w=e[n],a},o.packArray=function(e,t){var n=e.length;r(t)?t.length=4*n:t=new Array(4*n);for(var a=0;a<n;++a)o.pack(e[a],t,4*a);return t},o.unpackArray=function(e,t){var n=e.length;r(t)?t.length=n/4:t=new Array(n/4);for(var a=0;a<n;a+=4){var i=a/4;t[i]=o.unpack(e,a,t[i])}return t},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r.z=Math.min(e.z,t.z),r.w=Math.min(e.w,t.w),r},o.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r.z=Math.max(e.z,t.z),r.w=Math.max(e.w,t.w),r},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(e,t){var r=o.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t.z=e.z/r,t.w=e.w/r,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},o.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r.z=e.z*t.z,r.w=e.w*t.w,r},o.divideComponents=function(e,t,r){return r.x=e.x/t.x,r.y=e.y/t.y,r.z=e.z/t.z,r.w=e.w/t.w,r},o.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r.z=e.z+t.z,r.w=e.w+t.w,r},o.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r.z=e.z-t.z,r.w=e.w-t.w,r},o.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r.z=e.z*t,r.w=e.w*t,r},o.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r.z=e.z/t,r.w=e.w/t,r},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var s=new o;o.lerp=function(e,t,r,n){return o.multiplyByScalar(t,r,s),n=o.multiplyByScalar(e,1-r,n),o.add(s,n,n)};var c=new o;return o.mostOrthogonalAxis=function(e,t){var r=o.normalize(e,c);return o.abs(r,r),t=r.x<=r.y?r.x<=r.z?r.x<=r.w?o.clone(o.UNIT_X,t):o.clone(o.UNIT_W,t):r.z<=r.w?o.clone(o.UNIT_Z,t):o.clone(o.UNIT_W,t):r.y<=r.z?r.y<=r.w?o.clone(o.UNIT_Y,t):o.clone(o.UNIT_W,t):r.z<=r.w?o.clone(o.UNIT_Z,t):o.clone(o.UNIT_W,t)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)&&i.equalsEpsilon(e.z,t.z,n,a)&&i.equalsEpsilon(e.w,t.w,n,a)},o.ZERO=a(new o(0,0,0,0)),o.UNIT_X=a(new o(1,0,0,0)),o.UNIT_Y=a(new o(0,1,0,0)),o.UNIT_Z=a(new o(0,0,1,0)),o.UNIT_W=a(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/RuntimeError",["./defined"],function(e){"use strict";function t(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(e){t=e.stack}this.stack=t}return e(Object.create)&&(t.prototype=Object.create(Error.prototype),t.prototype.constructor=t),t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,n,a,i,o,u,s,c,l){
"use strict";function E(e,t,r,a,i,o,u,s,c,l,E,f,h,d,p,m){this[0]=n(e,0),this[1]=n(i,0),this[2]=n(c,0),this[3]=n(h,0),this[4]=n(t,0),this[5]=n(o,0),this[6]=n(l,0),this[7]=n(d,0),this[8]=n(r,0),this[9]=n(u,0),this[10]=n(E,0),this[11]=n(p,0),this[12]=n(a,0),this[13]=n(s,0),this[14]=n(f,0),this[15]=n(m,0)}E.packedLength=16,E.pack=function(e,t,r){return r=n(r,0),t[r++]=e[0],t[r++]=e[1],t[r++]=e[2],t[r++]=e[3],t[r++]=e[4],t[r++]=e[5],t[r++]=e[6],t[r++]=e[7],t[r++]=e[8],t[r++]=e[9],t[r++]=e[10],t[r++]=e[11],t[r++]=e[12],t[r++]=e[13],t[r++]=e[14],t[r]=e[15],t},E.unpack=function(e,t,r){return t=n(t,0),a(r)||(r=new E),r[0]=e[t++],r[1]=e[t++],r[2]=e[t++],r[3]=e[t++],r[4]=e[t++],r[5]=e[t++],r[6]=e[t++],r[7]=e[t++],r[8]=e[t++],r[9]=e[t++],r[10]=e[t++],r[11]=e[t++],r[12]=e[t++],r[13]=e[t++],r[14]=e[t++],r[15]=e[t],r},E.clone=function(e,t){if(a(e))return a(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new E(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},E.fromArray=E.unpack,E.fromColumnMajorArray=function(e,t){return E.clone(e,t)},E.fromRowMajorArray=function(e,t){return a(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new E(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},E.fromRotationTranslation=function(t,r,i){return r=n(r,e.ZERO),a(i)?(i[0]=t[0],i[1]=t[1],i[2]=t[2],i[3]=0,i[4]=t[3],i[5]=t[4],i[6]=t[5],i[7]=0,i[8]=t[6],i[9]=t[7],i[10]=t[8],i[11]=0,i[12]=r.x,i[13]=r.y,i[14]=r.z,i[15]=1,i):new E(t[0],t[3],t[6],r.x,t[1],t[4],t[7],r.y,t[2],t[5],t[8],r.z,0,0,0,1)},E.fromTranslationQuaternionRotationScale=function(e,t,r,n){a(n)||(n=new E);var i=r.x,o=r.y,u=r.z,s=t.x*t.x,c=t.x*t.y,l=t.x*t.z,f=t.x*t.w,h=t.y*t.y,d=t.y*t.z,p=t.y*t.w,m=t.z*t.z,_=t.z*t.w,T=t.w*t.w,y=s-h-m+T,R=2*(c-_),A=2*(l+p),v=2*(c+_),N=-s+h-m+T,S=2*(d-f),I=2*(l-p),g=2*(d+f),M=-s-h+m+T;return n[0]=y*i,n[1]=v*i,n[2]=I*i,n[3]=0,n[4]=R*o,n[5]=N*o,n[6]=g*o,n[7]=0,n[8]=A*u,n[9]=S*u,n[10]=M*u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n},E.fromTranslationRotationScale=function(e,t){return E.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},E.fromTranslation=function(e,t){return E.fromRotationTranslation(c.IDENTITY,e,t)},E.fromScale=function(e,t){return a(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new E(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},E.fromUniformScale=function(e,t){return a(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new E(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,h=new e,d=new e;E.fromCamera=function(t,r){var n=t.position,i=t.direction,o=t.up;e.normalize(i,f),e.normalize(e.cross(f,o,h),h),e.normalize(e.cross(h,f,d),d);var u=h.x,s=h.y,c=h.z,l=f.x,p=f.y,m=f.z,_=d.x,T=d.y,y=d.z,R=n.x,A=n.y,v=n.z,N=u*-R+s*-A+c*-v,S=_*-R+T*-A+y*-v,I=l*R+p*A+m*v;return a(r)?(r[0]=u,r[1]=_,r[2]=-l,r[3]=0,r[4]=s,r[5]=T,r[6]=-p,r[7]=0,r[8]=c,r[9]=y,r[10]=-m,r[11]=0,r[12]=N,r[13]=S,r[14]=I,r[15]=1,r):new E(u,s,c,N,_,T,y,S,-l,-p,-m,I,0,0,0,1)},E.computePerspectiveFieldOfView=function(e,t,r,n,a){var i=Math.tan(.5*e),o=1/i,u=o/t,s=(n+r)/(r-n),c=2*n*r/(r-n);return a[0]=u,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=o,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=s,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},E.computeOrthographicOffCenter=function(e,t,r,n,a,i,o){var u=1/(t-e),s=1/(n-r),c=1/(i-a),l=-(t+e)*u,E=-(n+r)*s,f=-(i+a)*c;return u*=2,s*=2,c*=-2,o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=0,o[12]=l,o[13]=E,o[14]=f,o[15]=1,o},E.computePerspectiveOffCenter=function(e,t,r,n,a,i,o){var u=2*a/(t-e),s=2*a/(n-r),c=(t+e)/(t-e),l=(n+r)/(n-r),E=-(i+a)/(i-a),f=-1,h=-2*i*a/(i-a);return o[0]=u,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=c,o[9]=l,o[10]=E,o[11]=f,o[12]=0,o[13]=0,o[14]=h,o[15]=0,o},E.computeInfinitePerspectiveOffCenter=function(e,t,r,n,a,i){var o=2*a/(t-e),u=2*a/(n-r),s=(t+e)/(t-e),c=(n+r)/(n-r),l=-1,E=-1,f=-2*a;return i[0]=o,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=u,i[6]=0,i[7]=0,i[8]=s,i[9]=c,i[10]=l,i[11]=E,i[12]=0,i[13]=0,i[14]=f,i[15]=0,i},E.computeViewportTransformation=function(e,t,r,a){e=n(e,n.EMPTY_OBJECT);var i=n(e.x,0),o=n(e.y,0),u=n(e.width,0),s=n(e.height,0);t=n(t,0),r=n(r,1);var c=.5*u,l=.5*s,E=.5*(r-t),f=c,h=l,d=E,p=i+c,m=o+l,_=t+E,T=1;return a[0]=f,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=h,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=d,a[11]=0,a[12]=p,a[13]=m,a[14]=_,a[15]=T,a},E.computeView=function(t,r,n,a,i){return i[0]=a.x,i[1]=n.x,i[2]=-r.x,i[3]=0,i[4]=a.y,i[5]=n.y,i[6]=-r.y,i[7]=0,i[8]=a.z,i[9]=n.z,i[10]=-r.z,i[11]=0,i[12]=-e.dot(a,t),i[13]=-e.dot(n,t),i[14]=e.dot(r,t),i[15]=1,i},E.toArray=function(e,t){return a(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},E.getElementIndex=function(e,t){return 4*e+t},E.getColumn=function(e,t,r){var n=4*t,a=e[n],i=e[n+1],o=e[n+2],u=e[n+3];return r.x=a,r.y=i,r.z=o,r.w=u,r},E.setColumn=function(e,t,r,n){n=E.clone(e,n);var a=4*t;return n[a]=r.x,n[a+1]=r.y,n[a+2]=r.z,n[a+3]=r.w,n},E.setTranslation=function(e,t,r){return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=e[15],r},E.getRow=function(e,t,r){var n=e[t],a=e[t+4],i=e[t+8],o=e[t+12];return r.x=n,r.y=a,r.z=i,r.w=o,r},E.setRow=function(e,t,r,n){return n=E.clone(e,n),n[t]=r.x,n[t+4]=r.y,n[t+8]=r.z,n[t+12]=r.w,n};var p=new e;E.getScale=function(t,r){return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],p)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],p)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],p)),r};var m=new e;E.getMaximumScale=function(t){return E.getScale(t,m),e.maximumComponent(m)},E.multiply=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[3],u=e[4],s=e[5],c=e[6],l=e[7],E=e[8],f=e[9],h=e[10],d=e[11],p=e[12],m=e[13],_=e[14],T=e[15],y=t[0],R=t[1],A=t[2],v=t[3],N=t[4],S=t[5],I=t[6],g=t[7],M=t[8],O=t[9],C=t[10],w=t[11],x=t[12],P=t[13],L=t[14],b=t[15],U=n*y+u*R+E*A+p*v,F=a*y+s*R+f*A+m*v,D=i*y+c*R+h*A+_*v,B=o*y+l*R+d*A+T*v,z=n*N+u*S+E*I+p*g,G=a*N+s*S+f*I+m*g,V=i*N+c*S+h*I+_*g,q=o*N+l*S+d*I+T*g,X=n*M+u*O+E*C+p*w,H=a*M+s*O+f*C+m*w,W=i*M+c*O+h*C+_*w,k=o*M+l*O+d*C+T*w,Y=n*x+u*P+E*L+p*b,Z=a*x+s*P+f*L+m*b,K=i*x+c*P+h*L+_*b,j=o*x+l*P+d*L+T*b;return r[0]=U,r[1]=F,r[2]=D,r[3]=B,r[4]=z,r[5]=G,r[6]=V,r[7]=q,r[8]=X,r[9]=H,r[10]=W,r[11]=k,r[12]=Y,r[13]=Z,r[14]=K,r[15]=j,r},E.add=function(e,t,r){return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},E.subtract=function(e,t,r){return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},E.multiplyTransformation=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],E=e[10],f=e[12],h=e[13],d=e[14],p=t[0],m=t[1],_=t[2],T=t[4],y=t[5],R=t[6],A=t[8],v=t[9],N=t[10],S=t[12],I=t[13],g=t[14],M=n*p+o*m+c*_,O=a*p+u*m+l*_,C=i*p+s*m+E*_,w=n*T+o*y+c*R,x=a*T+u*y+l*R,P=i*T+s*y+E*R,L=n*A+o*v+c*N,b=a*A+u*v+l*N,U=i*A+s*v+E*N,F=n*S+o*I+c*g+f,D=a*S+u*I+l*g+h,B=i*S+s*I+E*g+d;return r[0]=M,r[1]=O,r[2]=C,r[3]=0,r[4]=w,r[5]=x,r[6]=P,r[7]=0,r[8]=L,r[9]=b,r[10]=U,r[11]=0,r[12]=F,r[13]=D,r[14]=B,r[15]=1,r},E.multiplyByMatrix3=function(e,t,r){var n=e[0],a=e[1],i=e[2],o=e[4],u=e[5],s=e[6],c=e[8],l=e[9],E=e[10],f=t[0],h=t[1],d=t[2],p=t[3],m=t[4],_=t[5],T=t[6],y=t[7],R=t[8],A=n*f+o*h+c*d,v=a*f+u*h+l*d,N=i*f+s*h+E*d,S=n*p+o*m+c*_,I=a*p+u*m+l*_,g=i*p+s*m+E*_,M=n*T+o*y+c*R,O=a*T+u*y+l*R,C=i*T+s*y+E*R;return r[0]=A,r[1]=v,r[2]=N,r[3]=0,r[4]=S,r[5]=I,r[6]=g,r[7]=0,r[8]=M,r[9]=O,r[10]=C,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},E.multiplyByTranslation=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=n*e[0]+a*e[4]+i*e[8]+e[12],u=n*e[1]+a*e[5]+i*e[9]+e[13],s=n*e[2]+a*e[6]+i*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=o,r[13]=u,r[14]=s,r[15]=e[15],r};var _=new e;E.multiplyByUniformScale=function(e,t,r){return _.x=t,_.y=t,_.z=t,E.multiplyByScale(e,_,r)},E.multiplyByScale=function(e,t,r){var n=t.x,a=t.y,i=t.z;return 1===n&&1===a&&1===i?E.clone(e,r):(r[0]=n*e[0],r[1]=n*e[1],r[2]=n*e[2],r[3]=0,r[4]=a*e[4],r[5]=a*e[5],r[6]=a*e[6],r[7]=0,r[8]=i*e[8],r[9]=i*e[9],r[10]=i*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},E.multiplyByVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=t.w,u=e[0]*n+e[4]*a+e[8]*i+e[12]*o,s=e[1]*n+e[5]*a+e[9]*i+e[13]*o,c=e[2]*n+e[6]*a+e[10]*i+e[14]*o,l=e[3]*n+e[7]*a+e[11]*i+e[15]*o;return r.x=u,r.y=s,r.z=c,r.w=l,r},E.multiplyByPointAsVector=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i,u=e[1]*n+e[5]*a+e[9]*i,s=e[2]*n+e[6]*a+e[10]*i;return r.x=o,r.y=u,r.z=s,r},E.multiplyByPoint=function(e,t,r){var n=t.x,a=t.y,i=t.z,o=e[0]*n+e[4]*a+e[8]*i+e[12],u=e[1]*n+e[5]*a+e[9]*i+e[13],s=e[2]*n+e[6]*a+e[10]*i+e[14];return r.x=o,r.y=u,r.z=s,r},E.multiplyByScalar=function(e,t,r){return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},E.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},E.transpose=function(e,t){var r=e[1],n=e[2],a=e[3],i=e[6],o=e[7],u=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=n,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=o,t[14]=u,t[15]=e[15],t},E.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},E.equals=function(e,t){return e===t||a(e)&&a(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},E.equalsEpsilon=function(e,t,r){return e===t||a(e)&&a(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},E.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},E.getRotation=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var T=new c,y=new c,R=new t,A=new t(0,0,0,1);return E.inverse=function(e,r){if(c.equalsEpsilon(E.getRotation(e,T),y,s.EPSILON7)&&t.equals(E.getRow(e,3,R),A))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var n=e[0],a=e[4],i=e[8],o=e[12],u=e[1],f=e[5],h=e[9],d=e[13],p=e[2],m=e[6],_=e[10],v=e[14],N=e[3],S=e[7],I=e[11],g=e[15],M=_*g,O=v*I,C=m*g,w=v*S,x=m*I,P=_*S,L=p*g,b=v*N,U=p*I,F=_*N,D=p*S,B=m*N,z=M*f+w*h+x*d-(O*f+C*h+P*d),G=O*u+L*h+F*d-(M*u+b*h+U*d),V=C*u+b*f+D*d-(w*u+L*f+B*d),q=P*u+U*f+B*h-(x*u+F*f+D*h),X=O*a+C*i+P*o-(M*a+w*i+x*o),H=M*n+b*i+U*o-(O*n+L*i+F*o),W=w*n+L*a+B*o-(C*n+b*a+D*o),k=x*n+F*a+D*i-(P*n+U*a+B*i);M=i*d,O=o*h,C=a*d,w=o*f,x=a*h,P=i*f,L=n*d,b=o*u,U=n*h,F=i*u,D=n*f,B=a*u;var Y=M*S+w*I+x*g-(O*S+C*I+P*g),Z=O*N+L*I+F*g-(M*N+b*I+U*g),K=C*N+b*S+D*g-(w*N+L*S+B*g),j=P*N+U*S+B*I-(x*N+F*S+D*I),Q=C*_+P*v+O*m-(x*v+M*m+w*_),J=U*v+M*p+b*_-(L*_+F*v+O*p),$=L*m+B*v+w*p-(D*v+C*p+b*m),ee=D*_+x*p+F*m-(U*m+B*_+P*p),te=n*z+a*G+i*V+o*q;if(Math.abs(te)<s.EPSILON20)throw new l("matrix is not invertible because its determinate is zero.");return te=1/te,r[0]=z*te,r[1]=G*te,r[2]=V*te,r[3]=q*te,r[4]=X*te,r[5]=H*te,r[6]=W*te,r[7]=k*te,r[8]=Y*te,r[9]=Z*te,r[10]=K*te,r[11]=j*te,r[12]=Q*te,r[13]=J*te,r[14]=$*te,r[15]=ee*te,r},E.inverseTransformation=function(e,t){var r=e[0],n=e[1],a=e[2],i=e[4],o=e[5],u=e[6],s=e[8],c=e[9],l=e[10],E=e[12],f=e[13],h=e[14],d=-r*E-n*f-a*h,p=-i*E-o*f-u*h,m=-s*E-c*f-l*h;return t[0]=r,t[1]=i,t[2]=s,t[3]=0,t[4]=n,t[5]=o,t[6]=c,t[7]=0,t[8]=a,t[9]=u,t[10]=l,t[11]=0,t[12]=d,t[13]=p,t[14]=m,t[15]=1,t},E.IDENTITY=u(new E(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),E.ZERO=u(new E(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),E.COLUMN0ROW0=0,E.COLUMN0ROW1=1,E.COLUMN0ROW2=2,E.COLUMN0ROW3=3,E.COLUMN1ROW0=4,E.COLUMN1ROW1=5,E.COLUMN1ROW2=6,E.COLUMN1ROW3=7,E.COLUMN2ROW0=8,E.COLUMN2ROW1=9,E.COLUMN2ROW2=10,E.COLUMN2ROW3=11,E.COLUMN3ROW0=12,E.COLUMN3ROW1=13,E.COLUMN3ROW2=14,E.COLUMN3ROW3=15,i(E.prototype,{length:{get:function(){return E.packedLength}}}),E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},E.prototype.equalsEpsilon=function(e,t){return E.equalsEpsilon(this,e,t)},E.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},E}),define("Core/Rectangle",["./Cartographic","./Check","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,n,a,i,o,u,s){"use strict";function c(e,t,n,a){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(a,0)}a(c.prototype,{width:{get:function(){return c.computeWidth(this)}},height:{get:function(){return c.computeHeight(this)}}}),c.packedLength=4,c.pack=function(e,t,n){return n=r(n,0),t[n++]=e.west,t[n++]=e.south,t[n++]=e.east,t[n]=e.north,t},c.unpack=function(e,t,a){return t=r(t,0),n(a)||(a=new c),a.west=e[t++],a.south=e[t++],a.east=e[t++],a.north=e[t],a},c.computeWidth=function(e){var t=e.east,r=e.west;return t<r&&(t+=s.TWO_PI),t-r},c.computeHeight=function(e){return e.north-e.south},c.fromDegrees=function(e,t,a,i,o){return e=s.toRadians(r(e,0)),t=s.toRadians(r(t,0)),a=s.toRadians(r(a,0)),i=s.toRadians(r(i,0)),n(o)?(o.west=e,o.south=t,o.east=a,o.north=i,o):new c(e,t,a,i)},c.fromRadians=function(e,t,a,i,o){return n(o)?(o.west=r(e,0),o.south=r(t,0),o.east=r(a,0),o.north=r(i,0),o):new c(e,t,a,i)},c.fromCartographicArray=function(e,t){for(var r=Number.MAX_VALUE,a=-Number.MAX_VALUE,i=Number.MAX_VALUE,o=-Number.MAX_VALUE,u=Number.MAX_VALUE,l=-Number.MAX_VALUE,E=0,f=e.length;E<f;E++){var h=e[E];r=Math.min(r,h.longitude),a=Math.max(a,h.longitude),u=Math.min(u,h.latitude),l=Math.max(l,h.latitude);var d=h.longitude>=0?h.longitude:h.longitude+s.TWO_PI;i=Math.min(i,d),o=Math.max(o,d)}return a-r>o-i&&(r=i,a=o,a>s.PI&&(a-=s.TWO_PI),r>s.PI&&(r-=s.TWO_PI)),n(t)?(t.west=r,t.south=u,t.east=a,t.north=l,t):new c(r,u,a,l)},c.fromCartesianArray=function(e,t,r){for(var a=Number.MAX_VALUE,i=-Number.MAX_VALUE,o=Number.MAX_VALUE,u=-Number.MAX_VALUE,l=Number.MAX_VALUE,E=-Number.MAX_VALUE,f=0,h=e.length;f<h;f++){var d=t.cartesianToCartographic(e[f]);a=Math.min(a,d.longitude),i=Math.max(i,d.longitude),l=Math.min(l,d.latitude),E=Math.max(E,d.latitude);var p=d.longitude>=0?d.longitude:d.longitude+s.TWO_PI;o=Math.min(o,p),u=Math.max(u,p)}return i-a>u-o&&(a=o,i=u,i>s.PI&&(i-=s.TWO_PI),a>s.PI&&(a-=s.TWO_PI)),n(r)?(r.west=a,r.south=l,r.east=i,r.north=E,r):new c(a,l,i,E)},c.clone=function(e,t){if(n(e))return n(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new c(e.west,e.south,e.east,e.north)},c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equals=function(e,t){return e===t||n(e)&&n(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},c.prototype.equalsEpsilon=function(e,t){return n(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},c.validate=function(e){},c.southwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.south,r.height=0,r):new e(t.west,t.south)},c.northwest=function(t,r){return n(r)?(r.longitude=t.west,r.latitude=t.north,r.height=0,r):new e(t.west,t.north)},c.northeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.north,r.height=0,r):new e(t.east,t.north)},c.southeast=function(t,r){return n(r)?(r.longitude=t.east,r.latitude=t.south,r.height=0,r):new e(t.east,t.south)},c.center=function(t,r){var a=t.east,i=t.west;a<i&&(a+=s.TWO_PI);var o=s.negativePiToPi(.5*(i+a)),u=.5*(t.south+t.north);return n(r)?(r.longitude=o,r.latitude=u,r.height=0,r):new e(o,u)},c.intersection=function(e,t,r){var a=e.east,i=e.west,o=t.east,u=t.west;a<i&&o>0?a+=s.TWO_PI:o<u&&a>0&&(o+=s.TWO_PI),a<i&&u<0?u+=s.TWO_PI:o<u&&i<0&&(i+=s.TWO_PI);var l=s.negativePiToPi(Math.max(i,u)),E=s.negativePiToPi(Math.min(a,o));if(!((e.west<e.east||t.west<t.east)&&E<=l)){var f=Math.max(e.south,t.south),h=Math.min(e.north,t.north);if(!(f>=h))return n(r)?(r.west=l,r.south=f,r.east=E,r.north=h,r):new c(l,f,E,h)}},c.simpleIntersection=function(e,t,r){var a=Math.max(e.west,t.west),i=Math.max(e.south,t.south),o=Math.min(e.east,t.east),u=Math.min(e.north,t.north);if(!(i>=u||a>=o))return n(r)?(r.west=a,r.south=i,r.east=o,r.north=u,r):new c(a,i,o,u)},c.union=function(e,t,r){n(r)||(r=new c);var a=e.east,i=e.west,o=t.east,u=t.west;a<i&&o>0?a+=s.TWO_PI:o<u&&a>0&&(o+=s.TWO_PI),a<i&&u<0?u+=s.TWO_PI:o<u&&i<0&&(i+=s.TWO_PI);var l=s.convertLongitudeRange(Math.min(i,u)),E=s.convertLongitudeRange(Math.max(a,o));return r.west=l,r.south=Math.min(e.south,t.south),r.east=E,r.north=Math.max(e.north,t.north),r},c.expand=function(e,t,r){return n(r)||(r=new c),r.west=Math.min(e.west,t.longitude),r.south=Math.min(e.south,t.latitude),r.east=Math.max(e.east,t.longitude),r.north=Math.max(e.north,t.latitude),r},c.contains=function(e,t){var r=t.longitude,n=t.latitude,a=e.west,i=e.east;return i<a&&(i+=s.TWO_PI,r<0&&(r+=s.TWO_PI)),(r>a||s.equalsEpsilon(r,a,s.EPSILON14))&&(r<i||s.equalsEpsilon(r,i,s.EPSILON14))&&n>=e.south&&n<=e.north};var l=new e;return c.subsample=function(e,t,a,i){t=r(t,o.WGS84),a=r(a,0),n(i)||(i=[]);var u=0,E=e.north,f=e.south,h=e.east,d=e.west,p=l;p.height=a,p.longitude=d,p.latitude=E,i[u]=t.cartographicToCartesian(p,i[u]),u++,p.longitude=h,i[u]=t.cartographicToCartesian(p,i[u]),u++,p.latitude=f,i[u]=t.cartographicToCartesian(p,i[u]),u++,p.longitude=d,i[u]=t.cartographicToCartesian(p,i[u]),u++,E<0?p.latitude=E:f>0?p.latitude=f:p.latitude=0;for(var m=1;m<8;++m)p.longitude=-Math.PI+m*s.PI_OVER_TWO,c.contains(e,p)&&(i[u]=t.cartographicToCartesian(p,i[u]),u++);return 0===p.latitude&&(p.longitude=d,i[u]=t.cartographicToCartesian(p,i[u]),u++,p.longitude=h,i[u]=t.cartographicToCartesian(p,i[u]),u++),i.length=u,i},c.MAX_VALUE=u(new c(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),c}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./Check","./defaultValue","./defined","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix3","./Matrix4","./Rectangle"],function(e,t,r,n,a,i,o,u,s,c,l,E){"use strict";function f(t,r){this.center=e.clone(n(t,e.ZERO)),this.radius=n(r,0)}var h=new e,d=new e,p=new e,m=new e,_=new e,T=new e,y=new e,R=new e,A=new e,v=new e,N=new e,S=new e;f.fromPoints=function(t,r){if(a(r)||(r=new f),!a(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var n=e.clone(t[0],y),i=e.clone(n,h),o=e.clone(n,d),u=e.clone(n,p),s=e.clone(n,m),c=e.clone(n,_),l=e.clone(n,T),E=t.length,I=1;I<E;I++){e.clone(t[I],n);var g=n.x,M=n.y,O=n.z;g<i.x&&e.clone(n,i),g>s.x&&e.clone(n,s),M<o.y&&e.clone(n,o),M>c.y&&e.clone(n,c),O<u.z&&e.clone(n,u),O>l.z&&e.clone(n,l)}var C=e.magnitudeSquared(e.subtract(s,i,R)),w=e.magnitudeSquared(e.subtract(c,o,R)),x=e.magnitudeSquared(e.subtract(l,u,R)),P=i,L=s,b=C;w>b&&(b=w,P=o,L=c),x>b&&(b=x,P=u,L=l);var U=A;U.x=.5*(P.x+L.x),U.y=.5*(P.y+L.y),U.z=.5*(P.z+L.z);var F=e.magnitudeSquared(e.subtract(L,U,R)),D=Math.sqrt(F),B=v;B.x=i.x,B.y=o.y,B.z=u.z;var z=N;z.x=s.x,z.y=c.y,z.z=l.z;var G=e.multiplyByScalar(e.add(B,z,R),.5,S),V=0;for(I=0;I<E;I++){e.clone(t[I],n);var q=e.magnitude(e.subtract(n,G,R));q>V&&(V=q);var X=e.magnitudeSquared(e.subtract(n,U,R));if(X>F){var H=Math.sqrt(X);D=.5*(D+H),F=D*D;var W=H-D;U.x=(D*U.x+W*n.x)/H,U.y=(D*U.y+W*n.y)/H,U.z=(D*U.z+W*n.z)/H}}return D<V?(e.clone(U,r.center),r.radius=D):(e.clone(G,r.center),r.radius=V),r};var I=new o,g=new e,M=new e,O=new t,C=new t;f.fromRectangle2D=function(e,t,r){return f.fromRectangleWithHeights2D(e,t,0,0,r)},f.fromRectangleWithHeights2D=function(t,r,i,o,u){if(a(u)||(u=new f),!a(t))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;r=n(r,I),E.southwest(t,O),O.height=i,E.northeast(t,C),C.height=o;var s=r.project(O,g),c=r.project(C,M),l=c.x-s.x,h=c.y-s.y,d=c.z-s.z;u.radius=.5*Math.sqrt(l*l+h*h+d*d);var p=u.center;return p.x=s.x+.5*l,p.y=s.y+.5*h,p.z=s.z+.5*d,u};var w=[];f.fromRectangle3D=function(e,t,r,o){t=n(t,i.WGS84),r=n(r,0);var u;return a(e)&&(u=E.subsample(e,t,r,w)),f.fromPoints(u,o)},f.fromVertices=function(t,r,i,o){if(a(o)||(o=new f),!a(t)||0===t.length)return o.center=e.clone(e.ZERO,o.center),o.radius=0,o;r=n(r,e.ZERO),i=n(i,3);var u=y;u.x=t[0]+r.x,u.y=t[1]+r.y,u.z=t[2]+r.z;for(var s=e.clone(u,h),c=e.clone(u,d),l=e.clone(u,p),E=e.clone(u,m),I=e.clone(u,_),g=e.clone(u,T),M=t.length,O=0;O<M;O+=i){var C=t[O]+r.x,w=t[O+1]+r.y,x=t[O+2]+r.z;u.x=C,u.y=w,u.z=x,C<s.x&&e.clone(u,s),C>E.x&&e.clone(u,E),w<c.y&&e.clone(u,c),w>I.y&&e.clone(u,I),x<l.z&&e.clone(u,l),x>g.z&&e.clone(u,g)}var P=e.magnitudeSquared(e.subtract(E,s,R)),L=e.magnitudeSquared(e.subtract(I,c,R)),b=e.magnitudeSquared(e.subtract(g,l,R)),U=s,F=E,D=P;L>D&&(D=L,U=c,F=I),b>D&&(D=b,U=l,F=g);var B=A;B.x=.5*(U.x+F.x),B.y=.5*(U.y+F.y),B.z=.5*(U.z+F.z);var z=e.magnitudeSquared(e.subtract(F,B,R)),G=Math.sqrt(z),V=v;V.x=s.x,V.y=c.y,V.z=l.z;var q=N;q.x=E.x,q.y=I.y,q.z=g.z;var X=e.multiplyByScalar(e.add(V,q,R),.5,S),H=0;for(O=0;O<M;O+=i){u.x=t[O]+r.x,u.y=t[O+1]+r.y,u.z=t[O+2]+r.z;var W=e.magnitude(e.subtract(u,X,R));W>H&&(H=W);var k=e.magnitudeSquared(e.subtract(u,B,R));if(k>z){var Y=Math.sqrt(k);G=.5*(G+Y),z=G*G;var Z=Y-G;B.x=(G*B.x+Z*u.x)/Y,B.y=(G*B.y+Z*u.y)/Y,B.z=(G*B.z+Z*u.z)/Y}}return G<H?(e.clone(B,o.center),o.radius=G):(e.clone(X,o.center),o.radius=H),o},f.fromEncodedCartesianVertices=function(t,r,n){if(a(n)||(n=new f),!a(t)||!a(r)||t.length!==r.length||0===t.length)return n.center=e.clone(e.ZERO,n.center),n.radius=0,n;var i=y;i.x=t[0]+r[0],i.y=t[1]+r[1],i.z=t[2]+r[2];for(var o=e.clone(i,h),u=e.clone(i,d),s=e.clone(i,p),c=e.clone(i,m),l=e.clone(i,_),E=e.clone(i,T),I=t.length,g=0;g<I;g+=3){var M=t[g]+r[g],O=t[g+1]+r[g+1],C=t[g+2]+r[g+2];i.x=M,i.y=O,i.z=C,M<o.x&&e.clone(i,o),M>c.x&&e.clone(i,c),O<u.y&&e.clone(i,u),O>l.y&&e.clone(i,l),C<s.z&&e.clone(i,s),C>E.z&&e.clone(i,E)}var w=e.magnitudeSquared(e.subtract(c,o,R)),x=e.magnitudeSquared(e.subtract(l,u,R)),P=e.magnitudeSquared(e.subtract(E,s,R)),L=o,b=c,U=w;x>U&&(U=x,L=u,b=l),P>U&&(U=P,L=s,b=E);var F=A;F.x=.5*(L.x+b.x),F.y=.5*(L.y+b.y),F.z=.5*(L.z+b.z);var D=e.magnitudeSquared(e.subtract(b,F,R)),B=Math.sqrt(D),z=v;z.x=o.x,z.y=u.y,z.z=s.z;var G=N;G.x=c.x,G.y=l.y,G.z=E.z;var V=e.multiplyByScalar(e.add(z,G,R),.5,S),q=0;for(g=0;g<I;g+=3){i.x=t[g]+r[g],i.y=t[g+1]+r[g+1],i.z=t[g+2]+r[g+2];var X=e.magnitude(e.subtract(i,V,R));X>q&&(q=X);var H=e.magnitudeSquared(e.subtract(i,F,R));if(H>D){var W=Math.sqrt(H);B=.5*(B+W),D=B*B;var k=W-B;F.x=(B*F.x+k*i.x)/W,F.y=(B*F.y+k*i.y)/W,F.z=(B*F.z+k*i.z)/W}}return B<q?(e.clone(F,n.center),n.radius=B):(e.clone(V,n.center),n.radius=q),n},f.fromCornerPoints=function(t,r,n){a(n)||(n=new f);var i=n.center;return e.add(t,r,i),e.multiplyByScalar(i,.5,i),n.radius=e.distance(i,r),n},f.fromEllipsoid=function(t,r){return a(r)||(r=new f),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var x=new e;f.fromBoundingSpheres=function(t,r){if(a(r)||(r=new f),!a(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return f.clone(t[0],r);if(2===n)return f.union(t[0],t[1],r);for(var i=[],o=0;o<n;o++)i.push(t[o].center);r=f.fromPoints(i,r);var u=r.center,s=r.radius;for(o=0;o<n;o++){var c=t[o];s=Math.max(s,e.distance(u,c.center,x)+c.radius)}return r.radius=s,r};var P=new e,L=new e,b=new e;f.fromOrientedBoundingBox=function(t,r){a(r)||(r=new f);var n=t.halfAxes,i=c.getColumn(n,0,P),o=c.getColumn(n,1,L),u=c.getColumn(n,2,b),s=e.magnitude(i),l=e.magnitude(o),E=e.magnitude(u);return r.center=e.clone(t.center,r.center),r.radius=Math.max(s,l,E),r},f.clone=function(t,r){if(a(t))return a(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new f(t.center,t.radius)},f.packedLength=4,f.pack=function(e,t,r){r=n(r,0);var a=e.center;return t[r++]=a.x,t[r++]=a.y,t[r++]=a.z,t[r]=e.radius,t},f.unpack=function(e,t,r){t=n(t,0),a(r)||(r=new f);var i=r.center;return i.x=e[t++],i.y=e[t++],i.z=e[t++],r.radius=e[t],r};var U=new e,F=new e;f.union=function(t,r,n){a(n)||(n=new f);var i=t.center,o=t.radius,u=r.center,s=r.radius,c=e.subtract(u,i,U),l=e.magnitude(c);if(o>=l+s)return t.clone(n),n;if(s>=l+o)return r.clone(n),n;var E=.5*(o+l+s),h=e.multiplyByScalar(c,(-o+E)/l,F);return e.add(h,i,h),e.clone(h,n.center),n.radius=E,n};var D=new e;f.expand=function(t,r,n){n=f.clone(t,n);var a=e.magnitude(e.subtract(r,n.center,D));return a>n.radius&&(n.radius=a),n},f.intersectPlane=function(t,r){var n=t.center,a=t.radius,i=r.normal,o=e.dot(i,n)+r.distance;return o<-a?u.OUTSIDE:o<a?u.INTERSECTING:u.INSIDE},f.transform=function(e,t,r){return a(r)||(r=new f),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=l.getMaximumScale(t)*e.radius,r};var B=new e;f.distanceSquaredTo=function(t,r){var n=e.subtract(t.center,r,B);return e.magnitudeSquared(n)-t.radius*t.radius},f.transformWithoutScale=function(e,t,r){return a(r)||(r=new f),r.center=l.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var z=new e;f.computePlaneDistances=function(t,r,n,i){a(i)||(i=new s);var o=e.subtract(t.center,r,z),u=e.dot(n,o);return i.start=u-t.radius,i.stop=u+t.radius,i};for(var G=new e,V=new e,q=new e,X=new e,H=new e,W=new t,k=new Array(8),Y=0;Y<8;++Y)k[Y]=new e;var Z=new o;return f.projectTo2D=function(t,r,a){r=n(r,Z);var i=r.ellipsoid,o=t.center,u=t.radius,s=i.geodeticSurfaceNormal(o,G),c=e.cross(e.UNIT_Z,s,V);e.normalize(c,c);var l=e.cross(s,c,q);e.normalize(l,l),e.multiplyByScalar(s,u,s),e.multiplyByScalar(l,u,l),e.multiplyByScalar(c,u,c);var E=e.negate(l,H),h=e.negate(c,X),d=k,p=d[0];e.add(s,l,p),e.add(p,c,p),p=d[1],e.add(s,l,p),e.add(p,h,p),p=d[2],e.add(s,E,p),e.add(p,h,p),p=d[3],e.add(s,E,p),e.add(p,c,p),e.negate(s,s),p=d[4],e.add(s,l,p),e.add(p,c,p),p=d[5],e.add(s,l,p),e.add(p,h,p),p=d[6],e.add(s,E,p),e.add(p,h,p),p=d[7],e.add(s,E,p),e.add(p,c,p);for(var m=d.length,_=0;_<m;++_){var T=d[_];e.add(o,T,T);var y=i.cartesianToCartographic(T,W);r.project(y,T)}a=f.fromPoints(d,a),o=a.center;var R=o.x,A=o.y,v=o.z;return o.x=v,o.y=R,o.z=A,a},f.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},f.equals=function(t,r){return t===r||a(t)&&a(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},f.prototype.intersectPlane=function(e){return f.intersectPlane(this,e)},f.prototype.distanceSquaredTo=function(e){return f.distanceSquaredTo(this,e)},f.prototype.computePlaneDistances=function(e,t,r){return f.computePlaneDistances(this,e,t,r)},f.prototype.isOccluded=function(e){return f.isOccluded(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.prototype.clone=function(e){return f.clone(this,e)},f}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},a={};return t(a,{element:{get:function(){if(a.supportsFullscreen())return document[n.fullscreenElement]}},changeEventName:{get:function(){if(a.supportsFullscreen())return n.fullscreenchange}},errorEventName:{get:function(){if(a.supportsFullscreen())return n.fullscreenerror}},enabled:{get:function(){if(a.supportsFullscreen())return document[n.fullscreenEnabled]}},fullscreen:{get:function(){if(a.supportsFullscreen())return null!==a.element}}}),a.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",r=!0;for(var a,i=["webkit","moz","o","ms","khtml"],o=0,u=i.length;o<u;++o){var s=i[o];a=s+"RequestFullscreen","function"==typeof t[a]?(n.requestFullscreen=a,r=!0):(a=s+"RequestFullScreen","function"==typeof t[a]&&(n.requestFullscreen=a,r=!0)),a=s+"ExitFullscreen","function"==typeof document[a]?n.exitFullscreen=a:(a=s+"CancelFullScreen","function"==typeof document[a]&&(n.exitFullscreen=a)),a=s+"FullscreenEnabled",void 0!==document[a]?n.fullscreenEnabled=a:(a=s+"FullScreenEnabled",void 0!==document[a]&&(n.fullscreenEnabled=a)),a=s+"FullscreenElement",void 0!==document[a]?n.fullscreenElement=a:(a=s+"FullScreenElement",void 0!==document[a]&&(n.fullscreenElement=a)),a=s+"fullscreenchange",void 0!==document["on"+a]&&("ms"===s&&(a="MSFullscreenChange"),n.fullscreenchange=a),a=s+"fullscreenerror",void 0!==document["on"+a]&&("ms"===s&&(a="MSFullscreenError"),n.fullscreenerror=a)}return r},a.requestFullscreen=function(e,t){a.supportsFullscreen()&&e[n.requestFullscreen]({vrDisplay:t})},a.exitFullscreen=function(){a.supportsFullscreen()&&document[n.exitFullscreen]()},a}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function n(e){for(var t=e.split("."),r=0,n=t.length;r<n;++r)t[r]=parseInt(t[r],10);return t}function a(){if(!t(A)&&(A=!1,!f())){var e=/ Chrome\/([\.0-9]+)/.exec(R.userAgent);null!==e&&(A=!0,v=n(e[1]))}return A}function i(){return a()&&v}function o(){if(!t(N)&&(N=!1,!a()&&!f()&&/ Safari\/[\.0-9]+/.test(R.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(R.userAgent);null!==e&&(N=!0,S=n(e[1]))}return N}function u(){return o()&&S}function s(){if(!t(I)){I=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(R.userAgent);null!==e&&(I=!0,g=n(e[1]),g.isNightly=!!e[2])}return I}function c(){return s()&&g}function l(){if(!t(M)){M=!1;var e;"Microsoft Internet Explorer"===R.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(R.userAgent),null!==e&&(M=!0,O=n(e[1]))):"Netscape"===R.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(R.userAgent),null!==e&&(M=!0,O=n(e[1])))}return M}function E(){return l()&&O}function f(){if(!t(C)){C=!1;var e=/ Edge\/([\.0-9]+)/.exec(R.userAgent);null!==e&&(C=!0,w=n(e[1]))}return C}function h(){return f()&&w}function d(){if(!t(x)){x=!1;var e=/Firefox\/([\.0-9]+)/.exec(R.userAgent);
null!==e&&(x=!0,P=n(e[1]))}return x}function p(){return t(L)||(L=/Windows/i.test(R.appVersion)),L}function m(){return d()&&P}function _(){return t(b)||(b="undefined"!=typeof PointerEvent&&(!t(R.pointerEnabled)||R.pointerEnabled)),b}function T(){if(!t(F)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;F=t(r)&&""!==r,F&&(U=r)}return F}function y(){return T()?U:void 0}var R;R="undefined"!=typeof navigator?navigator:{};var A,v,N,S,I,g,M,O,C,w,x,P,L,b,U,F,D={isChrome:a,chromeVersion:i,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:l,internetExplorerVersion:E,isEdge:f,edgeVersion:h,isFirefox:d,firefoxVersion:m,isWindows:p,hardwareConcurrency:e(R.hardwareConcurrency,3),supportsPointerEvents:_,supportsImageRenderingPixelated:T,imageRenderingValue:y};return D.supportsFullscreen=function(){return r.supportsFullscreen()},D.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},D.supportsWebWorkers=function(){return"undefined"!=typeof Worker},D}),define("Core/WebGLConstants",["./freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047};return e(t)}),define("Core/ComponentDatatype",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./WebGLConstants"],function(e,t,r,n,a,i){"use strict";if(!n.supportsTypedArrays())return{};var o={BYTE:i.BYTE,UNSIGNED_BYTE:i.UNSIGNED_BYTE,SHORT:i.SHORT,UNSIGNED_SHORT:i.UNSIGNED_SHORT,INT:i.INT,UNSIGNED_INT:i.UNSIGNED_INT,FLOAT:i.FLOAT,DOUBLE:i.DOUBLE};return o.getSizeInBytes=function(e){switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.INT:return Int32Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Int32Array?o.INT:e instanceof Uint32Array?o.UNSIGNED_INT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.INT||e===o.UNSIGNED_INT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,t){switch(e){case o.BYTE:return new Int8Array(t);case o.UNSIGNED_BYTE:return new Uint8Array(t);case o.SHORT:return new Int16Array(t);case o.UNSIGNED_SHORT:return new Uint16Array(t);case o.INT:return new Int32Array(t);case o.UNSIGNED_INT:return new Uint32Array(t);case o.FLOAT:return new Float32Array(t);case o.DOUBLE:return new Float64Array(t)}},o.createArrayBufferView=function(t,r,n,a){switch(n=e(n,0),a=e(a,(r.byteLength-n)/o.getSizeInBytes(t)),t){case o.BYTE:return new Int8Array(r,n,a);case o.UNSIGNED_BYTE:return new Uint8Array(r,n,a);case o.SHORT:return new Int16Array(r,n,a);case o.UNSIGNED_SHORT:return new Uint16Array(r,n,a);case o.INT:return new Int32Array(r,n,a);case o.UNSIGNED_INT:return new Uint32Array(r,n,a);case o.FLOAT:return new Float32Array(r,n,a);case o.DOUBLE:return new Float64Array(r,n,a)}},o.fromName=function(e){switch(e){case"BYTE":return o.BYTE;case"UNSIGNED_BYTE":return o.UNSIGNED_BYTE;case"SHORT":return o.SHORT;case"UNSIGNED_SHORT":return o.UNSIGNED_SHORT;case"INT":return o.INT;case"UNSIGNED_INT":return o.UNSIGNED_INT;case"FLOAT":return o.FLOAT;case"DOUBLE":return o.DOUBLE}},a(o)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),define("Core/PrimitiveType",["./freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={POINTS:t.POINTS,LINES:t.LINES,LINE_LOOP:t.LINE_LOOP,LINE_STRIP:t.LINE_STRIP,TRIANGLES:t.TRIANGLES,TRIANGLE_STRIP:t.TRIANGLE_STRIP,TRIANGLE_FAN:t.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return e(r)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,n,a){"use strict";function i(t){t=e(t,e.EMPTY_OBJECT),this.attributes=t.attributes,this.indices=t.indices,this.primitiveType=e(t.primitiveType,a.TRIANGLES),this.boundingSphere=t.boundingSphere,this.geometryType=e(t.geometryType,n.NONE),this.boundingSphereCV=t.boundingSphereCV}return i.computeNumberOfVertices=function(e){var r=-1;for(var n in e.attributes)if(e.attributes.hasOwnProperty(n)&&t(e.attributes[n])&&t(e.attributes[n].values)){var a=e.attributes[n],i=a.values.length/a.componentsPerAttribute;r=i}return r},i}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(t){t=e(t,e.EMPTY_OBJECT),this.componentDatatype=t.componentDatatype,this.componentsPerAttribute=t.componentsPerAttribute,this.normalize=e(t.normalize,!1),this.values=t.values}return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";function t(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.bitangent=t.bitangent,this.tangent=t.tangent,this.color=t.color}return t}),define("Core/Cartesian2",["./Check","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,n,a,i){"use strict";function o(e,r){this.x=t(e,0),this.y=t(r,0)}o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){if(r(e))return r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y)},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(e,r,n){return n=t(n,0),r[n++]=e.x,r[n]=e.y,r},o.unpack=function(e,n,a){return n=t(n,0),r(a)||(a=new o),a.x=e[n++],a.y=e[n],a},o.packArray=function(e,t){var n=e.length;r(t)?t.length=2*n:t=new Array(2*n);for(var a=0;a<n;++a)o.pack(e[a],t,2*a);return t},o.unpackArray=function(e,t){var n=e.length;r(t)?t.length=n/2:t=new Array(n/2);for(var a=0;a<n;a+=2){var i=a/2;t[i]=o.unpack(e,a,t[i])}return t},o.fromArray=o.unpack,o.maximumComponent=function(e){return Math.max(e.x,e.y)},o.minimumComponent=function(e){return Math.min(e.x,e.y)},o.minimumByComponent=function(e,t,r){return r.x=Math.min(e.x,t.x),r.y=Math.min(e.y,t.y),r},o.maximumByComponent=function(e,t,r){return r.x=Math.max(e.x,t.x),r.y=Math.max(e.y,t.y),r},o.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var u=new o;o.distance=function(e,t){return o.subtract(e,t,u),o.magnitude(u)},o.distanceSquared=function(e,t){return o.subtract(e,t,u),o.magnitudeSquared(u)},o.normalize=function(e,t){var r=o.magnitude(e);return t.x=e.x/r,t.y=e.y/r,t},o.dot=function(e,t){return e.x*t.x+e.y*t.y},o.multiplyComponents=function(e,t,r){return r.x=e.x*t.x,r.y=e.y*t.y,r},o.divideComponents=function(e,t,r){return r.x=e.x/t.x,r.y=e.y/t.y,r},o.add=function(e,t,r){return r.x=e.x+t.x,r.y=e.y+t.y,r},o.subtract=function(e,t,r){return r.x=e.x-t.x,r.y=e.y-t.y,r},o.multiplyByScalar=function(e,t,r){return r.x=e.x*t,r.y=e.y*t,r},o.divideByScalar=function(e,t,r){return r.x=e.x/t,r.y=e.y/t,r},o.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t},o.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t};var s=new o;o.lerp=function(e,t,r,n){return o.multiplyByScalar(t,r,s),n=o.multiplyByScalar(e,1-r,n),o.add(s,n,n)};var c=new o,l=new o;o.angleBetween=function(e,t){return o.normalize(e,c),o.normalize(t,l),i.acosClamped(o.dot(c,l))};var E=new o;return o.mostOrthogonalAxis=function(e,t){var r=o.normalize(e,E);return o.abs(r,r),t=r.x<=r.y?o.clone(o.UNIT_X,t):o.clone(o.UNIT_Y,t)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)},o.ZERO=a(new o(0,0)),o.UNIT_X=a(new o(1,0)),o.UNIT_Y=a(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,n,a){"use strict";var i={};i.octEncodeInRange=function(e,t,r){if(r.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),r.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var n=r.x,i=r.y;r.x=(1-Math.abs(i))*a.signNotZero(n),r.y=(1-Math.abs(n))*a.signNotZero(i)}return r.x=a.toSNorm(r.x,t),r.y=a.toSNorm(r.y,t),r},i.octEncode=function(e,t){return i.octEncodeInRange(e,255,t)},i.octDecodeInRange=function(e,r,n,i){if(i.x=a.fromSNorm(e,n),i.y=a.fromSNorm(r,n),i.z=1-(Math.abs(i.x)+Math.abs(i.y)),i.z<0){var o=i.x;i.x=(1-Math.abs(i.y))*a.signNotZero(o),i.y=(1-Math.abs(o))*a.signNotZero(i.y)}return t.normalize(i,i)},i.octDecode=function(e,t,r){return i.octDecodeInRange(e,t,255,r)},i.octPackFloat=function(e){return 256*e.x+e.y};var o=new e;return i.octEncodeFloat=function(e){return i.octEncode(e,o),i.octPackFloat(o)},i.octDecodeFloat=function(e,t){var r=e/256,n=Math.floor(r),a=256*(r-n);return i.octDecode(n,a,t)},i.octPack=function(e,t,r,n){var a=i.octEncodeFloat(e),u=i.octEncodeFloat(t),s=i.octEncode(r,o);return n.x=65536*s.x+a,n.y=65536*s.y+u,n},i.octUnpack=function(e,t,r,n){var a=e.x/65536,o=Math.floor(a),u=65536*(a-o);a=e.y/65536;var s=Math.floor(a),c=65536*(a-s);i.octDecodeFloat(u,t),i.octDecodeFloat(c,r),i.octDecode(o,s,n)},i.compressTextureCoordinates=function(e){var t=4095*e.x|0,r=4095*e.y|0;return 4096*t+r},i.decompressTextureCoordinates=function(e,t){var r=e/4096,n=Math.floor(r);return t.x=n/4095,t.y=(e-4096*n)/4095,t},i}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function a(n,a,s,c,l){r(l)||(l=new t);var E,f,h,d,p,m,_,T;r(a.z)?(E=t.subtract(s,a,i),f=t.subtract(c,a,o),h=t.subtract(n,a,u),d=t.dot(E,E),p=t.dot(E,f),m=t.dot(E,h),_=t.dot(f,f),T=t.dot(f,h)):(E=e.subtract(s,a,i),f=e.subtract(c,a,o),h=e.subtract(n,a,u),d=e.dot(E,E),p=e.dot(E,f),m=e.dot(E,h),_=e.dot(f,f),T=e.dot(f,h));var y=1/(d*_-p*p);return l.y=(_*m-p*T)*y,l.z=(d*T-p*m)*y,l.x=1-l.y-l.z,l}var i=new t,o=new t,u=new t;return a}),define("Core/oneTimeWarning",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(r,n){t(a[r])||(a[r]=!0,console.warn(e(n,r)))}var a={};return n.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",n}),define("Core/deprecationWarning",["./defined","./DeveloperError","./oneTimeWarning"],function(e,t,r){"use strict";function n(e,t){r(e,t)}return n}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";function n(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)}n.encode=function(e,r){t(r)||(r={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),r.high=n,r.low=e-n):(n=65536*Math.floor(-e/65536),r.high=-n,r.low=e+n),r};var a={high:0,low:0};n.fromCartesian=function(e,r){t(r)||(r=new n);var i=r.high,o=r.low;return n.encode(e.x,a),i.x=a.high,o.x=a.low,n.encode(e.y,a),i.y=a.high,o.y=a.low,n.encode(e.z,a),i.z=a.high,o.z=a.low,r};var i=new n;return n.writeElements=function(e,t,r){n.fromCartesian(e,i);var a=i.high,o=i.low;t[r]=a.x,t[r+1]=a.y,t[r+2]=a.z,t[r+3]=o.x,t[r+4]=o.y,t[r+5]=o.z},n}),define("Core/IndexDatatype",["./defined","./DeveloperError","./freezeObject","./Math","./WebGLConstants"],function(e,t,r,n,a){"use strict";var i={UNSIGNED_BYTE:a.UNSIGNED_BYTE,UNSIGNED_SHORT:a.UNSIGNED_SHORT,UNSIGNED_INT:a.UNSIGNED_INT};return i.getSizeInBytes=function(e){switch(e){case i.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case i.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case i.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}},i.validate=function(t){return e(t)&&(t===i.UNSIGNED_BYTE||t===i.UNSIGNED_SHORT||t===i.UNSIGNED_INT)},i.createTypedArray=function(e,t){return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t):new Uint16Array(t)},i.createTypedArrayFromArrayBuffer=function(e,t,r,a){return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(t,r,a):new Uint16Array(t,r,a)},r(i)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,n){var a=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(a/Math.max(Math.abs(e),Math.abs(r)))<n?0:a}var n={};return n.computeDiscriminant=function(e,t,r){var n=t*t-4*e*r;return n},n.computeRealRoots=function(e,n,a){var i;if(0===e)return 0===n?[]:[-a/n];if(0===n){if(0===a)return[0,0];var o=Math.abs(a),u=Math.abs(e);if(o<u&&o/u<t.EPSILON14)return[0,0];if(o>u&&u/o<t.EPSILON14)return[];if(i=-a/e,i<0)return[];var s=Math.sqrt(i);return[-s,s]}if(0===a)return i=-n/e,i<0?[i,0]:[0,i];var c=n*n,l=4*e*a,E=r(c,-l,t.EPSILON14);if(E<0)return[];var f=-.5*r(n,t.sign(n)*Math.sqrt(E),t.EPSILON14);return n>0?[f/e,a/f]:[a/f,f/e]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,n){var a,i,o=e,u=t/3,s=r/3,c=n,l=o*s,E=u*c,f=u*u,h=s*s,d=o*s-f,p=o*c-u*s,m=u*c-h,_=4*d*m-p*p;if(_<0){var T,y,R;f*E>=l*h?(T=o,y=d,R=-2*u*d+o*p):(T=c,y=m,R=-c*p+2*s*m);var A=R<0?-1:1,v=-A*Math.abs(T)*Math.sqrt(-_);i=-R+v;var N=i/2,S=N<0?-Math.pow(-N,1/3):Math.pow(N,1/3),I=i===v?-S:-y/S;return a=y<=0?S+I:-R/(S*S+I*I+y),f*E>=l*h?[(a-u)/o]:[-c/(a+s)]}var g=d,M=-2*u*d+o*p,O=m,C=-c*p+2*s*m,w=Math.sqrt(_),x=Math.sqrt(3)/2,P=Math.abs(Math.atan2(o*w,-M)/3);a=2*Math.sqrt(-g);var L=Math.cos(P);i=a*L;var b=a*(-L/2-x*Math.sin(P)),U=i+b>2*u?i-u:b-u,F=o,D=U/F;P=Math.abs(Math.atan2(c*w,-C)/3),a=2*Math.sqrt(-O),L=Math.cos(P),i=a*L,b=a*(-L/2-x*Math.sin(P));var B=-c,z=i+b<2*s?i+s:b+s,G=B/z,V=F*z,q=-U*z-F*B,X=U*B,H=(s*q-u*X)/(-u*q+s*V);return D<=H?D<=G?H<=G?[D,H,G]:[D,G,H]:[G,D,H]:D<=G?[H,D,G]:H<=G?[H,G,D]:[G,H,D]}var n={};return n.computeDiscriminant=function(e,t,r,n){var a=e*e,i=t*t,o=r*r,u=n*n,s=18*e*t*r*n+i*o-27*a*u-4*(e*o*r+i*t*n);return s},n.computeRealRoots=function(e,n,a,i){var o,u;if(0===e)return t.computeRealRoots(n,a,i);if(0===n){if(0===a){if(0===i)return[0,0,0];u=-i/e;var s=u<0?-Math.pow(-u,1/3):Math.pow(u,1/3);return[s,s,s]}return 0===i?(o=t.computeRealRoots(e,0,a),0===o.Length?[0]:[o[0],0,o[1]]):r(e,0,a,i)}return 0===a?0===i?(u=-n/e,u<0?[u,0,0]:[0,0,u]):r(e,n,0,i):0===i?(o=t.computeRealRoots(e,n,a),0===o.length?[0]:o[1]<=0?[o[0],o[1],0]:o[0]>=0?[0,o[0],o[1]]:[o[0],0,o[1]]):r(e,n,a,i)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,n){"use strict";function a(t,a,i,o){var u=t*t,s=a-3*u/8,c=i-a*t/2+u*t/8,l=o-i*t/4+a*u/16-3*u*u/256,E=e.computeRealRoots(1,2*s,s*s-4*l,-c*c);if(E.length>0){var f=-t/4,h=E[E.length-1];if(Math.abs(h)<r.EPSILON14){var d=n.computeRealRoots(1,s,l);if(2===d.length){var p,m=d[0],_=d[1];if(m>=0&&_>=0){var T=Math.sqrt(m),y=Math.sqrt(_);return[f-y,f-T,f+T,f+y]}if(m>=0&&_<0)return p=Math.sqrt(m),[f-p,f+p];if(m<0&&_>=0)return p=Math.sqrt(_),[f-p,f+p]}return[]}if(h>0){var R=Math.sqrt(h),A=(s+h-c/R)/2,v=(s+h+c/R)/2,N=n.computeRealRoots(1,R,A),S=n.computeRealRoots(1,-R,v);return 0!==N.length?(N[0]+=f,N[1]+=f,0!==S.length?(S[0]+=f,S[1]+=f,N[1]<=S[0]?[N[0],N[1],S[0],S[1]]:S[1]<=N[0]?[S[0],S[1],N[0],N[1]]:N[0]>=S[0]&&N[1]<=S[1]?[S[0],N[0],N[1],S[1]]:S[0]>=N[0]&&S[1]<=N[1]?[N[0],S[0],S[1],N[1]]:N[0]>S[0]&&N[0]<S[1]?[S[0],N[0],S[1],N[1]]:[N[0],S[0],N[1],S[1]]):N):0!==S.length?(S[0]+=f,S[1]+=f,S):[]}}return[]}function i(t,a,i,o){var u=i*i,s=a*a,c=t*t,l=-2*a,E=i*t+s-4*o,f=c*o-i*a*t+u,h=e.computeRealRoots(1,l,E,f);if(h.length>0){var d,p,m=h[0],_=a-m,T=_*_,y=t/2,R=_/2,A=T-4*o,v=T+4*Math.abs(o),N=c-4*m,S=c+4*Math.abs(m);if(m<0||A*S<N*v){var I=Math.sqrt(N);d=I/2,p=0===I?0:(t*R-i)/I}else{var g=Math.sqrt(A);d=0===g?0:(t*R-i)/g,p=g/2}var M,O;0===y&&0===d?(M=0,O=0):r.sign(y)===r.sign(d)?(M=y+d,O=m/M):(O=y-d,M=m/O);var C,w;0===R&&0===p?(C=0,w=0):r.sign(R)===r.sign(p)?(C=R+p,w=o/C):(w=R-p,C=o/w);var x=n.computeRealRoots(1,M,C),P=n.computeRealRoots(1,O,w);if(0!==x.length)return 0!==P.length?x[1]<=P[0]?[x[0],x[1],P[0],P[1]]:P[1]<=x[0]?[P[0],P[1],x[0],x[1]]:x[0]>=P[0]&&x[1]<=P[1]?[P[0],x[0],x[1],P[1]]:P[0]>=x[0]&&P[1]<=x[1]?[x[0],P[0],P[1],x[1]]:x[0]>P[0]&&x[0]<P[1]?[P[0],x[0],P[1],x[1]]:[x[0],P[0],x[1],P[1]]:x;if(0!==P.length)return P}return[]}var o={};return o.computeDiscriminant=function(e,t,r,n,a){var i=e*e,o=i*e,u=t*t,s=u*t,c=r*r,l=c*r,E=n*n,f=E*n,h=a*a,d=h*a,p=u*c*E-4*s*f-4*e*l*E+18*e*t*r*f-27*i*E*E+256*o*d+a*(18*s*r*n-4*u*l+16*e*c*c-80*e*t*c*n-6*e*u*E+144*i*r*E)+h*(144*e*u*r-27*u*u-128*i*c-192*i*t*n);return p},o.computeRealRoots=function(t,n,o,u,s){if(Math.abs(t)<r.EPSILON15)return e.computeRealRoots(n,o,u,s);var c=n/t,l=o/t,E=u/t,f=s/t,h=c<0?1:0;switch(h+=l<0?h+1:h,h+=E<0?h+1:h,h+=f<0?h+1:h){case 0:return a(c,l,E,f);case 1:return i(c,l,E,f);case 2:return i(c,l,E,f);case 3:return a(c,l,E,f);case 4:return a(c,l,E,f);case 5:return i(c,l,E,f);case 6:return a(c,l,E,f);case 7:return a(c,l,E,f);case 8:return i(c,l,E,f);case 9:return a(c,l,E,f);case 10:return a(c,l,E,f);case 11:return i(c,l,E,f);case 12:return a(c,l,E,f);case 13:return a(c,l,E,f);case 14:return a(c,l,E,f);case 15:return a(c,l,E,f);default:return}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,n){"use strict";function a(r,n){n=e.clone(t(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(t(r,e.ZERO)),this.direction=n}return a.getPoint=function(t,n,a){return r(a)||(a=new e),a=e.multiplyByScalar(t.direction,n,a),e.add(t.origin,a,a)},a}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Interval","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,n,a,i,o,u,s,c,l){"use strict";function E(e,t,r,n){var a=t*t-4*e*r;if(!(a<0)){if(a>0){var i=1/(2*e),o=Math.sqrt(a),u=(-t+o)*i,s=(-t-o)*i;return u<s?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-t/(2*e);if(0!==c)return n.root0=n.root1=c,n}}function f(t,r,a){n(a)||(a=new i);var o=t.origin,u=t.direction,s=r.center,c=r.radius*r.radius,l=e.subtract(o,s,T),f=e.dot(u,u),h=2*e.dot(u,l),d=e.magnitudeSquared(l)-c,p=E(f,h,d,v);if(n(p))return a.start=p.root0,a.stop=p.root1,a}function h(e,t,r){var n=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<r?0:n}function d(t,r,n,a,i){var l,E=a*a,f=i*i,d=(t[u.COLUMN1ROW1]-t[u.COLUMN2ROW2])*f,p=i*(a*h(t[u.COLUMN1ROW0],t[u.COLUMN0ROW1],o.EPSILON15)+r.y),m=t[u.COLUMN0ROW0]*E+t[u.COLUMN2ROW2]*f+a*r.x+n,_=f*h(t[u.COLUMN2ROW1],t[u.COLUMN1ROW2],o.EPSILON15),T=i*(a*h(t[u.COLUMN2ROW0],t[u.COLUMN0ROW2])+r.z),y=[];
if(0===T&&0===_){if(l=s.computeRealRoots(d,p,m),0===l.length)return y;var R=l[0],A=Math.sqrt(Math.max(1-R*R,0));if(y.push(new e(a,i*R,i*-A)),y.push(new e(a,i*R,i*A)),2===l.length){var v=l[1],N=Math.sqrt(Math.max(1-v*v,0));y.push(new e(a,i*v,i*-N)),y.push(new e(a,i*v,i*N))}return y}var S=T*T,I=_*_,g=d*d,M=T*_,O=g+I,C=2*(p*d+M),w=2*m*d+p*p-I+S,x=2*(m*p-M),P=m*m-S;if(0===O&&0===C&&0===w&&0===x)return y;l=c.computeRealRoots(O,C,w,x,P);var L=l.length;if(0===L)return y;for(var b=0;b<L;++b){var U,F=l[b],D=F*F,B=Math.max(1-D,0),z=Math.sqrt(B);U=o.sign(d)===o.sign(m)?h(d*D+m,p*F,o.EPSILON12):o.sign(m)===o.sign(p*F)?h(d*D,p*F+m,o.EPSILON12):h(d*D+p*F,m,o.EPSILON12);var G=h(_*F,T,o.EPSILON15),V=U*G;V<0?y.push(new e(a,i*F,i*z)):V>0?y.push(new e(a,i*F,i*-z)):0!==z?(y.push(new e(a,i*F,i*-z)),y.push(new e(a,i*F,i*z)),++b):y.push(new e(a,i*F,i*z))}return y}var p={};p.rayPlane=function(t,r,a){n(a)||(a=new e);var i=t.origin,u=t.direction,s=r.normal,c=e.dot(s,u);if(!(Math.abs(c)<o.EPSILON15)){var l=(-r.distance-e.dot(s,i))/c;if(!(l<0))return a=e.multiplyByScalar(u,l,a),e.add(i,a,a)}};var m=new e,_=new e,T=new e,y=new e,R=new e;p.rayTriangleParametric=function(t,n,a,i,u){u=r(u,!1);var s,c,l,E,f,h=t.origin,d=t.direction,p=e.subtract(a,n,m),A=e.subtract(i,n,_),v=e.cross(d,A,T),N=e.dot(p,v);if(u){if(N<o.EPSILON6)return;if(s=e.subtract(h,n,y),l=e.dot(s,v),l<0||l>N)return;if(c=e.cross(s,p,R),E=e.dot(d,c),E<0||l+E>N)return;f=e.dot(A,c)/N}else{if(Math.abs(N)<o.EPSILON6)return;var S=1/N;if(s=e.subtract(h,n,y),l=e.dot(s,v)*S,l<0||l>1)return;if(c=e.cross(s,p,R),E=e.dot(d,c)*S,E<0||l+E>1)return;f=e.dot(A,c)*S}return f},p.rayTriangle=function(t,r,a,i,o,u){var s=p.rayTriangleParametric(t,r,a,i,o);if(n(s)&&!(s<0))return n(u)||(u=new e),e.multiplyByScalar(t.direction,s,u),e.add(t.origin,u,u)};var A=new l;p.lineSegmentTriangle=function(t,r,a,i,o,u,s){var c=A;e.clone(t,c.origin),e.subtract(r,t,c.direction),e.normalize(c.direction,c.direction);var l=p.rayTriangleParametric(c,a,i,o,u);if(!(!n(l)||l<0||l>e.distance(t,r)))return n(s)||(s=new e),e.multiplyByScalar(c.direction,l,s),e.add(c.origin,s,s)};var v={root0:0,root1:0};p.raySphere=function(e,t,r){if(r=f(e,t,r),n(r)&&!(r.stop<0))return r.start=Math.max(r.start,0),r};var N=new l;p.lineSegmentSphere=function(t,r,a,i){var o=N;e.clone(t,o.origin);var u=e.subtract(r,t,o.direction),s=e.magnitude(u);if(e.normalize(u,u),i=f(o,a,i),!(!n(i)||i.stop<0||i.start>s))return i.start=Math.max(i.start,0),i.stop=Math.min(i.stop,s),i};var S=new e,I=new e;p.rayEllipsoid=function(t,r){var n,a,o,u,s,c=r.oneOverRadii,l=e.multiplyComponents(c,t.origin,S),E=e.multiplyComponents(c,t.direction,I),f=e.magnitudeSquared(l),h=e.dot(l,E);if(f>1){if(h>=0)return;var d=h*h;if(n=f-1,a=e.magnitudeSquared(E),o=a*n,d<o)return;if(d>o){u=h*h-o,s=-h+Math.sqrt(u);var p=s/a,m=n/s;return p<m?new i(p,m):{start:m,stop:p}}var _=Math.sqrt(n/a);return new i(_,_)}return f<1?(n=f-1,a=e.magnitudeSquared(E),o=a*n,u=h*h-o,s=-h+Math.sqrt(u),new i(0,s/a)):h<0?(a=e.magnitudeSquared(E),new i(0,-h/a)):void 0};var g=new e,M=new e,O=new e,C=new e,w=new e,x=new u,P=new u,L=new u,b=new u,U=new u,F=new u,D=new u,B=new e,z=new e,G=new t;p.grazingAltitudeLocation=function(t,r){var a=t.origin,i=t.direction;if(!e.equals(a,e.ZERO)){var s=r.geodeticSurfaceNormal(a,g);if(e.dot(i,s)>=0)return a}var c=n(this.rayEllipsoid(t,r)),l=r.transformPositionToScaledSpace(i,g),E=e.normalize(l,l),f=e.mostOrthogonalAxis(l,C),h=e.normalize(e.cross(f,E,M),M),p=e.normalize(e.cross(E,h,O),O),m=x;m[0]=E.x,m[1]=E.y,m[2]=E.z,m[3]=h.x,m[4]=h.y,m[5]=h.z,m[6]=p.x,m[7]=p.y,m[8]=p.z;var _=u.transpose(m,P),T=u.fromScale(r.radii,L),y=u.fromScale(r.oneOverRadii,b),R=U;R[0]=0,R[1]=-i.z,R[2]=i.y,R[3]=i.z,R[4]=0,R[5]=-i.x,R[6]=-i.y,R[7]=i.x,R[8]=0;var A,v,N=u.multiply(u.multiply(_,y,F),R,F),S=u.multiply(u.multiply(N,T,D),m,D),I=u.multiplyByVector(N,a,w),V=d(S,e.negate(I,g),0,0,1),q=V.length;if(q>0){for(var X=e.clone(e.ZERO,z),H=Number.NEGATIVE_INFINITY,W=0;W<q;++W){A=u.multiplyByVector(T,u.multiplyByVector(m,V[W],B),B);var k=e.normalize(e.subtract(A,a,C),C),Y=e.dot(k,i);Y>H&&(H=Y,X=e.clone(A,X))}var Z=r.cartesianToCartographic(X,G);return H=o.clamp(H,0,1),v=e.magnitude(e.subtract(X,a,C))*Math.sqrt(1-H*H),v=c?-v:v,Z.height=v,r.cartographicToCartesian(Z,new e)}};var V=new e;return p.lineSegmentPlane=function(t,r,a,i){n(i)||(i=new e);var u=e.subtract(r,t,V),s=a.normal,c=e.dot(s,u);if(!(Math.abs(c)<o.EPSILON6)){var l=e.dot(s,t),E=-(a.distance+l)/c;if(!(E<0||E>1))return e.multiplyByScalar(u,E,i),e.add(t,i,i),i}},p.trianglePlaneIntersection=function(t,r,n,a){var i=a.normal,o=a.distance,u=e.dot(i,t)+o<0,s=e.dot(i,r)+o<0,c=e.dot(i,n)+o<0,l=0;l+=u?1:0,l+=s?1:0,l+=c?1:0;var E,f;if(1!==l&&2!==l||(E=new e,f=new e),1===l){if(u)return p.lineSegmentPlane(t,r,a,E),p.lineSegmentPlane(t,n,a,f),{positions:[t,r,n,E,f],indices:[0,3,4,1,2,4,1,4,3]};if(s)return p.lineSegmentPlane(r,n,a,E),p.lineSegmentPlane(r,t,a,f),{positions:[t,r,n,E,f],indices:[1,3,4,2,0,4,2,4,3]};if(c)return p.lineSegmentPlane(n,t,a,E),p.lineSegmentPlane(n,r,a,f),{positions:[t,r,n,E,f],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===l){if(!u)return p.lineSegmentPlane(r,t,a,E),p.lineSegmentPlane(n,t,a,f),{positions:[t,r,n,E,f],indices:[1,2,4,1,4,3,0,3,4]};if(!s)return p.lineSegmentPlane(n,r,a,E),p.lineSegmentPlane(t,r,a,f),{positions:[t,r,n,E,f],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return p.lineSegmentPlane(t,n,a,E),p.lineSegmentPlane(r,n,a,f),{positions:[t,r,n,E,f],indices:[0,1,4,0,4,3,2,3,4]}}},p}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,r,n){"use strict";function a(t,r){this.normal=e.clone(t),this.distance=r}a.fromPointNormal=function(r,n,i){var o=-e.dot(n,r);return t(i)?(e.clone(n,i.normal),i.distance=o,i):new a(n,o)};var i=new e;return a.fromCartesian4=function(r,n){var o=e.fromCartesian4(r,i),u=r.w;return t(n)?(e.clone(o,n.normal),n.distance=u,n):new a(o,u)},a.getPointDistance=function(t,r){return e.dot(t.normal,r)+t.distance},a.ORIGIN_XY_PLANE=n(new a(e.UNIT_Z,0)),a.ORIGIN_YZ_PLANE=n(new a(e.UNIT_X,0)),a.ORIGIN_ZX_PLANE=n(new a(e.UNIT_Y,0)),a}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var n={};return n.calculateACMR=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.indices,a=r.maximumIndex,i=e(r.cacheSize,24),o=n.length;if(!t(a)){a=0;for(var u=0,s=n[u];u<o;)s>a&&(a=s),++u,s=n[u]}for(var c=[],l=0;l<a+1;l++)c[l]=0;for(var E=i+1,f=0;f<o;++f)E-c[n[f]]>i&&(c[n[f]]=E,++E);return(E-i+1)/(o/3)},n.tipsify=function(r){function n(e,t,r,n){for(;t.length>=1;){var a=t[t.length-1];if(t.splice(t.length-1,1),e[a].numLiveTriangles>0)return a}for(;i<n;){if(e[i].numLiveTriangles>0)return++i,i-1;++i}return-1}function a(e,t,r,a,i,o,u){for(var s,c=-1,l=-1,E=0;E<r.length;){var f=r[E];a[f].numLiveTriangles&&(s=0,i-a[f].timeStamp+2*a[f].numLiveTriangles<=t&&(s=i-a[f].timeStamp),(s>l||l===-1)&&(l=s,c=f)),++E}return c===-1?n(a,o,e,u):c}r=e(r,e.EMPTY_OBJECT);var i,o=r.indices,u=r.maximumIndex,s=e(r.cacheSize,24),c=o.length,l=0,E=0,f=o[E],h=c;if(t(u))l=u+1;else{for(;E<h;)f>l&&(l=f),++E,f=o[E];if(l===-1)return 0;++l}for(var d=[],p=0;p<l;p++)d[p]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};E=0;for(var m=0;E<h;)d[o[E]].vertexTriangles.push(m),++d[o[E]].numLiveTriangles,d[o[E+1]].vertexTriangles.push(m),++d[o[E+1]].numLiveTriangles,d[o[E+2]].vertexTriangles.push(m),++d[o[E+2]].numLiveTriangles,++m,E+=3;var _=0,T=s+1;i=1;var y,R,A=[],v=[],N=0,S=[],I=c/3,g=[];for(p=0;p<I;p++)g[p]=!1;for(var M,O;_!==-1;){A=[],R=d[_],O=R.vertexTriangles.length;for(var C=0;C<O;++C)if(m=R.vertexTriangles[C],!g[m]){g[m]=!0,E=m+m+m;for(var w=0;w<3;++w)M=o[E],A.push(M),v.push(M),S[N]=M,++N,y=d[M],--y.numLiveTriangles,T-y.timeStamp>s&&(y.timeStamp=T,++T),++E}_=a(o,s,A,d,T,v,l)}return S},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,n,a,i,o,u,s,c,l,E,f,h,d,p,m,_,T,y,R,A,v,N,S,I){"use strict";function g(e,t,r,n,a){e[t++]=r,e[t++]=n,e[t++]=n,e[t++]=a,e[t++]=a,e[t]=r}function M(e){for(var t=e.length,r=t/3*6,n=_.createTypedArray(t,r),a=0,i=0;i<t;i+=3,a+=6)g(n,a,e[i],e[i+1],e[i+2]);return n}function O(e){var t=e.length;if(t>=3){var r=6*(t-2),n=_.createTypedArray(t,r);g(n,0,e[0],e[1],e[2]);for(var a=6,i=3;i<t;++i,a+=6)g(n,a,e[i-1],e[i],e[i-2]);return n}return new Uint16Array}function C(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),n=_.createTypedArray(t,r),a=e[0],i=0,o=1;o<t;++o,i+=6)g(n,i,a,e[o],e[o+1]);return n}return new Uint16Array}function w(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&c(e[r])&&c(e[r].values)){var n=e[r];t[r]=new p({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return t}function x(e,t,r){for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values))for(var a=t[n],i=0;i<a.componentsPerAttribute;++i)e[n].values.push(a.values[r*a.componentsPerAttribute+i])}function P(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;i<n;i+=3)a.unpack(r,i,oe),v.multiplyByPoint(e,oe,oe),a.pack(oe,r,i)}function L(e,t){if(c(t))for(var r=t.values,n=r.length,i=0;i<n;i+=3)a.unpack(r,i,oe),A.multiplyByVector(e,oe,oe),oe=a.normalize(oe,oe),a.pack(oe,r,i)}function b(e,t){var r,n=e.length,a={},i=e[0][t].attributes;for(r in i)if(i.hasOwnProperty(r)&&c(i[r])&&c(i[r].values)){for(var o=i[r],s=o.values.length,l=!0,E=1;E<n;++E){var f=e[E][t].attributes[r];if(!c(f)||o.componentDatatype!==f.componentDatatype||o.componentsPerAttribute!==f.componentsPerAttribute||o.normalize!==f.normalize){l=!1;break}s+=f.values.length}l&&(a[r]=new p({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return a}function U(e,t){var n,i,o,u,s,l,E,f=e.length,h=(e[0].modelMatrix,c(e[0][t].indices)),p=e[0][t].primitiveType,m=b(e,t);for(n in m)if(m.hasOwnProperty(n))for(s=m[n].values,u=0,i=0;i<f;++i)for(l=e[i][t].attributes[n].values,E=l.length,o=0;o<E;++o)s[u++]=l[o];var T;if(h){var y=0;for(i=0;i<f;++i)y+=e[i][t].indices.length;var R=d.computeNumberOfVertices(new d({attributes:m,primitiveType:S.POINTS})),A=_.createTypedArray(R,y),v=0,N=0;for(i=0;i<f;++i){var I=e[i][t].indices,g=I.length;for(u=0;u<g;++u)A[v++]=N+I[u];N+=d.computeNumberOfVertices(e[i][t])}T=A}var M,O=new a,C=0;for(i=0;i<f;++i){if(M=e[i][t].boundingSphere,!c(M)){O=void 0;break}a.add(M.center,O,O)}if(c(O))for(a.divideByScalar(O,f,O),i=0;i<f;++i){M=e[i][t].boundingSphere;var w=a.magnitude(a.subtract(M.center,O,ce))+M.radius;w>C&&(C=w)}return new d({attributes:m,indices:T,primitiveType:p,boundingSphere:c(O)?new r(O,C):void 0})}function F(e){if(c(e.indices))return e;for(var t=d.computeNumberOfVertices(e),r=_.createTypedArray(t,t),n=0;n<t;++n)r[n]=n;return e.indices=r,e}function D(e){var t=d.computeNumberOfVertices(e),r=_.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var n=3,a=3;a<t;++a)r[n++]=a-1,r[n++]=0,r[n++]=a;return e.indices=r,e.primitiveType=S.TRIANGLES,e}function B(e){var t=d.computeNumberOfVertices(e),r=_.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var n=6,a=3;a<t-1;a+=2)r[n++]=a,r[n++]=a-1,r[n++]=a+1,a+2<t&&(r[n++]=a,r[n++]=a+1,r[n++]=a+2);return e.indices=r,e.primitiveType=S.TRIANGLES,e}function z(e){if(c(e.indices))return e;for(var t=d.computeNumberOfVertices(e),r=_.createTypedArray(t,t),n=0;n<t;++n)r[n]=n;return e.indices=r,e}function G(e){var t=d.computeNumberOfVertices(e),r=_.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var n=2,a=2;a<t;++a)r[n++]=a-1,r[n++]=a;return e.indices=r,e.primitiveType=S.LINES,e}function V(e){var t=d.computeNumberOfVertices(e),r=_.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var n=2,a=2;a<t;++a)r[n++]=a-1,r[n++]=a;return r[n++]=t-1,r[n]=0,e.indices=r,e.primitiveType=S.LINES,e}function q(e){switch(e.primitiveType){case S.TRIANGLE_FAN:return D(e);case S.TRIANGLE_STRIP:return B(e);case S.TRIANGLES:return F(e);case S.LINE_STRIP:return G(e);case S.LINE_LOOP:return V(e);case S.LINES:return z(e)}return e}function X(e,t){Math.abs(e.y)<R.EPSILON6&&(t?e.y=-R.EPSILON6:e.y=R.EPSILON6)}function H(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return X(e,e.y<0),X(t,t.y<0),void X(r,r.y<0);var n,a=Math.abs(e.y),i=Math.abs(t.y),o=Math.abs(r.y);n=a>i?a>o?R.sign(e.y):R.sign(r.y):i>o?R.sign(t.y):R.sign(r.y);var u=n<0;X(e,u),X(t,u),X(r,u)}function W(e,t,r,n){a.add(e,a.multiplyByScalar(a.subtract(t,e,ve),e.y/(e.y-t.y),ve),r),a.clone(r,n),X(r,!0),X(n,!1)}function k(e,t,r){if(!(e.x>=0||t.x>=0||r.x>=0)){H(e,t,r);var n=e.y<0,a=t.y<0,i=r.y<0,o=0;o+=n?1:0,o+=a?1:0,o+=i?1:0;var u=Me.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(W(e,t,Ne,Ie),W(e,r,Se,ge),u[0]=0,u[3]=1,u[4]=2,u[6]=1):a?(W(t,r,Ne,Ie),W(t,e,Se,ge),u[0]=1,u[3]=2,u[4]=0,u[6]=2):i&&(W(r,e,Ne,Ie),W(r,t,Se,ge),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?a?i||(W(r,e,Ne,Ie),W(r,t,Se,ge),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(W(t,r,Ne,Ie),W(t,e,Se,ge),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(W(e,t,Ne,Ie),W(e,r,Se,ge),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Me.positions;return s[0]=e,s[1]=t,s[2]=r,s.length=3,1!==o&&2!==o||(s[3]=Ne,s[4]=Se,s[5]=Ie,s[6]=ge,s.length=7),Me}}function Y(e,t){var n=e.attributes;if(0!==n.position.values.length){for(var a in n)if(n.hasOwnProperty(a)&&c(n[a])&&c(n[a].values)){var i=n[a];i.values=u.createTypedArray(i.componentDatatype,i.values)}var o=d.computeNumberOfVertices(e);return e.indices=_.createTypedArray(o,e.indices),t&&(e.boundingSphere=r.fromVertices(n.position.values)),e}}function Z(e){var t=e.attributes,r={};for(var n in t)if(t.hasOwnProperty(n)&&c(t[n])&&c(t[n].values)){var a=t[n];r[n]=new p({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:[]})}return new d({attributes:r,indices:[],primitiveType:e.primitiveType})}function K(e,t,r){var n=c(e.geometry.boundingSphere);t=Y(t,n),r=Y(r,n),c(r)&&!c(t)?e.geometry=r:!c(r)&&c(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function j(e,r,i,o,u,s,l,E,f,h,d,p){if(c(s)||c(l)||c(E)||c(f)||c(h)){var m=a.fromArray(u,3*e,Oe),_=a.fromArray(u,3*r,Ce),T=a.fromArray(u,3*i,we),y=t(o,m,_,T,xe);if(c(s)){var R=a.fromArray(s,3*e,Oe),A=a.fromArray(s,3*r,Ce),v=a.fromArray(s,3*i,we);a.multiplyByScalar(R,y.x,R),a.multiplyByScalar(A,y.y,A),a.multiplyByScalar(v,y.z,v);var N=a.add(R,A,R);a.add(N,v,N),a.normalize(N,N),a.pack(N,d.normal.values,3*p)}if(c(h)){var S=a.fromArray(h,3*e,Oe),I=a.fromArray(h,3*r,Ce),g=a.fromArray(h,3*i,we);a.multiplyByScalar(S,y.x,S),a.multiplyByScalar(I,y.y,I),a.multiplyByScalar(g,y.z,g);var M;a.equals(S,a.ZERO)&&a.equals(I,a.ZERO)&&a.equals(g,a.ZERO)?(M=Oe,M.x=0,M.y=0,M.z=0):(M=a.add(S,I,S),a.add(M,g,M),a.normalize(M,M)),a.pack(M,d.extrudeDirection.values,3*p)}if(c(l)){var O=a.fromArray(l,3*e,Oe),C=a.fromArray(l,3*r,Ce),w=a.fromArray(l,3*i,we);a.multiplyByScalar(O,y.x,O),a.multiplyByScalar(C,y.y,C),a.multiplyByScalar(w,y.z,w);var x=a.add(O,C,O);a.add(x,w,x),a.normalize(x,x),a.pack(x,d.tangent.values,3*p)}if(c(E)){var P=a.fromArray(E,3*e,Oe),L=a.fromArray(E,3*r,Ce),b=a.fromArray(E,3*i,we);a.multiplyByScalar(P,y.x,P),a.multiplyByScalar(L,y.y,L),a.multiplyByScalar(b,y.z,b);var U=a.add(P,L,P);a.add(U,b,U),a.normalize(U,U),a.pack(U,d.bitangent.values,3*p)}if(c(f)){var F=n.fromArray(f,2*e,Pe),D=n.fromArray(f,2*r,Le),B=n.fromArray(f,2*i,be);n.multiplyByScalar(F,y.x,F),n.multiplyByScalar(D,y.y,D),n.multiplyByScalar(B,y.z,B);var z=n.add(F,D,F);n.add(z,B,z),n.pack(z,d.st.values,2*p)}}}function Q(e,t,r,n,a,i){var o=e.position.values.length/3;if(a!==-1){var u=n[a],s=r[u];return s===-1?(r[u]=o,e.position.values.push(i.x,i.y,i.z),t.push(o),o):(t.push(s),s)}return e.position.values.push(i.x,i.y,i.z),t.push(o),o}function J(e){var t,r,n,i,o,u=e.geometry,s=u.attributes,l=s.position.values,E=c(s.normal)?s.normal.values:void 0,f=c(s.bitangent)?s.bitangent.values:void 0,h=c(s.tangent)?s.tangent.values:void 0,d=c(s.st)?s.st.values:void 0,p=c(s.extrudeDirection)?s.extrudeDirection.values:void 0,m=u.indices,_=Z(u),T=Z(u),y=[];y.length=l.length/3;var R=[];for(R.length=l.length/3,o=0;o<y.length;++o)y[o]=-1,R[o]=-1;var A=m.length;for(o=0;o<A;o+=3){var v=m[o],N=m[o+1],S=m[o+2],I=a.fromArray(l,3*v),g=a.fromArray(l,3*N),M=a.fromArray(l,3*S),O=k(I,g,M);if(c(O)&&O.positions.length>3)for(var C=O.positions,w=O.indices,x=w.length,P=0;P<x;++P){var L=w[P],b=C[L];b.y<0?(t=T.attributes,r=T.indices,n=y):(t=_.attributes,r=_.indices,n=R),i=Q(t,r,n,m,L<3?o+L:-1,b),j(v,N,S,b,l,E,h,f,d,p,t,i)}else c(O)&&(I=O.positions[0],g=O.positions[1],M=O.positions[2]),I.y<0?(t=T.attributes,r=T.indices,n=y):(t=_.attributes,r=_.indices,n=R),i=Q(t,r,n,m,o,I),j(v,N,S,I,l,E,h,f,d,p,t,i),i=Q(t,r,n,m,o+1,g),j(v,N,S,g,l,E,h,f,d,p,t,i),i=Q(t,r,n,m,o+2,M),j(v,N,S,M,l,E,h,f,d,p,t,i)}K(e,T,_)}function $(e){var t,r=e.geometry,n=r.attributes,i=n.position.values,o=r.indices,u=Z(r),s=Z(r),l=o.length,E=[];E.length=i.length/3;var f=[];for(f.length=i.length/3,t=0;t<E.length;++t)E[t]=-1,f[t]=-1;for(t=0;t<l;t+=2){var h=o[t],d=o[t+1],p=a.fromArray(i,3*h,Oe),m=a.fromArray(i,3*d,Ce);Math.abs(p.y)<R.EPSILON6&&(p.y<0?p.y=-R.EPSILON6:p.y=R.EPSILON6),Math.abs(m.y)<R.EPSILON6&&(m.y<0?m.y=-R.EPSILON6:m.y=R.EPSILON6);var _=u.attributes,T=u.indices,A=f,v=s.attributes,N=s.indices,S=E,I=y.lineSegmentPlane(p,m,Ue,we);if(c(I)){var g=a.multiplyByScalar(a.UNIT_Y,5*R.EPSILON9,Fe);p.y<0&&(a.negate(g,g),_=s.attributes,T=s.indices,A=E,v=u.attributes,N=u.indices,S=f);var M=a.add(I,g,De);Q(_,T,A,o,t,p),Q(_,T,A,o,-1,M),a.negate(g,g),a.add(I,g,M),Q(v,N,S,o,-1,M),Q(v,N,S,o,t+1,m)}else{var O,C,w;p.y<0?(O=s.attributes,C=s.indices,w=E):(O=u.attributes,C=u.indices,w=f),Q(O,C,w,o,t,p),Q(O,C,w,o,t+1,m)}}K(e,s,u)}function ee(e){for(var t=e.attributes,r=t.position.values,n=t.prevPosition.values,i=t.nextPosition.values,o=r.length,u=0;u<o;u+=3){var s=a.unpack(r,u,Ge);if(!(s.x>0)){var c=a.unpack(n,u,Ve);(s.y<0&&c.y>0||s.y>0&&c.y<0)&&(u-3>0?(n[u]=r[u-3],n[u+1]=r[u-2],n[u+2]=r[u-1]):a.pack(s,n,u));var l=a.unpack(i,u,qe);(s.y<0&&l.y>0||s.y>0&&l.y<0)&&(u+3<o?(i[u]=r[u+3],i[u+1]=r[u+4],i[u+2]=r[u+5]):a.pack(s,i,u))}}}function te(e){var t,r,o,u=e.geometry,s=u.attributes,l=s.position.values,E=s.prevPosition.values,f=s.nextPosition.values,h=s.expandAndWidth.values,d=c(s.st)?s.st.values:void 0,p=c(s.color)?s.color.values:void 0,m=Z(u),_=Z(u),T=!1,A=l.length/3;for(t=0;t<A;t+=4){var v=t,N=t+2,S=a.fromArray(l,3*v,Ge),I=a.fromArray(l,3*N,Ve);if(Math.abs(S.y)<Ze)for(S.y=Ze*(I.y<0?-1:1),l[3*t+1]=S.y,l[3*(t+1)+1]=S.y,r=3*v;r<3*v+12;r+=3)E[r]=l[3*t],E[r+1]=l[3*t+1],E[r+2]=l[3*t+2];if(Math.abs(I.y)<Ze)for(I.y=Ze*(S.y<0?-1:1),l[3*(t+2)+1]=I.y,l[3*(t+3)+1]=I.y,r=3*v;r<3*v+12;r+=3)f[r]=l[3*(t+2)],f[r+1]=l[3*(t+2)+1],f[r+2]=l[3*(t+2)+2];var g=m.attributes,M=m.indices,O=_.attributes,C=_.indices,w=y.lineSegmentPlane(S,I,Ue,Xe);if(c(w)){T=!0;var x=a.multiplyByScalar(a.UNIT_Y,Ye,He);S.y<0&&(a.negate(x,x),g=_.attributes,M=_.indices,O=m.attributes,C=m.indices);var P=a.add(w,x,We);g.position.values.push(S.x,S.y,S.z,S.x,S.y,S.z),g.position.values.push(P.x,P.y,P.z),g.position.values.push(P.x,P.y,P.z),g.prevPosition.values.push(E[3*v],E[3*v+1],E[3*v+2]),g.prevPosition.values.push(E[3*v+3],E[3*v+4],E[3*v+5]),g.prevPosition.values.push(S.x,S.y,S.z,S.x,S.y,S.z),g.nextPosition.values.push(P.x,P.y,P.z),g.nextPosition.values.push(P.x,P.y,P.z),g.nextPosition.values.push(P.x,P.y,P.z),g.nextPosition.values.push(P.x,P.y,P.z),a.negate(x,x),a.add(w,x,P),O.position.values.push(P.x,P.y,P.z),O.position.values.push(P.x,P.y,P.z),O.position.values.push(I.x,I.y,I.z,I.x,I.y,I.z),O.prevPosition.values.push(P.x,P.y,P.z),O.prevPosition.values.push(P.x,P.y,P.z),O.prevPosition.values.push(P.x,P.y,P.z),O.prevPosition.values.push(P.x,P.y,P.z),O.nextPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),O.nextPosition.values.push(f[3*N],f[3*N+1],f[3*N+2]),O.nextPosition.values.push(f[3*N+3],f[3*N+4],f[3*N+5]);var L=n.fromArray(h,2*v,Be),b=Math.abs(L.y);g.expandAndWidth.values.push(-1,b,1,b),g.expandAndWidth.values.push(-1,-b,1,-b),O.expandAndWidth.values.push(-1,b,1,b),O.expandAndWidth.values.push(-1,-b,1,-b);var U=a.magnitudeSquared(a.subtract(w,S,qe));if(U/=a.magnitudeSquared(a.subtract(I,S,qe)),c(p)){var F=i.fromArray(p,4*v,ke),D=i.fromArray(p,4*N,ke),B=R.lerp(F.x,D.x,U),z=R.lerp(F.y,D.y,U),G=R.lerp(F.z,D.z,U),V=R.lerp(F.w,D.w,U);for(r=4*v;r<4*v+8;++r)g.color.values.push(p[r]);for(g.color.values.push(B,z,G,V),g.color.values.push(B,z,G,V),O.color.values.push(B,z,G,V),O.color.values.push(B,z,G,V),r=4*N;r<4*N+8;++r)O.color.values.push(p[r])}if(c(d)){var q=n.fromArray(d,2*v,Be),X=n.fromArray(d,2*(t+3),ze),H=R.lerp(q.x,X.x,U);for(r=2*v;r<2*v+4;++r)g.st.values.push(d[r]);for(g.st.values.push(H,q.y),g.st.values.push(H,X.y),O.st.values.push(H,q.y),O.st.values.push(H,X.y),r=2*N;r<2*N+4;++r)O.st.values.push(d[r])}o=g.position.values.length/3-4,M.push(o,o+2,o+1),M.push(o+1,o+2,o+3),o=O.position.values.length/3-4,C.push(o,o+2,o+1),C.push(o+1,o+2,o+3)}else{var W,k;for(S.y<0?(W=_.attributes,k=_.indices):(W=m.attributes,k=m.indices),W.position.values.push(S.x,S.y,S.z),W.position.values.push(S.x,S.y,S.z),W.position.values.push(I.x,I.y,I.z),W.position.values.push(I.x,I.y,I.z),r=3*t;r<3*t+12;++r)W.prevPosition.values.push(E[r]),W.nextPosition.values.push(f[r]);for(r=2*t;r<2*t+8;++r)W.expandAndWidth.values.push(h[r]),c(d)&&W.st.values.push(d[r]);if(c(p))for(r=4*t;r<4*t+16;++r)W.color.values.push(p[r]);o=W.position.values.length/3-4,k.push(o,o+2,o+1),k.push(o+1,o+2,o+3)}}T&&(ee(_),ee(m)),K(e,_,m)}var re={};re.toWireframe=function(e){var t=e.indices;if(c(t)){switch(e.primitiveType){case S.TRIANGLES:e.indices=M(t);break;case S.TRIANGLE_STRIP:e.indices=O(t);break;case S.TRIANGLE_FAN:e.indices=C(t)}e.primitiveType=S.LINES}return e},re.createLineSegmentsForVectors=function(e,t,n){t=s(t,"normal"),n=s(n,1e4);for(var a=e.attributes.position.values,i=e.attributes[t].values,o=a.length,l=new Float64Array(2*o),E=0,f=0;f<o;f+=3)l[E++]=a[f],l[E++]=a[f+1],l[E++]=a[f+2],l[E++]=a[f]+i[f]*n,l[E++]=a[f+1]+i[f+1]*n,l[E++]=a[f+2]+i[f+2]*n;var h,m=e.boundingSphere;return c(m)&&(h=new r(m.center,m.radius+n)),new d({attributes:{position:new p({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:S.LINES,boundingSphere:h})},re.createAttributeLocations=function(e){var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],n=e.attributes,a={},i=0,o=r.length;for(t=0;t<o;++t){var u=r[t];c(n[u])&&(a[u]=i++)}for(var s in n)n.hasOwnProperty(s)&&!c(a[s])&&(a[s]=i++);return a},re.reorderForPreVertexCache=function(e){var t=d.computeNumberOfVertices(e),r=e.indices;if(c(r)){for(var n=new Int32Array(t),a=0;a<t;a++)n[a]=-1;for(var i,o=r,s=o.length,l=_.createTypedArray(t,s),E=0,f=0,h=0;E<s;)i=n[o[E]],i!==-1?l[f]=i:(i=o[E],n[i]=h,l[f]=h,++h),++E,++f;e.indices=l;var p=e.attributes;for(var m in p)if(p.hasOwnProperty(m)&&c(p[m])&&c(p[m].values)){for(var T=p[m],y=T.values,R=0,A=T.componentsPerAttribute,v=u.createTypedArray(T.componentDatatype,h*A);R<t;){var N=n[R];if(N!==-1)for(a=0;a<A;a++)v[A*N+a]=y[A*R+a];++R}T.values=v}}return e},re.reorderForPostVertexCache=function(e,t){var r=e.indices;if(e.primitiveType===S.TRIANGLES&&c(r)){for(var n=r.length,a=0,i=0;i<n;i++)r[i]>a&&(a=r[i]);e.indices=I.tipsify({indices:r,maximumIndex:a,cacheSize:t})}return e},re.fitToUnsignedShortIndices=function(e){var t=[],r=d.computeNumberOfVertices(e);if(c(e.indices)&&r>=R.SIXTY_FOUR_KILOBYTES){var n,a=[],i=[],o=0,u=w(e.attributes),s=e.indices,l=s.length;e.primitiveType===S.TRIANGLES?n=3:e.primitiveType===S.LINES?n=2:e.primitiveType===S.POINTS&&(n=1);for(var E=0;E<l;E+=n){for(var f=0;f<n;++f){var h=s[E+f],p=a[h];c(p)||(p=o++,a[h]=p,x(u,e.attributes,h)),i.push(p)}o+n>=R.SIXTY_FOUR_KILOBYTES&&(t.push(new d({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),a=[],i=[],o=0,u=w(e.attributes))}0!==i.length&&t.push(new d({attributes:u,indices:i,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var ne=new a,ae=new o;re.projectTo2D=function(e,t,r,n,i){var o=e.attributes[t];i=c(i)?i:new h;for(var s=i.ellipsoid,l=o.values,E=new Float64Array(l.length),f=0,d=0;d<l.length;d+=3){var m=a.fromArray(l,d,ne),_=s.cartesianToCartographic(m,ae),T=i.project(_,ne);E[f++]=T.x,E[f++]=T.y,E[f++]=T.z}return e.attributes[r]=o,e.attributes[n]=new p({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:E}),delete e.attributes[t],e};var ie={high:0,low:0};re.encodeAttribute=function(e,t,r,n){for(var a=e.attributes[t],i=a.values,o=i.length,s=new Float32Array(o),c=new Float32Array(o),l=0;l<o;++l)f.encode(i[l],ie),s[l]=ie.high,c[l]=ie.low;var E=a.componentsPerAttribute;return e.attributes[r]=new p({componentDatatype:u.FLOAT,componentsPerAttribute:E,values:s}),e.attributes[n]=new p({componentDatatype:u.FLOAT,componentsPerAttribute:E,values:c}),delete e.attributes[t],e};var oe=new a,ue=new v,se=new A;re.transformToWorldCoordinates=function(e){var t=e.modelMatrix;if(v.equals(t,v.IDENTITY))return e;var n=e.geometry.attributes;P(t,n.position),P(t,n.prevPosition),P(t,n.nextPosition),(c(n.normal)||c(n.tangent)||c(n.bitangent))&&(v.inverse(t,ue),v.transpose(ue,ue),v.getRotation(ue,se),L(se,n.normal),L(se,n.tangent),L(se,n.bitangent));var a=e.geometry.boundingSphere;return c(a)&&(e.geometry.boundingSphere=r.transform(a,t,a)),e.modelMatrix=v.clone(v.IDENTITY),e};var ce=new a;re.combineInstances=function(e){for(var t=[],r=[],n=e.length,a=0;a<n;++a){var i=e[a];c(i.geometry)?t.push(i):c(i.westHemisphereGeometry)&&c(i.eastHemisphereGeometry)&&r.push(i)}var o=[];return t.length>0&&o.push(U(t,"geometry")),r.length>0&&(o.push(U(r,"westHemisphereGeometry")),o.push(U(r,"eastHemisphereGeometry"))),o};var le=new a,Ee=new a,fe=new a,he=new a;re.computeNormal=function(e){for(var t=e.indices,r=e.attributes,n=r.position.values,i=r.position.values.length/3,o=t.length,s=new Array(i),c=new Array(o/3),l=new Array(o),E=0;E<i;E++)s[E]={indexOffset:0,count:0,currentCount:0};var f=0;for(E=0;E<o;E+=3){var h=t[E],d=t[E+1],m=t[E+2],_=3*h,T=3*d,y=3*m;Ee.x=n[_],Ee.y=n[_+1],Ee.z=n[_+2],fe.x=n[T],fe.y=n[T+1],fe.z=n[T+2],he.x=n[y],he.y=n[y+1],he.z=n[y+2],s[h].count++,s[d].count++,s[m].count++,a.subtract(fe,Ee,fe),a.subtract(he,Ee,he),c[f]=a.cross(fe,he,new a),f++}var R=0;for(E=0;E<i;E++)s[E].indexOffset+=R,R+=s[E].count;f=0;var A;for(E=0;E<o;E+=3){A=s[t[E]];var v=A.indexOffset+A.currentCount;l[v]=f,A.currentCount++,A=s[t[E+1]],v=A.indexOffset+A.currentCount,l[v]=f,A.currentCount++,A=s[t[E+2]],v=A.indexOffset+A.currentCount,l[v]=f,A.currentCount++,f++}var N=new Float32Array(3*i);for(E=0;E<i;E++){var S=3*E;if(A=s[E],A.count>0){for(a.clone(a.ZERO,le),f=0;f<A.count;f++)a.add(le,c[l[A.indexOffset+f]],le);a.normalize(le,le),N[S]=le.x,N[S+1]=le.y,N[S+2]=le.z}else N[S]=0,N[S+1]=0,N[S+2]=1}return e.attributes.normal=new p({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:N}),e};var de=new a,pe=new a,me=new a;re.computeTangentAndBitangent=function(e){for(var t=(e.attributes,e.indices),r=e.attributes.position.values,n=e.attributes.normal.values,i=e.attributes.st.values,o=e.attributes.position.values.length/3,s=t.length,c=new Array(3*o),l=0;l<c.length;l++)c[l]=0;var E,f,h;for(l=0;l<s;l+=3){var d=t[l],m=t[l+1],_=t[l+2];E=3*d,f=3*m,h=3*_;var T=2*d,y=2*m,R=2*_,A=r[E],v=r[E+1],N=r[E+2],S=i[T],I=i[T+1],g=i[y+1]-I,M=i[R+1]-I,O=1/((i[y]-S)*M-(i[R]-S)*g),C=(M*(r[f]-A)-g*(r[h]-A))*O,w=(M*(r[f+1]-v)-g*(r[h+1]-v))*O,x=(M*(r[f+2]-N)-g*(r[h+2]-N))*O;c[E]+=C,c[E+1]+=w,c[E+2]+=x,c[f]+=C,c[f+1]+=w,c[f+2]+=x,c[h]+=C,c[h+1]+=w,c[h+2]+=x}var P=new Float32Array(3*o),L=new Float32Array(3*o);for(l=0;l<o;l++){E=3*l,f=E+1,h=E+2;var b=a.fromArray(n,E,de),U=a.fromArray(c,E,me),F=a.dot(b,U);a.multiplyByScalar(b,F,pe),a.normalize(a.subtract(U,pe,U),U),P[E]=U.x,P[f]=U.y,P[h]=U.z,a.normalize(a.cross(b,U,U),U),L[E]=U.x,L[f]=U.y,L[h]=U.z}return e.attributes.tangent=new p({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:P}),e.attributes.bitangent=new p({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:L}),e},re.computeBinormalAndTangent=function(e){return l("computeBinormalAndTangent","computeBinormalAndTangent was deprecated in 1.30.  It will be removed in 1.31.  Use a computeTangentAndBitangent."),re.computeTangentAndBitangent(e),e.attributes.binormal=e.attributes.bitangent,e};var _e=new n,Te=new a,ye=new a,Re=new a,Ae=new n;re.compressVertices=function(t){var r,i,o=t.attributes.extrudeDirection;if(c(o)){var s=o.values;i=s.length/3;var l=new Float32Array(2*i),E=0;for(r=0;r<i;++r)a.fromArray(s,3*r,Te),a.equals(Te,a.ZERO)?E+=2:(Ae=e.octEncodeInRange(Te,65535,Ae),l[E++]=Ae.x,l[E++]=Ae.y);return t.attributes.compressedAttributes=new p({componentDatatype:u.FLOAT,componentsPerAttribute:2,values:l}),delete t.attributes.extrudeDirection,t}var f=t.attributes.normal,h=t.attributes.st,d=c(f),m=c(h);if(!d&&!m)return t;var _,T,y,R,A=t.attributes.tangent,v=t.attributes.bitangent,N=c(A),S=c(v);d&&(_=f.values),m&&(T=h.values),N&&(y=A.values),S&&(R=v.values);var I=d?_.length:T.length,g=d?3:2;i=I/g;var M=i,O=m&&d?2:1;O+=N||S?1:0,M*=O;var C=new Float32Array(M),w=0;for(r=0;r<i;++r){m&&(n.fromArray(T,2*r,_e),C[w++]=e.compressTextureCoordinates(_e));var x=3*r;d&&c(y)&&c(R)?(a.fromArray(_,x,Te),a.fromArray(y,x,ye),a.fromArray(R,x,Re),e.octPack(Te,ye,Re,_e),C[w++]=_e.x,C[w++]=_e.y):(d&&(a.fromArray(_,x,Te),C[w++]=e.octEncodeFloat(Te)),N&&(a.fromArray(y,x,Te),C[w++]=e.octEncodeFloat(Te)),S&&(a.fromArray(R,x,Te),C[w++]=e.octEncodeFloat(Te)))}return t.attributes.compressedAttributes=new p({componentDatatype:u.FLOAT,componentsPerAttribute:O,values:C}),d&&delete t.attributes.normal,m&&delete t.attributes.st,S&&delete t.attributes.bitangent,N&&delete t.attributes.tangent,t};var ve=new a,Ne=new a,Se=new a,Ie=new a,ge=new a,Me={positions:new Array(7),indices:new Array(9)},Oe=new a,Ce=new a,we=new a,xe=new a,Pe=new n,Le=new n,be=new n,Ue=N.fromPointNormal(a.ZERO,a.UNIT_Y),Fe=new a,De=new a,Be=new n,ze=new n,Ge=new a,Ve=new a,qe=new a,Xe=new a,He=new a,We=new a,ke=new i,Ye=5*R.EPSILON9,Ze=R.EPSILON6;return re.splitLongitude=function(e){var t=e.geometry,n=t.boundingSphere;if(c(n)){var a=n.center.x-n.radius;if(a>0||r.intersectPlane(n,N.ORIGIN_ZX_PLANE)!==T.INTERSECTING)return e}if(t.geometryType!==m.NONE)switch(t.geometryType){case m.POLYLINES:te(e);break;case m.TRIANGLES:J(e);break;case m.LINES:$(e)}else q(t),t.primitiveType===S.TRIANGLES?J(e):t.primitiveType===S.LINES&&$(e);return e},re}),define("Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,n,a,i,o,u){"use strict";function s(e){this._ellipsoid=r(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}return a(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.mercatorAngleToGeodeticLatitude=function(e){return u.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},s.geodeticLatitudeToMercatorAngle=function(e){e>s.MaximumLatitude?e=s.MaximumLatitude:e<-s.MaximumLatitude&&(e=-s.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},s.MaximumLatitude=s.mercatorAngleToGeodeticLatitude(Math.PI),s.prototype.project=function(t,r){var a=this._semimajorAxis,i=t.longitude*a,o=s.geodeticLatitudeToMercatorAngle(t.latitude)*a,u=t.height;return n(r)?(r.x=i,r.y=o,r.z=u,r):new e(i,o,u)},s.prototype.unproject=function(e,r){var a=this._oneOverSemimajorAxis,i=e.x*a,o=s.mercatorAngleToGeodeticLatitude(e.y*a),u=e.z;return n(r)?(r.longitude=i,r.latitude=o,r.height=u,r):new t(i,o,u);
},s}),define("Scene/PrimitivePipeline",["../Core/BoundingSphere","../Core/ComponentDatatype","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryPipeline","../Core/IndexDatatype","../Core/Matrix4","../Core/WebMercatorProjection"],function(e,t,r,n,a,i,o,u,s,c,l,E,f,h){"use strict";function d(e,t,n){var a,i=!n,o=e.length;if(!i&&o>1){var u=e[0].modelMatrix;for(a=1;a<o;++a)if(!f.equals(u,e[a].modelMatrix)){i=!0;break}}if(i)for(a=0;a<o;++a)r(e[a].geometry)&&l.transformToWorldCoordinates(e[a]);else f.multiplyTransformation(t,e[0].modelMatrix,t)}function p(e,r){var n=e.attributes,a=n.position,i=a.values.length/a.componentsPerAttribute;n.batchId=new s({componentDatatype:t.FLOAT,componentsPerAttribute:1,values:new Float32Array(i)});for(var o=n.batchId.values,u=0;u<i;++u)o[u]=r}function m(e){for(var t=e.length,n=0;n<t;++n){var a=e[n];r(a.geometry)?p(a.geometry,n):r(a.westHemisphereGeometry)&&r(a.eastHemisphereGeometry)&&(p(a.westHemisphereGeometry,n),p(a.eastHemisphereGeometry,n))}}function _(n){var a,i,o,u=n.instances,s=n.projection,c=n.elementIndexUintSupported,E=n.scene3DOnly,f=n.vertexCacheOptimize,h=n.compressVertices,p=n.modelMatrix,_=u.length;for(a=0;a<_;++a)if(r(u[a].geometry)){o=u[a].geometry.primitiveType;break}if(d(u,p,E),!E)for(a=0;a<_;++a)r(u[a].geometry)&&l.splitLongitude(u[a]);if(m(u),f)for(a=0;a<_;++a){var T=u[a];r(T.geometry)?(l.reorderForPostVertexCache(T.geometry),l.reorderForPreVertexCache(T.geometry)):r(T.westHemisphereGeometry)&&r(T.eastHemisphereGeometry)&&(l.reorderForPostVertexCache(T.westHemisphereGeometry),l.reorderForPreVertexCache(T.westHemisphereGeometry),l.reorderForPostVertexCache(T.eastHemisphereGeometry),l.reorderForPreVertexCache(T.eastHemisphereGeometry))}var y=l.combineInstances(u);for(_=y.length,a=0;a<_;++a){i=y[a];var R,A=i.attributes;if(E)for(R in A)A.hasOwnProperty(R)&&A[R].componentDatatype===t.DOUBLE&&l.encodeAttribute(i,R,R+"3DHigh",R+"3DLow");else for(R in A)if(A.hasOwnProperty(R)&&A[R].componentDatatype===t.DOUBLE){var v=R+"3D",N=R+"2D";l.projectTo2D(i,R,v,N,s),r(i.boundingSphere)&&"position"===R&&(i.boundingSphereCV=e.fromVertices(i.attributes.position2D.values)),l.encodeAttribute(i,v,v+"High",v+"Low"),l.encodeAttribute(i,N,N+"High",N+"Low")}h&&l.compressVertices(i)}if(!c){var S=[];for(_=y.length,a=0;a<_;++a)i=y[a],S=S.concat(l.fitToUnsignedShortIndices(i));y=S}return y}function T(e,t,n,a){var i,o,u,s=a.length-1;if(s>=0){var c=a[s];i=c.offset+c.count,u=c.index,o=n[u].indices.length}else i=0,u=0,o=n[u].indices.length;for(var l=e.length,E=0;E<l;++E){var f=e[E],h=f[t];if(r(h)){var d=h.indices.length;i+d>o&&(i=0,o=n[++u].indices.length),a.push({index:u,offset:i,count:d}),i+=d}}}function y(e,t){var r=[];return T(e,"geometry",t,r),T(e,"westHemisphereGeometry",t,r),T(e,"eastHemisphereGeometry",t,r),r}function R(e,t){var n=e.attributes;for(var a in n)if(n.hasOwnProperty(a)){var i=n[a];r(i)&&r(i.values)&&t.push(i.values.buffer)}r(e.indices)&&t.push(e.indices.buffer)}function A(e,t){for(var r=e.length,n=0;n<r;++n)R(e[n],t)}function v(t){for(var n=1,a=t.length,i=0;i<a;i++){var o=t[i];if(++n,r(o)){var u=o.attributes;n+=6+2*e.packedLength+(r(o.indices)?o.indices.length:0);for(var s in u)if(u.hasOwnProperty(s)&&r(u[s])){var c=u[s];n+=5+c.values.length}}}return n}function N(e,t){var r=e.length,n=new Float64Array(1+16*r),a=0;n[a++]=r;for(var i=0;i<r;i++){var o=e[i];f.pack(o.modelMatrix,n,a),a+=f.packedLength}return t.push(n.buffer),n}function S(e){for(var t=e,r=new Array(t[0]),n=0,a=1;a<t.length;){var i=f.unpack(t,a);a+=f.packedLength,r[n++]={modelMatrix:i}}return r}function I(t){var n=t.length,a=1+(e.packedLength+1)*n,i=new Float32Array(a),o=0;i[o++]=n;for(var u=0;u<n;++u){var s=t[u];r(s)?(i[o++]=1,e.pack(t[u],i,o)):i[o++]=0,o+=e.packedLength}return i}function g(t){for(var r=new Array(t[0]),n=0,a=1;a<t.length;)1===t[a++]&&(r[n]=e.unpack(t,a)),++n,a+=e.packedLength;return r}if(!i.supportsTypedArrays())return{};var M={};return M.combineGeometry=function(t){var n,a,i=t.instances,o=i.length;o>0&&(n=_(t),n.length>0&&(a=l.createAttributeLocations(n[0])));var u;t.createPickOffsets&&n.length>0&&(u=y(i,n));for(var s=new Array(o),c=new Array(o),E=0;E<o;++E){var f=i[E],h=f.geometry;r(h)&&(s[E]=h.boundingSphere,c[E]=h.boundingSphereCV);var d=f.eastHemisphereGeometry,p=f.westHemisphereGeometry;r(d)&&r(p)&&(r(d.boundingSphere)&&r(p.boundingSphere)&&(s[E]=e.union(d.boundingSphere,p.boundingSphere)),r(d.boundingSphereCV)&&r(p.boundingSphereCV)&&(c[E]=e.union(d.boundingSphereCV,p.boundingSphereCV)))}return{geometries:n,modelMatrix:t.modelMatrix,attributeLocations:a,pickOffsets:u,boundingSpheres:s,boundingSpheresCV:c}},M.packCreateGeometryResults=function(t,n){var a=new Float64Array(v(t)),i=[],o={},u=t.length,s=0;a[s++]=u;for(var c=0;c<u;c++){var l=t[c],E=r(l);if(a[s++]=E?1:0,E){a[s++]=l.primitiveType,a[s++]=l.geometryType;var f=r(l.boundingSphere)?1:0;a[s++]=f,f&&e.pack(l.boundingSphere,a,s),s+=e.packedLength;var h=r(l.boundingSphereCV)?1:0;a[s++]=h,h&&e.pack(l.boundingSphereCV,a,s),s+=e.packedLength;var d=l.attributes,p=[];for(var m in d)d.hasOwnProperty(m)&&r(d[m])&&(p.push(m),r(o[m])||(o[m]=i.length,i.push(m)));a[s++]=p.length;for(var _=0;_<p.length;_++){var T=p[_],y=d[T];a[s++]=o[T],a[s++]=y.componentDatatype,a[s++]=y.componentsPerAttribute,a[s++]=y.normalize?1:0,a[s++]=y.values.length,a.set(y.values,s),s+=y.values.length}var R=r(l.indices)?l.indices.length:0;a[s++]=R,R>0&&(a.set(l.indices,s),s+=R)}}return n.push(a.buffer),{stringTable:i,packedData:a}},M.unpackCreateGeometryResults=function(r){for(var n,a=r.stringTable,i=r.packedData,o=new Array(i[0]),l=0,f=1;f<i.length;){var h=1===i[f++];if(h){var d,p,m=i[f++],_=i[f++],T=1===i[f++];T&&(d=e.unpack(i,f)),f+=e.packedLength;var y=1===i[f++];y&&(p=e.unpack(i,f)),f+=e.packedLength;var R,A,v,N=new c,S=i[f++];for(n=0;n<S;n++){var I=a[i[f++]],g=i[f++];v=i[f++];var M=0!==i[f++];R=i[f++],A=t.createTypedArray(g,R);for(var O=0;O<R;O++)A[O]=i[f++];N[I]=new s({componentDatatype:g,componentsPerAttribute:v,normalize:M,values:A})}var C;if(R=i[f++],R>0){var w=A.length/v;for(C=E.createTypedArray(w,R),n=0;n<R;n++)C[n]=i[f++]}o[l++]=new u({primitiveType:m,geometryType:_,boundingSphere:d,boundingSphereCV:p,indices:C,attributes:N})}else o[l++]=void 0}return o},M.packCombineGeometryParameters=function(e,t){for(var r=e.createGeometryResults,n=r.length,a=0;a<n;a++)t.push(r[a].packedData.buffer);return{createGeometryResults:e.createGeometryResults,packedInstances:N(e.instances,t),ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof o,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix,createPickOffsets:e.createPickOffsets}},M.unpackCombineGeometryParameters=function(e){for(var t=S(e.packedInstances),r=e.createGeometryResults,n=r.length,i=0,u=0;u<n;u++)for(var s=M.unpackCreateGeometryResults(r[u]),c=s.length,l=0;l<c;l++){var E=s[l],d=t[i];d.geometry=E,++i}var p=a.clone(e.ellipsoid),m=e.isGeographic?new o(p):new h(p);return{instances:t,ellipsoid:p,projection:m,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:f.clone(e.modelMatrix),createPickOffsets:e.createPickOffsets}},M.packCombineGeometryResults=function(e,t){r(e.geometries)&&A(e.geometries,t);var n=I(e.boundingSpheres),a=I(e.boundingSpheresCV);return t.push(n.buffer,a.buffer),{geometries:e.geometries,attributeLocations:e.attributeLocations,modelMatrix:e.modelMatrix,pickOffsets:e.pickOffsets,boundingSpheres:n,boundingSpheresCV:a}},M.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,modelMatrix:e.modelMatrix,pickOffsets:e.pickOffsets,boundingSpheres:g(e.boundingSpheres),boundingSpheresCV:g(e.boundingSpheresCV)}},M}),define("Core/formatError",["./defined"],function(e){"use strict";function t(t){var r,n=t.name,a=t.message;r=e(n)&&e(a)?n+": "+a:t.toString();var i=t.stack;return e(i)&&(r+="\n"+i),r}return t}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,t,r){"use strict";function n(n){var a,i=[],o={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;i.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=n(s.parameters,i)}catch(e){e instanceof Error?o.error={name:e.name,message:e.message,stack:e.stack}:o.error=e}t(a)||(a=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(i.length=0);try{a(o,i)}catch(e){o.result=void 0,o.error="postMessage failed with error: "+r(e)+"\n  with responseMessage: "+JSON.stringify(o),a(o)}}}return n}),define("Workers/createGeometry",["../Core/defined","../Scene/PrimitivePipeline","./createTaskProcessorWorker","require"],function(e,t,r,n){"use strict";function a(t){var r=o[t];return e(r)||("object"==typeof exports?o[r]=r=n("Workers/"+t):n(["./"+t],function(e){r=e,o[r]=e})),r}function i(r,n){for(var i=r.subTasks,o=i.length,u=new Array(o),s=0;s<o;s++){var c=i[s],l=c.geometry,E=c.moduleName;if(e(E)){var f=a(E);u[s]=f(l,c.offset)}else u[s]=l}return t.packCreateGeometryResults(u,n)}var o={};return r(i)})}();