package lipfd.scripts;

import lipfd.commons.*;

import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JLabel;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.RotatedRect;
import org.opencv.core.Size;
import org.opencv.highgui.*;
import org.opencv.imgproc.Imgproc;

import java.io.IOException;
import java.io.File;
import java.util.*;
import java.lang.Math;

public class TrainingSetGenerator {
	public static void main(String[] args){

		System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
		String originalInputImagePath = "downloadedImages/" + args[0] + ".IMG";
		String newInputImagePath="downloadedImages/" + args[0];
		String commandString = "hi2isis from=" + originalInputImagePath + " to=" + newInputImagePath + ".cub";
		Util.runProgram(commandString);
		commandString="hical from="+newInputImagePath+".cub to="+newInputImagePath+".cal.cub";
		//Util.runProgram(commandString);
		commandString="cubenorm from="+newInputImagePath+".cub to="+newInputImagePath+".norm.cub";
		Util.runProgram(commandString);
		commandString="isis2std from="+newInputImagePath+".norm.cub to="+newInputImagePath+".tiff"
			+" format=tiff";
		Util.runProgram(commandString);
		newInputImagePath = newInputImagePath + ".tiff";
		System.out.println(newInputImagePath);
		Image image = new Image(newInputImagePath);
		String metadataFile = args[1];
		int cropx = Integer.parseInt(args[2]);
		int cropy = Integer.parseInt(args[3]);
		int numRotations = Integer.parseInt(args[4]);
		String outputdir = args[5];
		int resizeTo = Integer.parseInt(args[6]);

		File mkdirsFile = new File(outputdir);
		mkdirsFile.mkdirs();

		int roiSeq = 0;
		List<Crater> rois;
		try{
			rois = Util.parseMetaData(Util.readFile(metadataFile),
					cropx, cropy, cropx + image.getWidth(), cropy + image.getHeight());
		} catch(IOException e) {
			e.printStackTrace();
			return;
		}
		for(Crater roi : rois) {
			generateArtificialData(roi, image, outputdir, ++roiSeq, numRotations, resizeTo);
		}
	}

	public static void generateArtificialData(Crater c, Image image, String outputdir, int seqNum, int numRotations, int resizeTo){
		//http://answers.opencv.org/question/497/extract-a-rotatedrect-area/
		double width = Math.max(c.enclosingRect[2] - c.enclosingRect[0],
					c.enclosingRect[3] - c.enclosingRect[1]);
		int minx = (int) (c.centerX - width);
		int miny = (int) (c.centerY - width);
		int maxx = (int) (c.centerX + width);
		int maxy = (int) (c.centerY + width);
		Mat src = image.crop(minx, miny, maxx, maxy).getMat();
		RotatedRect rect = new RotatedRect(new Point(width, width), new Size(width, width), 0);
		Mat rotated = new Mat();
		for(double angle = 0; angle < 360; angle += 360.0/((double) numRotations+1)){
			Mat m = Imgproc.getRotationMatrix2D(rect.center, angle, 1.0);
			Imgproc.warpAffine(src, rotated, m, src.size(), Imgproc.INTER_CUBIC);
			Mat cropped = new Mat();
			Imgproc.getRectSubPix(rotated, rect.size, rect.center, cropped);
			(new Image(cropped)).resize(resizeTo, resizeTo)
				.saveImage(outputdir + String.valueOf(seqNum) +"-4" +"-" +
					String.valueOf((int)angle) + ".pgm");
		}
	}
}
