package lipfd.dataExtract;

import lipfd.commons.model.*;
import lipfd.commons.*;

import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;


import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.imgproc.Moments;

public class DataExtract {

	public DataExtract(){

	}


	/***********************************************************************************************
	 *                USE THIS METHOD ONLY FOR EXTRACTING DEPTH/DIAMETER
	 *
	 ***********************************************************************************************/
	public static void computeDDs(List<Crater> craters, List<Image> images, List<ImageMetadata> metadatas, double correctedAzimAngle,
			double confidence, boolean usingSingleImage){
		for(int cCount = 0; cCount < craters.size(); cCount++){
			Crater crater = craters.get(cCount);
			if(crater.conf >= confidence){

				if(usingSingleImage == true){
					//update azimuth angle
					double oAzim = metadatas.get(0).sub_solar_azimuth;
					metadatas.get(0).sub_solar_azimuth = correctedAzimAngle;
					Image cImage = images.get(0).crop(crater.enclosingRect[0], crater.enclosingRect[1], crater.enclosingRect[2], crater.enclosingRect[3]);
					computeDepthDiameterSI(crater, cImage, metadatas.get(0), usingSingleImage);
					//change azimuth angle back to original
					metadatas.get(0).sub_solar_azimuth = oAzim;
				}else{
					computeDepthDiameter(crater, images, metadatas, usingSingleImage);
				}

			}//end if confidence...

		}//end craterList iteration
	}

	/*******************************************************************************************
	 *
	 *******************************************************************************************/

	//Use this method to find depth and diameter using only a single image, this is the default!
	public static void computeDepthDiameterSI(Crater crater, Image image, ImageMetadata metadata, boolean usingSingleImage){
		double diameter = computeDiameter(crater, image, metadata);
		double depth = computeDepth(crater, image, metadata, usingSingleImage);
		crater.diameter = diameter;
		crater.depth = depth;
	}

	//If we get pixel/lon and lat interpolation with better accuracy, use this function to find depth and diameter using multiple images.
	public static void computeDepthDiameter(Crater crater, List<Image> images, List<ImageMetadata> metadatas, boolean usingSingleImage){
		//update these variables as we loop along.
		double diameter = 0;
		double depth = 0;
		for(Image image : images){
			String imageName = image.getFilename();
			//crop out crater
			Image croppedCrater = image.crop(crater.enclosingRect[0], crater.enclosingRect[1], crater.enclosingRect[2], crater.enclosingRect[3]);
			ImageMetadata correspondingMd = new ImageMetadata();
			//loop through the list of metadata to get the right metadata
			for(ImageMetadata md : metadatas){
				if(imageName.equals(md.product_id)){
					correspondingMd = md;
				}//end if
			}
			diameter += computeDiameter(crater, croppedCrater, correspondingMd);

			depth += computeDepth(crater, croppedCrater, correspondingMd, usingSingleImage);
		}//end for each image
		System.gc();
		//get averages of depths and diameters (If using multiple images).
		double aveDiameter = diameter / images.size();
		crater.diameter  = aveDiameter;
		double aveDepth = depth / images.size();
		crater.depth = aveDepth;
	}

	public static double computeDiameter(Crater crater, Image cImage, ImageMetadata md){
		int width = cImage.getWidth();
		int height = cImage.getHeight();
		double average = (double)(width + height) / 2.0;

		//cf factor might create more error in calculations since lat/lon aren't accurate per crater.
//		double cfLon = Math.cos(Math.toRadians(crater.centerXLongLat));
//		double cfLat = Math.cos(Math.toRadians(crater.centerXLongLat));
//		double cf = 1/(cfLon * cfLat);
			double resolution = (md.scaled_pixel_width*md.image_lines+md.scaled_pixel_width)/2.0;
		//double resolution = (md.scaled_pixel_height + md.scaled_pixel_width)/2.0;
		//double diameter = distance * resolution;// * cf;
		double diameter = average * resolution;// * cf;
		return diameter;
	}

	public static double computeDepth(Crater crater, Image cImage, ImageMetadata md, boolean usingSingleImage){
		//get a mat of shadows for the image
		Mat shadows = getShadowsMat(cImage.getMat());
		//get shadow centers and bounding box
		ShadowData shadowD = getShadowData(shadows);
		//get shadow endpoints
		List<Point> endPoints = findShadowLength(crater, md, shadows, shadowD.centerPoint, shadowD.boundingRect, usingSingleImage);
		crater.shadowEndPoints.add(endPoints);
		Point p1 = endPoints.get(0);
		Point p2 = endPoints.get(1);

		//cf factor might create more error in calculations since lat/lon aren't accurate per crater.
//		double cfLon = Math.cos(Math.toRadians(crater.centerXLongLat));
//		double cfLat = Math.cos(Math.toRadians(crater.centerXLongLat));
//		double cf = 1/(cfLon * cfLat);

		double incidence = md.incidence_angle;
		double resolution = (md.scaled_pixel_width*md.image_lines+md.scaled_pixel_width)/2.0;
		//double resolution = (md.scaled_pixel_height + md.scaled_pixel_width)/2.0;
		double shadowLength = Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2));
		double scaledShadowLength = shadowLength * resolution;// * cf;
		double tanAngle = Math.tan(Math.toRadians(90 - incidence));
		double depth = scaledShadowLength * tanAngle;
		return depth;
	}

	//use this method to recompute depth using single image.
	public static void recomputeDepthSI(Crater crater, ImageMetadata metadata, Point newEnd1, Point newEnd2){
		double incidenceAngle = metadata.incidence_angle;
		//changed for mars images
		//double resolution = (metadata.scaled_pixel_height + metadata.scaled_pixel_width)/2.0;
		double resolution = (metadata.scaled_pixel_width*metadata.image_lines+metadata.scaled_pixel_width)/2.0;

	double shadowLength = Math.sqrt(Math.pow(newEnd1.x - newEnd2.x, 2) + Math.pow(newEnd1.y - newEnd2.y, 2));
		double scaledShadowLength = shadowLength * resolution;
		double tanAngle = Math.tan(Math.toRadians(90 - incidenceAngle));
		double depth = tanAngle * scaledShadowLength;
		crater.depth = depth;
	}

	public static void recomputeDiameterSI(Crater crater, ImageMetadata metadata, Point newEnd1, Point newEnd2){

		double resolution = (metadata.scaled_pixel_width*metadata.image_lines+metadata.scaled_pixel_width)/2.0;
//took out and replaced for mars
	//	double resolution = (metadata.scaled_pixel_height + metadata.scaled_pixel_width)/2.0;
//		double cfLon = Math.cos(Math.toRadians(crater.centerXLongLat));
//		double cfLat = Math.cos(Math.toRadians(crater.centerYLongLat));
//		double cf = 1/(cfLon * cfLat);

		//find euclidean distance between two points
		double diamDistance = Util.euclideanDistance(newEnd1, newEnd2);
		double diameter = resolution * diamDistance; // * cf;
		crater.diameter = diameter;
	}

	public static void recomputeDepthMI(Crater crater, int indexNum, ImageMetadata metadata, Point newEnd1, Point newEnd2){
		List<Point> newPoints = new ArrayList<Point>();
		newPoints.add(newEnd1);
		newPoints.add(newEnd2);
		//replace with new end points
		crater.shadowEndPoints.set(indexNum, newPoints);

//		double cfLon = Math.cos(Math.toRadians(crater.centerXLongLat));
//		double cfLat = Math.cos(Math.toRadians(crater.centerYLongLat));
//		double cf = 1/(cfLon * cfLat);

		double incidence = metadata.incidence_angle;
		//took out for mars
		//double resolution = (metadata.scaled_pixel_height + metadata.scaled_pixel_width)/2.0;
		double resolution = (metadata.scaled_pixel_width*metadata.image_lines+metadata.scaled_pixel_width)/2.0;

		double shadowLength = Math.sqrt(Math.pow(newEnd1.x - newEnd2.x, 2) + Math.pow(newEnd1.y - newEnd2.y, 2));
		double scaledShadowLength = shadowLength * resolution;// * cf;
		double tanAngle = Math.tan(Math.toRadians(90 - incidence));
		double newDepth = scaledShadowLength * tanAngle;
		crater.craterDepths.set(indexNum, newDepth);

		double tenaciousD = 0;//value for each depth.
		for(int x = 0; x < crater.craterDepths.size(); x++){
			tenaciousD += crater.craterDepths.get(x);
		}
		tenaciousD = tenaciousD / crater.craterDepths.size();

		//set new depth
		crater.depth = tenaciousD;
	}

	/**For Tony, method to get crater images for craters**/
	public static Mat cropOutCrater(Crater crater, Image fullImage){
		int[] boundBox = crater.enclosingRect;
		Image craterImage = fullImage.crop(boundBox[0], boundBox[1], boundBox[2], boundBox[3]);
		return craterImage.getMat();
	}

	//These two methods below are used to
	public static List<Point> findShadowLength(Crater crater, ImageMetadata metadata, Mat darkLight, Point shadowCenter, Rect boundShadow, boolean usingSingleImage) {

		double azimAngle = 0;
		int length = 30;

		if(usingSingleImage == true){
			azimAngle = metadata.sub_solar_azimuth;
			double boxWidth = crater.enclosingRect[2] - crater.enclosingRect[0];
			double boxHeight = crater.enclosingRect[3] - crater.enclosingRect[1];
			double diameter = (boxWidth + boxHeight)/2.0;
			if (diameter <= 70 && crater.diameter > 27) {
				length = 25;
			}
			if (diameter <= 27) {
				length = 13;
			}
		}
		else{
			azimAngle = Math.toDegrees(metadata.sub_solar_azimuth);
			//default arbitrary length when using multipe images, since diameters and depths are being
			//computed at the same time. Can't use crater.diameter to determine length anymore.
			length = 20;
		}
		// get the center of the shadow
		double shadowCX = shadowCenter.x;
		double shadowCY = shadowCenter.y;
		List<Point> points = null;
		double euclid = 0.0;
		while(euclid == 0.0){
			int arbX = (int) Math.round((shadowCX + length
					* Math.cos(Math.toRadians(azimAngle))));

			//should go clockwise or counterclockwise for sun direction
			int arbY = 0;
			if(false){//metadata.usage_note.equals("F")){
				//taken out for mars
			//if(metadata.lro_flight_direction.equals("-X")){
				arbY = (int) Math.round((shadowCY - length
						* Math.sin(Math.toRadians(azimAngle))));
				}else{
					arbY = (int) Math.round((shadowCY + length
							* Math.sin(Math.toRadians(azimAngle))));
				}
			// getting rise over run
			int rise = (int)(arbY - shadowCY);
			int run = (int)(arbX - shadowCX);
			int gcd = gcd(rise, run);

			rise = rise / gcd;
			run = run / gcd;

			// want to march along and keep getting gray values. Once we get black
			// or white value stop marching, record last position of gray value,
			// image also has blue and red so
			// that's why I'm sticking to just checking if it's a white or black
			// pixel
			List<Point> temPoints = march(rise, run, (int)shadowCX, (int)shadowCY, crater, darkLight, boundShadow);
			euclid = Util.euclideanDistance(temPoints.get(0), temPoints.get(1));
			if(euclid > 0){
				points = temPoints;
			}else{
				length -= 1;
			}
			if(length == 2){
				points = temPoints;
				break;
			}

		}

		//create two arbitrary points using azimuth and lenth to find rise and run.
		return points;
	}

	public static int gcd(int rise, int run) {
		while (rise != 0 && run != 0) {
			int c = run;
			run = rise % run;
			//System.out.println("run: " + run);
			rise = c;
		}
		return rise + run;
	}


	//This method marches from center of shadow centroid to opposite ends of shadow along sun vector and returns two shadow end points
	public static List<Point> march(int rise, int run, int xPos, int yPos, Crater crater, Mat darkLight, Rect bounds) {
		List<Point> points = new ArrayList<Point>();

		// want values to be inside of bounding box, if not then stop with
		// boolean
		boolean maxedOut = false;

		int xMax = (int)bounds.br().x - 1;
		int yMax = (int)bounds.br().y - 1;
		int yMin = (int)bounds.tl().y;
		int xMin = (int)bounds.tl().x;
		int currentX1 = xPos;
		int currentY1 = yPos;
		int tempX = xPos;
		int tempY = yPos;

		// while x and y are still inside bounding box
		while (maxedOut == false) {
			// get temporary x and y using currentx and currentY + rise and run
			// respectively
			tempX +=  run;
			tempY +=  rise;
			// check to make sure they're within bounding box range
			if (tempX <= xMax && tempY <= yMax && tempX >= xMin
					&& tempY >= yMin) {
				double data[];
				// get pixel values to check or black or white
				data = darkLight.get(tempY, tempX);
				//if pixels are white, then we are still within shadow, save coordinates
				if(data[0] == 255){
					currentX1 = tempX;
					currentY1 = tempY;
					//System.out.println("found new shadow point:" + tempX + ", " + tempY);
				}
			//Stop marching one you reach the end of the bounding box
			} else {
				//System.out.println("end.");
				maxedOut = true;
			}
		}// end first while loop
			// store point of last x1 and y1
		Point firstPoint = new Point(currentX1, currentY1);
		points.add(firstPoint);
		// reset maxed out, run to the opposite direction
		maxedOut = false;
		// use new anchor points to march along the other way
		int currentX2 = xPos;
		int currentY2 = yPos;
		tempX = xPos;
		tempY = yPos;
		while (maxedOut == false) {
			// keep subtracting and go the other way
			tempX -= run;
			tempY -= rise;
			if (tempX <= xMax && tempY <= yMax && tempX >= xMin
					&& tempY >= yMin) {
				double data[] = new double[0];
				data = darkLight.get(tempY, tempX);
				if(data[0] == 255){
					currentX2 = tempX;
					currentY2 = tempY;
				}
			// if it's not within bounding box, stop
			} else {
				maxedOut = true;
			}
		}
		// store point of last x2 and y2
		Point secPoint = new Point(currentX2, currentY2);
		points.add(secPoint);
		return points;
	}

	public static Mat getShadowsMat(Mat imgMat){
		Mat grayMat = imgMat.clone();
		Mat shadows = new Mat();
		Mat element = Imgproc.getStructuringElement(Imgproc.MORPH_RECT, new  Size(5, 5));
		//image processing for finding shadows
		double devThresh = getStandardDevThresh(grayMat);
		Imgproc.threshold(grayMat, shadows, devThresh, 255.0, Imgproc.THRESH_BINARY_INV);
		Imgproc.medianBlur(shadows, shadows, 3);
		Imgproc.dilate(shadows, shadows, element);
		Imgproc.erode(shadows, shadows, element);

		return shadows;
	}

	public static ShadowData getShadowData(Mat shadowMat){
		Rect boundR = new Rect();
		ArrayList<MatOfPoint> contours = new ArrayList<MatOfPoint>();
		Mat hierarchy = new Mat();
		//Mat dMat = new Mat();
		//find contours
		Imgproc.findContours(shadowMat.clone(), contours, hierarchy, Imgproc.RETR_TREE, Imgproc.CHAIN_APPROX_SIMPLE);
		Point bestCenter = new Point();
		double largestArea = 0;
		//get moments
		for (int i = 0; i < contours.size(); i++)
		{
			//find contour with largest area
			if(Imgproc.contourArea(contours.get(i)) > largestArea){
				largestArea = Imgproc.contourArea(contours.get(i));
				Moments moment = Imgproc.moments(contours.get(i), false);
				int xCenter = (int) (moment.get_m10() / moment.get_m00());
				int yCenter = (int) (moment.get_m01() / moment.get_m00());
				bestCenter.x = xCenter;
				bestCenter.y = yCenter;
				boundR = Imgproc.boundingRect(contours.get(i));
			}
		}
//		BufferedImage nb = matToBufferedImage(shadowMat);
//		displayImage(nb, "inverted shadows");
		return new ShadowData(bestCenter, boundR);
	}


	public static int getStandardDevThresh(Mat grayMat){
		double[] pixels = new double[1];
		double sum = 0;
		double otsu = Imgproc.threshold(grayMat.clone(), grayMat.clone(), 0, 255, Imgproc.THRESH_OTSU);
		for(int rows = 0; rows < grayMat.rows(); rows++){
			for(int cols = 0; cols < grayMat.cols(); cols++){
				pixels = grayMat.get(rows, cols);
				sum += Math.pow((pixels[0] - otsu), 2);
			}
		}
		int deviate = (int)Math.sqrt( ((double)sum/(double)(grayMat.rows() * grayMat.cols())) );
		//threshhold value for shadows
		return (int)(otsu - deviate);
	}


//	public static void main(String[] args){
//
//		System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
//		String filename = "C:\\courses\\CS496\\TestData\\YoshiCrater\\sample2.tiff";
//		Mat oMat = Highgui.imread(filename);
//		//System.out.println(oMat.size());
//		Mat grayMat = new Mat();
//		Mat dMat = new Mat();
//		Imgproc.cvtColor(oMat, grayMat, Imgproc.COLOR_RGB2GRAY);
//		Mat shadows = getShadowsMat(grayMat);
//		ShadowData sd = getShadowData(shadows);
//		Imgproc.equalizeHist(grayMat, dMat);
//		ImageMetadata md = new ImageMetadata();
//		md.scaled_pixel_height = 0.92;
//		md.scaled_pixel_width = 0.85;
//		md.incidence_angle = 76.53;
//		md.lro_flight_direction = "+X";
//		md.sub_solar_azimuth = 170.45;
//
//		Crater crater = new Crater();
//		crater.diameter = 60;
//		//Crater crater, ImageMetadata metadata, Mat darkLight, Point shadowCenter, Rect boundShadow
//		List<Point> points = findShadowLength(crater, md, shadows, sd.centerPoint, sd.boundingRect, true);
//		Core.line(dMat, new Point(sd.centerPoint.x-4, sd.centerPoint.y),new Point(sd.centerPoint.x+4,sd.centerPoint.y),new Scalar(255,255,0,255),1);
//		Core.line(dMat, new Point(sd.centerPoint.x, sd.centerPoint.y-4),new Point(sd.centerPoint.x,sd.centerPoint.y+4),new Scalar(255,255,0,255),1);
//		Core.line(dMat, new Point(sd.centerPoint.x-2, sd.centerPoint.y-2),new Point(sd.centerPoint.x+2,sd.centerPoint.y+2),new Scalar(255,255,0,255),1);
//		Core.line(dMat, new Point(sd.centerPoint.x+1, sd.centerPoint.y-1),new Point(sd.centerPoint.x-1,sd.centerPoint.y+1),new Scalar(200,200,0,255),1);
//		BufferedImage dImage = matToBufferedImage(dMat);
//		displayImage(dImage, "Original");
//
//		Core.rectangle(dMat, sd.boundingRect.tl(), sd.boundingRect.br(), new Scalar(0, 0, 0), 1);
//		Core.line(oMat, points.get(0), points.get(1), new Scalar(0, 0, 255));
//		BufferedImage oImage = matToBufferedImage(oMat);
//		displayImage(oImage, "Rectangle");
//	}

    public static void displayImage(BufferedImage img2, String title){
    	ImageIcon icon = new ImageIcon(img2);
    	JFrame frame=new JFrame();
    	frame.setLayout(new FlowLayout());
    	frame.setSize(img2.getWidth(null)+50, img2.getHeight(null)+50);
    	JLabel lbl=new JLabel();
    	lbl.setIcon(icon);
    	frame.add(lbl);
    	frame.setTitle(title);
    	frame.setVisible(true);
}

	public static BufferedImage matToBufferedImage(Mat m){
		int type = BufferedImage.TYPE_BYTE_GRAY;
		if (m.channels() > 1)
		{
			type = BufferedImage.TYPE_3BYTE_BGR;
		}
		int bufferSize = m.channels()*m.cols()*m.rows();
		byte[] b = new byte[bufferSize];
		m.get(0, 0, b);
		BufferedImage img = new BufferedImage(m.cols(), m.rows(), type);
		final byte[] targetPixels = ((DataBufferByte) img.getRaster().getDataBuffer()).getData();
		System.arraycopy(b, 0, targetPixels, 0, b.length);

		return img;
	}

}
