function images = loadCraterImages(dirname)
	fileName = strcat(dirname, '*.pgm');
	filenames = dir(fullfile(pwd,fileName));
	files = sort_nat({filenames.name}, 'ascend')';

	images = zeros(28, 28, size(files, 1));
	for i = 1:(size(files,1))
    	images(:, :, i) = imread(strcat(dirname, files{i, 1}));
	end
	images = double(images)./255;
	%images = reshape(images, numCols, numRows, numImages)
end
