package lipfd.commons;
import java.util.*;
import lipfd.commons.*;
import lipfd.commons.model.*;
import lipfd.commons.model.dao.*;
import lipfd.commons.model.dao.jdbc.*;
import lipfd.circleHough.CircleHoughDetector;
import lipfd.templateMatching.TemplateMatching;
import lipfd.ellipse.EnclosingRect;
import lipfd.pca.PCA;
import lipfd.dataExtract.*;
import lipfd.performanceCalculator.PerformanceCalculator;
import java.awt.Rectangle;

public class UniqueCraterTree{

	private Node root;
	private int depth;
	private static double OVERLAP_THRESHOLD = 0.5;
	private static double AREA_THRESHOLD = 0.8;
	
	public UniqueCraterTree(double width, double height){
	  this(width,height,1);
	}

	public UniqueCraterTree(double width, double height, int depth){
		//spit 2d into quadrants like a quadtree structure 
		root = new Node(0,width,0,height);
		double midY = height/2;
		double midX = width/2;
		root.north_west = new Node(0,midX,0,midY);
		root.north_east = new Node(midX,width,0,midY);
		root.south_west = new Node(0,midX,midY,height);
		root.south_east = new Node(midX,width,midY, height);
		root.hasChildren = true;
		if(depth > 1)divideQuadrants(root,1,depth);
	}
	/*
	  recursivly divide children quadrants based on the depth specified
	*/
	private void divideQuadrants(Node node, int currentDepth, int targetDepth){
		if(currentDepth != targetDepth)return;
		double width = node.maxX - node.minX;
		double height = node.maxY - node.minY; 
		double midY = height/2;
		double midX = width/2;
		node.north_west = new Node(0,midX,0,midY);
		node.north_east = new Node(midX,width,0,midY);
		node.south_west = new Node(0,midX,midY,height);
		node.south_east = new Node(midX,width,midY, height);
		if(currentDepth != targetDepth){
			node.hasChildren = true;
			int nextDepth = currentDepth+ 1;
			divideQuadrants(node.north_west,nextDepth,targetDepth);
			divideQuadrants(node.north_east,nextDepth,targetDepth);
			divideQuadrants(node.south_west,nextDepth,targetDepth);
			divideQuadrants(node.south_east,nextDepth,targetDepth);
		}
	}


	public List<Crater> toList(){
		return getAllCraters();
	}
	
	public void insertCraterList(List<Crater> craters){
		for(Crater c: craters){
			insert(c);		
		}
	}
	
	private ArrayList<Crater> getAllCraters(){
		ArrayList<Crater> craters = new ArrayList<Crater>();
		ArrayList<Node> leafNodes = new ArrayList<Node>();
		leafNodes = findLeafNodes(root);
		System.out.print("Tree Node length: "+leafNodes.size());
		for(Node node: leafNodes)
		{
			appendCratersToList(craters,node);	
		}
		
		return craters;		
	}

	private ArrayList<Node> findLeafNodes(Node rootNode){
		
		ArrayList<Node> nextNodes = new ArrayList<Node>();
		nextNodes.add(rootNode.north_east);
		nextNodes.add(rootNode.north_west);
		nextNodes.add(rootNode.south_east);
		nextNodes.add(rootNode.south_west);
		return getLastNodes(nextNodes);
	}
	
	private ArrayList<Node> getLastNodes(ArrayList<Node> parseNodes){
		if(!parseNodes.get(0).hasChildren)return parseNodes;
		ArrayList<Node> nextNodes = new ArrayList<Node>();
		for(Node node: parseNodes )
		{
			nextNodes.add(node.north_east);
			nextNodes.add(node.north_west);
			nextNodes.add(node.south_east);
			nextNodes.add(node.south_west);
		}
		return getLastNodes(nextNodes);			
	}	


	private void appendCratersToList(ArrayList<Crater> craters, Node node){
		for(Crater c: node.craters) craters.add(c);
	}

		
	private void insert(Crater insertCrater){
		
	    Node parseNode = root;
	    //identify which node this crater should be placed in 
	    while(parseNode.hasChildren)
	   {
		if(parseNode.north_west.containsPoint(insertCrater.centerX, insertCrater.centerY))
		{
			parseNode = parseNode.north_west;
		}else if(parseNode.north_east.containsPoint(insertCrater.centerX, insertCrater.centerY)){
			parseNode = parseNode.north_east;
		}else if(parseNode.south_west.containsPoint(insertCrater.centerX, insertCrater.centerY)){
			parseNode = parseNode.south_west;
		}else if(parseNode.south_east.containsPoint(insertCrater.centerX, insertCrater.centerY)){
			parseNode = parseNode.south_east;
		}		
	    }
	  
	   if(parseNode.craters == null ){
		parseNode.craters = new ArrayList<Crater>();
	   }
	   //if there are no craters then we insert 
	   if(parseNode.craters.isEmpty())parseNode.craters.add(insertCrater);
	   else{
		// check to see if the crater we are trying to insert overlaps with any craters in this node
	      boolean isDuplicate = false;
	      for(Crater crater: parseNode.craters){
			if(isDuplicate(crater,insertCrater))
			{
			  crater = combineCrater(crater, insertCrater);
			  isDuplicate = true;
			  break;
			}
	      }
	     if(!isDuplicate)parseNode.craters.add(insertCrater);	
	   }

	}
	/*
		takes 2 craters and "combines" them by returning a new crater representing the combined crater
	*/
	private Crater combineCrater(Crater crater1, Crater crater2){
	  //TODO Experiment with implementation 
	   int minx = (crater1.enclosingRect[0] + crater2.enclosingRect[0])/2;
	   int miny = (crater1.enclosingRect[1] + crater2.enclosingRect[1])/2;
	   int maxx = (crater1.enclosingRect[2] + crater2.enclosingRect[2])/2;
	   int maxy = (crater1.enclosingRect[3] + crater2.enclosingRect[3])/2;
	
           return new Crater(minx,miny,maxx,maxy);
	}
	
	/*
		takes 2 crates and 
	*/
	private boolean isDuplicate(Crater crater1, Crater crater2){
		//return false;
		//TODO Experiment with implementation
		//rectangle of crater 1
		int x1 = crater1.enclosingRect[0];
		int y1 = crater1.enclosingRect[1];
		int width1 = crater1.enclosingRect[2]-x1;
		int height1 = crater1.enclosingRect[3]-y1;
		//rectangle of crater 2
		int x2 = crater2.enclosingRect[0];		
		int y2 = crater2.enclosingRect[1];		
		int width2 = crater2.enclosingRect[2]-x2;		
		int height2 = crater2.enclosingRect[3]-y2;
		Rectangle rec1 = new Rectangle(x1,y1,width1,height1); 
		Rectangle rec2 = new Rectangle(x2,y2,width2,height2);
			
		if(!(rec1.contains(crater2.centerX,crater2.centerY) && rec2.contains(crater1.centerX,crater1.centerY)))return false;
		//check if they are similar in size 
		double areaRec1 = rec1.getWidth()*rec1.getHeight();
		double areaRec2 = rec2.getWidth()*rec2.getHeight();
		double maxArea = Math.max(areaRec1,areaRec2);
		double minArea = Math.min(areaRec1,areaRec2);
		double ratio = minArea/maxArea;
		if(ratio < AREA_THRESHOLD)return false;
		//check there over lap 
		Rectangle overlapRec = rec1.intersection(rec2);
		if(overlapRec.isEmpty())return true;
		double area = overlapRec.getWidth()*overlapRec.getHeight();
		ratio = area/minArea;
		if(ratio < OVERLAP_THRESHOLD) return false;

		return true;
		/*double areaRec1 = rec1.getWidth()*rec1.getHeight();
		double areaRec2 = rec2.getWidth()*rec2.getHeight();
		double dif = Math.abs(areaRec1-areaRec2);
		int sizeRange = 100;
		
		if(dif > sizeRange)return false;*/
		//check to see if they are centered around the same thing 
		/*double centerRange  = Math.pow(25,2);
		//compare centers of the craters 
		double unSqrtDistance = Math.pow(crater1.centerX-crater2.centerX,2)+Math.pow(crater1.centerY-crater2.centerY,2);
		if(unSqrtDistance > centerRange) return false;*/
		
		//check to see if the width and height of a crater are within a certain percentage of each other
		/*double thresh_percent = 0.05;
		double maxWidth = Math.max(width1,width2);
		double minWidth = Math.min(width1,width2);
		double maxHeight = Math.max(height1,height2);
		double minHeight = Math.min(height1,height2);

		double percentW = 1-(minWidth/maxWidth);		
		double percentH = 1-(minHeight/maxHeight);
		
		if(percentW < thresh_percent && percentH < thresh_percent)return true;	*/
		
		//check if areas are similar
		/*double areaRec1 = rec1.getWidth()*rec1.getHeight();
		double areaRec2 = rec2.getWidth()*rec2.getHeight();
		double dif = Math.abs(areaRec1-areaRec2);
		int sizeRange = 100;
		
		if(dif < sizeRange)return true;*/	


		


		//return true;
		/*Rectangle overlapRec = rec1.intersection(rec2);
		if(overlapRec.isEmpty())return false;
		else return true;
		int recArea1 = (int)(rec1.getWidth()*rec1.getHeight());
		int recArea2 = (int)(rec2.getWidth()*rec2.getHeight());

		double minArea = Math.min(recArea1,recArea2);
		int overlapArea = (int)(overlapRec.getWidth()*overlapRec.getHeight());
 		return (overlapArea/minArea) >= overlap_threshold;
		//return false;*/
	}


	public class Node{
		double maxX, maxY, minX, minY;
		Node north_west, north_east, south_west, south_east;
		boolean hasChildren = false;
		List<Crater> craters;
		public Node(double minX, double maxX, double minY, double maxY ){
			this.minX = minX;
			this.minY = minY;
			this.maxX = maxX;
			this.maxY = maxY;
		}


		public boolean containsPoint(double x, double y){
		return x <= maxX && x >= minX && y <= maxY && y >= minY;
		}
	}	
}
