package lipfd.commons;
import java.sql.*;
import java.util.*;

import lipfd.commons.model.ImageMetadata;

public class DBWrite {
	public static void main(String[] args) {
		// createTable(a);
	}

	public static void createTable(ArrayList<Crater> cratersList){
		try {
			// Login information
			String url = "jdbc:mysql://localhost:3306/lrocmetadata";
			String username = "lipfd";
			// Replace password with your password
			String password = "lipfd";

			Connection connection = null;

			System.out.println("Connecting database...");

			connection = DriverManager.getConnection(url, username, password);
			System.out.println("Database connected!");

			System.out.println("Creating table in given database...");
		    Statement stmt = connection.createStatement();

		    stmt.executeUpdate("DROP TABLE IF EXISTS results");
		    String sql = "CREATE TABLE results " +
		    		"(id VARCHAR(200) NOT NULL, " +
	                " nac_x DOUBLE, " +
	                " nac_y DOUBLE, " +
		            " center_x_latitude DOUBLE," +
		            " center_y_longitude DOUBLE," +
		            " major_axis DOUBLE," +
		            " minor_axis DOUBLE," +
		            " confidence DOUBLE," +
		            " incidence DOUBLE," +
		            " subsolar_azimuth DOUBLE," +
		            " orientation DOUBLE," +
		            " diameter DOUBLE," +
		            " depth DOUBLE,"+
		            " PRIMARY KEY(id)"+ ")";


		    stmt.executeUpdate(sql);
		    for(int i = 0; i < cratersList.size(); i++){
		    	Crater c = cratersList.get(i);
		    	c.imd = new ImageMetadata();
		    	c.imd.product_id = "Test";
		    	c.imd.incidence_angle = 76.53;
		    	c.imd.sub_solar_azimuth = 173.45;
		    	stmt.executeUpdate("insert into results(id, nac_x, nac_y, center_x_latitude, center_y_longitude, "
	        			+ "major_axis, minor_axis, confidence, incidence, subsolar_azimuth, orientation, diameter, "
	        			+ "depth)"+
	        	" values("+
	        			// Product ID-x-y-width-height-Crater ID
	        			("\"" + c.imd.product_id + "\\-" + c.enclosingRect[0] + "\\-" + c.enclosingRect[1] + "\\-" +
	        					(c.enclosingRect[2] - c.enclosingRect[0]) + "\\-" +
	        					(c.enclosingRect[3] - c.enclosingRect[1]) + "\\-" + c.id + "\"") +","+
	        			c.centerX+","+
	        	        c.centerY+","+
	        	        c.centerXLongLat+","+
	        			c.centerYLongLat+","+
	        	        c.majorAxis+","+
	        			c.minorAxis+","+
	        	        c.conf+","+
	        			c.imd.incidence_angle+","+
	        	        c.imd.sub_solar_azimuth+","+
	        			c.orientationAngle+","+
	        			c.diameter+","+
	        	        c.depth+
	        	")");
		    }

		    connection.close();
		}
		catch (Exception e){
			e.printStackTrace();
		}
	}
}
