package lipfd.commons;

import java.util.*;
import java.lang.Math;

import lipfd.commons.model.*;

import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Size;


public class Crater{

	public int[] enclosingRect = new int[4]; //minx miny maxx maxy
	public double[] enclosingRectLongLat = new double[4]; //top left lon, top left lat, bottom right lon, bottom right lat
	public ImageMetadata imd;
	public double area;
	public double centerX;
	public double centerY;
	public double centerXLongLat;
	public double centerYLongLat;
	public double shadowCenterX = -1;
	public double shadowCenterY = -1;
	public int[] shadowBoundingBox = new int[4];
	public int shadowGrayLevel = -1;
	public double highlightCenterX = -1;
	public double highlightCenterY = -1;
	public double radius;
	public double minorAxis;
	public double majorAxis;
	public double orientationAngle;
	public double conf = 1.0;
	public int id;
	

	//variables needed for diameter, depth
	public double diameter;
	public double depth;
	public List<List<Point>> shadowEndPoints = new ArrayList<List<Point>>();
	//need to store depths for each image in case user updates one.
	public List<Double> craterDepths = new ArrayList<Double>();

	public Crater(){}
	public Crater(int minx, int miny, int maxx, int maxy){
		enclosingRect[0] = minx;
		enclosingRect[1] = miny;
		enclosingRect[2] = maxx;
		enclosingRect[3] = maxy;
		this.centerX = (double)(maxx + minx)/2.0;
		this.centerY = (double)(maxy + miny)/2.0;
		this.radius = ((double)(maxx-minx+maxy-miny))/4.0;

	}

	public Crater(int minx, int miny, int maxx, int maxy, double centerX, double centerY){
		enclosingRect[0] = minx;
		enclosingRect[1] = miny;
		enclosingRect[2] = maxx;
		enclosingRect[3] = maxy;
		this.centerX = centerX;
		this.centerY = centerY;
		this.radius = ((double)(maxx-minx+maxy-miny))/4.0;
	}

	// Constructor for Long., Lat. coords.
	public Crater(double minx, double miny, double maxx, double maxy, double centerX, double centerY){
		enclosingRectLongLat[0] = minx;
		enclosingRectLongLat[1] = miny;
		enclosingRectLongLat[2] = maxx;
		enclosingRectLongLat[3] = maxy;
		centerXLongLat = centerX;
		centerYLongLat = centerY;
		this.radius = ((double)(maxx-minx+maxy-miny))/4.0;
	}

	public Crater(double x, double y, int minx, int miny, int maxx, int maxy, double shadowx, double shadowy){
		enclosingRect[0] = minx;
		enclosingRect[1] = miny;
		enclosingRect[2] = maxx;
		enclosingRect[3] = maxy;
		centerX = x;
		centerY = y;
		shadowCenterX = shadowx;
		shadowCenterY = shadowy;
		this.radius = ((double)(maxx-minx+maxy-miny))/4.0;
	}



	public String serialize(){
		String craterString = "";
		craterString += String.valueOf(id) + ",";
		craterString += String.valueOf(enclosingRect[0]) + ",";
		craterString += String.valueOf(enclosingRect[1]) + ",";
		craterString += String.valueOf(enclosingRect[2]) + ",";
		craterString += String.valueOf(enclosingRect[3]) + ",";
		craterString += String.valueOf(highlightCenterX) + ",";
		craterString += String.valueOf(highlightCenterY) + ",";
		craterString += String.valueOf(shadowCenterX) + ",";
		craterString += String.valueOf(shadowCenterY);
		return craterString;
	}
	public void addMargin(int width, int height, double ratio){
		int proposedradius = (int)((double) Math.max(enclosingRect[2] - enclosingRect[0],
			enclosingRect[3] - enclosingRect[1])/2 * ratio);

		// proposedradius = Math.min((int)centerX, proposedradius);
		// proposedradius = Math.min((int)centerY, proposedradius);
		// proposedradius = Math.min(width - (int)centerX, proposedradius);
		// proposedradius = Math.min(height - (int)centerY, proposedradius);

		enclosingRect[0] = ((int)centerX) - proposedradius;
		enclosingRect[1] = ((int)centerY) - proposedradius;
		enclosingRect[2] = ((int)centerX) + proposedradius;
		enclosingRect[3] = ((int)centerY) + proposedradius;
		radius = proposedradius;
	}
	public static String serialize(List<Crater> craters){
		String metadata = ""; //String.valueOf(craters.size());
		for(int i = 0; i < craters.size(); i++){
			craters.get(i).id = i+1;
			metadata += craters.get(i).serialize();
			metadata += ";";
		}
		return metadata;
	}
	// given the upper left and lower right lat and longs of an image calculate the enclosing rectangle in geographic coordinates
	public void calculateLatLong(Point uLeft, Point lRight, Size imageSize){
		Point ul = Util.lonLatPixConverter(uLeft, lRight, imageSize, new Point(enclosingRect[0], enclosingRect[1]));
		Point lr = Util.lonLatPixConverter(uLeft, lRight, imageSize, new Point(enclosingRect[2], enclosingRect[3]));
		enclosingRectLongLat[0] = ul.x;
		enclosingRectLongLat[1] = ul.y;
		enclosingRectLongLat[2] = lr.x;
		enclosingRectLongLat[3] = lr.y;
	}
}
