function layerSizes = computeLayerSizes(imageDim,filterDim1,...
                                 numFilters1,filterDim2,numFilters2,poolDim1,...
                                 poolDim2,numClasses)

convDim1 = imageDim - filterDim1 + 1;
inputDim1 = convDim1/poolDim1;
inputSize1 = inputDim1 ^ 2 * numFilters1;
convDim2 = inputDim1 - filterDim2 + 1;
inputDim2 = convDim2/poolDim2;
inputSize2 = inputDim2 ^ 2 * numFilters2 * numFilters1;
hiddenSize1 = inputSize2;
hiddenSize2 = inputSize2;

layerSizes = zeros(5, 1);

layerSizes(1, 1) = filterDim1 ^ 2 * numFilters1 + numFilters1;
layerSizes(2, 1) = filterDim2 ^ 2 * numFilters2 + numFilters2;
layerSizes(3, 1) = hiddenSize1*inputSize2 + hiddenSize1;
layerSizes(4, 1) = hiddenSize2*hiddenSize1 + hiddenSize2;
layerSizes(5, 1) = numClasses*hiddenSize2 + numClasses;


end