package lipfd.ringtoss;
import lipfd.commons.*;
import lipfd.commons.model.*;
import lipfd.commons.model.dao.*;
import lipfd.commons.model.dao.jdbc.*;
import lipfd.circleHough.CircleHoughDetector;
import lipfd.templateMatching.TemplateMatching;
import lipfd.ellipse.EnclosingRect;
import lipfd.pca.PCA;
import lipfd.dataExtract.*;
import lipfd.performanceCalculator.PerformanceCalculator;
import java.util.*;
import java.lang.*;
import java.io.*;
import org.opencv.core.Point;
import org.opencv.core.Size;
import org.opencv.core.Core;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.RotatedRect;
import org.opencv.core.Rect;

import java.awt.Color;
import java.awt.image.*;
import javax.imageio.*;


public class Ringtoss {

	static String IMG_DIRECTORY = "downloadedImages/";
	static String RESULTS_DIRECTORY = "results/";

	public static void main(String[] args) throws IOException{
		System.loadLibrary(Core.NATIVE_LIBRARY_NAME);

		Boolean useMultipleImages = (args[0].equalsIgnoreCase("yes")?true:false);
		Boolean chooseImageAutomatically = (args[1].equalsIgnoreCase("yes")?true:false);
		String inputImageName = args[2];

		Double ulLon = Double.parseDouble(args[3]);
		Double ulLat = Double.parseDouble(args[4]);
		Double lrLon = Double.parseDouble(args[5]);
		Double lrLat = Double.parseDouble(args[6]);

		double ulx = Double.parseDouble(args[7]);
		double uly = Double.parseDouble(args[8]);
		double lrx = Double.parseDouble(args[9]);
		double lry = Double.parseDouble(args[10]);

		Boolean usePCA = (args[11].equalsIgnoreCase("yes")?true:false);
		Boolean useCNN = (args[12].equalsIgnoreCase("yes")?true:false);
		Double confThreshold = Double.parseDouble(args[13]);

		// circle hough
		double upperHist = Double.parseDouble(args[14]);

		// template matching parameters
		double addMarginRatio = Double.parseDouble(args[15]);
		Integer medianKernelSize = Integer.parseInt(args[16]);
		double areaFilterSize = Double.parseDouble(args[17]);
		double powerFilterThreshold = Double.parseDouble(args[18]);
		double shapeFilterMaxDistance = Double.parseDouble(args[19]);
		Integer shapeFilterMinMatches = Integer.parseInt(args[20]);
		double areaRatio = Double.parseDouble(args[21]);
		double distanceCoef = Double.parseDouble(args[22]);
		double maxCombinedElongation = Double.parseDouble(args[23]);
		double individualElonCoef = Double.parseDouble(args[24]);
		double sunAzimuthToleranceCoef = Double.parseDouble(args[25]);
		double roiEccentricity = Double.parseDouble(args[26]);
		String highlightTemplatesFolder = args[27];
		String shadowTemplatesFolder = args[28];
		boolean generateCroppedCandidates = (args[29].equalsIgnoreCase("yes")?true:false);
		boolean generateCroppedShadowImages = (args[30].equalsIgnoreCase("yes")?true:false);
		boolean useWeightedEuclideanDistance = (args[31].equalsIgnoreCase("yes")?true:false);
		boolean useHuMoments = (args[32].equalsIgnoreCase("yes")?true:false);

		// pca
		String cratersFolder = args[33];
		String nonCratersFolder = args[34];
		Integer m = Integer.parseInt(args[35]);
		Integer mPrime = Integer.parseInt(args[36]);
		Boolean useConvolution = (args[37].equalsIgnoreCase("yes")?true:false);
		Integer numClusters = Integer.parseInt(args[38]);
		Integer numNeighbors = Integer.parseInt(args[39]);
		Boolean useNearestMean = (args[40].equalsIgnoreCase("yes")?true:false);

		String groundTruthFileName = args[41];
		double mlAddMargin = Double.parseDouble(args[42]);
		boolean twoPhase = (args[45].equalsIgnoreCase("yes")?true:false);


		//Hazard Map
		double redThreshold = Double.parseDouble(args[43]);
		double yellowThreshold = Double.parseDouble(args[44]);


		if(useMultipleImages){
			System.out.println("reading image metadata from the database");
			ImageMetadataDao imageDao = new ImageMetadataDaoImpl("lipfd", "lipfd");
			List<ImageMetadata> imagesMD = imageDao.getMetadata(ulLon, lrLat, lrLon, ulLat);
			System.out.println("found these images in the database:");
			for(Iterator<ImageMetadata> iterator = imagesMD.iterator(); iterator.hasNext();){
				ImageMetadata im = iterator.next();
				if(im.isCloseToMeridian())
					iterator.remove();
				else System.out.println(im.product_id);
			}

			System.out.println("\nchecking the downloaded files");
			File file = new File("downloadedImages/");
			List<File> imageFiles = new ArrayList<File>(Arrays.asList(file.listFiles(new FilenameFilter() {
				    public boolean accept(File dir, String name) {
				        return name.toLowerCase().endsWith(".img");
				    }
				})));

			List<ImageMetadata> downloadList = new ArrayList<ImageMetadata>();
			for(ImageMetadata im : imagesMD){
				Boolean found = false;
				for(File f : imageFiles){
					if(f.getName().equals(im.product_id + ".IMG")){
						found = true;
						break;
					}
				}
				if(!found){
					downloadList.add(im);
				}
			}
			System.out.println("downloading these images:");
			for(ImageMetadata im : downloadList)
				System.out.println(im.product_id);

			for(ImageMetadata im : downloadList){
				Util.download("http://hirise-pds.lpl.arizona.edu/PDS/" + im.file_specification_name,
					"downloadedImages/" + im.product_id + ".IMG");
			}

			List<Crater> redundantOutput = new ArrayList<Crater>();
			for(ImageMetadata im : imagesMD){
				List<Crater> temporaryList = new ArrayList<Crater>();
				String originalInputImagePath = "downloadedImages/" + im.product_id + ".IMG";
				String newInputImagePath = "";
				String commandString = "";
				if(System.getProperty("os.name").equalsIgnoreCase("linux")){
					newInputImagePath = "downloadedImages/" + im.product_id;
					commandString = "gdal_translate -srcwin 0 0 " + String.valueOf(im.line_samples) + " " +
						String.valueOf(im.image_lines) +
						" -ot Byte -of PNM -scale " +
						originalInputImagePath + " " + newInputImagePath;
					commandString = "hi2isis from=" + originalInputImagePath + " to=" + newInputImagePath + ".cub";
					Util.runProgram(commandString);

				}
				else {
					newInputImagePath = "downloadedImages/" + im.product_id + ".tiff";
					commandString = "gdal_translate -srcwin 0 0 " + String.valueOf(im.line_samples) + " " +
						String.valueOf(im.image_lines) + " " + originalInputImagePath +
						" " + newInputImagePath +
						" -ot Byte -scale 0 4095 0 255";
				}
				System.out.println("running gdal:");
				System.out.println(commandString);
				if(!Util.fileExists(newInputImagePath+".tiff")) {
					//Util.runProgram(commandString);
					commandString="hical from="+newInputImagePath+".cub to="+newInputImagePath+".cal.tiff";
					Util.runProgram(commandString);
					commandString="cubenorm from="+newInputImagePath+".cal.cub to="+newInputImagePath+".cal.norm.tiff";
					Util.runProgram(commandString);
					commandString="isis2std from="+newInputImagePath+".cal.norm.cub to="+newInputImagePath+".tiff"
						+"format=tiff";
					Util.runProgram(commandString);
				}
				ImageMetadata correctedIM = null;
				System.out.println(String.format("is flipped around horizontal axes: %b\nis flipped around vertical axes: %b",
					im.isFlippedAroundHorizontalAxis(), im.isFlippedAroundVerticalAxis()));
				if(im.isFlippedAroundVerticalAxis() || im.isFlippedAroundHorizontalAxis()){
					System.out.println("flipping the image back . . . ");
					correctedIM = im.makeRightSideUp();
				}

				// calculate rotation angle
				double rotationAngle = Util.getRotationAngle(new Point(correctedIM.minimum_longitude, correctedIM.minimum_latitude),
					new Point(correctedIM.maximum_longitude, correctedIM.maximum_latitude));
				System.out.println(String.format("rotation angle (-180,180): %f degrees", rotationAngle * 180 / Math.PI));
				// in radians between 0 and 2PI
				 double sunAzimuthAngle = correctedIM.sub_solar_azimuth;
				 System.out.println("Sub_solar_azimuth: "+im.sub_solar_azimuth);
				
				double sunAzimuthAngleFromSun = 0;
				if(sunAzimuthAngle < Math.PI)
					sunAzimuthAngleFromSun = sunAzimuthAngle + Math.PI;
				else sunAzimuthAngleFromSun = sunAzimuthAngle - Math.PI;
				System.out.println(String.format("sun azimuth angle (0, 360): %f", sunAzimuthAngle * 180/ Math.PI));
				System.out.println(String.format("ROI center lon lat: %f, %f", (ulLon+lrLon)/2, (ulLat+lrLat)/2));
				Point roiCenter = Util.getCenterofROI(correctedIM, new Point(ulLon, ulLat), new Point(lrLon, lrLat));
				Size rrectSize = Util.getNewImageDims(correctedIM, new Point(ulLon, ulLat), new Point(lrLon, lrLat));
				System.out.println(String.format("ROI center in pixels: (%f, %f)", roiCenter.x, roiCenter.y));
				System.out.println(String.format("cropped image size: %f x %f", rrectSize.width, rrectSize.height));
				Image inputImage = new Image(newInputImagePath).flip(im.isFlippedAroundHorizontalAxis(), im.isFlippedAroundVerticalAxis()).cropRotated(roiCenter, rrectSize, -rotationAngle, false, false);
				System.gc();

				inputImage.saveImage("results/" + im.product_id + ".pgm");
				System.out.println("running the circle hough detector:");
				temporaryList.addAll(CircleHoughDetector.run(inputImage.getMat().clone(), upperHist));
				System.gc();
				System.out.println("running the ellipse fitting detector:");
				temporaryList.addAll(EnclosingRect.getBoundRect(inputImage.getMat().clone(), (sunAzimuthAngle<Math.PI?sunAzimuthAngle:(sunAzimuthAngle-2*Math.PI)) * 180 / Math.PI));
				System.gc();
				System.out.println("running the template matching algorithm:");
				temporaryList.addAll(TemplateMatching.run(inputImage, (sunAzimuthAngleFromSun<Math.PI?sunAzimuthAngleFromSun:(sunAzimuthAngleFromSun-2*Math.PI)),
					medianKernelSize, areaFilterSize,
					powerFilterThreshold, shapeFilterMaxDistance,
					shapeFilterMinMatches, areaRatio, distanceCoef,
					maxCombinedElongation, individualElonCoef,
					sunAzimuthToleranceCoef, roiEccentricity,
					highlightTemplatesFolder, shadowTemplatesFolder,
					generateCroppedCandidates, generateCroppedShadowImages,
					useWeightedEuclideanDistance, useHuMoments, false, true));
				System.gc();

				System.out.println(String.format("detected craters: %d", temporaryList.size()));
				for(Crater c : temporaryList){
					c.imd = im;
					c.calculateLatLong(new Point(ulLon, ulLat), new Point(lrLon, lrLat), rrectSize);
				}
				redundantOutput.addAll(temporaryList);
			}
			System.out.println(String.format("removing duplicates: %d total craters", redundantOutput.size()));
			//get a quadtree of unique craters.
			QuadTree<Double, Crater> uniqueCratersQT = Util.getQuadTreeWithNoDuplicatesLongLat(redundantOutput, ulLon, ulLat, lrLon, lrLat);
			ArrayList<Crater> mergedCratersList = Util.mergeCraters(uniqueCratersQT, redundantOutput);

			System.out.println(String.format("finished removing duplicates: %d craters", mergedCratersList.size()));

			// Forwards! To machine learning!

		}
		else {
			ImageMetadata bestInputImageMetadata = null;

			if(chooseImageAutomatically){
				System.out.println("reading image metadata from the database");
				ImageMetadataDao imageDao = new ImageMetadataDaoImpl("root", "");
				List<ImageMetadata> imagesMD = imageDao.getMetadata(ulLon, lrLat, lrLon, ulLat);
				System.out.println("found these images in the database:");

				double closestMatchDistance = 10000;
				for(Iterator<ImageMetadata> iterator = imagesMD.iterator(); iterator.hasNext();){
					ImageMetadata im = iterator.next();
					if(im.isCloseToMeridian())
						iterator.remove();
					else {
						if(closestMatchDistance > Math.abs(67.5 - im.incidence_angle)){
							bestInputImageMetadata = im;
							closestMatchDistance = Math.abs(67.5 - im.incidence_angle);
						}
						System.out.println(String.format("product id: %s, incidence angle: %f",
							im.product_id, im.incidence_angle));
					}
				}

				System.out.println(String.format("best sun angle: %s", bestInputImageMetadata.product_id));

			}
			else {
				System.out.println("reading image metadata from the database");
				ImageMetadataDao imageDao = new ImageMetadataDaoImpl("lipfd", "lipfd");
				System.out.println(inputImageName);
				bestInputImageMetadata = imageDao.getMetadata(inputImageName);

			}

			System.out.println("\nchecking the downloaded files.");
			System.out.println(bestInputImageMetadata.file_specification_name);
		        String imagePath = IMG_DIRECTORY + bestInputImageMetadata.product_id + ".IMG";

			if(!Util.fileExists(IMG_DIRECTORY+bestInputImageMetadata.product_id+".IMG")){

				System.out.println(String.format("downloading the image: %s", bestInputImageMetadata.product_id + ".IMG"));
				//System.out.println()
				Util.download("http://hirise-pds.lpl.arizona.edu/PDS/" + bestInputImageMetadata.file_specification_name,	imagePath);
			}

			//String imagePath = IMG_DIRECTORY + bestInputImageMetadata.product_id + ".IMG";
			String newInputImagePath = "";
			String commandString = "";
			if(System.getProperty("os.name").equalsIgnoreCase("linux")){
				newInputImagePath = "downloadedImages/" + bestInputImageMetadata.product_id;
				commandString = "gdal_translate -srcwin 0 0 " + String.valueOf(bestInputImageMetadata.line_samples) + " " +
					String.valueOf(bestInputImageMetadata.image_lines) +
					" -ot Byte -of PNM -scale " +
					imagePath + " " + newInputImagePath;
				commandString = "hi2isis from=" + imagePath + " to=" + newInputImagePath + ".cub";
				Util.runProgram(commandString);

			}
			else {

					newInputImagePath = "downloadedImages/" + bestInputImageMetadata.product_id;
				commandString = "gdal_translate -srcwin 0 0 " + String.valueOf(bestInputImageMetadata.line_samples) + " " +
					String.valueOf(bestInputImageMetadata.image_lines) + " " + imagePath +
					" " + newInputImagePath +
					" -ot Byte -scale 0 4095 0 255";
					commandString = "hi2isis from=" + imagePath + " to=" + newInputImagePath + ".cub";
					System.out.println(commandString);
					Util.runProgram(commandString);
			}
			if(!Util.fileExists(newInputImagePath+".tiff")){
				//Util.runProgram(commandString);
				//commandString="isis2std from="+newInputImagePath+".cub to="+newInputImagePath+".tiff"
					//+" format=tiff";
				commandString="hical from="+newInputImagePath+".cub to="+newInputImagePath+".cal.cub";
				//Util.runProgram(commandString);
				commandString="cubenorm from="+newInputImagePath+".cub to="+newInputImagePath+".norm.cub";
				Util.runProgram(commandString);
				commandString="isis2std from="+newInputImagePath+".norm.cub to="+newInputImagePath+".tiff"
					+" format=tiff";
				Util.runProgram(commandString);
			}
			newInputImagePath = newInputImagePath + ".tiff";
			Image inputImage = null;
			ImageMetadata correctedIM = null;
			double sunAzimuthAngle = 0;
			if(chooseImageAutomatically){
				correctedIM = bestInputImageMetadata.makeRightSideUp();
				double rotationAngle = Util.getRotationAngle(new Point(correctedIM.minimum_longitude, correctedIM.minimum_latitude),
				new Point(correctedIM.maximum_longitude, correctedIM.maximum_latitude));
				System.out.println(String.format("rotation angle (-180,180): %f degrees", rotationAngle * 180 / Math.PI));
				System.out.println(String.format("ROI center (lon, lat): %f, %f", (ulLon+lrLon)/2, (ulLat+lrLat)/2));
				Point roiCenter = Util.getCenterofROI(correctedIM, new Point(ulLon, ulLat), new Point(lrLon, lrLat));
				Size rrectSize = Util.getNewImageDims(correctedIM, new Point(ulLon, ulLat), new Point(lrLon, lrLat));
				System.out.println(String.format("ROI center in pixels (x, y): (%f, %f)", roiCenter.x, roiCenter.y));
				System.out.println(String.format("cropped image size: %f x %f", rrectSize.width, rrectSize.height));
				inputImage = new Image(newInputImagePath).flip(bestInputImageMetadata.isFlippedAroundHorizontalAxis(), bestInputImageMetadata.isFlippedAroundVerticalAxis()).cropRotated(roiCenter, rrectSize, -rotationAngle, false, false);
				// sunAzimuthAngle =
				// (correctedIM.usage_note.equals("F")?(bestInputImageMetadata.sub_solar_azimuth):(360 - bestInputImageMetadata.sub_solar_azimuth))/
				// //taken out for mars
				//(bestInputImageMetadata.lro_flight_direction.equalsIgnoreCase("-X")?(bestInputImageMetadata.sub_solar_azimuth):(360 - bestInputImageMetadata.sub_solar_azimuth))/
				//	180 * (Math.PI);
			} else {
				correctedIM = bestInputImageMetadata;
				sunAzimuthAngle = bestInputImageMetadata.sub_solar_azimuth;
				System.out.println("SunAzimuth:"+sunAzimuthAngle);
				//correctedIM.usage_note.equals("F")?(bestInputImageMetadata.sub_solar_azimuth):(360 - bestInputImageMetadata.sub_solar_azimuth)/180 * (Math.PI);
				//taken out for mars
				//(bestInputImageMetadata.lro_flight_direction.equalsIgnoreCase("-X")?(bestInputImageMetadata.sub_solar_azimuth):(360 - bestInputImageMetadata.sub_solar_azimuth))/

					//System.out.println(newInputImagePath);
				inputImage = new Image(newInputImagePath);
				System.out.println(newInputImagePath);
				System.out.println(inputImage.getWidth());
				System.out.println(inputImage.getHeight());
				System.out.println(inputImage.getChannels());
				inputImage = inputImage.crop(ulx, uly, lrx, lry);
			}
			System.gc();

			//Set up for running detection algorithm
			String imageResultDir= RESULTS_DIRECTORY+bestInputImageMetadata.product_id+"/";
			//create directory if it doesn't exsist
			(new File((new File(imageResultDir+"test")).getParent())).mkdirs();
			//inputImage.saveImage(RESULTS_DIRECTORY+bestInputImageMetadata.product_id+".tiff");
			//inputImage.saveImage(imageResultDir+bestInputImageMetadata.product_id+".png");
			sunAzimuthAngle = sunAzimuthAngle * Math.PI / 180;
			System.out.println(String.format("sun azimuth angle (0, 360): %f degrees", sunAzimuthAngle* 180 / (Math.PI)));
			System.out.println("Scaled Pixel width:" + correctedIM.scaled_pixel_width);
			double sunAzimuthAngleFromSun = 0;
			if(sunAzimuthAngle < Math.PI)
				sunAzimuthAngleFromSun = sunAzimuthAngle + Math.PI;
			else sunAzimuthAngleFromSun = sunAzimuthAngle - Math.PI;

			List<Crater> groundTruth = Util.parseMetaData(Util.readFile(groundTruthFileName),
					(int)ulx, (int)uly, (int)lrx, (int)lry);
			List<Crater> cratersList = new ArrayList<Crater>();
			Mat inputImageMat = inputImage.getMat();
			List<Crater> algList = null;

			//Run Circle Hough
			System.out.println("running the circle hough detector:");
			algList = CircleHoughDetector.run(inputImageMat.clone(), upperHist);
			PerformanceCalculator.run(groundTruth, algList, inputImage.getWidth(), inputImage.getHeight(), confThreshold);
			//saveCratersToImage(inputImageMat,algList, imageResultDir+"resultCH"+bestInputImageMetadata.product_id+".png");
			System.out.println(String.format("detected: %d craters", algList.size()));
			cratersList.addAll(algList);
			System.gc();

			//run ellipse fitting
			System.out.println("running the highlight and shadow detector:");
			algList = EnclosingRect.getBoundRect(inputImageMat.clone(), (sunAzimuthAngle<Math.PI?sunAzimuthAngle:(sunAzimuthAngle-2*Math.PI)) * 180 / Math.PI);
			PerformanceCalculator.run(groundTruth, algList, inputImage.getWidth(), inputImage.getHeight(), confThreshold);
			//saveCratersToImage(inputImageMat,algList, imageResultDir+"resultEllipse"+bestInputImageMetadata.product_id+".png");
			cratersList.addAll(algList);
			System.out.println(String.format("detected: %d craters", algList.size()));
			System.gc();

			//Run Template matching
			System.out.println("running the template matching algorithm:");
			algList = TemplateMatching.run(inputImage, (sunAzimuthAngleFromSun<Math.PI?sunAzimuthAngleFromSun:(sunAzimuthAngleFromSun-2*Math.PI)),
				medianKernelSize, areaFilterSize,
				powerFilterThreshold, shapeFilterMaxDistance,
				shapeFilterMinMatches, areaRatio, distanceCoef,
				maxCombinedElongation, individualElonCoef,
				sunAzimuthToleranceCoef, roiEccentricity,
				highlightTemplatesFolder, shadowTemplatesFolder,
				generateCroppedCandidates, generateCroppedShadowImages,
				useWeightedEuclideanDistance, useHuMoments, false, true);
			PerformanceCalculator.run(groundTruth, algList, inputImage.getWidth(), inputImage.getHeight(), confThreshold);
			cratersList.addAll(algList);
			//saveCratersToImage(inputImageMat,algList, imageResultDir+"resultTM"+bestInputImageMetadata.product_id+".png");
			System.out.println(String.format("detected: %d craters", algList.size()));
			System.gc();

			//Start duplicate removal
			System.out.println(String.format("removing duplicates: %d total craters", cratersList.size()));
			List<Crater> polishedCraterList = removeDuplicatesDetections(cratersList, inputImage.getWidth(), inputImage.getHeight());
			System.out.println(String.format("finished removing duplicates: %d craters", polishedCraterList.size()));
			PerformanceCalculator.run(groundTruth, polishedCraterList, inputImage.getWidth(), inputImage.getHeight(), confThreshold);
			saveCratersToImage(inputImageMat,polishedCraterList, imageResultDir+"resultDetectors"+bestInputImageMetadata.product_id+".png");


			//
			// Forwards! To machine learning!
			//

			if(usePCA){
				System.out.println("using PCA:");
				PCA.run(polishedCraterList, inputImage, cratersFolder, nonCratersFolder, m, mPrime,
					useConvolution, numClusters, numNeighbors, useNearestMean);
				PerformanceCalculator.run(groundTruth, polishedCraterList, inputImage.getWidth(), inputImage.getHeight(), confThreshold);
			}
			if(useCNN){
				for(int i = 0; i < polishedCraterList.size(); i++){
					Crater c = polishedCraterList.get(i);
					c.id = i+1;
					c.addMargin(inputImage.getWidth(), inputImage.getHeight(), mlAddMargin);
					inputImage
						.crop(c.enclosingRect[0], c.enclosingRect[1], c.enclosingRect[2], c.enclosingRect[3])
						.resize(28, 28)
						.saveImage(String.format(RESULTS_DIRECTORY+"craterCandidates/%d.pgm", i+1));
				}
				try{
					Util.writeFile(RESULTS_DIRECTORY+"result-metadata.txt", Crater.serialize(polishedCraterList));
				} catch(IOException e){e.printStackTrace();}
				if (!twoPhase){
				commandString = "matlab -nodisplay -nosplash -nodesktop -r run('cnn/detect.m');";
				commandString = "octave cnn/detect.m data-files/craterDetectorCE.mat";
				System.out.println(commandString);
				Util.runProgram(commandString);
				String metadataString = "";
				try{metadataString = Util.readFile(RESULTS_DIRECTORY+"result-ml-metadata.txt");}
				catch(IOException e){e.printStackTrace();}
				polishedCraterList = Util.parseMetaData(metadataString, (int)ulx, (int)uly, (int)lrx, (int)lry);
				for(Crater c : polishedCraterList)
					c.addMargin(inputImage.getWidth(), inputImage.getHeight(), 1.0 / mlAddMargin);
				PerformanceCalculator.run(groundTruth, polishedCraterList, inputImage.getWidth(), inputImage.getHeight(), confThreshold);
				}else{
					commandString = "matlab -nodisplay -nosplash -nodesktop -r run('cnn/detect.m');";
					commandString = "octave cnn/detect.m data-files/craterDetectorCE.mat";
					System.out.println(commandString);
					Util.runProgram(commandString);
					String metadataString = "";
					try{metadataString = Util.readFile(RESULTS_DIRECTORY+"result-ml-metadata.txt");}
					catch(IOException e){e.printStackTrace();}
					polishedCraterList = Util.parseMetaData(metadataString, (int)ulx, (int)uly, (int)lrx, (int)lry);
					for(Crater c : polishedCraterList)
						c.addMargin(inputImage.getWidth(), inputImage.getHeight(), 1.0 / mlAddMargin);
					PerformanceCalculator.run(groundTruth, polishedCraterList, inputImage.getWidth(), inputImage.getHeight(), confThreshold);
				List<Crater> secondlist = new ArrayList<Crater>();
				secondlist=secondPassCraters(polishedCraterList,.5,.25);
				System.out.println("Secondlist:"+secondlist.size());
				runCNN(secondlist,inputImage,mlAddMargin, "craterDetectorCEMars.mat");
				try{metadataString = Util.readFile(RESULTS_DIRECTORY+"result-ml2-metadata.txt");}
				catch(IOException e){e.printStackTrace();}
			 secondlist = Util.parseMetaData(metadataString, (int)ulx, (int)uly, (int)lrx, (int)lry);
				//items needed for crater depth and diameter extraction.
	      polishedCraterList.addAll(secondlist);
			}
			}

			ArrayList<Image> images = new ArrayList<Image>();
			images.add(inputImage);
			ArrayList<ImageMetadata> mds = new ArrayList<ImageMetadata>();
			mds.add(correctedIM);
			double correctedAzimDeg = Math.toDegrees(sunAzimuthAngle);
			DataExtract.computeDDs(polishedCraterList, images, mds, correctedAzimDeg, confThreshold, true);
			//get final list of craters based on confidence value
			List<Crater> finalCraterList = new ArrayList<Crater>();
			for(Crater crater : polishedCraterList){
				if(crater.conf > confThreshold){
					finalCraterList.add(crater);
				}

			}
			saveCratersToImage(inputImageMat,finalCraterList, imageResultDir+"result"+inputImageName+".png");

			//Generate hazard map
			generateHazardMap(inputImage, correctedIM, inputImageName, polishedCraterList, confThreshold,redThreshold,yellowThreshold, imageResultDir);

			try{
				Util.writeFile(RESULTS_DIRECTORY+"result-final-metadata.txt", Crater.serialize(finalCraterList));
			} catch(IOException e){e.printStackTrace();}

			//Create image for ground truth
			System.out.println("Generating Ground Truth Image..");
			//now create a seperate image printing out the ground truth
			saveCratersToImage(inputImageMat,groundTruth, imageResultDir+"groundTruth-"+inputImageName+".png");
			System.out.println("Ground Truth Image has been created!");

		}
		System.exit(0);
	}//end main


	public static List<Crater> removeDuplicatesDetections(List<Crater> detectedCraters, double imgWidth, double imgHeight){

		UniqueCraterTree tree = new UniqueCraterTree(imgWidth, imgHeight);
		tree.insertCraterList(detectedCraters);

		return tree.toList();

	}
  public static List<Crater> secondPassCraters(List<Crater> craterList,double topThreshold, double bottomThreshold){
		List<Crater> secondPassList=new ArrayList<Crater>();
		for(Crater c:craterList){
			if(c.conf<topThreshold){
				if(c.conf>=bottomThreshold){
					secondPassList.add(c);
				}
			}
		}
		return secondPassList;
	}
	public static void saveCratersToImage(Mat src,List<Crater> craters,String imageName){

		Image image = new Image(new Mat());
		Imgproc.cvtColor(src, image.getMat(), Imgproc.COLOR_GRAY2BGR);
		Scalar color =  new Scalar(255,0,0);
		for(Crater crater:craters)
		{
			Core.rectangle(image.getMat(), new Point(crater.enclosingRect[0], crater.enclosingRect[1]),
					new Point(crater.enclosingRect[2], crater.enclosingRect[3]), getRandomScalar(), 1);
		}
		image.saveImage(imageName);
	}

	public static Scalar getRandomScalar(){
		return new Scalar((int) (Math.random()*255),(int) (Math.random()*255),(int) (Math.random()*255));
	}

	public static void generateHazardMap(Image inputImage, ImageMetadata correctedIM, String inputImageName, List<Crater> polishedCraterList, Double confThreshold, double redThreshold, double yellowThreshold, String imageResultDir)throws IOException{

			Image colorImageResult = new Image(new Mat());
			Imgproc.cvtColor(inputImage.getMat(), colorImageResult.getMat(), Imgproc.COLOR_GRAY2BGR);
			List<Crater> finalCraterList = new ArrayList<Crater>();

			//Variables for non-craters
			Image nonCraterResult = new Image(new Mat());
			Imgproc.cvtColor(inputImage.getMat(), nonCraterResult.getMat(), Imgproc.COLOR_GRAY2BGR);
			List<Crater> nonCraterList = new ArrayList<Crater>();

			Image hazardMapResultB = new Image(new Mat());
			Imgproc.cvtColor(inputImage.getMat(), hazardMapResultB.getMat(), Imgproc.COLOR_GRAY2BGR);

			//Creates an Image highlighting the craters red
			Image cratersRed = new Image(new Mat());
			Imgproc.cvtColor(inputImage.getMat(), cratersRed.getMat(), Imgproc.COLOR_GRAY2BGR);
			//Creates and image adding red squares
			Image cratersSquareRed = new Image(new Mat());
			Imgproc.cvtColor(inputImage.getMat(), cratersSquareRed.getMat(), Imgproc.COLOR_GRAY2BGR);



			for(Crater crater : polishedCraterList){

				//Bounding boxes for craters
				if(crater.conf > confThreshold){
					finalCraterList.add(crater);
					
					Core.rectangle(colorImageResult.getMat(), new Point(crater.enclosingRect[0], crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]), new Scalar(255, 0, 0), 1);
					Core.rectangle(hazardMapResultB.getMat(), new Point(crater.enclosingRect[0], crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]), new Scalar(255, 0, 0), 1);

					Core.rectangle(cratersRed.getMat(), new Point(crater.enclosingRect[0], crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]), new Scalar(0, 0, 255), 1);

					Core.rectangle(cratersSquareRed.getMat(), new Point(crater.enclosingRect[0], crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]), new Scalar(0, 0, 255), -1);

				}

				//Green bounding box for threshold to 2/3 * threshold
				if(crater.conf < confThreshold && crater.conf >= (confThreshold * 2.0/3.0)){
					nonCraterList.add(crater);

					Core.rectangle(nonCraterResult.getMat(), new Point(crater.enclosingRect[0], 						crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]),
						new Scalar(0, 255, 0), 1);

					Core.rectangle(hazardMapResultB.getMat(), new Point(crater.enclosingRect[0], 						crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]),
						new Scalar(0, 255, 0), 1);

					Core.rectangle(cratersSquareRed.getMat(), new Point(crater.enclosingRect[0], crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]), new Scalar(0, 0, 255), -1);
				}

				//Blue bounding box for 2/3 * threshold to 1/3 * threshold
				if(crater.conf < (confThreshold * 2.0/3.0) && crater.conf >= (confThreshold * 1.0/3.0)){
					nonCraterList.add(crater);

					Core.rectangle(nonCraterResult.getMat(), new Point(crater.enclosingRect[0], 						crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]),
						new Scalar(255,0, 0), 1);
					Core.rectangle(hazardMapResultB.getMat(), new Point(crater.enclosingRect[0], 						crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]),
						new Scalar(255, 0, 0), 1);

					Core.rectangle(cratersSquareRed.getMat(), new Point(crater.enclosingRect[0], crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]), new Scalar(0, 0, 255), -1);
				}

				//Red bounding box for below 1/3 * threshold
				if(crater.conf < confThreshold * 1.0/3.0){
					nonCraterList.add(crater);

					Core.rectangle(nonCraterResult.getMat(), new Point(crater.enclosingRect[0], 						crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]),
						new Scalar(0, 0, 255), 1);
					Core.rectangle(hazardMapResultB.getMat(), new Point(crater.enclosingRect[0], 						crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]),
						new Scalar(0, 0, 255), 1);

					Core.rectangle(cratersSquareRed.getMat(), new Point(crater.enclosingRect[0], crater.enclosingRect[1]),
						new Point(crater.enclosingRect[2], crater.enclosingRect[3]), new Scalar(0, 0, 255), -1);
				}
			}

		double gridInc = Math.ceil(correctedIM.scaled_pixel_width * 100.0);
		double hectareInc = gridInc;
		double imageWidth = inputImage.getWidth();
		double imageHeight = inputImage.getHeight();
		double gridWidth = Math.ceil(imageWidth/gridInc);
		double gridHeight = Math.ceil(imageHeight/gridInc);
		double gridWidthEdge = imageWidth%gridInc;
		double gridHeightEdge = imageHeight%gridInc;
		double[][] grid = new double[(int)gridHeight][(int)gridWidth];

		//Generate grid dimensions for the hazard map
		for(int i=0;i<grid.length;i++){
			gridInc = 0;
			for(int j=0;j<grid[i].length;j++){
				gridInc += hectareInc;
				grid[i][j] = gridInc;
			}
		}

		double craterTotal = finalCraterList.size() + nonCraterList.size();
		Image hazardMapResult = new Image(new Mat());
			Imgproc.cvtColor(inputImage.getMat(), hazardMapResult.getMat(), Imgproc.COLOR_GRAY2BGR);
		double[][] hazardCount = new double[(int)gridHeight][(int)gridWidth];

			colorImageResult.saveImage(imageResultDir+"result"+inputImageName+"S.png");
			nonCraterResult.saveImage(imageResultDir+"NonCraterResult"+inputImageName+"S.png");
			cratersRed.saveImage(imageResultDir+"cratersRed"+inputImageName+"S.png");
			cratersSquareRed.saveImage(imageResultDir+"cratersSquareRed"+inputImageName+"S.png");

			//Counts the amount of Red Pixels. We can add more colors based on the harzard map later on
			String path = imageResultDir+"cratersSquareRed"+inputImageName+"S.png";
			BufferedImage imageRed = ImageIO.read(new File(path));
			int redCount = 0;
			int red = Color.red.getRGB();
			for(int y = 0; y < imageRed.getHeight(); y++) {
            			for(int x = 0; x < imageRed.getWidth(); x++) {
               				int pixel = imageRed.getRGB(x, y);
                			if(pixel == red)   redCount++;
            			}
        		}
			System.out.println("\nRed Pixel Count: " + redCount);

			//Count the number of red pixels within each hectare
			int hectareRow = 0;
			for(int y = 0; y < imageRed.getHeight(); y++) {
				if(y%hectareInc == 0 && y != 0)
				hectareRow++;
            			for(int x = 0; x < imageRed.getWidth(); x++) {
               				int pixel = imageRed.getRGB(x, y);
                			if(pixel == red){
						for(int i=0; i < grid[i].length-1; i++){
						if(x<=grid[hectareRow][0] && i == 0)
							hazardCount[hectareRow][0]++;
						else if(x>grid[hectareRow][i] && x<=grid[hectareRow][i+1])
							hazardCount[hectareRow][i+1]++;
						}
					}
            			}
        		}

		Image transOverlay = new Image(new Mat());
		Imgproc.cvtColor(inputImage.getMat(), transOverlay.getMat(), Imgproc.COLOR_GRAY2BGR);
		double alpha = 0.8;
		double hectareArea = 0.0;
		double hazardPerc[][] = new double[(int)gridHeight][(int)gridWidth];

		//Create a transparent overlay and calculate the coloring for the hazard map
		for(int i=0;i<grid.length;i++){
			for(int j=0;j<grid[i].length;j++){

			Point upperLeftCorner = new Point(grid[i][j]-hectareInc, grid[j][i]-hectareInc);
			Point lowerRightCorner = new Point(grid[i][j], grid[j][i]);
			if(j == grid[i].length-1){
				hectareArea = hectareInc*gridWidthEdge;
			}

			else if(i == grid.length-1){
				hectareArea = hectareInc*gridHeightEdge;
			}
			else if(j == grid[i].length-1 && i == grid.length-1){
				hectareArea = gridWidthEdge*gridHeightEdge;
			}
			else{
				hectareArea = hectareInc*hectareInc;
			}
			hazardPerc[i][j] = hazardCount[i][j]/hectareArea;
			Core.rectangle(hazardMapResult.getMat(), upperLeftCorner, lowerRightCorner, new Scalar(0, 0, 0), 1);
			Core.rectangle(hazardMapResultB.getMat(), upperLeftCorner, lowerRightCorner, new Scalar(0, 0, 0), 1);
			if(hazardPerc[i][j] >= redThreshold)
			Core.rectangle(transOverlay.getMat(), upperLeftCorner, lowerRightCorner, new Scalar(0,0, 255.0),-1);
			else if(hazardPerc[i][j] >= yellowThreshold && hazardPerc[i][j] < redThreshold)
			Core.rectangle(transOverlay.getMat(), upperLeftCorner, lowerRightCorner, new Scalar(0,255.0,255.0),-1);
			else if(hazardPerc[i][j] < yellowThreshold)
			Core.rectangle(transOverlay.getMat(), upperLeftCorner, lowerRightCorner, new Scalar(0,255.0,0),-1);
		}}

			Core.addWeighted(hazardMapResult.getMat(), alpha, transOverlay.getMat(), 1 - alpha, 0, hazardMapResult.getMat());
			Core.addWeighted(hazardMapResultB.getMat(), alpha, transOverlay.getMat(), 1 - alpha, 1, hazardMapResultB.getMat());


		for(int i=0; i<hazardCount.length; i++){
			System.out.println();
			for(int j=0; j<hazardCount[i].length; j++){
			System.out.print(hazardCount[i][j] + " ");
}}
			System.out.println();
		for(int i=0; i<hazardPerc.length; i++){
			System.out.println();
			for(int j=0; j<hazardPerc[i].length; j++){
			System.out.print(hazardPerc[i][j] + " ");
}}

			hazardMapResult.saveImage(imageResultDir+"HazardMap"+inputImageName+"S.png");
			hazardMapResultB.saveImage(imageResultDir+"HazardMapB"+inputImageName+"S.png");

	}


  public static void runCNN(List<Crater> craterList, Image inputImage, double addMargin, String filename){
		String commandString="rm -f "+RESULTS_DIRECTORY+"craterCandidates/*.pgm;";
		System.out.println(commandString);
    Util.runProgram(commandString);
		System.out.println("crater List size: "+craterList.size());
		for(int i = 0; i < craterList.size(); i++){

			Crater c = craterList.get(i);
			c.id = i+1;
			c.addMargin(inputImage.getWidth(), inputImage.getHeight(), addMargin);
			inputImage
				.crop(c.enclosingRect[0], c.enclosingRect[1], c.enclosingRect[2], c.enclosingRect[3])
				.resize(28, 28)
				.saveImage(String.format(RESULTS_DIRECTORY+"craterCandidates/%d.pgm", i+1));
		}
		try{
			Util.writeFile(RESULTS_DIRECTORY+"result-metadata.txt", Crater.serialize(craterList));
		} catch(IOException e){e.printStackTrace();}
	  commandString="";
		commandString = "matlab -nodisplay -nosplash -nodesktop -r run('cnn/detect.m');";
		commandString = "octave cnn/detect.m "+filename;
		Util.runProgram(commandString);
	}

}
