package lipfd.metadataEditor;

import lipfd.commons.*;

import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JLabel;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

import org.opencv.core.Core;
import org.opencv.core.Mat;

import java.io.IOException;
import java.io.File;
import java.util.*;
import java.lang.Math;

public class MetadataEditor{
	public static void main(String[] args){
		System.out.println(args.length);
		System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
		if(args.length == 4){
			System.out.println("in here");
			String imageFileName = args[0];
			System.out.println(imageFileName);
			String metaDataFileName = args[1];
			int minx = Integer.parseInt(args[2]);
			int miny = Integer.parseInt(args[3]);
			Image image = new Image(imageFileName);
			try{
				String metaDataString = Util.readFile(metaDataFileName);
				List<Crater> craters = Util.parseMetaData(metaDataString, minx, miny,
					minx + image.getWidth(), miny + image.getHeight());
				JFrame frame=new JFrame();
				JScrollPane scrollpane = new JScrollPane();
				//frame.setLayout(new FlowLayout());
				frame.setSize(Math.min(image.getWidth(), 1000), Math.min(image.getHeight(), 600));
				frame.setTitle(imageFileName);
				CraterLabel lbl = new CraterLabel(image, craters);
				scrollpane.getViewport().add(lbl);
				lbl.addKeyListener(new KeyAdapter(){
					@Override
		      		public void keyReleased(KeyEvent e){
		      			if(e.getKeyCode() == KeyEvent.VK_S && e.isControlDown() && lbl.craters != null){
		      				JFileChooser chooser = new JFileChooser();
						    FileNameExtensionFilter filter = new FileNameExtensionFilter(
						        "Text", "txt");
						    chooser.setFileFilter(filter);
						    chooser.setDialogType(JFileChooser.SAVE_DIALOG);
						    chooser.setDialogTitle("Save");
						    chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
						    int returnVal = chooser.showOpenDialog(frame);
						    //CraterLabel lbl = (CraterLabel) scrollpane.getComponent(0);
						    if(returnVal == JFileChooser.APPROVE_OPTION) {
						    	String metaData = Crater.serialize(lbl.craters);
						    	try{
						    		Util.writeFile(chooser.getSelectedFile().getAbsolutePath(), metaData);
						    	} catch(IOException ex){ex.printStackTrace();}
						    }
		      			}
		      			else if(e.getKeyCode() == KeyEvent.VK_O && e.isControlDown()){
		      				JFileChooser chooser = new JFileChooser();
						    FileNameExtensionFilter filter = new FileNameExtensionFilter(
						        "Text", "txt");
						    chooser.setFileFilter(filter);
						    chooser.setDialogType(JFileChooser.OPEN_DIALOG);
						    chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
						    int returnVal = chooser.showOpenDialog(frame);
						    if(returnVal == JFileChooser.APPROVE_OPTION) {
						    	String metaDataString = null;
						    	try{
						    		metaDataString = Util.readFile(chooser.getSelectedFile().getAbsolutePath());
						    	}catch(IOException ex){ex.printStackTrace();}
						    	List<Crater> newCraters = Util.parseMetaData(metaDataString, minx, miny,
									minx + image.getWidth(), miny + image.getHeight());
						    	lbl.referenceCraters = newCraters;
						    	lbl.craters = new ArrayList<Crater>(lbl.referenceCraters);
						    	lbl.repaint();
						    	// CraterLabel lbl = new CraterLabel(new ImageIcon(Util.Mat2BufferedImage(image.getMat())), newCraters);
						    	// scrollpane.getViewport().removeAll();
						    	// scrollpane.getViewport().add(lbl);
						    }
		      			}
		      		}
				});
				frame.add(scrollpane);
				frame.setVisible(true);
				frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			}
			catch(IOException e){
				e.printStackTrace();
			}
		}
	}



}
