package lipfd.metadataEditor;

import lipfd.commons.*;

import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.BasicStroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.Line2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.Cursor;
import java.awt.AlphaComposite;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JLabel;
import javax.swing.JComponent;



import java.io.IOException;
import java.util.*;
import java.lang.Math;

public class CraterLabel extends JLabel {

	public List<Crater> craters = new ArrayList<Crater>();
	public List<Crater> referenceCraters = null;
	public Image originalImage = null;

	private Point startDrag, endDrag;
	private boolean rightClick = false;
	private boolean displayBoxes=true;
	private boolean enhanced = false;
	private double confThreshold = 0.5;

	public CraterLabel(Image image, List<Crater> crats){
		referenceCraters = crats;
		this.originalImage = image;
		this.setIcon(new ImageIcon(Util.Mat2BufferedImage(originalImage.getMat())));
		for(Crater c : crats)
			this.craters.add(c);
		setFocusable(true);
		int x = Toolkit.getDefaultToolkit().getBestCursorSize(68, 68).width;		
		BufferedImage cursorImg = new BufferedImage(x, x, BufferedImage.TYPE_INT_ARGB);		
		Graphics2D g2i = cursorImg.createGraphics();
    	g2i.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.50f));
    	g2i.setColor(Color.GREEN);
    	Shape line = new Line2D.Float(0, x/2, x, x/2);
    	g2i.draw(line);
    	line = new Line2D.Float(x/2, 0, x/2, x);
    	g2i.draw(line);
    	g2i.dispose();
    	// System.out.println(Toolkit.getDefaultToolkit().getBestCursorSize(68, 68).toString());
    	Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(
    		cursorImg, new Point(x/2, x/2), "blank cursor");
		this.setCursor(blankCursor);
		this.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e){
				if(displayBoxes){
					int x = e.getX();
					int y = e.getY();
					int width = ((ImageIcon)getIcon()).getIconWidth();
					int height = ((ImageIcon)getIcon()).getIconHeight();
					x = Math.min(Math.max(x, 0), width);
					y = Math.min(Math.max(y, 0), height);
					if(e.getButton() == MouseEvent.BUTTON1)
						rightClick = false;
					else rightClick = true;
					startDrag = new Point(x, y);				
					endDrag = startDrag;
					repaint();
				}			
			}
			public void mouseReleased(MouseEvent e){
				if(displayBoxes){
					int x = e.getX();
					int y = e.getY();
					int width = ((ImageIcon)getIcon()).getIconWidth();
					int height = ((ImageIcon)getIcon()).getIconHeight();
					x = Math.min(Math.max(x, 0), width);
					y = Math.min(Math.max(y, 0), height);

					if(startDrag != null && endDrag != null){
						if(!rightClick){			
							Crater cnew = new Crater(Math.min(startDrag.x, x), Math.min(startDrag.y, y),
								Math.max(startDrag.x, x), Math.max(startDrag.y, y));
							Util.addCrater(craters, cnew);												
							
							endDrag = null;
							repaint();
						} else {
							Crater duplicate  = new Crater(Math.min(startDrag.x, x), Math.min(startDrag.y, y),
									Math.max(startDrag.x, x), Math.max(startDrag.y, y));
							for(int i = 0; i < craters.size(); i++){
								if(Util.isSimilar(craters.get(i), duplicate)){
									craters.remove(i);
									break;
								}
							}
							endDrag = null;
							repaint();
						}
					}	
				}				
			}
		});
		this.addMouseMotionListener(new MouseMotionAdapter() {
			@Override
	        public void mouseDragged(MouseEvent e) {
	        	if(displayBoxes){
		        	int x = e.getX();
					int y = e.getY();
					int width = ((ImageIcon)getIcon()).getIconWidth();
					int height = ((ImageIcon)getIcon()).getIconHeight();
					x = Math.min(Math.max(x, 0), width);
					y = Math.min(Math.max(y, 0), height);
					endDrag = new Point(x, y);
					repaint();
				}
	        }
      	});
      	this.addKeyListener(new KeyAdapter(){  
      		@Override
      		public void keyReleased(KeyEvent e){
      			if(displayBoxes && e.getKeyCode() == KeyEvent.VK_C && e.isControlDown() && referenceCraters != null){
      				craters = new ArrayList<Crater>();
      				for(Crater c : referenceCraters)
      					craters.add(c);
      				repaint();
      			}
      			else if(displayBoxes && e.getKeyCode() == KeyEvent.VK_R && e.isControlDown()) {
      				craters.clear();
      				repaint();
      			}	
      		}    		
      		@Override
      		public void keyTyped(KeyEvent e) {
      			if(displayBoxes && e.getKeyChar() == 'r' && craters.size() > 0){
      				craters.remove(craters.size() - 1); 
      				repaint();     				
      			}
      			else if(e.getKeyChar() == 'd' && craters.size() > 0){
      				if(displayBoxes == true){
      					startDrag = endDrag = null;
      				}
      				displayBoxes = !displayBoxes;
      				repaint();
      			}
      			else if(e.getKeyChar() == 'e'){
      				if(!enhanced)
      					setIcon(new ImageIcon(Util.Mat2BufferedImage(
      						originalImage.equalizeHistogram().getMat())));
      				else
      					setIcon(new ImageIcon(Util.Mat2BufferedImage(
      						originalImage.getMat())));
      				enhanced = !enhanced;
      				repaint();
      			}
      		}
      	});
	}
	public CraterLabel(Image image){
		this(image, new ArrayList<Crater>());
	}
	@Override
  	public void paint(Graphics g){
  		Graphics2D g2 = (Graphics2D) g;
  		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
  		g2.setStroke(new BasicStroke(1));
  		ImageIcon icon = (ImageIcon)getIcon();
  		if(icon != null)
  			g.drawImage(icon.getImage(), 0, 0, null);
  		if(displayBoxes){
	  		Shape s = null;
	  		if(startDrag != null && endDrag != null && startDrag != endDrag){
	  			g2.setPaint(rightClick?Color.RED:Color.BLUE);
	  			s = new Rectangle2D.Float(Math.min(startDrag.x, endDrag.x), Math.min(startDrag.y, endDrag.y),
	  				Math.abs(startDrag.x - endDrag.x), Math.abs(startDrag.y - endDrag.y));
	  			g2.draw(s);
	  		}
	  		g2.setPaint(Color.BLUE);
	  		for(Crater c : craters){
	  			if(c.conf >= confThreshold){
	  				s = new Rectangle2D.Float(c.enclosingRect[0], c.enclosingRect[1], 
	  					c.enclosingRect[2] - c.enclosingRect[0], c.enclosingRect[3] - c.enclosingRect[1]);
	  				g2.draw(s);
	  			}
	  		}
  		}
  	}
  	@Override
  	protected void paintChildren(Graphics g) {
	  super.paintChildren(g);
	}
	public void setConfThreshold(double confT){
		confThreshold = confT;
		repaint();
	}
}