package lipfd.commons.model.dao.jdbc;

import lipfd.commons.model.dao.*;
import lipfd.commons.model.*;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.lang.IllegalAccessException;

import java.lang.reflect.Field;
import java.lang.ClassNotFoundException;
import java.util.*;

public class ImageMetadataDaoImpl implements ImageMetadataDao {
	public String myUsername;
	public String myPassword;
	public String url = "jdbc:mysql://localhost/hirise";

	public ImageMetadataDaoImpl(String user, String pass){
		try {
			Class.forName("com.mysql.jdbc.Driver");
			myUsername = user;
			myPassword = pass;
		}
		catch (ClassNotFoundException e) {e.printStackTrace();}
	}
	public ImageMetadata getMetadata(String imageName){

		String sqlStatement;
		ImageMetadata im  = null;
		Connection c = null;
		try {
			c = DriverManager.getConnection(url, myUsername, myPassword);
			sqlStatement="select * from images where product_id = ?;";
			PreparedStatement stmt= c.prepareStatement(sqlStatement);
			stmt.setString(1, imageName);
			System.out.println(stmt.toString());
			ResultSet rs= stmt.executeQuery();
			if(rs.next()){
				im = new ImageMetadata();
				for(Field f : ImageMetadata.class.getDeclaredFields()){
					f.set(im, rs.getObject(f.getName()));
				}
			}
			c.close();
		} catch(SQLException e){
			e.printStackTrace();
		} catch(IllegalAccessException e){
			e.printStackTrace();
		}
		finally {
			try{
				if(c != null)
					c.close();
			} catch(SQLException e){ e.printStackTrace(); }
		}
		return im;
	}
	public List<ImageMetadata> getMetadata(Double lower_left_longitude, Double lower_left_latitude,
		Double upper_right_longitude, Double upper_right_latitude){

		String sqlStatement;
		List<ImageMetadata> ims = new ArrayList<ImageMetadata>();
		Connection c = null;
		try {
			c = DriverManager.getConnection(url, myUsername, myPassword);
			sqlStatement="select * from images i where st_contains(i.g, geomfromtext('polygon((" +

				String.valueOf(lower_left_longitude) + " " + String.valueOf(lower_left_latitude) + "," +
				String.valueOf(lower_left_longitude) + " " + String.valueOf(upper_right_latitude) + "," +
				String.valueOf(upper_right_longitude) + " " + String.valueOf(upper_right_latitude) + "," +
				String.valueOf(upper_right_longitude) + " " + String.valueOf(lower_left_latitude) + "," +
				String.valueOf(lower_left_longitude) + " " + String.valueOf(lower_left_latitude) +

				"))')) and (i.product_id like '%LC' or i.product_id like '%RC');";

			PreparedStatement stmt= c.prepareStatement(sqlStatement);
			ResultSet rs= stmt.executeQuery();
			while(rs.next()){
				ImageMetadata im = new ImageMetadata();
				for(Field f : ImageMetadata.class.getDeclaredFields()){
					f.set(im, rs.getObject(f.getName()));
				}
				ims.add(im);
			}
			c.close();
		} catch(SQLException e){
			e.printStackTrace();
		} catch(IllegalAccessException e){
			e.printStackTrace();
		}
		finally {
			try{
				if(c != null)
					c.close();
			} catch(SQLException e){ e.printStackTrace(); }
		}
		return ims;
	}
}
