format long
more off
% warning ('off', 'Octave:broadcast');
clear all

isOctave = exist('OCTAVE_VERSION', 'builtin') ~= 0;
if ~isOctave
feature accel on
end

if isOctave
	craters_folder = './results/craterCandidates/';
	tm_metadata_file = './results/result-metadata.txt';
	final_result_file = './results/result-ml-metadata.txt';
else
	craters_folder = '../results/craterCandidates/';
	tm_metadata_file = '../results/result-metadata.txt';
	final_result_file = '../results/result-ml-metadata.txt';
end
args = argv;

imageDim = 28;
numClasses = 1;
filterDim1 = 9;
numFilters1 = 20;
filterDim2 = 5;
numFilters2 = 10;
poolDim1 = 2;
poolDim2 = 2;

if isOctave
	addpath ./commons/matlab/;
	addpath ./cnn/
else
	addpath ../commons/matlab/;
end

images = loadCraterImages(craters_folder);
images = bsxfun(@minus, images, sum(sum(images))/imageDim/imageDim);


cnnCost = @cnnCostCPU;


%load('data-files/craterDetectorCESaman.mat');
load(args{1});
preds = zeros(size(images, 3), 1);
probs = zeros(size(images, 3), 1);
stepsize = 500;
for i=1:stepsize:size(images, 3);
	if size(images,3) - i + 1 >= stepsize
		[cost,time,~,predstemp, probstemp]=cnnCost(opttheta,images(:, :, i:(i+stepsize-1)),...
								1,numClasses,...
                                filterDim1,numFilters1, filterDim2, numFilters2,...
                                poolDim1, poolDim2, true, 0, 0);
	else
		[cost,time,~,predstemp, probstemp]=cnnCost(opttheta,images(:, :, i:end),...
								1,numClasses,...
                                filterDim1,numFilters1, filterDim2, numFilters2,...
                                poolDim1, poolDim2, true, 0, 0);
	end
	preds(i:(i+size(predstemp, 1)-1), 1) = predstemp(:);
	probs(i:(i+size(predstemp, 1)-1), 1) = probstemp(:);
	fprintf('Progress: %2.2f%%\n', min(i+500, size(images, 3))/size(images, 3)*100);
end



strs = strsplit(strtrim(fileread(tm_metadata_file)), ';')';

for i=1:min(size(probs, 1), size(strs, 1))
	strs(i, 1) = strcat(strs(i, 1), sprintf(',%f' ,probs(i, 1)));
end

result = '';

for i=1:min(size(probs, 1), size(strs, 1))
	result = strcat(result, strs(i, 1));
	result = strcat(result, ';');
end


fileid = fopen(final_result_file, 'w+');
if isOctave
	fprintf(fileid, '%s', result{1});
else
	fprintf(fileid, '%s', result);
end
fclose(fileid);

quit
