package lipfd.scripts;

import lipfd.commons.*;
import lipfd.commons.model.*;
import lipfd.commons.model.dao.*;
import lipfd.commons.model.dao.jdbc.*;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.lang.IllegalAccessException;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.BufferedReader;

import java.lang.reflect.Field;
import java.lang.ClassNotFoundException;
import java.lang.StringBuilder;

import java.math.BigDecimal;
import java.util.*;

public class CreateDatabase {

	public static void main(String[] args){
		String metadataFile = args[0];
		String myUsername = args[1];
		String myPassword = "lipfd";
		System.out.println("Metadata file is: "+metadataFile);
		String url = "jdbc:mysql://localhost/hirise";

		Connection c = null;
		BufferedReader br = null;
		try {
			Class.forName("com.mysql.jdbc.Driver");
			c = DriverManager.getConnection(url, myUsername, myPassword);
			PreparedStatement stmt = null;
			System.out.println("creating the table");
			String sqlStatement = "drop table if exists images;\n";
			stmt = c.prepareStatement(sqlStatement);
			stmt.executeUpdate();
			sqlStatement = "create table if not exists images (\n";

			// based on: http://stackoverflow.com/questions/1097807/java-reflection-is-the-order-of-class-fields-and-methods-standardized
			Field[] metadataFields = ImageMetadata.class.getDeclaredFields();
			Arrays.sort(metadataFields, new Comparator<Field>() {
	            @Override
	            public int compare(Field o1, Field o2) {
	                ImageMetadata.Order or1 = o1.getAnnotation(ImageMetadata.Order.class);
	                ImageMetadata.Order or2 = o2.getAnnotation(ImageMetadata.Order.class);
	                // nulls last
	                if (or1 != null && or2 != null) {
	                    return or1.value() - or2.value();
	                } else
	                if (or1 != null && or2 == null) {
	                    return -1;
	                } else
	                if (or1 == null && or2 != null) {
	                    return 1;
	                }
	                return o1.getName().compareTo(o2.getName());
	            }
	        });

			for(int i = 0; i < metadataFields.length; i++){
				Field f = metadataFields[i];
				String name = f.getName();
				sqlStatement += name + " ";
				if(f.getType().equals(Class.forName("java.lang.Double")))
					sqlStatement += "double";
				else if(f.getType().equals(Class.forName("java.lang.Integer")))
					sqlStatement += "int";
				else if (name.equals("product_id"))
					sqlStatement += "varchar(190) not null";
				else if (name.equals("upper_right_latitude") || name.equals("upper_right_longitude") || name.equals("lower_right_latitude") ||
					name.equals("lower_right_longitude") || name.equals("lower_left_latitude") || name.equals("lower_left_longitude") ||
					name.equals("upper_left_latitude") || name.equals("upper_left_longitude")){
					sqlStatement += "not null";
					//system.out.println("got here");
				}
				else if(f.getType().equals(Class.forName("java.lang.String")))
					sqlStatement += "varchar(100)";
				sqlStatement += ",\n";
			}

			/*sqlStatement+="lower_left_latitude double, "+
				" \n lower_right_latitude double, \n upper_left_latitude double,\n "+
				"upper_right_latitude double, \n  upper_right_longitude double,"+
				"\n upper_left_longitude double, \n lower_right_longitude double,"+
				"\n lower_left_longitude double, \n scaled_pixel_height double,"+
				"\n pixel_aspect_ratio double, \n usage_note varchar(100), \n";
			*/sqlStatement += /*"g geometry not null, SPATIAL INDEX(g), index(product_id),*/" primary key (product_id)) ENGINE=MyISAM;";

			System.out.println(sqlStatement);
			stmt = c.prepareStatement(sqlStatement);
			stmt.executeUpdate();

			System.out.println("reading the metadata file");
			String databaseString = "";


			System.out.println("parsing the metadata file");
			br = new BufferedReader(new FileReader(metadataFile));
	        String line = br.readLine();

	        int buffer_max = 300;
	        int count = 1;
	        int rows = 0;
	        StringBuilder sb = new StringBuilder();
	        sb.append("insert into images values\n");
	        while (line != null) {
	        	count++;
	        	rows++;
	        	if (count > buffer_max){
	        		sb.delete(0, sb.length());
	        		System.gc();
	        		sb.append("insert into images values\n");
	        		count = 1;
	        	}
	            String[] cols = line.split(",");
	            assert (cols.length == metadataFields.length);
							//System.out.println(cols.length +"= colsLength  mdFields ="+metadataFields.length);
							sb.append("(");
	            for (int i = 0; i < cols.length; i++){
	            	sb.append(cols[i].trim().replaceAll("^\\\"\\s*|\\s*\\\"$", "\""));
	            	if(i < cols.length - 1)
	            		sb.append(", ");
	            }

	            line = br.readLine();
							sb.append(")");
							if(count<buffer_max){
								sb.append(", ");
							}
							else{
	             	sb.append(";");
								//System.out.println(sb.toString());

								stmt = c.prepareStatement(sb.toString());

								stmt.executeUpdate();

	            }
								System.out.print(String.format("rows processed: %d\r", rows));
            }
			System.out.println("\ndone.");
		}
		catch(SQLException e){
			e.printStackTrace();
		}
		// catch(IllegalAccessException e){
		// 	e.printStackTrace();
		// }
		catch(IOException e){
			e.printStackTrace();
		}
		catch(ClassNotFoundException e){
			e.printStackTrace();
		}
		finally {
			try{ if(c != null) c.close();}
			catch(SQLException e){e.printStackTrace();}
			finally {
				try {if (br != null) br.close();}
				catch(IOException e) {e.printStackTrace();}
			}
		}
	}
}
