package lipfd.commons.model;

import java.lang.annotation.*;
import java.util.*;
import java.lang.*;
import java.lang.reflect.Field;

public class ImageMetadata {
	@Retention(RetentionPolicy.RUNTIME)
    public @interface Order {
        int value();
    }

    public ImageMetadata(ImageMetadata im){
    	try{
	    	for(Field f : ImageMetadata.class.getDeclaredFields()){
	    		f.set(this, f.get(im));
	    	}
    	}
    	catch(IllegalAccessException e){e.printStackTrace();}
    }

    public ImageMetadata(){
    }

    @Order(value=1)
	public String volume_id;
	@Order(value=2)
	public String file_specification_name;
	@Order(value=3)
	public String instrument_host_id;
	@Order(value=4)
	public String instrument_id;
	@Order(value=5)
	public String observation_id;
	@Order(value=6)
	public String product_id;
	@Order(value=7)
	public String product_version_id;
	@Order(value=8)
	public String hical_version;
	@Order(value=9)
	public String target_name;
	@Order(value=10)
	public Integer orbit_number;//changed name
	@Order(value=11)
	public String mission_phase_name; // 10
	@Order(value=12)
	public String rationale_desc;
	@Order(value=13)
	public String observation_start_time;
	@Order(value=14)
	public String observation_start_count;
	@Order(value=15)
	public String start_time;
	@Order(value=16)
	public String spacecraft_clock_start_count;
	@Order(value=17)
	public String stop_time;
	@Order(value=18)
	public String spacecraft_clock_stop_count;
	@Order(value=19)
	public String ccd_name;
	@Order(value=20)
	public Integer channel_number;
	@Order(value=21)
	public String filter_name; //20 //stopped here
	@Order(value=22)
	public Double scan_exposure_duration;
	@Order(value=23)
	public Integer delta_line_time_count;
	@Order(value=24)
	public Integer binning;
	@Order(value=25)
	public Integer tdi;
	@Order(value=26)
	public Integer trim_lines;
	@Order(value=27)
	public Integer focus_posistion_count;
	@Order(value=28)
	public String felics_compression_flag;
	@Order(value=29)
	public String stimulation_lamp_flag_red;
	@Order(value=30)
	public String stimulation_lamp_flag_bluegreen;
	@Order(value=31)
	public String stimulation_lamp_flag_nearinfrared; //30
	@Order(value=32)
	public String lookup_table_type;
	@Order(value=33)
	public Integer lookup_table_minimum;
	@Order(value=34)
	public Integer lookup_table_maximum;
	@Order(value=35)
	public Integer lookup_table_median;
	@Order(value=36)
	public Integer lookup_table_k_value;
	@Order(value=37)
	public Integer lookup_table_number;
	@Order(value=38)
	public Integer adc_conversion_settings1;
	@Order(value=39)
	public Integer adc_conversion_settings2;
	@Order(value=40)
	public Double fpa_positive_y_temperature;
	@Order(value=41)
	public Double fpa_negative_y_temperature;
	@Order(value=42)
	public Double fpe_temperature; //40
	@Order(value=43)
	public Double iea_temperature;
	@Order(value=44)
	public Double iea_pws_board_temperature;
	@Order(value=45)
	public Double cpmm_pws_board_temperature;
	@Order(value=46)
	public Integer image_lines;
	@Order(value=47)
	public Integer line_samples;
	@Order(value=48)
	public Integer sample_bits;
	@Order(value=49)
	public Double scaled_pixel_width;//48
	@Order(value=50)
	public Double emission_angle;
	@Order(value=51)
	public Double incidence_angle;
	@Order(value=52)
	public Double phase_angle; //50
	@Order(value=53)
	public Double center_latitude;
	@Order(value=54)
	public Double center_longitude;
	@Order(value=55)
	public Double minimum_latitude;//54
	@Order(value=56)
	public Double maximum_latitude;//55
	@Order(value=57)
	public Double minimum_longitude;//56
	@Order(value=58)
	public Double maximum_longitude;//57
	@Order(value=59)
	public Double spacecraft_altitude;
	@Order(value=60)
	public Double target_center_distance;
	@Order(value=61)
	public Double slant_distance;
	@Order(value=62)
	public Double north_azimuth;
	@Order(value=63)
	public Double sub_solar_azimuth;
	@Order(value=64)
	public Double sub_solar_latitude;
	@Order(value=65)
	public Double sub_solar_longitude ;
	@Order(value=66)
	public Double sub_spacecraft_latitude;
	@Order(value=67)
	public Double sub_spacecraft_longitude;
	@Order(value=68)
	public Double solar_distance ;
	@Order(value=69)
	public Double solar_longitude;
	@Order(value=70)
	public Double local_time;
	@Order(value=71)
	public String stereo_flag;


	public String toString(){
		Field[] metadataFields = ImageMetadata.class.getDeclaredFields();
		Arrays.sort(metadataFields, new Comparator<Field>() {
            @Override
            public int compare(Field o1, Field o2) {
                ImageMetadata.Order or1 = o1.getAnnotation(ImageMetadata.Order.class);
                ImageMetadata.Order or2 = o2.getAnnotation(ImageMetadata.Order.class);
                // nulls last
                if (or1 != null && or2 != null) {
                    return or1.value() - or2.value();
                } else
                if (or1 != null && or2 == null) {
                    return -1;
                } else
                if (or1 == null && or2 != null) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        String result = "";
		try {
			for(int i = 0; i < metadataFields.length; i++){
				Field f = metadataFields[i];
				result += String.format("(%02d) %35s: %s\n", i+1, f.getName().replaceAll("_", " "),
					String.valueOf(f.get(this)));
			}

		}
		catch (IllegalArgumentException e){e.printStackTrace();}
		catch (IllegalAccessException e){e.printStackTrace();}
		return result;
	}


	public boolean isFlippedAroundHorizontalAxis(){
		if(maximum_latitude < minimum_latitude)
			return true;
		return false;
	}
	public boolean isFlippedAroundVerticalAxis(){
		if(maximum_latitude < maximum_longitude)
			return true;
		return false;
	}
	public ImageMetadata flipAroundHorizontalAxis(){
		double temp = 0;
		ImageMetadata im = new ImageMetadata(this);

		temp = im.maximum_latitude;
		im.maximum_latitude = im.minimum_latitude;
		im.minimum_latitude = temp;

		temp = im.maximum_longitude;
		im.maximum_longitude = im.minimum_longitude;
		im.minimum_longitude = temp;

		temp = im.minimum_latitude;
		im.minimum_latitude = im.minimum_latitude;
		im.minimum_latitude = temp;

		temp = im.maximum_latitude;
		im.maximum_latitude = im.minimum_longitude;
		im.minimum_longitude = temp;

		// if(im.lro_flight_direction.equalsIgnoreCase("+X"))
		// 	im.lro_flight_direction = "-X";
		// else im.lro_flight_direction = "+X";

		im.north_azimuth = 360 - im.north_azimuth;
		im.sub_solar_azimuth = 360 - im.sub_solar_azimuth;

		return im;
	}
	public ImageMetadata flipAroundVerticalAxis(){
		double temp = 0;
		ImageMetadata im = new ImageMetadata(this);

		temp = im.maximum_latitude;
		im.maximum_latitude = im.minimum_latitude;
		im.minimum_latitude = temp;

		temp = im.maximum_longitude;
		im.maximum_longitude = im.maximum_latitude;
		im.maximum_latitude = temp;

		temp = im.minimum_latitude;
		im.minimum_latitude = im.minimum_latitude;
		im.minimum_latitude = temp;

		temp = im.minimum_longitude;
		im.minimum_longitude = im.minimum_longitude;
		im.minimum_longitude = temp;

		im.north_azimuth = 180 - im.north_azimuth;
		im.sub_solar_azimuth = 180 - im.sub_solar_azimuth;

		return im;
	}

	public ImageMetadata makeRightSideUp(){
		ImageMetadata im = new ImageMetadata(this);
		if(im.isFlippedAroundVerticalAxis())
			im = im.flipAroundVerticalAxis();
		if(im.isFlippedAroundHorizontalAxis())
			im = im.flipAroundHorizontalAxis();
		return im;
	}

	public boolean isCloseToMeridian(){
		double epsilon = 2;
		if(maximum_longitude < epsilon || maximum_longitude > (360-epsilon) ||
			minimum_longitude < epsilon || minimum_longitude > (360-epsilon) ||
			maximum_latitude < epsilon || maximum_latitude > (360-epsilon) ||
			minimum_longitude < epsilon || minimum_longitude > (360-epsilon))
			return true;
		return false;
	}
}
