# update repos 
echo "Updating..."
sudo apt-get update
sudo apt-get upgrade -y

echo "Installing tools for OpenCV"
# install tools for opencv
sudo apt-get install build-essential libgtk2.0-dev libjpeg-dev libtiff4-dev libjasper-dev libopenexr-dev cmake python-dev python-numpy python-tk libtbb-dev libeigen3-dev yasm libfaac-dev libopencore-amrnb-dev libopencore-amrwb-dev libtheora-dev libvorbis-dev libxvidcore-dev libx264-dev libqt4-dev libqt4-opengl-dev sphinx-common texlive-latex-extra libv4l-dev libdc1394-22-dev libavcodec-dev libavformat-dev libswscale-dev default-jdk ant libvtk5-qt4-dev -y

# opencv 
#cd ~
#wget http://sourceforge.net/projects/opencvlibrary/files/opencv-unix/2.4.9/opencv-2.4.9.zip
echo "Installing OpenCV"
unzip opencv-2.4.9.zip
cd opencv-2.4.9

# start building opencv
mkdir build
cd build
cmake -D WITH_TBB=ON -D BUILD_NEW_PYTHON_SUPPORT=ON -D WITH_V4L=ON -D INSTALL_C_EXAMPLES=ON -D INSTALL_PYTHON_EXAMPLES=ON -D BUILD_EXAMPLES=ON -D WITH_QT=ON -D WITH_OPENGL=ON -D WITH_VTK=ON ..

# actually make opencv
make
sudo make install

# add the opencv library
echo "/usr/local/lib" | sudo tee -a /etc/ld.so.conf.d/opencv.conf
# append this to the file /usr/local/lib

echo "Configuring OpenCV library"
# configure opencv library
sudo ldconfig

#add lib to path
echo "PKG_CONFIG_PATH=\$PKG_CONFIG_PATH:/usr/local/lib/pkgconfig" | sudo tee -a /etc/bash.bashrc
echo "export PKG_CONFIG_PATH" | sudo tee -a /etc/bash.bashrc
# append this : 
# PKG_CONFIG_PATH=$PKG_CONFIG_PATH:/usr/local/lib/pkgconfig
# export PKG_CONFIG_PATH
cd ../../
rm opencv-2.4.9 -r -f 
echo "Configuration Complete! Refreshing Terminal..."
# refresh terminal
sudo source /etc/bash.bashrc

#get java8 
sudo add-apt-repository ppa:webupd8team/java # need this repository to get java8
sudo apt-get update
sudo apt-get install oracle-java8-installer -y

echo "Installing Addition software for Ringtoss..."
# install gdal 
sudo apt-get install gdal-bin -y

#install octave
sudo apt-get install octave -y 

#install pre requizet librbary for isis some 
sudo apt-get install libjpeg62 -y

 #install mysql
sudo apt-get install mysql-server -y



echo "Setting up SQL database for images' metadata. Please enter MySQL root user password"
# set up mysql user 
mysql -u root -p << EOF
CREATE DATABASE hirise;
CREATE USER 'lipfd'@'localhost' IDENTIFIED BY 'lipfd';
GRANT ALL PRIVILEGES ON hirise.* to 'lipfd'@'localhost';
EOF

echo "Installing USGS ISIS... Please do not change default installation directory"
#install isis
chmod +x isisInstall.sh
./isisInstall.sh

echo "Setting USGS Isis Root"
#add isis to path
#sudo gedit /etc/bash.bashrc
echo "ISISROOT=~/Isis/isis" | sudo tee -a /etc/bash.bashrc
echo "export ISISROOT" | sudo tee -a /etc/bash.bashrc
echo ". \$ISISROOT/scripts/isis3Startup.sh" | sudo tee -a /etc/bash.bashrc
#echo "ISISROOT=~/Isis/isis" >> /etc/bash.bashrc
#sudo echo "export ISISROOT" >> /etc/bash.bashrc
#sudo echo ". $ISISROOT/scripts/isis3Startup.sh" >> /etc/bash.bashrc
# append this :
# ISISROOT=~/Isis/isis
# export ISISROOT
# . $ISISROOT/scripts/isis3Startup.sh

echo "Instillation complete! Reopen terminal"


####################################end of install script
