red_thresh=0.8
yellow_thresh=0.5
rt_two_phase="no"
##
## Bash file for Linux
##
#######################################################################
# JAVA PATHS
#######################################################################
java_library_path="/usr/local/share/OpenCV/java/"
class_path="./class_files/:/usr/local/share/OpenCV/java/opencv-249.jar:./libs/mysql-connector-java-5.1.39-bin.jar"

#######################################################################
# COMPILE PARAMETERS
#######################################################################

compile_java_code="yes"

#######################################################################
# RUNTIME PARAMETERS
#######################################################################

## RUN PROGRAMS:
empty_results_directory="no"
run_ringtoss="yes"
cropimage="no"
run_circle_hough="no"
run_template_matching="no"
run_ellipse_gui="no"
run_data_extract="no"
run_metadata_editor="no"
run_negative_metadata_editor="no"
run_performance_calculator="no"
run_training_set_generator="no"
run_create_database="no"
run_tests="no"

# RINGTOSS:
rt_use_multiple_images_of_the_same_area="no"
rt_choose_image_automatically="no"
rt_input_image="AEB_000002_0000_RED5_0"
rt_upper_left_longitude=32.76343
rt_upper_left_latitude=40.40706
rt_lower_right_longitude=32.88265
rt_lower_right_latitude=40.34749
rt_upper_left_x=0
rt_upper_left_y=0
image_width=1000
image_height=1000
rt_lower_right_x=$(($rt_upper_left_x + $image_width))
rt_lower_right_y=$(($rt_upper_left_y + $image_height))
rt_use_pca="no"
rt_use_cnn="yes"
rt_ml_add_margin=2

# PCA:
pca_craters_folder="pca/craters/"
pca_noncraters_folder="pca/non-craters/"
pca_m=300
pca_m_prime=100
pca_use_convolution="no"
pca_num_clusters=50
pca_num_neighbors=1
pca_use_nearest_mean="no" # yes: nearest mean, no: k nearest neighbors



# GDAL: Crop Image
inputimage="downloadedImages/$rt_input_image.IMG"
croppedimage="results/$rt_input_image.tiff"
cropx=0
cropy=1000
cropwidth=800
cropheight=800

# Circle Hough Detector
upper_hist_threshold=0.09

# Template Matching
sun_azimuth=-0.1
margin_ratio=1.2
median_kernel_size=1
area_filter_size=4
power_filter_threshold=15
shape_filter_max_distance=0.05
shape_filter_min_matches=1
highlight_shadow_area_ratio=4.2
highlight_shadow_distance_coef=1.95
max_combined_elongation=3
individual_elongation_coef=2.05
sun_azimuth_tolerance_coef=0.33
max_roi_eccentricity=2
highlights_folder="src/templateMatching/highlight-templates/"
shadows_folder="src/templateMatching/shadow-templates/"
generate_cropped_candidates="no"
generate_cropped_shadow_images="no"
use_weighted_euclidean_distance="yes"
use_hu_moments="no"

# Metadata Editor
jpl_metadata="ground-truth/"$rt_input_image-$rt_upper_left_x-$rt_upper_left_y-$image_width-$image_height"-CRATER.txt"
negative_metadata="negativeImageData/"$rt_input_image-$rt_upper_left_x-$rt_upper_left_y-$image_width-$image_height"-NOTCRATER.txt"

# Performance Calculator
ground_truth_metadata=$jpl_metadata
result_metadata="results/result-ml-metadata.txt"
pc_add_margin=0.5
pc_conf_threshold=0.5

# Training Set Generator
tsg_metadata_file=$jpl_metadata
tsg_num_rotations=0
tsg_output_folder="results/training-set/"
tsg_resize_to=28


# Create Database
cd_metadata_file="./image-metadata/EDRCUMINDEX.TAB"
cd_metadata_file="./data-files/EDRCUMINDEX.TAB"
cd_username="lipfd"
cd_password="lipfd"



#######################################################################
# EXECUTE
#######################################################################
delay=2


if [ $empty_results_directory = "yes" ]
then
rm -R results
echo "removed results directory"
fi

if [ ! -d "results" ]
then
mkdir results
mkdir results/craterCandidates
echo "created results directory"
fi

if [ $compile_java_code = "yes" ]
then
rm -R class_files
mkdir class_files
echo "class files removed"
echo "compiling the opencv/java code"
javac -d ./class_files src/metadataEditor/*.java src/commons/*.java src/commons/model/*.java src/commons/model/dao/*.java src/commons/model/dao/jdbc/*.java src/performanceCalculator/*.java src/templateMatching/*.java src/scripts/*.java src/tests/commons/*.java src/tests/commons/model/*.java src/ellipse/*.java src/circleHough/*.java src/dataExtract/*.java src/ringtoss/*.java src/pca/*.java -cp $class_path -Xlint:unchecked
echo "---------------------finished compiling the java code ----------------------"
sleep $delay
fi

if [ $run_ringtoss = "yes" ]
then
echo "********************"
echo "* running RINGTOSS *"
echo "********************"
java -classpath $class_path -Djava.library.path=$java_library_path -Xmx16g -Xss1g lipfd.ringtoss.Ringtoss $rt_use_multiple_images_of_the_same_area $rt_choose_image_automatically $rt_input_image $rt_upper_left_longitude $rt_upper_left_latitude $rt_lower_right_longitude $rt_lower_right_latitude $rt_upper_left_x $rt_upper_left_y $rt_lower_right_x $rt_lower_right_y $rt_use_pca $rt_use_cnn $pc_conf_threshold $upper_hist_threshold $margin_ratio $median_kernel_size $area_filter_size $power_filter_threshold $shape_filter_max_distance $shape_filter_min_matches $highlight_shadow_area_ratio $highlight_shadow_distance_coef $max_combined_elongation $individual_elongation_coef $sun_azimuth_tolerance_coef $max_roi_eccentricity $highlights_folder $shadows_folder $generate_cropped_candidates $generate_cropped_shadow_images $use_weighted_euclidean_distance $use_hu_moments $pca_craters_folder $pca_noncraters_folder $pca_m $pca_m_prime $pca_use_convolution $pca_num_clusters $pca_num_neighbors $pca_use_nearest_mean $ground_truth_metadata $rt_ml_add_margin $red_thresh $yellow_thresh $rt_two_phase
sleep $delay
fi

if [ $cropimage = "yes" ]
then
echo "cropping the input image using GDAL"
gdal_translate -srcwin $cropx $cropy $cropwidth $cropheight -ot Byte -of PNM -scale $inputimage $croppedimage
fi

if [ $run_circle_hough = "yes" ]
then
echo "running circle hough GUI"
java -classpath $class_path -Djava.library.path=$java_library_path -Xmx4g -Xss1g lipfd.circleHough.CircleHoughDetector $rt_input_image $rt_upper_left_x $rt_upper_left_y $rt_lower_right_x $rt_lower_right_y $upper_hist_threshold
fi

if [ $run_template_matching = "yes" ]
then
echo "running the template matching algorithm"
java -classpath $class_path -Djava.library.path=$java_library_path -Xmx4g -Xss1g lipfd.templateMatching.TemplateMatching $croppedimage $sun_azimuth $margin_ratio $median_kernel_size $area_filter_size $power_filter_threshold $shape_filter_max_distance $shape_filter_min_matches $highlight_shadow_area_ratio $highlight_shadow_distance_coef $max_combined_elongation $individual_elongation_coef $sun_azimuth_tolerance_coef $max_roi_eccentricity $highlights_folder $shadows_folder $generate_cropped_candidates $generate_cropped_shadow_images $use_weighted_euclidean_distance $use_hu_moments
sleep $delay
fi

if [ $run_ellipse_gui = "yes" ]
then
echo "running ellipse GUI"





java -classpath $class_path -Djava.library.path=$java_library_path -Xmx4g -Xss1g lipfd.ellipse.EllipseGui $rt_input_image $rt_upper_left_x $rt_upper_left_y $rt_lower_right_x $rt_lower_right_y $ground_truth_metadata
fi

if [ $run_data_extract = "yes" ]
then
echo "running Depth and Diameter GUI"
java -classpath $class_path -Djava.library.path=$java_library_path -Xmx4g -Xss1g lipfd.dataExtract.RingtossGUI $rt_input_image $rt_upper_left_x $rt_upper_left_y $rt_lower_right_x $rt_lower_right_y $pc_conf_threshold
fi

if [ $run_metadata_editor = "yes" ]
then
echo "running metadata editor"
echo $jpl_metadata
java -classpath $class_path -Djava.library.path=$java_library_path -Xmx4g -Xss1g lipfd.metadataEditor.MetadataEditor $croppedimage $jpl_metadata $cropx $cropy
sleep $delay
fi

if [ $run_negative_metadata_editor = "yes" ]
then
echo "running metadata editor"
echo $jpl_metadata
java -classpath $class_path -Djava.library.path=$java_library_path -Xmx4g -Xss1g lipfd.metadataEditor.MetadataEditor $croppedimage $negative_metadata $cropx $cropy
sleep $delay
fi


if [ $run_performance_calculator = "yes" ]
then
echo "generating performance report"
java -classpath $class_path -Djava.library.path=$java_library_path -Xmx4g -Xss1g lipfd.performanceCalculator.PerformanceCalculator $croppedimage $ground_truth_metadata $result_metadata $cropx $cropy $pc_add_margin $pc_conf_threshold
sleep $delay
fi

if [ $run_training_set_generator = "yes" ]
then
echo "generating training set"
java -classpath $class_path -Djava.library.path=$java_library_path -Xmx4g -Xss1g lipfd.scripts.TrainingSetGenerator $croppedimage $tsg_metadata_file $cropx $cropy $tsg_num_rotations $tsg_output_folder $tsg_resize_to
sleep $delay
fi

if [ $run_create_database = "yes" ]
then
echo "running create databse"
java -classpath $class_path -Djava.library.path=$java_library_path -Xmx16g -Xss1g lipfd.scripts.CreateDatabase $cd_metadata_file $cd_username $cd_password
sleep $delay
fi

if [ $run_tests = "yes" ]
then
echo "running test 1"
java -classpath $class_path -Djava.library.path=$java_library_path -Xmx4g -Xss1g lipfd.tests.commons.model.ImageMetadataTest
sleep $delay
java -classpath $class_path -Djava.library.path=$java_library_path -Xmx4g -Xss1g lipfd.tests.commons.UtilTest
sleep $delay
fi
echo "--------------------------DONE--------------------------"
