function pooledFeatures = cnnPool(poolDim, convolvedFeatures)

	numImages = size(convolvedFeatures, 4);
	numFilters = size(convolvedFeatures, 3);
	convolvedDim = size(convolvedFeatures, 1);

	pooledFeatures = zeros(convolvedDim / poolDim, ...
	        convolvedDim / poolDim, numFilters, numImages);


	pooledFeatDim = convolvedDim / poolDim;
	filter = ones(poolDim);
	parfor imageNum = 1:numImages
		for filterNum = 1:numFilters
			convolved = conv2(convolvedFeatures(:, :, filterNum, imageNum), filter, 'valid');
			pooledFeatures(:, :, filterNum, imageNum) = convolved(1:poolDim:end, 1:poolDim:end) ./ (poolDim^2);
		end
	end

end

