# LIPFD
Lunar Image Processing - Feature Detection

### General
A sample linux bash file is provided to run the project. You need to have OpenCV version 2 installed and make sure to change the necessary paths in the bash file.


### Metadata Editor
A GUI tool to generate ground truth metadata files. Here are some tips on how to use this tool:

##### Commands

	* Ctrl + O    - Open metadata file
	* Ctrl + S    - Save to metadata file
	* Ctrl + C    - Reset to initial state (careful!)
	* Ctrl + R    - Remove all bounding boxes (careful!)
	* r           - Remove the most recently added bounding box
	* d           - Toggle display bounding boxes
	* e           - Toggle histogram equalization
	* mouse left  - Add a new bounding box
	* mouse right - Remove a bounding box

##### Input Arguments

	1. background image file
	2. jpl metadata file
	3. cropx: top-left x coordinate 
	4. cropy: top-left y coordinate


### Performance Calculator
This program compares the output of crater detectors with ground truth files and reports their performance (f1 score, precision, recall etc.) and displays 3 images containing true positives, false positives and false negatives respectively.

##### Input Arguments

	1. cropped image
	2. ground truth file
	3. results file
	4. cropx
	5. cropy


### Training Set Generator
This program reads a metadata file, crops each roi in the metadata file, rotates it a specified number of times and then saves all those rotated images to a folder.

##### Input Arguments

	1. input image
	2. metadata file
	3. cropx: top-left x coordinate 
	4. cropy: top-left y coordinate
	5. number of rotations
	6. output directory
	7. N: resize to NxN



### Template Matching
make sure to set the correct sun azimuth and the margin to be added to the output. 

##### Input Arguments

	1.  sun_azimuth=-0.1 						sun azimuth angle in radians compared to the east of the image 
	2.  margin_ratio=2 							the bounding boxes are twice the original size
	3.  median_kernel_size=1 					median filter kernel (1=off)
	4.  area_filter_size=4 						remove any highlight or shadow smaller than 4 pixels
	5.  power_filter_threshold=15 				A*(h-hn)^2 for any feature should be bigger than 15
	6.  shape_filter_max_distance=55 			weighted euclidean distance of features from templates should be smaller than 55
	7.  shape_filter_min_matches=1 				match at least one template
	8.  highlight_shadow_area_ratio=4.2 		area of highlights should be at most 4.2 times the area of the corresponding shadows and vice versa
	9.  highlight_shadow_distance_coef=1.95 	distance of highlights from shadows over max(sqrt(their area)) is at most 1.95
	10. max_combined_elongation=3 				max combined elongation of highlights and shadows 
	11. individual_elongation_coef=2.05 		max elongation of individual highlights or shadows
	12. sun_azimuth_tolerance_coef=0.33 		difference between crater orientation and sun azimuth angle can be at most 0.33 * PI
	13. max_roi_eccentricity=2 					the ratio of the laterals of the resulting rectangular bounding box can be at most 2
	14. highlights_folder="" 					highlight templates folder
	15. shadows_folder="" 						shadow templates folder
	16. generate_cropped_candidates="no" 		crop crater candidates for machine learning
	17. generate_cropped_shadow_images="no" 	crop shadow images for depth detection
	18. use_weighted_euclidean_distance="yes"	
	19. use_hu_moments="no" 					use hu moment invariants instead of Flusser